/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAMBEDeviceReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAMBEDeviceReport::SWGAMBEDeviceReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAMBEDeviceReport::SWGAMBEDeviceReport() {
    device_path = nullptr;
    m_device_path_isSet = false;
    success_count = 0;
    m_success_count_isSet = false;
    failure_count = 0;
    m_failure_count_isSet = false;
}

SWGAMBEDeviceReport::~SWGAMBEDeviceReport() {
    this->cleanup();
}

void
SWGAMBEDeviceReport::init() {
    device_path = new QString("");
    m_device_path_isSet = false;
    success_count = 0;
    m_success_count_isSet = false;
    failure_count = 0;
    m_failure_count_isSet = false;
}

void
SWGAMBEDeviceReport::cleanup() {
    if(device_path != nullptr) { 
        delete device_path;
    }


}

SWGAMBEDeviceReport*
SWGAMBEDeviceReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAMBEDeviceReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&device_path, pJson["devicePath"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&success_count, pJson["successCount"], "qint32", "");
    
    ::SWGSDRangel::setValue(&failure_count, pJson["failureCount"], "qint32", "");
    
}

QString
SWGAMBEDeviceReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAMBEDeviceReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(device_path != nullptr && *device_path != QString("")){
        toJsonValue(QString("devicePath"), device_path, obj, QString("QString"));
    }
    if(m_success_count_isSet){
        obj->insert("successCount", QJsonValue(success_count));
    }
    if(m_failure_count_isSet){
        obj->insert("failureCount", QJsonValue(failure_count));
    }

    return obj;
}

QString*
SWGAMBEDeviceReport::getDevicePath() {
    return device_path;
}
void
SWGAMBEDeviceReport::setDevicePath(QString* device_path) {
    this->device_path = device_path;
    this->m_device_path_isSet = true;
}

qint32
SWGAMBEDeviceReport::getSuccessCount() {
    return success_count;
}
void
SWGAMBEDeviceReport::setSuccessCount(qint32 success_count) {
    this->success_count = success_count;
    this->m_success_count_isSet = true;
}

qint32
SWGAMBEDeviceReport::getFailureCount() {
    return failure_count;
}
void
SWGAMBEDeviceReport::setFailureCount(qint32 failure_count) {
    this->failure_count = failure_count;
    this->m_failure_count_isSet = true;
}


bool
SWGAMBEDeviceReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(device_path && *device_path != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_success_count_isSet){
            isObjectUpdated = true; break;
        }
        if(m_failure_count_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

