﻿///////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2023 Jon Beniston, M7RCE <jon@beniston.com>                     //
//                                                                               //
// This program is free software; you can redistribute it and/or modify          //
// it under the terms of the GNU General Public License as published by          //
// the Free Software Foundation as version 3 of the License, or                  //
// (at your option) any later version.                                           //
//                                                                               //
// This program is distributed in the hope that it will be useful,               //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                  //
// GNU General Public License V3 for more details.                               //
//                                                                               //
// You should have received a copy of the GNU General Public License             //
// along with this program. If not, see <http://www.gnu.org/licenses/>.          //
///////////////////////////////////////////////////////////////////////////////////

#include "airlines.h"

// Data from: https://en.wikipedia.org/wiki/List_of_airline_codes
// MSVC is comically slow if we use QStringLiterals for this data
const char *Airline::Init::m_airlines[] = {
    "BOI", "2GO", "ABAIR", "Philippines",
    "AAC", "Army Air Corps", "ARMYAIR", "United Kingdom",
    "AAD", "Mann Air Ltd", "Ambassador", "United Kingdom",
    "AAF", "Aigle Azur", "AIGLE AZUR", "France",
    "AAG", "Atlantic Flight Training", "ATLANTIC", "United Kingdom",
    "AAH", "Aloha Air Cargo", "ALOHA", "United States",
    "AAI", "Air Aurora", "BOREALIS", "United States",
    "AAJ", "Alfa Airlines", "ALFA SUDAN", "Sudan",
    "AAK", "Alaska Island Air", "ALASKA ISLAND", "United States",
    "AAL", "American Airlines", "AMERICAN", "United States",
    "AAM", "Aim Air", "", "Moldova",
    "AAN", "Oasis International Airlines Now assigned to Boliviana de Aviacion (BoA)", "OASIS", "Spain",
    "AAO", "Atlantis Airlines (USA)", "ATLANTIS AIR", "United States",
    "AAP", "Arabasco Air Services", "ARABASCO", "Saudi Arabia",
    "AAQ", "Copterline", "COPTERLINE", "Finland",
    "AAR", "Asiana Airlines", "ASIANA", "South Korea",
    "AAS", "Askari Aviation", "AL-ASS", "Pakistan",
    "AAT", "Air Central Asia", "", "Kyrgyzstan",
    "AAU", "Australia Asia Airlines", "AUSTASIA", "Australia",
    "AAV", "Astro Air International", "ASTRO-PHIL", "United States",
    "AAW", "Afriqiyah Airways", "AFRIQIYAH", "Libya",
    "AAX", "Advance Aviation", "ADVANCE AVIATION", "Thailand",
    "AAY", "Allegiant Air", "ALLEGIANT", "United States",
    "AAZ", "Asian Air", "", "Kyrgyzstan",
    "ABA", "Aero-Beta", "AEROBETA", "Germany",
    "ABB", "African Business and Transportations", "AFRICAN BUSINESS", "Democratic Republic of the Congo",
    "ABD", "Air Atlanta Icelandic", "ATLANTA", "Iceland",
    "ABE", "Aban Air", "ABAN", "Iran",
    "ABF", "Aerial Oy", "SKYWINGS", "Finland",
    "ABG", "Abakan-Avia", "ROYAL FLIGHT", "Russia",
    "ABH", "Hokuriki-Koukuu Company", "", "Japan",
    "ABL", "Air Busan", "AIR BUSAN", "South Korea",
    "ABM", "Aero Albatros", "ALBATROS ESPANA", "Spain",
    "ABN", "Air Albania", "AIR ALBANIA", "Albania",
    "ABO", "APSA Colombia", "AEROEXPRESO", "Colombia",
    "ABP", "ABS Jets", "BAIR", "Czech Republic",
    "ABQ", "Airblue", "PAKBLUE", "Pakistan",
    "ABR", "ASL Airlines Ireland", "CONTRACT", "Ireland",
    "ABS", "Transwest Air", "ATHABASKA", "Canada",
    "ABT", "Ambeo", "AMBITION", "United Kingdom",
    "ABU", "Eagle Aviation Services", "", "United States",
    "ABV", "Antrak Air", "ANTRAK", "Ghana",
    "ABW", "AirBridge Cargo", "AIRBRIDGE CARGO", "Russia",
    "ABX", "ABX Air", "ABEX", "United States",
    "ABY", "Air Arabia", "ARABIA", "United Arab Emirates",
    "ABZ", "Air Ambulance Services", "ISLAND LIFEFLIGHT", "Bahamas",
    "ACA", "Air Canada", "AIR CANADA", "Canada",
    "ACB", "African Cargo Services", "AFRICARGO", "Kenya",
    "ACC", "Airspeed Charter", "", "Jamaica",
    "ACD", "Academy Airlines", "ACADEMY", "United States",
    "ACE", "Air Charter Express", "", "Ghana",
    "ACF", "Centro de Formación Aeronáutica de Canarias", "FORCAN", "Spain",
    "ACG", "Air Partner", "AIR PARTNER", "United Kingdom",
    "ACH", "Air Cargo Plus", "AIR PLUS", "Liberia",
    "ACI", "Air Caledonie International", "AIRCALIN", "France",
    "ACJ", "Avicon", "AVICHARTER", "Kenya",
    "ACK", "Nantucket Airlines", "ACK AIR", "United States",
    "ACL", "Itali Airlines", "SPADA", "Italy",
    "ACM", "Air Caledonia", "WEST CAL", "Canada",
    "ACN", "Central American Airlines", "AEROCENTRO", "Nicaragua",
    "ACP", "Astral Aviation", "ASTRAL CARGO", "Kenya",
    "ACQ", "Aryan Cargo Express", "", "India",
    "ACR", "Aerocenter  Escuela de Formación de Pilotos Privados de Avión", "AEROCENTER", "Spain",
    "ACS", "Aircraft Sales and Services", "AIRCRAFT SALES", "Pakistan",
    "ACT", "Flight Line", "AMERICAN CHECK", "United States",
    "ACU", "Air Cargo Transportation System", "AFRISPIRIT", "Kenya",
    "ACW", "Royal Air Force", "AIR CADET", "United Kingdom",
    "ACY", "Fly Arna", "ARNA", "Armenia",
    "ADA", "Airservices Australia", "AUSCAL", "Australia",
    "ADB", "Antonov Airlines", "ANTONOV BUREAU", "Ukraine",
    "ADC", "AD Astra Executive Charter", "AD ASTRA", "Poland",
    "ADF", "Ade  Aviación Deportiva", "ADE AVIACION", "Spain",
    "ADG", "Aerea Flying Training Organization", "AEREA TRAINING", "Spain",
    "ADI", "Audeli Air", "AUDELI", "Spain",
    "ADL", "Aero Dynamics", "COTSWOLD", "United Kingdom",
    "ADN", "Aero-Dienst", "AERODIENST", "Germany",
    "ADO", "AIRDO", "AIR DO", "Japan",
    "ADP", "Aerodiplomatic", "AERODIPLOMATIC", "Mexico",
    "ADQ", "Avion Taxi", "AIR DATA", "Canada",
    "ADS", "Aviones de Sonora", "SONORAV", "Mexico",
    "ADT", "Arrendaminetos y Transportes Turisticos", "ARRENDA-TRANS", "Mexico",
    "ADU", "Airdeal Oy", "AIRDEAL", "Finland",
    "ADV", "Advanced Flight Training", "ADVANCED", "United Kingdom",
    "ADX", "Anderson Aviation", "ANDAX", "United States",
    "ADY", "Air Arabia Abu Dhabi", "Nawras [6][7]", "United Arab Emirates",
    "ADZ", "Avio Delta", "", "Bulgaria",
    "AEA", "Air Europa", "EUROPA", "Spain",
    "AEE", "Aegean Airlines", "AEGEAN", "Greece",
    "AEF", "Aerea", "", "Spain",
    "AEH", "Aero4m", "AEROCUTTER", "Slovenia",
    "AEJ", "Air Express", "KHAKI EXPRESS", "Tanzania",
    "AEK", "Aerocon", "AEROCON", "Bolivia",
    "AEM", "Aero Madrid", "AEROMADRID", "Spain",
    "AEO", "Aeroservicios Ejecutivos Del Occidente", "AERO OCCIDENTE", "Mexico",
    "AEP", "Aerotec Escuela de Pilotos", "AEROTEC", "Spain",
    "AEQ", "Air Express", "LUNA", "Sweden",
    "AER", "Alaska Central Express", "ACE AIR", "United States",
    "AES", "Aerosur Paraguay", "AEROPARAGUAY", "Paraguay",
    "AEV", "Aeroventas", "AEROVENTAS", "Mexico",
    "AEY", "Air Italy", "AIR ITALY", "Italy",
    "AEZ", "Aerial Transit", "AERIAL TRANZ", "United States",
    "AFA", "Alfa Air", "BLUE ALFA", "Czech Republic",
    "AFC", "African West Air", "AFRICAN WEST", "Senegal",
    "AFD", "Panorama Flight Service", "AIRFED", "United States",
    "AFE", "Airfast Indonesia", "AIRFAST", "Indonesia",
    "AFG", "Ariana Afghan Airlines", "ARIANA", "Afghanistan",
    "AFI", "Africaone", "AFRICAWORLD", "The Gambia",
    "AFK", "Africa Air Links", "AFRICA LINKS", "Sierra Leone",
    "AFL", "Aeroflot", "AEROFLOT", "Russia",
    "AFM", "AEROSPEED FORMATION ET MAINTENANCE", "EPIC AIR", "France",
    "AFN", "African International Airlines", "SIMBA", "Lesotho",
    "AFO", "Aero Empresa Mexicana", "AERO EMPRESA", "Mexico",
    "AFP", "Portuguese Air Force", "PORTUGUESE AIR FORCE", "Portugal",
    "AFQ", "Alba Servizi Aerotrasporti", "ALBA", "Italy",
    "AFR", "Air France", "AIRFRANS", "France",
    "AFS", "Air Data", "", "United Kingdom",
    "AFV", "Air Afrique Vacancies", "AFRIQUE VACANCE", "Côte d'Ivoire",
    "AFW", "Africa World Airlines", "BLACKSTAR", "Ghana",
    "AFY", "Africa Chartered Services", "AFRICA CHARTERED", "Nigeria",
    "AFZ", "Africa Freight Services", "AFREIGHT", "Zambia",
    "AGA", "AG Air", "GEOLINE", "Georgia",
    "AGC", "Arab Agricultural Aviation Company", "AGRICO", "Egypt",
    "AGE", "Servicios Aéreos de Los Ángeles", "AEROANGEL", "Mexico",
    "AGH", "Altagna", "ALTAGNA", "France",
    "AGI", "Aereo Transportes Los Angeles de America", "ANGELES AMERICA", "Mexico",
    "AGM", "Aviation West Charters", "ANGEL MED", "United States",
    "AGO", "Angola Air Charter", "ANGOLA CHARTER", "Angola",
    "AGP", "AERFI Group", "AIR TARA", "Ireland",
    "AGR", "United States Department Of Agriculture", "AGRICULTURE", "United States",
    "AGT", "Amadeus IT Group", "AMADEUS", "Spain",
    "AGU", "Angara Airlines", "SARMA", "Russia",
    "AGV", "Air Glaciers", "AIR GLACIERS", "Switzerland",
    "AGY", "Aero Flight Service", "FLIGHT GROUP", "United States",
    "AGZ", "Agrolet-Mci", "AGROLET", "Slovakia",
    "AHA", "Air Alpha Greenland", "AIR ALPHA", "Denmark",
    "AHC", "Azal Avia Cargo", "AZALAVIACARGO", "Azerbaijan",
    "AHD", "Czech Air Handling", "AIRHANDLING", "Czech Republic",
    "AHE", "Airport Helicopter Basel  Muller & Co.", "AIRPORT HELICOPTER", "Switzerland",
    "AHF", "Aspen Helicopters", "ASPEN", "United States",
    "AHH", "Airplanes Holdings", "AIRHOLD", "Ireland",
    "AHI", "Servicios Aéreos de Chihuahua Aerochisa", "AEROCHISA", "Mexico",
    "AHK", "Air Hong Kong", "AIR HONG KONG", "Hong Kong",
    "AHL", "Aerolíneas Hidalgo", "HIDALGO", "Mexico",
    "AHM", "Garrison Aviation", "AIR HURON", "Canada",
    "AHN", "Air Hungaria", "AIR HUNGARIA", "Hungary",
    "AHO", "Air Hamburg", "AIR HAMBURG", "Germany",
    "AHP", "Aerochiapas", "AEROCHIAPAS", "Mexico",
    "AHS", "Air Viggi San Raffaele", "AIRSAR", "Italy",
    "AHT", "HTA Helicopteros", "HELIAPRA", "Portugal",
    "AHY", "Azerbaijan Airlines", "AZAL", "Azerbaijan",
    "AIA", "Avies", "AVIES", "Estonia",
    "AIB", "Airbus Industrie", "AIRBUS INDUSTRIE", "France",
    "AIC", "Air India Limited", "AIRINDIA", "India",
    "AID", "Christian Konig - Century Airbirds", "CENTURY AIRBIRD", "Austria",
    "AIE", "Air Inuit", "AIR INUIT", "Canada",
    "AIF", "Compañía Aérea de Valencia", "", "Spain",
    "AIG", "Air Inter Gabon", "", "Gabon",
    "AIH", "Air Incheon", "AIR INCHEON", "South Korea",
    "AII", "Air Integra", "INTEGRA", "Canada",
    "AIJ", "Interjet", "ABC AEROLINEAS", "Mexico",
    "AIK", "African Airlines International Limited", "AFRICAN AIRLINES", "Kenya",
    "AIM", "Trabajos Aéreos Murcianos", "PIJO", "Spain",
    "AIN", "African International Airways", "FLY CARGO", "Eswatini",
    "AIO", "United States Air Force", "AIR CHIEF", "United States",
    "AIP", "Alpine Air Express", "ALPINE AIR", "United States",
    "AIQ", "Thai AirAsia", "THAI ASIA", "Thailand",
    "AIS", "Air Sureste", "SURESTE", "Spain",
    "AIT", "Airest", "AIREST CARGO", "Estonia",
    "AIU", "Alicante Internacional Airlines", "ALIA", "Spain",
    "AIV", "Airvias S/A Linhas Aéreas", "AIRVIAS", "Brazil",
    "AIW", "Atlantic Island Airways", "TARTAN", "Canada",
    "AIX", "Aircruising Australia", "CRUISER", "Australia",
    "AIY", "Aircrew Check and Training Australia", "AIRCREW", "Australia",
    "AIZ", "Arkia Israel Airlines", "ARKIA", "Israel",
    "AJA", "Afghan Jet International Airlines", "AFGHAN JET", "Afghanistan",
    "AJB", "Aero JBR", "AERO JBR", "Mexico",
    "AJC", "Bar Harbor Airlines", "BAR HARBOR", "United States",
    "AJF", "Avia Consult Flugbetriebs", "AVIACONSULT", "Austria",
    "AJH", "Aeroaljarafe", "ALJARAFE", "Spain",
    "AJI", "Ameristar Jet Charter", "AMERISTAR", "United States",
    "AJJ", "A2 Jet Leasing", "ATLANTIC JET", "United States",
    "AJK", "Allied Air", "BAMBI", "Nigeria",
    "AJP", "Aero Jets Corporativos", "AEROJETS", "Mexico",
    "AJR", "A-Jet Aviation Company", "JET MONGOLIA", "Mongolia",
    "AJS", "Aeroejecutivos Colombia", "AEROEJECUTIVOS", "Colombia",
    "AJT", "Amerijet International", "AMERIJET", "United States",
    "AJU", "Air Jetsul", "AIRJETSUL", "Portugal",
    "AJV", "ANA & JP Express", "AYJAY CARGO", "Japan",
    "AJW", "Alpha Jet International", "ALPHAJET", "United States",
    "AJX", "Air Japan", "AIR JAPAN", "Japan",
    "AKA", "Air Korea Co. Ltd.", "", "Republic of Korea",
    "AKB", "Aktjubavia", "KARAB", "Kazakhstan",
    "AKC", "Arca Aerovías Colombianas Ltda.", "ARCA", "Colombia",
    "AKF", "Anikay Air Company", "ANIKAY", "Kyrgyzstan",
    "AKG", "No. 84 Squadron RAF", "GRIFTER", "United Kingdom",
    "AKH", "Akhal", "AKHAL", "Turkmenistan",
    "AKI", "Ibk-Petra", "", "Sudan",
    "AKJ", "Akasa Air", "AKASA AIR", "India",
    "AKK", "Aklak Air", "AKLAK", "Canada",
    "AKL", "Air Kiribati", "KIRIBATI", "Kiribati",
    "AKM", "Mak Air", "MAKAIR", "Kazakhstan",
    "AKN", "Alkan Air", "ALKAN AIR", "Canada",
    "AKR", "Aero Clinker", "AERO CLINKER", "Mexico",
    "AKT", "Canadian North", "ARCTIC", "Canada",
    "AKX", "Air Nippon Network Co. Ltd.", "ALFA WING", "Japan",
    "AKY", "Yak-Service", "YAK-SERVICE", "Russia",
    "ALB", "Aero Albatros", "ALBATROS", "Mexico",
    "ALC", "Southern Jersey Airways  Inc.", "ACOM", "United States",
    "ALD", "Albion Aviation", "ALBION", "United Kingdom",
    "ALF", "Allied Command Europe (Mobile Force)", "ACEFORCE", "Belgium",
    "ALG", "Air Logistics", "AIRLOG", "United States",
    "ALJ", "Heli Ambulance Team", "ALPIN HELI", "Austria",
    "ALK", "SriLankan Airlines", "SRILANKAN", "Sri Lanka",
    "ALL", "Aerovallarta", "VALLARTA", "Mexico",
    "ALN", "Air Lincoln", "CHICAGO LINCOLN", "United States",
    "ALO", "Allegheny Commuter Airlines", "ALLEGHENY", "United States",
    "ALP", "Allpoints Jet", "ALLPOINTS", "China",
    "ALQ", "Altair Aviation (1986)", "ALTAIR", "Canada",
    "ALR", "Líneas Aéreas Alaire S.L.", "AEROLAIRE", "Spain",
    "ALS", "Aeralp", "AERALP", "France",
    "ALT", "Aerolíneas Centrales", "AERLINEAS CENTRALES", "Mexico",
    "ALU", "Air Luxor STP", "LUXORJET", "São Tomé and Príncipe",
    "ALV", "Aeropostal Alas de Venezuela", "AEROPOSTAL", "Venezuela",
    "ALW", "Alas Nacionales  S.A.", "ALNACIONAL", "Dominican Republic",
    "ALX", "ALPI Jets", "ALPIJETS", "Austria",
    "ALY", "Alyeska Air Service", "ALYESKA", "United States",
    "ALZ", "Alta Flights (Charters) Ltd.", "", "Canada",
    "AMA", "ATMA", "ADIK", "Kazakhstan",
    "AMB", "Deutsche Rettungsflugwacht", "CIVIL AIR AMBULANCE", "Germany",
    "AMC", "Air Malta", "AIR MALTA", "Malta",
    "AME", "Spanish Air Force", "AIRMIL", "Spain",
    "AMF", "Ameriflight", "AMFLIGHT", "United States",
    "AMJ", "Aviation Amos", "AVIATION AMOS", "Canada",
    "AMK", "Amerer Air", "AMER AIR", "Austria",
    "AMM", "Aeroputul International Marculesti", "AEROM", "Moldova",
    "AMO", "Air Montreal (Air Holdings Inc.)", "AIR MONTREAL", "Canada",
    "AMP", "Aero Transporte S.A. (ATSA)", "ATSA", "Peru",
    "AMQ", "Aircraft Management and Consulting", "AMEX", "Poland",
    "AMR", "Air Specialties Corporation", "AIR AM", "United States",
    "AMS", "Air Muskoka", "AIR MUSKOKA", "Canada",
    "AMU", "Air Macau", "AIR MACAO", "Macao",
    "AMV", "AMC Airlines", "AMC AIRLINES", "Egypt",
    "AMW", "Armenia Airways", "ARMENIA", "Armenia",
    "AMX", "Aeroméxico", "AEROMEXICO", "Mexico",
    "AMY", "Air Ambar", "AIR AMBAR", "Dominican Republic",
    "AMZ", "Amiya Airline", "AMIYA AIR", "Nigeria",
    "ANA", "All Nippon Airways", "ALL NIPPON", "Japan",
    "ANB", "Air Navigation And Trading Co. Ltd.", "AIR NAV", "United Kingdom",
    "AND", "National Jet Service", "AIR INDIANA", "United States",
    "ANE", "Air Nostrum", "AIR NOSTRUM", "Spain",
    "ANG", "Air Niugini", "NIUGINI", "Papua New Guinea",
    "ANH", "Alajnihah for Air Transport", "ALAJNIHAH", "Libya",
    "ANI", "Air Atlantic (Nig) Limited", "NIGALANTIC", "Nigeria",
    "ANL", "Nacoia Lda", "AIR NACOIA", "Angola",
    "ANM", "Aerotransportacion de Norteamerica", "NORAM", "Mexico",
    "ANO", "Airnorth", "TOPEND", "Australia",
    "ANQ", "Aerolínea de Antioquia", "ANTIOQUIA", "Colombia",
    "ANS", "Andes Líneas Aéreas", "AEROANDES", "Argentina",
    "ANT", "Air North Charter - Canada", "AIR NORTH", "Canada",
    "ANV", "Air Nevada", "AIR NEVADA", "United States",
    "ANX", "Secretaria de Marina", "SECRETARIA DEMARINA", "Mexico",
    "ANZ", "Air New Zealand", "NEW ZEALAND", "New Zealand",
    "AOA", "Alcon Servicios Aéreos  S.A. de C.V.", "ALCON", "Mexico",
    "AOB", "Aerocaribe Coro", "CARIBE CORO", "Venezuela",
    "AOC", "AVCOM", "AERO AVCOM", "Russia",
    "AOD", "Aero Vodochody", "AERO CZECH", "Czech Republic",
    "AOE", "Livingstone Executive", "LIVINGSTONE AIR", "Italy",
    "AOF", "Atair Pty Ltd.", "ATAIR", "South Africa",
    "AOJ", "Avcon Jet", "ASTERIX", "Austria",
    "AON", "Aero Entreprise", "AERO ENTERPRISE", "France",
    "AOO", "As  Opened Joint Stock Company", "COMPANY AS", "Ukraine",
    "AOP", "Aeropiloto", "AEROPILOTO", "Portugal",
    "AOR", "Afro International Ent. Limited", "INTER-AFRO", "Nigeria",
    "AOS", "Servicios Aéreos Del Sol  S.A. de C.V.", "AEROSOL", "Mexico",
    "AOT", "Asia Overnight Express", "ASIA OVERNIGHT", "Philippines",
    "AOU", "Air Tractor", "AIR TRACTOR", "Croatia",
    "AOV", "Aero Vision", "AEROVISION", "France",
    "AOX", "Aerotaxi Del Valle", "AEROVALLE", "Colombia",
    "APA", "Air Park Aviation Ltd.", "CAN-AM", "Canada",
    "APC", "Airpac Airlines  Inc.", "AIRPAC", "United States",
    "APD", "Sabre Pacific", "", "Australia",
    "APE", "Parcel Express", "AIR PARCEL", "United States",
    "APF", "Amapola Flyg AB", "AMAPOLA", "Sweden",
    "APG", "Air People International", "AIR PEOPLE", "Thailand",
    "APH", "Alpha Aviation  Inc.", "AIRFLIGHT", "United States",
    "API", "ASA Pesada  Lda.", "ASA PESADA", "Angola",
    "APJ", "Peach Aviation", "AIR PEACH", "Japan",
    "APL", "Appalachian Flying Service  Inc.", "APPALACHIAN", "United States",
    "APM", "Airpac  Inc.", "ALASKA PACIFIC", "United States",
    "APN", "Alpine Airlines", "AIR ALPES", "France",
    "APP", "AlpAvia d.o.o.", "ALPAVIA", "Slovenia",
    "APQ", "Aspen Aviation", "ASPEN BASE", "United States",
    "APR", "Aerolíneas Primordiales", "AEROPERLAS", "Mexico",
    "APT", "LAP Colombia - Líneas Aéreas Petroleras  S.A.", "LAP", "Colombia",
    "APU", "Aeropuma  S.A.", "AEROPUMA", "El Salvador",
    "APV", "Air Plan International", "AIR PLAN", "Democratic Republic of the Congo",
    "APX", "Apex Air Cargo", "PARCEL EXPRESS", "United States",
    "APY", "APA Internacional", "APA INTERNACIONAL", "Dominican Republic",
    "APZ", "Air Premia", "AIR PREMIA", "South Korea",
    "AQA", "Aeroatlas  S.A.", "ATCO", "Colombia",
    "AQL", "Aquila Air Ltd.", "AQUILA", "Canada",
    "AQO", "Aluminum Company Of America", "ALCOA SHUTTLE", "United States",
    "AQT", "Avioquintana", "AVIOQUINTANA", "Mexico",
    "AQZ", "Aerodyne Charter Company", "QUANZA", "United States",
    "ARA", "Arik Air", "ARIK AIR", "Nigeria",
    "ARB", "Avia Air N.V.", "AVIAIR", "Aruba",
    "ARC", "Air Routing International Corp.", "", "United States",
    "ARE", "LATAM Colombia", "LAN COLOMBIA", "Colombia",
    "ARG", "Aerolíneas Argentinas", "ARGENTINA", "Argentina",
    "ARH", "Arrowhead Airways", "ARROWHEAD", "United States",
    "ARI", "Aero Vics", "AEROVICS", "Mexico",
    "ARJ", "Aerojet de Costa Rica  S.A.", "", "Costa Rica",
    "ARK", "Aero Link Air Services S.L.", "LINK SERVICE", "Spain",
    "ARL", "Airlec - Air Aquitaine Transport", "AIRLEC", "France",
    "ARO", "Acero Taxi", "ACERO", "Mexico",
    "ARP", "Aero Corporate", "IVORYCORP", "Côte d'Ivoire",
    "ARQ", "Armstrong Air  Inc.", "ARMSTRONG", "Canada",
    "ARR", "Air Armenia", "AIR ARMENIA", "Armenia",
    "ARS", "Aeromet Servicios", "METSERVICE", "Chile",
    "ART", "Smartlynx Airlines", "SMART LYNX", "Latvia",
    "ARU", "Aruba Airlines", "ARUBA", "Aruba",
    "ARV", "Aravco Ltd.", "ARAVCO", "United Kingdom",
    "ARW", "Aria", "ARIABIRD", "France",
    "ARX", "Air Xpress  Inc.", "AIREX", "United States",
    "ARY", "Argosy Airways", "GOSEY", "United States",
    "ARZ", "Air Resorts", "AIR RESORTS", "United States",
    "ASA", "Alaska Airlines  Inc.", "ALASKA", "United States",
    "ASB", "Air-Spray 1967 Ltd.", "AIR SPRAY", "Canada",
    "ASC", "Air Star Corporation", "AIR STAR", "Canada",
    "ASD", "Air Sinai", "AIR SINAI", "Egypt",
    "ASF", "Austrian Air Force", "AUSTRIAN AIRFORCE", "Austria",
    "ASG", "African Star Airways (PTY) Ltd.", "AFRICAN STAR", "South Africa",
    "ASH", "Mesa Airlines", "AIR SHUTTLE", "United States",
    "ASI", "Aerosun International  Inc.", "AEROSUN", "United States",
    "ASK", "Aerosky", "MULTISKY", "Spain",
    "ASL", "Air Serbia", "AIR SERBIA", "Serbia",
    "ASM", "Awesome Flight Services (PTY) Ltd.", "AWESOME", "South Africa",
    "ASN", "Air and Sea Transport", "", "Russia",
    "ASO", "Aero Slovakia", "AERO NITRA", "Slovakia",
    "ASP", "Airsprint", "AIRSPRINT", "Canada",
    "ASQ", "ExpressJet", "ACEY", "United States",
    "ASR", "All Star Airlines  Inc.", "ALL STAR", "United States",
    "ASS", "Air Class  S.A. de C.V.", "AIR CLASS", "Mexico",
    "AST", "Aerolíneas Del Oeste", "AEROESTE", "Mexico",
    "ASV", "Air Seoul", "AIR SEOUL", "South Korea",
    "ASX", "Air Special", "AIRSPEC", "Czech Republic",
    "ASY", "Royal Australian Air Force", "AUSSIE", "Australia",
    "ATA", "Air Transport Association", "", "United States",
    "ATB", "Atlantair Ltd.", "STARLITE", "Canada",
    "ATC", "Air Tanzania", "TANZANIA", "Tanzania",
    "ATD", "Aerotours Dominicana", "AEROTOURS", "Dominican Republic",
    "ATE", "Atlantis Transportation Services  Ltd.", "ATLANTIS CANADA", "Canada",
    "ATF", "Compañía Aerotécnicas Fotográficas", "AEROTECNICAS", "Spain",
    "ATG", "Aerotranscargo[9]", "MOLDCARGO", "Moldova",
    "ATH", "Air Travel Corp.", "AIR TRAVEL", "United States",
    "ATJ", "Air Traffic GmbH", "SNOOPY", "Germany",
    "ATL", "Atlas Air Service AG", "AIR BREMEN", "Germany",
    "ATM", "Airlines of Tasmania", "AIRTAS", "Australia",
    "ATN", "Air Transport International", "AIR TRANSPORT", "United States",
    "ATP", "ASTRAL Colombia - Aerotransportes Especiales Ltda.", "ASTRAL", "Colombia",
    "ATQ", "Air Transport Schiphol", "MULTI", "Netherlands",
    "ATR", "Atlas Airlines", "ATLAS-AIR", "United States",
    "ATS", "Air Transport Service", "", "Democratic Republic of the Congo",
    "ATT", "Attawasol Airlines", "ATTAWASOL AIR", "Libya",
    "ATU", "Atlant Aerobatics Ltd.", "ATLANT HUNGARY", "Hungary",
    "ATV", "Avanti Air", "AVANTI AIR", "Germany",
    "ATX", "Warwickshire Aerocentre Ltd.", "AIRTAX", "United Kingdom",
    "AUA", "Austrian Airlines", "AUSTRIAN", "Austria",
    "AUD", "Audi Air  Inc.", "AUDI AIR", "United States",
    "AUF", "Augusta Air Luftfahrtunternehmen", "AUGUSTA", "Germany",
    "AUH", "Presidential Flight", "SULTAN", "United Arab Emirates",
    "AUI", "Ukraine International Airlines", "UKRAINE INTERNATIONAL", "Ukraine",
    "AUJ", "Business Flight Salzburg", "AUSTROJET", "Austria",
    "AUL", "Nordavia", "ARCHANGELSK AIR", "Russia",
    "AUM", "Air Atlantic Uruguay", "ATLAMUR", "Uruguay",
    "AUN", "Common Sky", "COMMON SKY", "Austria",
    "AUO", "Empresa (Aero Uruguay)  S.A.", "UNIFORM OSCAR", "Uruguay",
    "AUP", "Avia Business Group", "", "Russia",
    "AUR", "Aurigny Air Services", "AYLINE", "United Kingdom",
    "AUT", "Austral Líneas Aéreas", "AUSTRAL", "Argentina",
    "AUX", "Air Uganda International Ltd.", "", "Uganda",
    "AUY", "Aerolíneas Uruguayas  S.A.", "AUSA", "Uruguay",
    "AUZ", "Australian Airlines", "AUSTRALIAN", "Australia",
    "AVA", "Avianca", "AVIANCA", "Colombia",
    "AVB", "Aviation Beauport", "BEAUPAIR", "United Kingdom",
    "AVD", "Álamo Aviación  S.L.", "ALAMO", "Spain",
    "AVF", "Aviair Aviation Ltd.", "CARIBOO", "Canada",
    "AVG", "Aviation Legacy", "AVILEF", "Gambia",
    "AVH", "AV8 Helicopters", "KENT HELI", "United Kingdom",
    "AVJ", "Avia Traffic Company", "ATOMIC", "Kyrgyzstan",
    "AVK", "AV8 Helicopters", "AVIATE-COPTER", "South Africa",
    "AVM", "Aviación Ejecutiva Mexicana  S.A.", "AVEMEX", "Mexico",
    "AVN", "Air Vanuatu", "AIR VAN", "Vanuatu",
    "AVO", "Aviation at Work", "AVIATION WORK", "South Africa",
    "AVP", "Aviacion Corporativa de Peubla", "AVIA PUEBLA", "Mexico",
    "AVQ", "Aviation Services  Inc.", "AQUILINE", "United States",
    "AVR", "Active Aero Charter  Inc.", "ACTIVE AERO", "United States",
    "AVS", "Avialsa T-35", "AVIALSA", "Spain",
    "AVU", "Avia Sud Aérotaxi", "AVIASUD", "France",
    "AVV", "Airvantage Incorporated", "AIRVANTAGE", "United States",
    "AVW", "Aviator Airways", "AVIATOR", "Greece",
    "AVX", "Aeroclub de Vitoria", "", "Spain",
    "AVY", "Aerovaradero  S.A.", "AEROVARADERO", "Cuba",
    "AVZ", "Air Valencia", "AIR VALENCIA", "Spain",
    "AWB", "Airways International  Inc.", "AIRNAT", "United States",
    "AWC", "Titan Airways", "ZAP", "United Kingdom",
    "AWD", "Providence Aviation Services", "", "Pakistan",
    "AWE", "America West Airlines", "CACTUS", "United States",
    "AWF", "Aeroforward", "", "United States",
    "AWG", "Animawings", "ANIMA WINGS", "Romania",
    "AWI", "Air Wisconsin", "WISCONSIN", "United States",
    "AWJ", "Sahel Airlines", "SAHEL AIRLINES", "Niger",
    "AWK", "Airwork", "AIRWORK", "New Zealand",
    "AWL", "Australian Wetleasing", "AUSSIEWORLD", "Australia",
    "AWN", "Air Niamey", "AIR NIAMEY", "Niger",
    "AWO", "Awood Air Ltd.", "AWOOD AIR", "Canada",
    "AWP", "Aeroworld Pakistan", "", "Pakistan",
    "AWQ", "Indonesia AirAsia", "WAGON AIR", "Indonesia",
    "AWR", "Arctic Wings And Rotors Ltd.", "ARCTIC WINGS", "Canada",
    "AWS", "Arab Wings", "ARAB WINGS", "Jordan",
    "AWT", "Albawings", "ALBAWINGS", "Albania",
    "AWU", "Sylt Air GmbH", "SYLT-AIR", "Germany",
    "AWV", "Airwave Transport  Inc.", "AIRWAVE", "Canada",
    "AWX", "Civil Aviation Authority Directorate of Airspace Policy", "ALLWEATHER", "United Kingdom",
    "AWY", "Aeroway  S.L.", "AEROWEE", "Spain",
    "AWZ", "AirWest", "", "Sudan",
    "AXB", "Air India Express", "EXPRESS INDIA", "India",
    "AXD", "Air Express", "AIR SUDEX", "Sudan",
    "AXE", "AirExplore", "GALILEO", "Slovakia",
    "AXH", "Aeromexhaga", "AEROMEXHAGA", "Mexico",
    "AXI", "Aeron International Airlines  Inc.", "AIR FREIGHTER", "United States",
    "AXK", "African Express Airways", "EXPRESS JET", "Kenya",
    "AXP", "Aeromax", "AEROMAX SPAIN", "Spain",
    "AXQ", "Action Airlines (Action Air Charter)", "ACTION AIR", "United States",
    "AXR", "Axel Rent  S.A.", "RENTAXEL", "Mexico",
    "AXS", "Altus Airlines", "ALTUS", "United States",
    "AXV", "Aviaxess", "AXAVIA", "France",
    "AXX", "Advance Air Luftfahrtgesellschaft", "SKY SHUTTLE", "Germany",
    "AXY", "Air X Charter", "LEGEND", "Malta",
    "AYB", "Belgian Army", "BELGIAN ARMY", "Belgium",
    "AYE", "Yunnan Yingan Airlines", "AIR YING AN", "China",
    "AYG", "Yangon Airways", "AIR YANGON", "Burma",
    "AYM", "Airman  S.L.", "AIRMAN", "Spain",
    "AYN", "Atlantic Airlines  S.A.", "ATLANTIC NICARAGUA", "Nicaragua",
    "AYR", "Flight Training Europe", "CYGNET", "Spain",
    "AYT", "Ayeet Aviation & Tourism", "AYEET", "Israel",
    "AYU", "Yuhi Air Lines", "", "Japan",
    "AZB", "Zaab Air", "ZAAB AIR", "Ghana",
    "AZE", "Arcus-Air Logistic", "ARCUS AIR", "Germany",
    "AZF", "Air Zermatt AG", "AIR ZERMATT", "Switzerland",
    "AZG", "Silk Way West Airlines", "SILK WEST", "Azerbaijan",
    "AZI", "Astra Airlines", "ASTRA", "Greece",
    "AZJ", "Zas Air", "", "Egypt",
    "AZK", "Azalhelikopter", "AZALHELICOPTER", "Azerbaijan",
    "AZM", "Aerocozumel", "AEROCOZUMEL", "Mexico",
    "AZN", "Línea Aérea Amaszonas", "", "Bolivia",
    "AZP", "Arizona Pacific Airways", "ARIZONA PACIFIC", "United States",
    "AZQ", "Silk Way Airlines", "SILK LINE", "Azerbaijan",
    "AZR", "Zenith Air", "ZENAIR", "South Africa",
    "AZS", "Aviacon Zitotrans Air Company", "ZITOTRANS", "Russia",
    "AZT", "Azimut  S.A.", "AZIMUT", "Spain",
    "AZU", "Azul Linhas Aéreas Brasileiras", "Azul", "Brazil",
    "AZW", "Air Zimbabwe", "AIR ZIMBABWE", "Zimbabwe",
    "AZY", "Aztec Worldwide Airlines", "AZTEC WORLD", "United States",
    "AZZ", "Azza Transport", "AZZA TRANSPORT", "Sudan",
    "BAA", "Balkan Agro Aviation", "BALKAN AGRO", "Bulgaria",
    "BAB", "Bahrain Air BSC (Closed)", "AWAL", "Bahrain",
    "BAC", "BAC Leasing Limited", "", "United Kingdom",
    "BAE", "BAE Systems", "FELIX", "United Kingdom",
    "BAF", "Belgian Air Force", "BELGIAN AIRFORCE", "Belgium",
    "BAG", "Dba", "SPEEDWAY", "Germany",
    "BAH", "The Amiri Flight", "BAHRAIN", "Bahrain",
    "BAJ", "Baker Aviation", "RODEO", "United States",
    "BAK", "Blackhawk Airways", "BLACKHAWK", "United States",
    "BAL", "Belle Air Europe", "BELLEAIR EUROPE", "Italy",
    "BAM", "Business Air Services", "BUSINESS AIR", "Canada",
    "BAN", "British Antarctic Survey", "PENGUIN", "United Kingdom",
    "BAP", "Trans International Express Aviation", "BIG APPLE", "United States",
    "BAR", "Bradly Air (Charter) Services", "BRADLEY", "Canada",
    "BAS", "Aero Services", "AEROSERV", "Barbados",
    "BAT", "Premiair", "BALLISTIC", "Luxembourg",
    "BAU", "Bissau Airlines", "AIR BISSAU", "Guinea-Bissau",
    "BAV", "Bamboo Airways", "BAMBOO", "Vietnam",
    "BAW", "British Airways", "SPEEDBIRD", "United Kingdom",
    "BAX", "Best Aero Handling Ltd", "", "Russia",
    "BAY", "Bravo Airways", "BRAVOAVIANCA", "Ukraine",
    "BBA", "Bannert Air", "BANAIR", "Austria",
    "BBB", "SwedJet Airways", "BLACKBIRD", "Sweden",
    "BBC", "Biman Bangladesh Airlines", "BANGLADESH", "Bangladesh",
    "BBD", "Bluebird Nordic", "BLUE CARGO", "Iceland",
    "BBE", "Ababeel Aviation", "BABEL AIR", "Sudan",
    "BBF", "B-Air Charter", "SPEEDCHARTER", "Germany",
    "BBJ", "Blue Air Lines", "BLUE KOREA", "South Korea",
    "BBL", "IBM Euroflight Operations", "BLUE", "Switzerland",
    "BBN", "Civil Aviation Authority Airworthiness Division", "BRABAZON", "United Kingdom",
    "BBO", "Flybaboo", "BABOO", "Switzerland",
    "BBR", "Santa Barbara Airlines", "SANTA BARBARA", "Venezuela",
    "BBS", "Beibars CJSC", "BEIBARS", "Kazakhstan",
    "BBV", "Bravo Airlines", "BRAVO EUROPE", "Spain",
    "BBW", "BB Airways", "BEEBEE AIRWAYS", "Nepal",
    "BBZ", "Bluebird Aviation", "COBRA", "Kenya",
    "BCB", "Carib Express", "WAVEBIRD", "Barbados",
    "BCF", "BACH Flugbetriebsges", "BACH", "Austria",
    "BCH", "Phillips Air", "BEACHBALL", "United States",
    "BCI", "Blue Islands", "BLUE ISLAND", "United Kingdom",
    "BCJ", "Blue Jet Charters", "BLUE BOY", "Poland",
    "BCK", "Priority Aviation Company", "BANKCHECK", "United States",
    "BCN", "Ocean Air", "BLUE OCEAN", "Mauritania",
    "BCR", "British Charter", "BACKER", "United Kingdom",
    "BCS", "European Air Transport", "POSTMAN", "Belgium",
    "BCT", "BCT Aviation", "BOBCAT", "United Kingdom",
    "BCV", "Business Aviation Center", "BUSINESS AVIATION", "Ukraine",
    "BCY", "CityJet", "CITY JET", "Ireland",
    "BDA", "Blue Dart Aviation", "BLUE DART", "India",
    "BDF", "Bissau Discovery Flying Club", "BISSAU DISCOVERY", "Guinea-Bissau",
    "BDG", "Mississippi State University", "BULLDOG", "United States",
    "BDM", "Air Bandama", "BANDAMA", "Ivory Coast",
    "BDN", "DERA Boscombe Down", "GAUNTLET", "United Kingdom",
    "BDR", "Badr Airlines", "BADR AIR", "Sudan",
    "BDS", "South Asian Airlines", "SOUTH ASIAN", "Bangladesh",
    "BDV", "Aberdair Aviation", "ABERDAV", "Kenya",
    "BEA", "Best Aviation Ltd", "BEST AIR", "Bangladesh",
    "BEC", "State Air Company Berkut", "", "Kazakhstan",
    "BEE", "Flybe", "JERSEY", "United Kingdom",
    "BEF", "Balear Express", "BALEAR EXPRESS", "Spain",
    "BEH", "Bel Air Helicopters", "BLUECOPTER", "Denmark",
    "BEK", "Berkut Air", "BERKUT", "Kazakhstan",
    "BEL", "Brussels Airlines", "BEE-LINE", "Belgium",
    "BES", "Aero Services Executive", "BIRD EXPRESS", "France",
    "BET", "BETA - Brazilian Express Transportes Aéreos", "BETA CARGO", "Brazil",
    "BEZ", "Kingfisher Air Services", "SEA BREEZE", "United States",
    "BFA", "Presidence Du Faso", "", "Burkina Faso",
    "BFC", "Basler Flight Service", "BASLER", "United States",
    "BFF", "Air Baffin", "AIR BAFFIN", "Canada",
    "BFG", "Bear Flight", "BEARFLIGHT", "Sweden",
    "BFL", "Buffalo Airways", "BUFFALO", "Canada",
    "BFN", "Compagnie Nationale Naganagani", "", "Burkino Faso",
    "BFO", "Bombardier", "BOMBARDIER", "Canada",
    "BFR", "Burkina Airlines", "BURKLINES", "Burkina Faso",
    "BFS", "Business Flight Sweden", "BUSINESS FLIGHT", "Sweden",
    "BFW", "Bahrain Defence Force", "SUMMAN", "Bahrain",
    "BGA", "Airbus Transport International", "BELUGA", "France",
    "BGF", "Aviodetachment-28", "BULGARIAN", "Bulgaria",
    "BGG", "Aero BG", "AERO BG", "Mexico",
    "BGH", "BH Air", "BALKAN HOLIDAYS", "Bulgaria",
    "BGI", "British Gulf International", "BRITISH GULF", "São Tomé and Príncipe",
    "BGK", "British Gulf International-Fez", "GULF INTER", "Kyrgyzstan",
    "BGL", "Benin Golf Air", "BENIN GOLF", "Benin",
    "BGM", "Bugulma Air Enterprise", "BUGAVIA", "Russia",
    "BGR", "Budget Air Bangladesh", "BUDGET AIR", "Bangladesh",
    "BGT", "Bergen Air Transport", "BERGEN AIR", "Norway",
    "BHA", "Buddha Air", "BUDDHA AIR", "Nepal",
    "BHC", "Aerotaxis De La Bahia", "BAHIA", "Mexico",
    "BHI", "Balkh Airlines", "SHARIF", "Afghanistan",
    "BHK", "Blu Halkin", "BLUEHAKIN", "United Kingdom",
    "BHL", "Bristow Helicopters", "BRISTOW", "United Kingdom",
    "BHN", "Bristow Helicopters Nigeria", "BRISTOW HELICOPTERS", "Nigeria",
    "BHO", "Bhoja Airlines", "BHOJA", "Pakistan",
    "BHP", "Belair Airlines", "BELAIR", "Switzerland",
    "BHR", "Bighorn Airways", "BIGHORN AIR", "United States",
    "BHS", "Bahamasair", "BAHAMAS", "Bahamas",
    "BHV", "Specavia Air Company", "AVIASPEC", "Russia",
    "BHY", "Bosphorus European Airways", "BOSPHORUS", "Turkey",
    "BIB", "Michelin Air Services", "", "France",
    "BID", "Binair", "BINAIR", "Germany",
    "BIG", "Big Island Air", "BIG ISLE", "United States",
    "BIH", "British International Helicopters", "BRINTEL", "United Kingdom",
    "BIL", "Billund Air Center", "BILAIR", "Denmark",
    "BIN", "Boise Interagency Fire Center", "BISON-AIR", "United States",
    "BIO", "Bioflight A/S", "BIOFLIGHT", "Denmark",
    "BIR", "Bird Leasing", "BIRD AIR", "United States",
    "BIS", "Sky Bishek", "JUMA AIR", "Kyrgyzstan",
    "BIV", "Aviaservice", "AVIASERVICE", "Georgia",
    "BIZ", "Bizjet Ltd", "BIZZ", "United Kingdom",
    "BJA", "Baja Air", "BAJA AIR", "Mexico",
    "BJC", "Baltic Jet Aircompany", "BALTIC JET", "Latvia",
    "BJK", "Atlantic Airlines", "BLACKJACK", "United States",
    "BJS", "Business Jet Solutions", "SOLUTION", "United States",
    "BJT", "ACM Aviation", "BAY JET", "United States",
    "BJU", "AeroJet", "JET EXPRESS", "Angola",
    "BJV", "Beijing Vistajet Aviation", "BEIJING VISTA", "China",
    "BKA", "Bankair", "BANKAIR", "United States",
    "BKF", "BF-Lento OY", "BAKERFLIGHT", "Finland",
    "BKH", "RAF Barkston Heath", "", "United Kingdom",
    "BKJ", "Barken International", "BARKEN JET", "United States",
    "BKK", "Blink", "BLINKAIR", "United Kingdom",
    "BKL", "Aircompany Barcol", "BARCOL", "Russia",
    "BKP", "Bangkok Airways", "BANGKOK AIR", "Thailand",
    "BKR", "Civil Air Patrol South Carolina Wing", "BOX KAR", "United States",
    "BKV", "Bukovyna", "BUKOVYNA", "Ukraine",
    "BLA", "Blue Air", "BLUE AIR", "Romania",
    "BLB", "Blue Bird Aviation", "BLUEBIRD SUDAN", "Sudan",
    "BLC", "Bellesavia", "BELLESAVIA", "Belarus",
    "BLE", "Blue Line", "BLUE BERRY", "France",
    "BLF", "Blue1", "BLUEFIN", "Finland",
    "BLG", "Belgavia", "BELGAVIA", "Belgium",
    "BLH", "Blue Horizon Travel Club", "BLUE HORIZON", "United States",
    "BLI", "Thyssen Krupp AG", "BLUELINE", "Germany",
    "BLJ", "Blue Jet", "BLUEWAY", "Spain",
    "BLK", "Westcoast Energy", "BLUE FLAME", "Canada",
    "BLL", "Baltic Airlines", "BALTIC AIRLINES", "Russia",
    "BLN", "Bali International Air Service", "BIAR", "Indonesia",
    "BLS", "Bearskin Lake Air Service", "BEARSKIN", "Canada",
    "BLT", "Baltic Aviation", "BALTAIR", "United States",
    "BLU", "IMP Aviation Services", "BLUENOSE", "Canada",
    "BLV", "Bellview Airlines", "BELLVIEW AIRLINES", "Nigeria",
    "BLW", "Wermlandsflyg AB", "BLUESTAR", "Sweden",
    "BLX", "TUI fly Nordic", "BLUESCAN", "Sweden",
    "BLY", "Starair", "BLARNEY", "Ireland",
    "BLZ", "Aero Barloz", "AEROLOZ", "Mexico",
    "BMD", "British Medical Charter", "BRITISH MEDICAL", "United Kingdom",
    "BME", "Briggs Marine Environmental Services", "BRIGGS", "United Kingdom",
    "BMH", "Bristow Masayu Helicopters", "MASAYU", "Indonesia",
    "BMJ", "Bemidji Airlines", "BEMIDJI", "United States",
    "BMK", "GST Aero Aircompany", "MURAT", "Kazakhstan",
    "BML", "Bismillah Airlines", "BISMILLAH", "Bangladesh",
    "BMN", "Bowman Aviation", "BOWMAN", "United States",
    "BMR", "BMI Regional", "MIDLAND", "United Kingdom",
    "BMV", "Alatau Airlines", "OLIGA", "Kazakhstan",
    "BMW", "BMW", "BMW-FLIGHT", "Germany",
    "BMX", "Banco de Mexico", "BANXICO", "Mexico",
    "BNA", "Bun Air Corporation", "BUN AIR", "United States",
    "BNB", "Aero Banobras", "AEROBANOBRAS", "Mexico",
    "BNC", "Sundance Air", "BARNACLE AIR", "United States",
    "BND", "Bond Offshore Helicopters", "BOND", "United Kingdom",
    "BNE", "Benina Air", "BENINA AIR", "Libya",
    "BNG", "BN Group Limited", "VECTIS", "United Kingdom",
    "BNI", "Alberni Airways", "ALBERNI", "Canada",
    "BNJ", "Air Service Liège (ASL)", "JET BELGIUM", "Belgium",
    "BNL", "Blue Nile Ethiopia Trading", "NILE TRADING", "Ethiopia",
    "BNR", "Bonair Aviation", "BONAIR", "Canada",
    "BNS", "Bancstar - Valley National Corporation", "BANCSTAR", "United States",
    "BNT", "Bentiu Air Transport", "BENTIU AIR", "Sudan",
    "BNV", "Benane Aviation Corporation", "BENANE", "Mauritania",
    "BNW", "British North West Airlines", "BRITISH NORTH", "United Kingdom",
    "BNX", "LAI - Línea Aérea IAACA", "AIR BARINAS", "Venezuela",
    "BNZ", "Bonza", "BONZA", "Australia",
    "BOA", "Boniair", "KUMANOVO", "North Macedonia",
    "BOB", "Backbone A/S", "BACKBONE", "Denmark",
    "BOC", "Aerobona", "AEROBONA", "Mexico",
    "BOD", "Bond Air Services", "UGABOND", "Uganda",
    "BOE", "Boeing", "BOEING", "United States",
    "BOF", "Bordaire", "BORDAIR", "Canada",
    "BOL", "Transportes Aéreos Bolivianos", "BOL", "Bolivia",
    "BON", "B&H Airlines", "Air Bosna", "Bosnia and Herzegovina",
    "BOO", "Bookajet Limited", "BOOKAJET", "United Kingdom",
    "BOS", "OpenSkies", "MISTRAL", "United Kingdom",
    "BOT", "Air Botswana", "BOTSWANA", "Botswana",
    "BOU", "Bouraq Indonesia Airlines", "BOURAQ", "Indonesia",
    "BOV", "Boliviana de Aviación", "BOLIVIANA", "Bolivia",
    "BOX", "Aerologic", "GERMAN CARGO", "Germany",
    "BPA", "Blue Panorama Airlines", "BLUE PANOROMA", "Italy",
    "BPH", "Phoenix Helicopter Academy", "BLACK PHOENIX", "United Kingdom",
    "BPK", "Berkhut ZK", "VENERA", "Kazakhstan",
    "BPO", "Bundespolizei-Fliegertruppe", "PIROL", "Germany",
    "BPS", "Budapest Aircraft Services/Manx2", "BASE", "Hungary",
    "BPT", "Bonus Aviation", "BONUS", "United Kingdom",
    "BPX", "British Petroleum Exploration", "", "Colombia",
    "BRB", "BRA-Transportes Aéreos", "BRA-TRANSPAEREOS", "Brazil",
    "BRD", "Brock Air Services", "BROCK AIR", "Canada",
    "BRE", "Breeze Ltd", "AVIABREEZE", "Ukraine",
    "BRF", "Air Bravo", "AIR BRAVO", "Uganda",
    "BRG", "Bering Air", "BERING AIR", "United States",
    "BRJ", "Borajet", "BORA JET", "Turkey",
    "BRK", "Briansk State Air Enterprise", "BRIANSK-AVIA", "Russia",
    "BRL", "Air Brasd'or", "BRASD'OR", "Canada",
    "BRN", "Branson Airlines", "BRANSON", "United States",
    "BRO", "2Excel Aviation", "BROADSWORD", "United Kingdom",
    "BRP", "AeroBratsk", "AEROBRA", "Russia",
    "BRQ", "El-Buraq Air Transport", "BURAQAIR", "Libya",
    "BRR", "Mountain Air Service", "MOUNTAIN AIR", "United States",
    "BRS", "Brazilian Air Force", "BRAZILIAN AIR FORCE", "Brazil",
    "BRU", "Belavia Belarusian Airlines", "BELARUS AVIA", "Belarus",
    "BRW", "Bright Aviation Services", "BRIGHT SERVICES", "Bulgaria",
    "BRX", "Buffalo Express Airlines", "BUFF EXPRESS", "United States",
    "BRY", "Burundayavia", "BURAIR", "Kazakhstan",
    "BSB", "Air Wings", "ARBAS", "Moldova",
    "BSC", "Bistair - Fez", "BIG SHOT", "Kyrgyzstan",
    "BSD", "Blue Star Airlines", "AIRLINES STAR", "Mexico",
    "BSI", "Brasair Transportes Aéreos", "BRASAIR", "Brazil",
    "BSJ", "Skybus Jet", "SKYBUS JET", "Bahamas",
    "BSK", "Miami Air International", "BISCAYNE", "United States",
    "BSM", "Blue Sky Aviation", "", "Lebanon",
    "BSN", "Connectair Charters", "BASTION", "Canada",
    "BSO", "Aeroclub Barcelona-Sabadell", "", "Spain",
    "BSP", "Global Airways (BSP)", "", "Democratic Republic of Congo",
    "BSR", "Guine Bissaur Airlines", "BISSAU AIRLINES", "Guinea-Bissau",
    "BSS", "Bissau Aero Transporte", "BISSAU AIRSYSTEM", "Guinea-Bissau",
    "BST", "Best Air", "TUNCA", "Turkey",
    "BSW", "Blue Sky Airways", "SKY BLUE", "Czech Republic",
    "BSY", "Big Sky Airlines", "BIG SKY", "United States",
    "BTC", "BAL Bashkirian Airlines", "BASHKIRIAN", "Russia",
    "BTH", "Baltijas Helicopters", "BALTIJAS HELICOPTERS", "Latvia",
    "BTI", "Air Baltic", "AIRBALTIC", "Latvia",
    "BTK", "Batik Air", "BATIK", "Indonesia",
    "BTL", "Baltia Air Lines", "BALTIA", "United States",
    "BTP", "Veritair", "NET RAIL", "United Kingdom",
    "BTQ", "Boutique Air", "BOUTIQUE", "United States",
    "BTR", "Botir-Avia", "BOTIR-AVIA", "Kyrgyzstan",
    "BTS", "Aerotaxis Albatros", "AEROLINEAS ALBATROS", "Mexico",
    "BTT", "BT-Slavuta", "BEETEE-SLAVUTA", "Ukraine",
    "BTU", "Rolls-Royce plc", "ROLLS", "United Kingdom",
    "BTV", "Batavia Air", "BATAVIA", "Indonesia",
    "BTZ", "Bristow U.S. LLC", "BRISTOW", "United States",
    "BUC", "Bulgarian Air Charter", "BULGARIAN CHARTER", "Bulgaria",
    "BUE", "Orebro Aviation", "BLUELIGHT", "Sweden",
    "BUG", "UVT Aero", "", "Russia",
    "BUL", "Blue Airlines", "BLUE AIRLINES", "Democratic Republic of the Congo",
    "BUN", "Buryat Airlines Aircompany", "BURAL", "Russia",
    "BUZ", "Buzz Stansted", "BUZZ", "United Kingdom",
    "BVA", "Buffalo Airways", "BUFFALO AIR", "United States",
    "BVC", "Bulgarian Aeronautical Centre", "BULGARIAN WINGS", "Bulgaria",
    "BVN", "Baron Aviation Services", "SHOW-ME", "United States",
    "BVR", "ACM Air Charter", "BAVARIAN", "Germany",
    "BVT", "Berjaya Air", "BERJAYA", "Malaysia",
    "BVU", "Bellview Airlines  Sierra Leone", "BELLVIEW AIRLINES", "Sierra Leone",
    "BVV", "Sparc Avia", "SPARC", "Russia",
    "BWA", "Caribbean Airlines", "CARIBBEAN", "Trinidad and Tobago",
    "BWD", "Bluewest Helicopters-Greenland", "BLUEWEST", "Denmark",
    "BWI", "Blue Wing Airlines", "BLUE TAIL", "Suriname",
    "BWL", "British World Airlines", "BRITWORLD", "United Kingdom",
    "BWY", "Fleet Requirements Air Direction Unit", "BROADWAY", "United Kingdom",
    "BXA", "Bahrain Executive Air Services", "BEXAIR", "Bahrain",
    "BXH", "Bar XH Air", "PALLISER", "Canada",
    "BXI", "Brussels Airlines", "XENIA", "Belgium",
    "BXJ", "Brixtel Group", "BRIXTEL JET", "United States",
    "BYA", "Berry Aviation", "BERRY", "United States",
    "BYC", "Northern Airlines Sanya", "BEIYA", "China",
    "BYE", "Bayu Indonesia Air", "BAYU", "Indonesia",
    "BYF", "San Carlos Flight Center", "BAY FLIGHT", "United States",
    "BYG", "Bygone Aviation", "BYGONE", "United States",
    "BYL", "Bylina Joint-Stock Company", "BYLINA", "Russia",
    "BYR", "Berytos Airlines", "", "Lebanon",
    "BYT", "Patriot Aviation Limited", "BYTE", "United Kingdom",
    "BZA", "Bizair Fluggesellschaft", "BERLIN BEAR", "Germany",
    "BZE", "Zenith Aviation", "ZENSTAR", "United Kingdom",
    "BZF", "Jet Aviation Business Jets", "BIZFLEET", "United States",
    "BZH", "Brit Air", "BRITAIR", "France",
    "BZQ", "Seneca College", "STING", "Canada",
    "BZS", "Aero Biniza", "BINIZA", "Mexico",
    "BZY", "Fresh Air Aviation", "BREEZY", "United States",
    "BZZ", "Butane Buzzard Aviation Corporation", "BUZZARD", "United Kingdom",
    "CAA", "Civil Aviation Authority of the Czech Republic", "INSPECTOR", "Czech Republic",
    "CAB", "Chesapeake Air Service", "CHESAPEAKE AIR", "United States",
    "CAC", "Conquest Airlines", "CONQUEST AIR", "United States",
    "CAD", "Chilliwack Aviation", "CHILLIWACKAIR", "Canada",
    "CAE", "Colibri Aviation", "HUMMINGBIRD", "Canada",
    "CAG", "China National Aviation Corporation", "CHINA NATIONAL", "China",
    "CAI", "Corendon Airlines", "CORENDON", "Turkey",
    "CAJ", "Air Caraibes Atlantique", "CAR LINE", "France",
    "CAK", "Congo Air", "", "Bahamas",
    "CAL", "China Airlines", "DYNASTY", "Taiwan",
    "CAM", "Camai Air", "AIR CAMAI", "United States",
    "CAN", "Crest Aviation", "CREST", "United Kingdom",
    "CAO", "Air China Cargo", "AIRCHINA FREIGHT", "China",
    "CAP", "Civil Air Patrol", "CAP", "United States",
    "CAQ", "Cityair (Chester) Limited", "AIR CHESTER", "United Kingdom",
    "CAR", "Inter RCA", "QUEBEC ROMEO", "Central African Republic",
    "CAS", "Christman Air System", "CHRISTMAN", "United States",
    "CAT", "Copenhagen Air Taxi", "AIRCAT", "Denmark",
    "CAV", "Calm Air", "CALM AIR", "Canada",
    "CAW", "Comair", "COMMERCIAL", "South Africa",
    "CAX", "Central Air Express", "CENTRAL EXPRESS", "Democratic Republic of the Congo",
    "CAY", "Cayman Airways", "CAYMAN", "Cayman Islands",
    "CAZ", "Cat Aviation", "EUROCAT", "Switzerland",
    "CBA", "Civil Aviation Inspectorate of the Czech Republic", "CALIBRA", "Czech Republic",
    "CBB", "Cheboksary Airenterprise JSC", "CHEBAIR", "Russia",
    "CBD", "Lockheed Martin Aeronautics", "CATBIRD", "United States",
    "CBE", "Aerovías Caribe", "AEROCARIBE", "Mexico",
    "CBH", "Corporate Eagle Management Services", "CLUB HOUSE", "United States",
    "CBI", "Cabi", "CABI", "Ukraine",
    "CBJ", "Beijing Capital Airlines", "CAPITAL JET", "China",
    "CBL", "Cumberland Airways (Nicholson Air Service)", "CUMBERLAND", "United States",
    "CBM", "Cherokee Express", "BLUE MAX", "United States",
    "CBN", "Swedish Civil Aviation Administration", "CALIBRATION", "Sweden",
    "CBO", "Aerotaxi del Cabo", "TAXI CABO", "Mexico",
    "CBR", "Cabair College of Air Training", "CABAIR", "United Kingdom",
    "CBS", "Air Columbus", "AIR COLUMBUS", "Ukraine",
    "CBT", "Catalina Flying Boats", "CATALINA AIR", "United States",
    "CBV", "Aereo Cabo", "CABOAEREO", "Mexico",
    "CBY", "RAF Coningsby", "TYPHOON", "United Kingdom",
    "CCA", "Air China", "AIR CHINA", "China",
    "CCB", "Caricom Airways", "DOLPHIN", "Barbados",
    "CCE", "Cairo Air Transport Company", "", "Egypt",
    "CCF", "CCF Manager Airline", "TOMCAT", "Germany",
    "CCH", "Chilchota Taxi Aéreo", "CHILCHOTA", "Mexico",
    "CCK", "Flight Trac", "CABLE CHECK", "United States",
    "CCL", "Cambodia Airlines", "ANGKOR WAT", "Cambodia",
    "CCM", "Air Corsica", "CORSICA", "France",
    "CCP", "Champion Air", "CHAMPION AIR", "United States",
    "CCQ", "Capital City Air Carriers", "CAP CITY", "United States",
    "CCT", "Connect Air", "CONNECT", "Canada",
    "CCV", "Centro De Helicopteros Corporativos", "HELICORPORATIVO", "Mexico",
    "CCW", "Central Charter", "CENTRAL CHARTER", "Czech Republic",
    "CCX", "Colt International", "", "United States",
    "CCY", "Cherry Air", "CHERRY", "United States",
    "CDA", "Aerocardal", "CARDAL", "Chile",
    "CDC", "Loong Air", "LOONG AIR", "China",
    "CDE", "Comed Group", "COMEX", "United Kingdom",
    "CDG", "Shandong Airlines", "SHANDONG", "China",
    "CDI", "Cards Air Services", "CARDS", "Philippines",
    "CDL", "Sunbird Airlines", "CAROLINA", "United States",
    "CDM", "Carga Aérea Dominicana", "CARGA AEREA", "Dominican Republic",
    "CDN", "Canadian Helicopters", "CANADIAN", "Canada",
    "CDP", "Aero Condor Peru", "CONDOR-PERU", "Peru",
    "CDS", "Spectrem Air", "SPECDAS", "South Africa",
    "CDT", "Real Aero Club de Reus-Costa Dorado", "AEROREUS", "Spain",
    "CDU", "Aerotrans", "", "Russia",
    "CDV", "Airline Skol", "SKOL", "Russia",
    "CDY", "Heliaviation Limited", "CADDY", "United Kingdom",
    "CEA", "RegionsAir", "CORP-X", "United States",
    "CEB", "Cebu Pacific", "CEBU", "Philippines",
    "CEC", "Celtic Airways", "CELTAIR", "United Kingdom",
    "CED", "CEDTA (Compañía Ecuatoriana De Transportes Aéreos)", "CEDTA", "Ecuador",
    "CEE", "Servicios Aéreos Centrales", "CENTRA AEREOS", "Mexico",
    "CEF", "Czech Air Force", "CZECH AIR FORCE", "Czech Republic",
    "CEG", "Cega Aviation", "CEGA", "United Kingdom",
    "CEM", "Central Mongolia Airways", "CENTRAL MONGOLIA", "Mongolia",
    "CEP", "Chipola Aviation", "CHIPOLA", "United States",
    "CER", "Cetraca Aviation Service", "CETRACA", "Democratic Republic of the Congo",
    "CES", "China Eastern Airlines", "CHINA EASTERN", "China",
    "CET", "Centrafrican Airlines", "CENTRAFRICAIN", "Central African Republic",
    "CEV", "Centre d'Essais en Vol", "CENTEV", "France",
    "CEX", "Capitol Air Express", "CAPITOL EXPRESS", "United States",
    "CFA", "China Flying Dragon Aviation", "FEILONG", "China",
    "CFB", "Chongqing Forebase General Aviation", "FOREBASE", "China",
    "CFC", "Canadian Forces", "CANFORCE", "Canada",
    "CFD", "Cranfield University", "AERONAUT", "United Kingdom",
    "CFE", "BA CityFlyer", "FLYER", "United Kingdom",
    "CFF", "Aerofan", "AEROFAN", "Spain",
    "CFG", "Condor Flugdienst", "CONDOR", "Germany",
    "CFH", "CareFlight", "CARE FLIGHT", "Australia",
    "CFI", "Flight Inspection Center of the General Administration of Civil Aviation in China", "CHINA JET", "China",
    "CFJ", "Fujian Airlines", "FUJIAN", "China",
    "CFL", "Swedish Airlines", "SWEDISH", "Sweden",
    "CFN", "RAF Church Fenton", "CHURCH FENTON", "United Kingdom",
    "CFS", "Empire Airlines", "EMPIRE AIR", "United States",
    "CFT", "Jet Freighters", "CASPER FREIGHT", "United States",
    "CFU", "United Kingdom Civil Aviation Authority", "MINAIR", "United Kingdom",
    "CFV", "Aero Calafia", "CALAFIA", "Mexico",
    "CFZ", "Zhongfei General Aviation", "ZHONGFEI", "China",
    "CGA", "Congressional Air", "CONGRESSIONAL", "United States",
    "CGB", "Air Cargo Belize", "CARGO BELIZE", "Belize",
    "CGC", "Cal Gulf Aviation", "CAL-GULF", "São Tomé and Príncipe",
    "CGD", "Charlotte Air National Guard", "", "United States",
    "CGE", "Nelson Aviation College", "COLLEGE", "New Zealand",
    "CGG", "Walmart Aviation", "CHARGE", "United States",
    "CGH", "Guizhou Airlines", "GUIZHOU", "China",
    "CGI", "Rusair JSAC", "CGI-RUSAIR", "Russia",
    "CGK", "Click Airways", "CLICK AIR", "Kyrgyzstan",
    "CGL", "Seagle Air", "SEAGLE", "Slovakia",
    "CGM", "Cargoman", "HOTEL CHARLIE", "Oman",
    "CGN", "Chang An Airlines", "CHANGAN", "China",
    "CGO", "Chicago Air", "WILD ONION", "United States",
    "CGP", "Cargo Plus Aviation", "", "United Arab Emirates",
    "CGR", "Compagnia Generale Ripreseaeree", "COMPRIP", "Italy",
    "CGS", "Centre of Applied Geodynamica", "GEO CENTRE", "Russia",
    "CGU", "Chinguetti Airlines", "CHINGUETTI", "Mauritania",
    "CGV", "Aero Clube Do Algarve", "CLUBE ALGARVE", "Portugal",
    "CGX", "United States Coast Guard Auxiliary", "COASTGUARD AUXAIR", "United States",
    "CGY", "Corporacion Paraguaya De Aeronautica", "", "Paraguay",
    "CHA", "Central Flying Service", "CHARTER CENTRAL", "United States",
    "CHB", "West Air (China)", "WEST CHINA", "China",
    "CHC", "China Ocean Helicopter Corporation", "CHINA HELICOPTER", "China",
    "CHD", "223rd Flight Unit", "CHKALOVSK-AVIA", "Russia",
    "CHE", "Top Flight Air Service", "CHECK AIR", "United States",
    "CHF", "Chitaavia", "CHITA", "Russia",
    "CHG", "Challenge Airlines BE", "Challenge", "Belgium",
    "CHH", "Hainan Airlines", "HAINAN", "China",
    "CHI", "Cougar Helicopters", "COUGAR", "Canada",
    "CHJ", "Aircompany Chaika", "AIR CHAIKA", "Ukraine",
    "CHK", "Chalk's International Airlines", "CHALKS", "United States",
    "CHL", "Cohlmia Aviation", "COHLMIA", "United States",
    "CHM", "Chemech Aviation", "", "Pakistan",
    "CHN", "Channel Island Aviation", "CHANNEL", "United States",
    "CHO", "Chrome Air Services", "CHROME AIR", "United States",
    "CHP", "Aviacsa", "AVIACSA", "Mexico",
    "CHQ", "Chautauqua Airlines", "CHAUTAUQUA", "United States",
    "CHR", "Air Charter Services", "ZAIRE CHARTER", "Democratic Republic of the Congo",
    "CHS", "Challenge Aviation", "CHALLENGE AVIATION", "Australia",
    "CHU", "Church Aircraft", "CHURCHAIR", "United States",
    "CHV", "Air Charter Professionals", "CHARTAIR", "United States",
    "CHW", "Charter Air", "CHARTER WIEN", "Austria",
    "CHZ", "Cherline", "CHERL", "Russia",
    "CIA", "Civil Aviation Authority", "CALIMERA", "Slovakia",
    "CIB", "Condor", "CONDOR BERLIN", "Germany",
    "CIC", "ICC Canada", "AIR TRADER", "Canada",
    "CIE", "Czech Government Flying Service", "CZECH REPUBLIC", "Czech Republic",
    "CIG", "Sirius-Aero", "SIRIUS AERO", "Russia",
    "CII", "Cityfly", "CITYFLY", "Italy",
    "CIL", "Cecil Aviation", "CECIL", "United Kingdom",
    "CIM", "Cimber Sterling", "CIMBER", "Denmark",
    "CIN", "Cinnamon Air", "CINNAMON", "Sri Lanka",
    "CIO", "Il Ciocco International Travel Service", "CIOCCO", "Italy",
    "CIR", "Arctic Circle Air Service", "AIR ARCTIC", "United States",
    "CIT", "Zanesville Aviation", "ZANE", "United States",
    "CIU", "Cielos Airlines", "CIELOS", "Peru",
    "CIV", "Civil Aviation Authority of New Zealand", "CIVAIR", "New Zealand",
    "CIW", "Civair Airways", "CIVFLIGHT", "South Africa",
    "CJA", "CanJet", "CANJET", "Canada",
    "CJC", "Colgan Air", "COLGAN", "United States",
    "CJE", "Aeroservices Corporate", "BIRD JET", "France",
    "CJI", "Corporate Jets", "SEA JET", "United States",
    "CJR", "Caverton Helicopters", "CAVERTON AIR", "Nigeria",
    "CJS", "Commonwealth Jet Service", "COMMONWEALTH", "United States",
    "CJT", "Cargojet Airways", "CARGOJET", "Canada",
    "CJZ", "Caliber Jet", "CALIBER JET", "United States",
    "CKA", "Cook Inlet Aviation", "COOK-AIR", "United States",
    "CKC", "CKC Services", "", "United States",
    "CKE", "Corporate Aviation Services", "CHECKMATE", "United States",
    "CKK", "China Cargo Airlines", "CARGO KING", "China",
    "CKL", "Aviation Charter Services", "CIRCLE CITY", "United States",
    "CKM", "BKS Air (Rivaflecha)", "COSMOS", "Spain",
    "CKR", "Crown Air Systems", "CROWN AIR", "United States",
    "CKS", "Kalitta Air", "CONNIE", "United States",
    "CLA", "Comlux Aviation", "COMLUX", "Switzerland",
    "CLB", "Flight Precision Limited", "CALIBRATOR", "United Kingdom",
    "CLD", "Clowes Estates Limited", "CLOWES", "United Kingdom",
    "CLE", "Colemill Enterprises", "COLEMILL", "United States",
    "CLF", "Bristol Flying Centre", "CLIFTON", "United Kingdom",
    "CLG", "Chalair Aviation", "CHALLAIR", "France",
    "CLH", "Lufthansa CityLine", "HANSALINE", "Germany",
    "CLI", "Clickair", "CLICKJET", "Spain",
    "CLK", "Clark Aviation", "CLARKAIR", "United States",
    "CLL", "Aerovías Castillo", "AEROCASTILLO", "Mexico",
    "CLM", "Cargo Link (Caribbean)", "CARGO LINK", "Barbados",
    "CLN", "Barnes Olsen Aeroleasing", "SEELINE", "United Kingdom",
    "CLP", "Aero Club De Portugal", "CLUB PORTUGAL", "Portugal",
    "CLR", "Trans America", "CLINTON AIRWAYS", "United States",
    "CLS", "Challenge Air Transport", "AIRISTO", "Germany",
    "CLT", "Club Aerocelta de Vuelo Con Motor", "", "Spain",
    "CLU", "Cargo Logic Air", "FIREBIRD", "United Kingdom",
    "CLV", "Lom Praha Flying School", "AEROTRAINING", "Czech Republic",
    "CLW", "Centralwings", "CENTRALWINGS", "Poland",
    "CLX", "Cargolux", "CARGOLUX", "Luxembourg",
    "CLY", "Clay Lacy Aviation", "CLAY-LACY", "United States",
    "CLZ", "Cloud 9 Air Charters", "CLOUDLINE", "South Africa",
    "CMA", "Central European Airlines", "EUROCENTRAL", "Czech Republic",
    "CME", "Commerce Bank", "COMMERCE BANK", "United States",
    "CMF", "Air Care Alliance", "COMPASSION", "United States",
    "CMG", "Comet Airlines", "SUNSPY", "Nigeria",
    "CMH", "Commair Aviation", "COMMODORE", "United Kingdom",
    "CMI", "Continental Micronesia", "AIR MIKE", "United States",
    "CMJ", "Mudanjiang General Aviation", "MUDANJIANG", "China",
    "CMK", "Chernomor-Avia", "CHERAVIA", "Russia",
    "CML", "Commander Air Charter", "COMMANDAIR", "Canada",
    "CMM", "Compagnie Aérienne du Mali", "CAMALI", "Mali",
    "CMN", "Eckles Aircraft", "CIMMARON AIRE", "United States",
    "CMP", "Copa Airlines", "COPA", "Panama",
    "CMR", "CAM Air Management", "CAMEO", "United Kingdom",
    "CMS", "Commercial Aviation", "ACCESS", "Canada",
    "CMT", "Casement Aviation", "CASEMENT", "United States",
    "CMU", "Northern Aviation Service", "LANNA AIR", "Thailand",
    "CMV", "Calima Aviación", "CALIMA", "Spain",
    "CMX", "El Caminante Taxi Aéreo", "EL CAMINANTE", "Mexico",
    "CMY", "Cape Smythe Air", "CAPE SMYTHE AIR", "United States",
    "CMZ", "CM Stair", "CEE-EM STAIRS", "Mauritania",
    "CNB", "Cityline Hungary", "CITYHUN", "Hungary",
    "CNC", "Corporación Aéreo Cencor", "CENCOR", "Mexico",
    "CND", "Corendon Dutch Airlines", "DUTCH CORENDON", "Netherlands",
    "CNE", "Air Toronto", "CONNECTOR", "Canada",
    "CNG", "Coastal Airways", "SID-AIR", "United States",
    "CNH", "Aquila Air", "CHENANGO", "United States",
    "CNI", "Empresa Nacional De Servicios Aéreos", "SERAER", "Cuba",
    "CNJ", "Nanjing Airlines", "NINGHANG", "China",
    "CNK", "Sunwest Home Aviation", "CHINOOK", "Canada",
    "CNL", "Centennial Airlines", "WYO-AIR", "United States",
    "CNM", "Air China Inner Mongolia", "MENGYUAN", "China",
    "CNO", "SAS Braathens", "SCANOR", "Norway",
    "CNR", "Condor Aero Services", "CONAERO", "United States",
    "CNS", "Cobalt Air LLC", "CHRONOS", "United States",
    "CNT", "Centre national d'études des télécommunications - C.N.E.T.", "KNET", "France",
    "CNU", "Air Consul", "AIR CONSUL", "Spain",
    "CNV", "U.S. Navy Reserve Logistic Air Forces", "CONVOY", "United States",
    "CNW", "Continental Airways", "", "Moldovoa",
    "CNY", "Central Airways", "CENTRAL LEONE", "Sierra Leone",
    "COD", "Concordavia", "CONCORDAVIA", "Ukraine",
    "COF", "Confort Air", "CONFORT", "Canada",
    "COH", "RAF Coltishall", "COLT", "United Kingdom",
    "COM", "Comair", "COMAIR", "United States",
    "CON", "Continental Oil", "CONOCO", "United States",
    "COO", "Corporate Airlink", "CORPORATE", "Canada",
    "COP", "Copper State Air Service", "COPPER STATE", "United States",
    "COT", "RAF Cottesmore", "COTTESMORE", "United Kingdom",
    "COV", "Helicentre Coventry", "HELICENTRE", "United Kingdom",
    "COW", "COWI", "COWI", "Denmark",
    "COY", "Coyne Aviation", "COYNE AIR", "United Kingdom",
    "COZ", "Cosmic Air", "COSMIC AIR", "Nepal",
    "CPA", "Cathay Pacific", "CATHAY", "Hong Kong",
    "CPB", "Corpac Canada", "PENTA", "Canada",
    "CPD", "Capital Airlines", "CAPITAL DELTA", "Kenya",
    "CPG", "Corporacion Aeroangeles", "CORPORANG", "Mexico",
    "CPH", "Champagne Airlines", "CHAMPAGNE", "France",
    "CPI", "Compagnia Aeronautica Italiana", "AIRCAI", "Italy",
    "CPJ", "Baltimore Air Transport", "CORPJET", "United States",
    "CPL", "Chaparral Airlines", "CHAPARRAL", "United States",
    "CPM", "Compagnie Mauritanienne Des Transports", "", "Mauritania",
    "CPN", "Caspian Airlines", "CASPIAN", "Iran",
    "CPO", "Corporate Aircraft Company", "MOKAN", "United States",
    "CPR", "Corporate Air", "CORPAIR", "United States",
    "CPS", "Compass International Airways", "COMPASS", "United Kingdom",
    "CPT", "Corporate Air", "AIR SPUR", "United States",
    "CPV", "Air Corporate", "AIRCORPORATE", "Italy",
    "CPW", "Chippewa Air Commuter", "CHIPPEWA-AIR", "United States",
    "CPX", "Capital Air Service", "CAPAIR", "United States",
    "CPZ", "Compass Airlines", "COMPASS ROSE", "United States",
    "CQC", "Central Queensland Aviation College", "", "Australia",
    "CQH", "Spring Airlines", "AIR SPRING", "China",
    "CQN", "Chongqing Airlines", "CHONG QING", "China",
    "CRA", "Coronado Aerolíneas", "CORAL", "Colombia",
    "CRB", "Caricom Airways", "CARIBBEAN COMMUTER", "Suriname",
    "CRC", "Conair Aviation", "CONAIR-CANADA", "Canada",
    "CRE", "Cree Airways", "CREE AIR", "Canada",
    "CRF", "Croix Rouge Francais", "CROIX ROUGE", "France",
    "CRG", "Cargoitalia", "WHITE PELICAN", "Italy",
    "CRH", "CRI Helicopters Mexico", "HELI-MEX", "Mexico",
    "CRJ", "Air Cruzal", "AIR CRUZAL", "Angola",
    "CRK", "Hong Kong Airlines", "BAUHINIA", "Hong Kong",
    "CRL", "Corsairfly", "CORSAIR", "France",
    "CRM", "Commander Mexicana", "COMMANDERMEX", "Mexico",
    "CRN", "Carson Air Ltd", "CARSON", "Canada",
    "CRO", "Crown Airways", "CROWN AIRWAYS", "United States",
    "CRP", "Aerotransportes Corporativos", "AEROTRANSCORP", "Mexico",
    "CRQ", "Air Creebec", "CREE", "Canada",
    "CRS", "Comercial Aérea", "COMERCIAL AEREA", "Mexico",
    "CRT", "Caribintair", "CARIBINTAIR", "Haiti",
    "CRV", "Acropolis Aviation", "ACROPOLIS", "United Kingdom",
    "CRW", "Crownair", "REGAL", "Canada",
    "CRX", "Cross Aviation", "CROSSAIR", "United Kingdom",
    "CRY", "Primavia Limited", "CARRIERS", "United Kingdom",
    "CSA", "Czech Airlines", "CSA", "Czech Republic",
    "CSC", "Sichuan Airlines", "SI CHUAN", "China",
    "CSD", "Courier Services", "DELIVERY", "United States",
    "CSE", "CSE Aviation", "OXFORD", "United Kingdom",
    "CSF", "Clasair", "CALEDONIAN", "United Kingdom",
    "CSH", "Shanghai Airlines", "SHANGHAI AIR", "China",
    "CSI", "Central Skyport", "SKYPORT", "United States",
    "CSJ", "Castle Aviation", "CASTLE", "United States",
    "CSK", "Flightcraft", "CASCADE", "United States",
    "CSL", "California Air Shuttle", "CALIFORNIA SHUTTLE", "United States",
    "CSM", "Ratkhan Air", "LORRY", "Kazakhstan",
    "CSN", "China Southern Airlines", "CHINA SOUTHERN", "China",
    "CSO", "Casino Airline", "CASAIR", "United States",
    "CSP", "Casper Air Service", "CASPER AIR", "United States",
    "CSQ", "IBC Airways", "CHASQUI", "United States",
    "CSS", "SF Airlines", "SHUN FENG", "China",
    "CST", "Coast Air", "COAST CENTER", "Norway",
    "CSU", "Chari Aviation Services", "CHARI SERVICE", "Chad",
    "CSV", "Coastal Travels", "COASTAL TRAVEL", "Tanzania",
    "CSW", "SW Italia", "SILKITALIA", "Italy",
    "CSX", "Choice Airways", "CHOICE AIR", "United States",
    "CSY", "Shuangyang General Aviation", "SHUANGYANG", "China",
    "CSZ", "Shenzhen Airlines", "SHENZHEN AIR", "China",
    "CTA", "Aero Charter and Transport", "CHAR-TRAN", "United States",
    "CTD", "Aerocorporativos", "AEROCORPORATIVOS", "Mexico",
    "CTE", "Air Tenglong", "TENGLONG", "China",
    "CTF", "Cutter Aviation", "CUTTER FLIGHT", "United States",
    "CTG", "Canadian Coast Guard", "CANADIAN COAST GUARD", "Canada",
    "CTH", "China General Aviation Corporation", "TONGHANG", "China",
    "CTK", "East Midlands Helicopters", "COSTOCK", "United Kingdom",
    "CTL", "Central Airlines", "CENTRAL COMMUTER", "United States",
    "CTM", "Commandement Du Transport Aerien Militaire Francais", "COTAM", "France",
    "CTN", "Croatia Airlines", "CROATIA", "Croatia",
    "CTO", "Cape Air Transport", "", "Australia",
    "CTP", "Tashkent Aircraft Production Corporation", "CORTAS", "Uzbekistan",
    "CTQ", "CTK Network Aviation", "CITYLINK", "Ghana",
    "CTR", "Aerolíneas Centauro", "CENTAURO", "Mexico",
    "CTS", "Center-South", "CENTER-SOUTH", "Russia",
    "CTT", "Custom Air Transport", "CATT", "United States",
    "CTV", "Escuela De Pilotos Are Aviación", "ARE AVIACION", "Spain",
    "CTW", "Cargo Three", "THIRD CARGO", "Panama",
    "CTY", "Cryderman Air Service", "CENTURY", "United States",
    "CTZ", "CATA Línea Aérea", "CATA", "Argentina",
    "CUA", "China United Airlines", "LIANHANG", "China",
    "CUB", "Cubana de Aviación", "CUBANA", "Cuba",
    "CUH", "Urumqi Airlines", "LOULAN", "China",
    "CUI", "Cancun Air", "CAN-AIR", "Mexico",
    "CUK", "Polo Aviation", "CHUKKA", "United Kingdom",
    "CUO", "Aerocuahonte", "CUAHONTE", "Mexico",
    "CUT", "Court Helicopters", "COURT AIR", "South Africa",
    "CVA", "Air Chathams", "CHATHAM", "New Zealand",
    "CVC", "Centre-Avia", "AVIACENTRE", "Russia",
    "CVE", "Cabo Verde Express", "KABEX", "Cape Verde",
    "CVF", "Dassault Falcon Jet Corporation", "CLOVERLEAF", "United States",
    "CVG", "Carill Aviation", "CARILL", "United Kingdom",
    "CVK", "CAVOK Airlines", "CARGO LINE", "Ukraine",
    "CVL", "Coval Air", "COVAL", "Canada",
    "CVO", "Center Vol", "CENTERVOL", "Spain",
    "CVR", "Chevron U.S.A", "CHEVRON", "United States",
    "CVT", "Peran", "CVETA", "Kazakhstan",
    "CVU", "Grand Canyon Airlines", "CANYON VIEW", "United States",
    "CVV", "Comeravia", "COMERAVIA", "Venezuela",
    "CWA", "Canadian Western Airlines", "CANADIAN WESTERN", "Canada",
    "CWC", "Centurion Air Cargo", "CHALLENGE CARGO", "United States",
    "CWD", "Caernarfon Airworld", "AMBASSADOR", "United Kingdom",
    "CWE", "Celtic West", "CELTIC", "United Kingdom",
    "CWH", "Canadian Warplane Heritage Museum", "WARPLANE HERITAGE", "Canada",
    "CWK", "Comores Airlines", "CONTICOM", "Comoros",
    "CWL", "RAF Cranwell", "CRANWELL", "United Kingdom",
    "CWM", "Air Marshall Islands", "AIR MARSHALLS", "Marshall Islands",
    "CWN", "Cardiff Wales Flying Club", "CAMBRIAN", "United Kingdom",
    "CWP", "Australian Customs Service", "COASTWATCH", "Australia",
    "CWR", "Beijing City International Jet", "CITY WORLD", "China",
    "CWT", "Texas Airways", "TEXAS AIRWAYS", "United States",
    "CWU", "Wuhan Airlines", "WUHAN AIR", "China",
    "CWW", "Canair", "CANAIR", "China",
    "CWX", "Crow Executive Air", "CROW EXPRESS", "United States",
    "CWY", "Woodgate Aviation", "CAUSEWAY", "United Kingdom",
    "CWZ", "Capitol Wings Airline", "CAPWINGS", "United States",
    "CXA", "Xiamen Airlines", "XIAMEN AIR", "China",
    "CXB", "Comlux Aruba", "STARLUX", "Aruba",
    "CXE", "Caicos Express Airways", "CAICOS", "Turks and Caicos Islands",
    "CXH", "China Xinhua Airlines", "XINHUA", "China",
    "CXI", "Corendon Airlines Europe", "TOURIST", "Malta",
    "CXJ", "Xinjiang Airlines", "XINJIANG", "China",
    "CXO", "Conroe Aviation Services", "CONROE AIR", "United States",
    "CXS", "Boston-Maine Airways", "CLIPPER CONNECTION", "United States",
    "CYA", "Cheyenne Airways", "CHEYENNE AIR", "United States",
    "CYC", "Cyprair Tours", "CYPRAIR", "Cyprus",
    "CYE", "Aerocheyenne", "AEROCHEYENNE", "Mexico",
    "CYF", "Company Flight", "COMPANY FLIGHT", "Denmark",
    "CYG", "Yana Airlines", "VICAIR", "Cambodia",
    "CYH", "China Southern Airlines Henan", "YUHAO", "China",
    "CYL", "Air One Cityliner", "CITYLINER", "Italy",
    "CYO", "Air Transport", "COYOTE", "United States",
    "CYP", "Cyprus Airways", "CYPRUS", "Cyprus",
    "CYS", "Cypress Airlines", "SKYBIRD", "Canada",
    "CYT", "Crystal Shamrock Airlines", "CRYSTAL-AIR", "United States",
    "CYZ", "China Postal Airlines", "CHINA POST", "China",
    "DAA", "Decatur Aviation", "DECUR", "United States",
    "DAB", "Dassault Aviation", "", "France",
    "DAC", "McDonnell Douglas", "DACO", "United States",
    "DAD", "Dorado Air", "DORADO AIR", "Dominican Republic",
    "DAE", "DHL Aero Expreso", "YELLOW", "Panama",
    "DAF", "Danish Air Force", "DANISH AIRFORCE", "Denmark",
    "DAG", "Dagestan Airlines", "DAGAL", "Russia",
    "DAH", "Air Algérie", "AIR ALGERIE", "Algeria",
    "DAL", "Delta Air Lines", "DELTA", "United States",
    "DAM", "Kyrgyzstan Department of Aviation", "FLIGHT RESCUE", "Kyrgyzstan",
    "DAO", "Daallo Airlines", "DALO AIRLINES", "Djibouti",
    "DAP", "Aerovías DAP", "DAP", "Chile",
    "DAR", "Danish Army", "DANISH ARMY", "Denmark",
    "DAS", "Damascene Airways", "AIRDAM", "Syrian Arab Republic",
    "DAT", "Lynx Air", "DAUNTLESS", "Canada",
    "DAU", "Dauair", "DAUAIR", "Germany",
    "DAV", "Dornier Aviation Nigeria", "DANA AIR", "Nigeria",
    "DAY", "Daya Aviation", "DAYA", "Sri Lanka",
    "DBA", "Air Alpha", "DOUBLE-A", "United States",
    "DBC", "Gemini Air Group", "DIAMOND BACK", "United States",
    "DBD", "Air Niagara Express", "AIR NIAGARA", "Canada",
    "DBJ", "Duchess of Brittany (Jersey) Limited", "DUCHESS", "United Kingdom",
    "DBK", "Dubrovnik Air", "SEAGULL", "Croatia",
    "DCA", "Dreamcatcher Airways", "DREAM CATCHER", "United Kingdom",
    "DCC", "Caribbean Air Cargo", "CARICARGO", "Barbados",
    "DCE", "Dutch Caribbean Express", "DUTCH CARIBBEAN", "Netherlands Antilles",
    "DCL", "Transportes Aéreos Don Carlos", "DON CARLOS", "Chile",
    "DCM", "FLTPLAN (anonymized service)", "DOT COM", "United States",
    "DCN", "Federal Armed Forces", "DIPLOMATIC CLEARANCE", "Germany",
    "DCO", "David Crawshaw Consultants Limited", "", "United Kingdom",
    "DCS", "DC Aviation", "TWIN STAR", "Germany",
    "DCT", "Direct Flight", "", "United Kingdom",
    "DCV", "Discover Air", "DISCOVER", "United States",
    "DCX", "Daimler-Chrysler", "DAIMLER", "United States",
    "DDA", "D & D Aviation", "DUSTY", "United States",
    "DEA", "Delta Aerotaxi", "JET SERVICE", "Italy",
    "DEE", "Dixie Airways", "TACAIR", "United States",
    "DEF", "Aviation Defense Service", "TIRPA", "France",
    "DEI", "Ecoair", "", "Algeria",
    "DEL", "Carib Aviation", "RED TAIL", "Antigua and Barbuda",
    "DES", "Chilcotin Caribou Aviation", "CHILCOTIN", "Canada",
    "DET", "DETA Air", "SAMAL", "Kazakhstan",
    "DEV", "Red Devils Parachute Display Team", "RED DEVILS", "United Kingdom",
    "DFA", "Aero Coach Aviation", "AERO COACH", "United States",
    "DFS", "Dwyer Aircraft Services", "DWYAIR", "United States",
    "DGA", "Yellow River Delta General Aviation", "YELLOW RIVER", "China",
    "DGO", "DGO Jet", "DGO JET", "Mexico",
    "DGT", "Digital Equipment Corporation", "DIGITAL", "United States",
    "DGX", "Dasnair", "DASNA", "Switzerland",
    "DHA", "Dahla Airlines", "", "Democratic Republic of Congo",
    "DHC", "De Havilland", "DEHAVILLAND", "Canada",
    "DHE", "DAP Helicopteros", "HELIDAP", "Chile",
    "DHK", "DHL Air Limited", "WORLD EXPRESS", "United Kingdom",
    "DHV", "DHL Aviation", "WORLDSTAR", "South Africa",
    "DHX", "DHL International", "DILMUN", "Bahrain",
    "DIA", "Direct Air", "BLUE SKY", "United States",
    "DIC", "Aeromedica", "AEROMEDICA", "Mexico",
    "DIN", "Aerodin", "AERODIN", "Mexico",
    "DIP", "Diplomatic Freight Services", "DIPFREIGHT", "United Kingdom",
    "DIR", "Dirgantara Air Service", "DIRGANTARA", "Indonesia",
    "DIS", "Di Air", "DI AIR", "Serbia",
    "DIX", "Dix Aviation", "DIX FLIGHT", "Germany",
    "DJE", "Durango Jet", "DURANGO JET", "Mexico",
    "DJR", "Desert Jet", "DESERT FLIGHT", "United States",
    "DJS", "DayJet", "DAYJET", "United States",
    "DJT", "Dreamjet", "DREAMJET", "France",
    "DKA", "Daka", "", "Kazakhstan",
    "DKE", "Jubilee Airways", "DUKE", "United Kingdom",
    "DKH", "Juneyao Airlines", "AIR JUNEYAO", "China",
    "DKN", "Deccan Charters", "DECCAN", "India",
    "DKT", "Sioux Falls Aviation", "DAKOTA", "United States",
    "DKY", "Servicios Aéreos Elite", "DAKOY", "Spain",
    "DLA", "Air Dolomiti", "DOLOMITI", "Italy",
    "DLC", "Dehong South Asian General Aviation", "SOARCOPTER", "China",
    "DLH", "Lufthansa", "LUFTHANSA", "Germany",
    "DLI", "Delta Express International", "DELTA EXPRESS", "Ukraine",
    "DLK", "Millennium Airlines", "DEKKANLANKA", "Sri Lanka",
    "DLR", "Dala Air Services", "DALA AIR", "Nigeria",
    "DLS", "Aero Modelo", "AEROMODELO", "Mexico",
    "DMC", "Aerodinamica de Monterrey", "DINAMICAMONT", "Mexico",
    "DMD", "Namdeb Diamond Corporation", "DIAMONDJET", "Namibia",
    "DMF", "DMCFLY", "DEMLY", "Mexico",
    "DMI", "Aeroservicios Dinamicos", "AERODINAMICO", "Mexico",
    "DML", "Aerotaxis Dosmil", "", "Mexico",
    "DNA", "Aerodespachos de El Salvador", "AERODESPACHOS", "El Salvador",
    "DNC", "Aerodynamics Málaga", "FLYINGOLIVE", "Spain",
    "DND", "Eldinder Aviation", "DINDER", "Sudan",
    "DNI", "Servicios Aéreos Denim", "AERO DENIM", "Mexico",
    "DNJ", "Aerodynamics Incorporated", "DYNAJET", "United States",
    "DNK", "D&K Aviation", "DIRECT JET", "United States",
    "DNL", "Dutch Antilles Express", "DUTCH ANTILLES", "Netherlands Antilles",
    "DNR", "Dynamair Aviation", "DYNAMAIR", "Canada",
    "DNS", "Dniproaviaservis Company", "", "Ukraine",
    "DNU", "Danu Oro Transportas", "DANU", "Lithuania",
    "DNV", "Donavia", "DONAVIA", "Russia",
    "DNY", "Danish Navy", "DANISH NAVY", "Denmark",
    "DOC", "Norsk Luftambulanse", "HELIDOC", "Norway",
    "DOD", "USAF Air Mobility Operations Control Center", "", "United States",
    "DOI", "U.S. Department of the Interior", "INTERIOR", "United States",
    "DOJ", "Justice Prisoner and Alien Transportation System", "JUSTICE", "United States",
    "DOM", "Dos Mundos", "DOS MUNDOS", "Dominican Republic",
    "DON", "Donair Flying Club", "DONAIR", "United Kingdom",
    "DOP", "Dancopter", "DANCOPTER", "Denmark",
    "DOR", "Dornier", "DORNIER", "Germany",
    "DOT", "Telnic Limited", "DOT TEL", "United Kingdom",
    "DPJ", "Delta Private Jets", "JET CARD", "United States",
    "DPL", "Dome Petroleum", "DOME", "Canada",
    "DQA", "Maldivian (airline)", "SKYSURFER", "Maldives",
    "DRB", "Didier Rousset Buy", "DIDIER", "Chile",
    "DRC", "Triton Airlines", "TRITON AIR", "Canada",
    "DRD", "Aereo Dorado", "AEREO DORADO", "Mexico",
    "DRE", "Drummond Island Air", "MICHIGAN", "United States",
    "DRF", "Dream Flyers Training Center", "", "Spain",
    "DRK", "Druk Air", "ROYAL BHUTAN", "Bhutan",
    "DRL", "Omni Air Transport", "DRILLER", "United States",
    "DRM", "Airways Flight Training", "DARTMOOR", "United Kingdom",
    "DRN", "Central De Discos De Reynosa", "DISCOS REYNOSA", "Mexico",
    "DRO", "Aeronaves Del Noreste", "AERONORESTE", "Mexico",
    "DRT", "Darta", "DARTA", "France",
    "DRU", "Alrosa Air Company", "MIRNY", "Russia",
    "DRX", "Des R Cargo Express", "", "Mauritania",
    "DRY", "Deraya Air Taxi", "DERAYA", "Indonesia",
    "DSA", "Danbury Airways", "DANBURY AIRWAYS", "United States",
    "DSC", "Addis Air Cargo Services", "ADDIS CARGO", "Ethiopia",
    "DSH", "Dash Air Charter", "DASH CHARTER", "United States",
    "DSL", "Meridian Aviation", "DIESEL", "United Kingdom",
    "DSM", "LATAM Argentina", "LAN AR", "Argentina",
    "DSN", "DESNA", "DESNA", "Ukraine",
    "DSO", "Dassault Falcon Service", "DASSAULT", "France",
    "DSQ", "Dasab Airlines", "DASAB AIR", "Uganda",
    "DSR", "DAS Air Cargo", "DAIRAIR", "Uganda",
    "DST", "Aex Air", "DESERT", "United States",
    "DSU", "Delta State University", "DELTA STATE", "United States",
    "DTA", "TAAG Angola Airlines", "DTA", "Angola",
    "DTH", "Tassili Airlines", "TASSILI AIR", "Algeria",
    "DTN", "Data International", "DATA AIR", "Sudan",
    "DTR", "DAT Danish Air Transport", "DANISH", "Denmark",
    "DTV", "Centre Airlines", "DUTCH VALLEY", "United States",
    "DTY", "Destiny Air Services", "DESTINY", "Sierra Leone",
    "DUB", "Dubai Airwing", "DUBAI", "United Arab Emirates",
    "DUK", "Ducair", "LION KING", "Luxembourg",
    "DUN", "Dun'Air", "DUNAIR", "Mauritania",
    "DUO", "Duo Airways", "FLY DUO", "United Kingdom",
    "DVA", "Discovery Airways", "DISCOVERY AIRWAYS", "United States",
    "DVB", "Don Avia", "DONSEBAI", "Kazakhstan",
    "DVI", "Aerodavinci", "AERO DAVINCI", "Mexico",
    "DVN", "Adventia", "", "Spain",
    "DWN", "Dawn Air", "DAWN AIR", "United States",
    "DWR", "Delaware Skyways", "DELAWARE", "United States",
    "DWT", "Darwin Airline", "DARWIN", "Switzerland",
    "DWW", "Jet Courier Service", "DON JUAN", "United States",
    "DXH", "East Star Airlines", "EAST STAR", "China",
    "DXP", "Dallas Express Airlines", "DALLAS EXPRESS", "United States",
    "DYA", "Dynamic Airways", "DYNAMIC AIR", "United States",
    "DZR", "Midwest Aviation", "DOZER", "United States",
    "EAB", "Swiss Eagle", "SWISS EAGLE", "Switzerland",
    "EAC", "Executive Air Charter", "EXECAIR", "United States",
    "EAD", "Escola De Aviacao Aerocondor", "AERO-ESCOLA", "Portugal",
    "EAE", "Aeroservicios Ecuatorianos", "AECA", "Ecuador",
    "EAF", "European Aviation Air Charter", "EUROCHARTER", "United Kingdom",
    "EAG", "Eagle Airways", "EAGLE", "New Zealand",
    "EAH", "Baltimore Airways", "EASTERN", "United States",
    "EAI", "Emerald Airlines", "GEMSTONE", "Ireland",
    "EAK", "Euro-Asia Air", "EAKAZ", "Kazakhstan",
    "EAL", "European Air Express", "STAR WING", "Germany",
    "EAM", "Embassy Airlines", "EMBASSY AIR", "Nigeria",
    "EAN", "Skypower Express Airways", "NIGERIA EXPRESS", "Nigeria",
    "EAP", "Aero-Pyrenees", "AERO-PYRENEES", "France",
    "EAQ", "Eastern Australia Airlines", "EASTERN", "Australia",
    "EAR", "Transporte Ejecutivo Aéreo", "EJECUTIVO-AEREO", "Mexico",
    "EAT", "Air Transport", "TRANS EUROPE", "Slovakia",
    "EAV", "Eagle Airlines Luftverkehrsges", "MAYFLOWER", "Austria",
    "EAX", "Eastern Air Executive", "EASTEX", "United Kingdom",
    "EAZ", "Eastern Air", "EASAIR", "Zambia",
    "EBA", "Bond Aviation", "BOND AVIATION", "Italy",
    "EBC", "Aero Ejecutivo De Baja California", "CALIXJET", "Mexico",
    "EBE", "Minebea Technologies", "MINEBEA", "United States",
    "EBF", "MSR Flug-Charter", "SKYRUNNER", "Germany",
    "EBG", "Eurosense", "EUROSENSE", "Bulgaria",
    "EBJ", "European Business Jets", "", "United Kingdom",
    "EBS", "AEG Aviation Services", "", "United States",
    "ECA", "Eurocypria Airlines", "EUROCYPRIA", "Cyprus",
    "ECB", "European Coastal Airlines", "COASTAL CLIPPER", "Croatia",
    "ECC", "Eclair Aviation", "ECLAIR", "Czech Republic",
    "ECD", "Ecotour", "ECOTOUR", "Mexico",
    "ECE", "Air City", "AIRCITY", "Germany",
    "ECF", "Eurocopter", "EUROCOPTER", "France",
    "ECG", "Aero Ejecutivos RCG", "EJECTUIVOS RCG", "Mexico",
    "ECI", "Eastern Carolina Aviation", "EASTERN CAROLINA", "United States",
    "ECJ", "East Coast Jets", "EASTCOAST JET", "United States",
    "ECL", "Aeronáutica Castellana", "AERO CASTELLANA", "Spain",
    "ECM", "Aerolíneas Comerciales", "AERO COMERCIALES", "Mexico",
    "ECN", "Euro Continental AIE", "EURO CONTINENTAL", "Spain",
    "ECQ", "Eco Air", "SKYBRIDGE", "Nigeria",
    "ECS", "Executive Aircraft Charter and Charter Services", "ECHO", "Ireland",
    "ECT", "East Coast Airways", "EASTWAY", "South Africa",
    "ECU", "Ecuavia", "ECUAVIA", "Ecuador",
    "ECV", "Ecuatoguineana De Aviación (EGA)", "EQUATOGUINEA", "Equatorial Guinea",
    "ECX", "Ecomex Air Cargo", "AIR ECOMEX", "Angola",
    "ECY", "Euroceltic Airways", "ECHELON", "United Kingdom",
    "EDC", "Air Charter Scotland", "SALTIRE", "United Kingdom",
    "EDD", "Líneas Aéreas Ejectuivas De Durango", "LINEAS DURANGO", "Mexico",
    "EDJ", "Edwards Jet Center of Montana", "EDWARDS", "United States",
    "EDL", "Polizeihubschrauberstaffel Bayern", "POLICE EDELWEISS", "Germany",
    "EDO", "Elidolomiti", "ELIDOLOMITI", "Italy",
    "EDR", "Líneas Aéreas Eldorado", "ELDORADRO", "Colombia",
    "EDV", "Endeavor Air", "ENDEAVOR", "United States",
    "EDW", "Edelweiss Air", "EDELWEISS", "Switzerland",
    "EDY", "Apollo Air Service", "STOBART", "United Kingdom",
    "EEA", "Empresa Ecuatoriana De Aviación", "ECUATORIANA", "Ecuador",
    "EEF", "Estonian Air Force", "ESTONIAN AIR FORCE", "Estonia",
    "EES", "Eagle Express", "", "Serbia",
    "EET", "Air Este", "AESTE", "Spain",
    "EEU", "Eurofly Service", "EUROFLY", "Italy",
    "EEZ", "Eurofly", "E-FLY", "Italy",
    "EFC", "Air Mana", "FLIGHT TAXI", "France",
    "EFD", "Eisele Flugdienst", "EVER FLIGHT", "Germany",
    "EFG", "Elifriulia", "ELIFRIULIA", "Italy",
    "EFS", "EFAOS- Agencia De Viagens e Turismo", "EFAOS", "Angola",
    "EFT", "Embassy Freight Company", "EMBASSY FREIGHT", "United States",
    "EFW", "BA Euroflyer", "GRIFFIN", "United Kingdom",
    "EGJ", "Eagle Jet Charter", "EAGLE JET", "United States",
    "EGL", "Capital Trading Aviation", "PRESTIGE", "United Kingdom",
    "EGN", "Eagle Aviation France", "FRENCH EAGLE", "France",
    "EGO", "Gauteng Air Cargo", "GAUTENG", "South Africa",
    "EGR", "Eagle Air", "EAGLE SIERRA", "Sierra Leone",
    "EGU", "Eagle Air", "AFRICAN EAGLE", "Uganda",
    "EGV", "Enrique Gleisner Vivanco", "GLEISNER", "Chile",
    "EGX", "Eagle Air Company", "THAI EAGLE", "Thailand",
    "EGY", "Egyptian Air Force", "", "Egypt",
    "EHA", "East Hampton Aire", "AIRE HAMPTON", "United States",
    "EHD", "E H Darby Aviation", "PLATINUM AIR", "United States",
    "EHR", "Valfell-Verkflug", "ROTOR", "Iceland",
    "EIA", "Evergreen International Airlines", "EVERGREEN", "United States",
    "EIC", "Express International Cargo", "EXCARGO", "São Tomé and Príncipe",
    "EIJ", "Efata Papua Airlines", "EFATA", "Indonesia",
    "EIN", "Aer Lingus", "SHAMROCK", "Ireland",
    "EIR", "Eirjet", "EIRJET", "Ireland",
    "EIS", "EIS Aircraft", "COOL", "Germany",
    "EIX", "Ei Air Exports", "AIR EXPORTS", "Ireland",
    "EJA", "NetJets", "EXECJET", "United States",
    "EJC", "Grupo De Aviación Ejecutiva", "GRUPOEJECUTIVA", "Mexico",
    "EJD", "Elite Jets", "ELITE DUBAI", "United Arab Emirates",
    "EJM", "Executive Jet Management", "JET SPEED", "United States",
    "EJO", "Execujet Middle East", "MIDJET", "United Arab Emirates",
    "EJP", "Aeroservicios Ejecutivos Corporativos", "EJECCORPORATIVOS", "Mexico",
    "EJS", "Eurojet Servis", "EEJAY SERVICE", "Czech Republic",
    "EJT", "Eclipse Aviation", "ECLIPSE JET", "United States",
    "EJU", "easyJet Europe", "ALPINE", "Austria",
    "EJV", "Compania Ejecutiva", "EJECUTIVA", "Mexico",
    "EJX", "Egyptian Aviation", "", "Egypt",
    "EKA", "Equaflight Service", "EQUAFLIGHT", "Republic of the Congo",
    "EKC", "East Kansas City Aviation", "BLUE GOOSE", "United States",
    "ELA", "Eastland Air", "", "Australia",
    "ELB", "Ellinair", "ELLINAIR HELLAS", "Greece",
    "ELH", "Elilario Italia", "LARIO", "Italy",
    "ELJ", "Delta Private Jets", "ELITE JET", "United States",
    "ELL", "Estonian Air", "ESTONIAN", "Estonia",
    "ELM", "Crelam", "CRELAM", "Mexico",
    "ELN", "Eleron Aviation Company", "ELERON", "Ukraine",
    "ELO", "Eurolot", "EUROLOT", "Poland",
    "ELR", "Elrom Aviation and Investments", "", "Israel",
    "ELS", "El Sal Air", "EL SAL", "El Salvador",
    "ELT", "Elliott Aviation", "ELLIOT", "United States",
    "ELU", "Egyptian Leisure Airlines", "EGYPTIAN LEISURE", "Egypt",
    "ELV", "Transportes Aéreos Nacionales De Selva Tans", "AEREOS SELVA", "Peru",
    "ELW", "Yellow Wings Air Services", "YELLOW WINGS", "Kenya",
    "ELX", "Elan Express", "ELAN", "United States",
    "ELY", "El Al Israel Airlines", "ELAL", "Israel",
    "EMA", "Egyptian Aviation Company", "", "Egypt",
    "EMB", "Empresa Brasileira De Aeronáutica", "EMBRAER", "Brazil",
    "EMD", "Eaglemed (Ballard Aviation)", "EAGLEMED", "United States",
    "EME", "Eastern Metro Express", "EMAIR", "United States",
    "EMI", "Premium Air Shuttle", "BLUE SHUTTLE", "Nigeria",
    "EMJ", "Yellow Air Taxi/Friendship Airways", "", "United States",
    "EMN", "Examiner Training Agency", "AGENCY", "United Kingdom",
    "EMP", "Empire Air Service", "EMPIRE", "United States",
    "EMR", "Zenmour Airlines", "ZENMOUR", "Mauritania",
    "EMS", "Aero Servicios Empresariales", "SERVIEMPRESARIAL", "Mexico",
    "EMT", "Emetebe", "EMETEBE", "Ecuador",
    "EMU", "East Asia Airlines", "", "Macao",
    "EMX", "Euromanx Airways", "EUROMANX", "Austria",
    "ENA", "Dirección General de Aviación Civil y Telecomunicasciones", "ENA", "Spain",
    "ENC", "Endecots", "ENDECOTS", "Ecuador",
    "END", "Arrendadora y Transportadora Aérea", "ARRENDADORA", "Mexico",
    "ENI", "Enimex", "ENIMEX", "Estonia",
    "ENK", "Executive Airlink", "SUNBIRD", "United States",
    "ENR", "Scenic Air", "", "Namibia",
    "ENS", "Entergy Services", "ENTERGY SHUTTLE", "United States",
    "ENT", "Enter Air", "ENTER", "Poland",
    "ENV", "Victoria Aviation", "ENDEAVOUR", "United Kingdom",
    "ENW", "Aeronaves Del Noroeste", "AERONOR", "Spain",
    "ENY", "Envoy Air", "ENVOY", "United States",
    "ENZ", "Jota Aviation", "ENZO", "United Kingdom",
    "EOA", "Elilombarda", "LOMBARDA", "Italy",
    "EOK", "Aero K", "AEROHANKUK", "South Korea",
    "EOL", "Airailes", "EOLE", "France",
    "EOM", "Aero Ermes", "AERO ERMES", "Mexico",
    "EPB", "Eastern Pacific Aviation", "EAST PAC", "Canada",
    "EPC", "Espace Aviation Services", "ESPACE", "Democratic Republic of the Congo",
    "EPE", "Aero Empresarial", "AEROEMPRESARIAL", "Mexico",
    "EPL", "Aero Transportes Empresariales", "EMPRESARIALES", "Mexico",
    "EPR", "Express Airways", "EMPEROR", "Slovenia",
    "EPU", "Aero Elite Acapulco", "ELITACAPULCO", "Mexico",
    "EQC", "Ecuatorial Cargo", "ECUA-CARGO", "Equatorial Guinea",
    "EQT", "Equatorial Airlines", "", "Equatorial Guinea",
    "EQZ", "Equatair Air Services (Zambia)", "ZAMBIA CARGO", "Zambia",
    "ERC", "Esso Resources Canada", "ESSO", "Canada",
    "ERE", "Erie Airways", "AIR ERIE", "United States",
    "ERF", "Erfoto", "ERFOTO", "Portugal",
    "ERH", "Era Helicopters", "ERAH", "United States",
    "ERI", "Aero Servicios Regiomontanos", "ASERGIO", "Mexico",
    "ERJ", "Eurojet Italia", "JET ITALIA", "Italy",
    "ERK", "Aerosec", "AEROSEC", "Chile",
    "ERM", "Aeromaan", "EOMAAN", "Mexico",
    "ERO", "Aeroecom", "AEROECOM", "Venezuela",
    "ERT", "Eritrean Airlines", "ERITREAN", "Eritrea",
    "ERV", "Yerevan-Avia", "YEREVAN-AVIA", "Armenia",
    "ERX", "Earth Airlines Services", "EARTH AIR", "Nigeria",
    "ESB", "Aereosaba", "AEREOSABA", "Mexico",
    "ESC", "El Sol De América", "SOLAMERICA", "Venezuela",
    "ESE", "Ensenada Vuelos Especiales", "ENSENADA ESPECIAL", "Mexico",
    "ESF", "Estafeta Carga Aérea", "", "Mexico",
    "ESI", "ESI Eliservizi Italiani", "ELISERVIZI", "Italy",
    "ESJ", "Eastern SkyJets", "EASTERN SKYJETS", "United Arab Emirates",
    "ESL", "Russian Sky Airlines", "RADUGA", "Russia",
    "ESN", "Euro Sun", "EURO SUN", "Turkey",
    "ESO", "Avitat", "", "United Kingdom",
    "ESR", "Eastar Jet", "EASTAR", "South Korea",
    "ESS", "Eos Airlines", "NEW DAWN", "United States",
    "EST", "Carga Express Internacional", "CARGAINTER", "Mexico",
    "ESU", "Aerolíneas Ejecutivas Del Sureste", "ALESUR", "Mexico",
    "ESX", "Euroskylink", "CATFISH", "United Kingdom",
    "ESZ", "Aeronáutica La Esperanza", "ESPERANZA", "Mexico",
    "ETA", "Estrellas Del Aire", "ESTRELLAS", "Mexico",
    "ETC", "African Transport Trading and Investment Company", "TRANATTICO", "Sudan",
    "ETD", "Etihad Airways", "ETIHAD", "United Arab Emirates",
    "ETE", "Aero Siete", "AEROSIETE", "Mexico",
    "ETH", "Ethiopian Airlines", "ETHIOPIAN", "Ethiopia",
    "ETI", "H-Bird Aviation Services AB", "JETHAWK", "Sweden",
    "ETL", "Patterson Aviation Company", "ENTEL", "United States",
    "ETM", "Etram Air Wing", "ETRAM", "Angola",
    "ETN", "Chim-Nir Aviation", "CHIMNIR", "Israel",
    "ETP", "Empire Test Pilots' School", "TESTER", "United Kingdom",
    "ETS", "Flygtransporter I Nykoping", "EXTRANS", "Sweden",
    "ETV", "European Executive", "EURO EXEC", "United Kingdom",
    "EUC", "Eurocontrol", "", "Belgium",
    "EUG", "Euroguineana de Aviación", "EUROGUINEA", "Equatorial Guinea",
    "EUK", "Aer Lingus UK", "GREEN FLIGHT", "United Kingdom",
    "EUP", "Pan Europeenne Air Service", "SAVOY", "France",
    "EUT", "European 2000 Airlines", "FIESTA", "Malta",
    "EUU", "Euroamerican Air", "EUROAMERICAN", "Uruguay",
    "EUW", "EFS European Flight Service", "EUROWEST", "Sweden",
    "EUY", "EU Airways", "EUROAIRWAYS", "Ireland",
    "EVA", "EVA Air", "EVA", "Taiwan",
    "EVE", "Air Evex", "SUNBEAM", "Germany",
    "EVK", "Everett Aviation", "EVERETT", "Kenya",
    "EVL", "Evolem Aviation", "EVOLEM", "France",
    "EVM", "Natural Environment Research Council", "SCIENCE", "United Kingdom",
    "EVN", "Euraviation", "EURAVIATION", "Italy",
    "EVR", "Aeronautical Academy of Europe", "DIANA", "Portugal",
    "EVS", "Exploits Valley Air Services", "EVAS", "Canada",
    "EVT", "Everett Limited", "", "Tanzania",
    "EVY", "34 Squadron  Royal Australian Air Force", "Multiple", "",
    "EWE/EWL", "Eurowings Europe", "EUROPWINGS BLACK PEARL", "Austria",
    "EWG", "Eurowings", "EUROWINGS", "Germany",
    "EWL", "Eurowings Europe", "Black Pearl", "Malta",
    "EWR", "Ewa Air", "MAYOTTE AIR", "France",
    "EWS", "Enterprise World Airways", "WORLD ENTERPRISE", "Democratic Republic of the Congo",
    "EWW", "Emery Worldwide Airlines", "EMERY", "United States",
    "EXA", "Execair Aviation", "CANADIAN EXECAIRE", "Canada",
    "EXB", "Brazilian Army Aviation", "BRAZILIAN ARMY", "Brazil",
    "EXC", "European Executive Express", "ECHO EXPRESS", "Sweden",
    "EXE", "Executive Flight", "EXEC", "United States",
    "EXF", "Eximflight", "EXIMFLIGHT", "Mexico",
    "EXG", "Air Exchange", "EXCHANGE", "United States",
    "EXH", "G5 Executive", "BATMAN", "Switzerland",
    "EXJ", "Executive Jet Charter", "", "United Kingdom",
    "EXK", "Executive Airlines", "EXECUTIVE EAGLE", "United States",
    "EXL", "Sunshine Express Airlines", "", "Australia",
    "EXM", "United Kingdom Civil Aviation Authority", "EXAM", "United Kingdom",
    "EXN", "Exin", "EXIN", "Poland",
    "EXP", "Island Air Express", "ISLAND EXPRESS", "United States",
    "EXR", "Expertos En Carga", "EXPERTOS ENCARGA", "Mexico",
    "EXS", "Jet2.com", "CHANNEX", "United Kingdom",
    "EXT", "Night Express", "EXECUTIVE", "Germany",
    "EXU", "Executive Airlines", "SACAIR", "Spain",
    "EXV", "FitsAir", "EXPOAVIA", "Sri Lanka",
    "EXW", "Executive Airlines Services", "ECHOLINE", "Nigeria",
    "EXX", "International Air Corporation", "EXPRESS INTERNATIONAL", "United States",
    "EXY", "South African Express", "EXPRESSWAYS", "South Africa",
    "EXZ", "East African Safari Air Express", "TWIGA", "Kenya",
    "EYE", "F.S. Air Service", "SOCKEYE", "United States",
    "EZB", "Flugschule Eichenberger", "EICHENBURGER", "Switzerland",
    "EZD", "Philippines AirAsia", "REDHOT", "Philippines",
    "EZE", "Eastern Airways", "EASTFLIGHT", "United Kingdom",
    "EZJ", "Ezjet GT", "GUYANA JET", "Guyana",
    "EZS", "easyJet Switzerland", "TOPSWISS", "Switzerland",
    "EZX", "Eagle Express Air Charter", "EAGLEXPRESS", "Malaysia",
    "EZY", "easyJet UK", "EASY", "United Kingdom",
    "FAB", "First Air", "FIRST AIR", "Canada",
    "FAC", "Atlantic Helicopters", "FAROECOPTER", "Denmark",
    "FAD", "Rog-Air", "AIR FRONTIER", "Canada",
    "FAE", "Freshaer", "WILDGOOSE", "United Kingdom",
    "FAF", "Force Aerienne Francaise", "FRENCH AIR FORCE", "France",
    "FAG", "Argentine Air Force", "FUAER", "Argentina",
    "FAH", "Farnair Hungary", "BLUE STRIP", "Hungary",
    "FAK", "Financial Airxpress", "FACTS", "United States",
    "FAL", "Friendship Air Alaska", "FRIENDSHIP", "United States",
    "FAM", "Fumigación Aérea Andaluza", "FAASA", "Spain",
    "FAN", "AF-Air International", "FANBIRD", "Angola",
    "FAO", "Falcon Air Express", "PANTHER", "United States",
    "FAP", "F Air", "FAIR SCHOOL", "Czech Republic",
    "FAQ", "Aerofaq", "", "Ecuador",
    "FAR", "Falcon Air", "FALCAIR", "Slovenia",
    "FAS", "Florida Air Cargo", "FLORIDA CARGO", "United States",
    "FAT", "ASL Airlines Switzerland", "FARNER", "Switzerland",
    "FAU", "Falcon Airline", "FALCON AIRLINE", "Nigeria",
    "FAV", "Fair Aviation", "FAIRAVIA", "South Africa",
    "FAW", "Falwell Aviation", "FALWELL", "United States",
    "FAX", "Midwest Air Freighters", "FAIRFAX", "United States",
    "FAY", "Fayban Air Services", "FAYBAN AIR", "Nigeria",
    "FAZ", "Flint Aviation Services", "FLINT AIR", "United States",
    "FBA", "Fab Air", "FAB AIR", "Kyrgyzstan",
    "FBF", "Fine Airlines", "FINE AIR", "United States",
    "FBO", "TAG Farnborough Airport", "", "United Kingdom",
    "FBU", "French Bee", "FRENCH BEE", "France",
    "FBW", "Aviation Data Systems", "", "United States",
    "FBZ", "Flybondi", "BONDI", "Argentina",
    "FCA", "First Choice Airways", "JETSET", "United Kingdom",
    "FCB", "Cobalt", "NEW AGE", "Cyprus",
    "FCC", "First Cambodia Airlines", "FIRST CAMBODIA", "Cambodia",
    "FCE", "Flycolumbia", "FLYCOLUMBIA", "Spain",
    "FCI", "Air Carriers", "FAST CHECK", "United States",
    "FCJ", "AirSprint US", "FRACJET", "United States",
    "FCK", "FCS Flight Calibration Services", "NAV CHECKER", "Germany",
    "FCL", "Florida Coastal Airlines", "FLORIDA COASTAL", "United States",
    "FCN", "Falcon Air", "FALCON", "Sweden",
    "FCO", "Aerofrisco", "AEROFRISCO", "Mexico",
    "FCP", "Nelson Aviation College Ltd", "FLIGHTCORP", "New Zealand",
    "FCR", "Flying Carpet Company", "FLYING CARPET", "Lebanon",
    "FCS", "Facts Air", "MEXFACTS", "Mexico",
    "FCT", "Fly CI Limited", "DEALER", "United Kingdom",
    "FCU", "Alfa 4", "", "Mexico",
    "FCV", "Flight Centre Victoria", "NAVAIR", "Canada",
    "FDA", "Fuji Dream Airlines", "FUJI DREAM", "Japan",
    "FDB", "Flydubai", "SKYDUBAI", "UAE",
    "FDF", "IVV Femida", "", "Russia",
    "FDL", "Farmingdale State University", "FARMINGDALE STATE", "United States",
    "FDN", "Dolphin Air", "FLYING DOLPHIN", "United Arab Emirates",
    "FDO", "France Douanes", "FRENCH CUSTOM", "France",
    "FDP", "Flight Dispatch Services", "", "Poland",
    "FDR", "Federal Air", "FEDAIR", "South Africa",
    "FDS", "African Medical and Research Foundation", "FLYDOC", "Kenya",
    "FDX", "FedEx Express", "FEDEX", "United States",
    "FDY", "Sun Air International", "FRIENDLY", "United States",
    "FEA", "Far Eastern Air Transport", "Far Eastern", "Taiwan",
    "FEC", "Denver Express", "FALCON EXPRESS", "United States",
    "FED", "Líneas Aéreas Federales", "FEDERALES", "Argentina",
    "FEE", "Fly Europa Limited", "FLY EURO", "United Kingdom",
    "FEG", "FlyEgypt", "SKY EGYPT", "Egypt",
    "FEI", "Eagle Air", "ARCTIC EAGLE", "Iceland",
    "FEO", "Aeroferinco", "FERINCO", "Mexico",
    "FER", "Feria Aviación", "FERIA", "Spain",
    "FES", "Aero Taxis Y Servicios Alfe", "AERO ALFE", "Mexico",
    "FET", "Old Dominion Freight Lines", "FREIGHT LINE", "United States",
    "FEX", "Flightexec", "FLIGHTEXEC", "Canada",
    "FEY", "Fly Easy", "FLYEASY", "India",
    "FFA", "Avialesookhrana", "AVIALESOOKHRANA", "Russia",
    "FFB", "Africair Service", "FOXTROT FOXTROT", "Senegal",
    "FFC", "Fairoaks Flight Centre", "FAIROAKS", "United Kingdom",
    "FFD", "Stuttgarter Flugdienst", "FIRST FLIGHT", "Germany",
    "FFF", "Freedom Air Services", "INTER FREEDOM", "Nigeria",
    "FFG", "Flugdienst Fehlhaber", "WITCHCRAFT", "Germany",
    "FFH", "Shalom Air Services", "PEACE AIR", "Nigeria",
    "FFI", "Infinit Air", "INFINIT", "Spain",
    "FFL", "ForeFlight", "FOREFLIGHT", "United States",
    "FFM", "Firefly", "FIREFLY", "Malaysia",
    "FFP", "Fischer Air Polska", "FLYING FISH", "Poland",
    "FFR", "Fischer Air", "FISCHER", "Czech Republic",
    "FFS", "Florida Department of Agriculture", "FORESTRY", "United States",
    "FFT", "Frontier Airlines", "FRONTIER FLIGHT", "United States",
    "FFU", "GEC Marconi Avionics", "FERRANTI", "United Kingdom",
    "FFY", "Fun Flying Thai Air Service", "FUN FLYING", "Thailand",
    "FGA", "Georgian Aviation Federation", "GEORGIA FED", "Georgia",
    "FGC", "Departament d'Agricultura de la Generalitat de Catalunya", "FORESTALS", "Spain",
    "FGE", "Fly Georgia", "GEORGIA WING", "Georgia",
    "FGN", "National Gendarmerie", "FRANCE GENDARME", "France",
    "FGP", "Flying-Research Aerogeophysical Center", "FLYING CENTER", "Russia",
    "FGS", "Elitellina", "ELITELLINA", "Italy",
    "FGT", "Aero Freight", "FREIAERO", "Mexico",
    "FGY", "Froggy Corporate Aviation", "", "Australia",
    "FHE", "Hello", "FLYHELLO", "Switzerland",
    "FHL", "Fast Helicopters", "FINDON", "United Kingdom",
    "FHS", "Forth and Clyde Helicopter Services", "HELISCOT", "United Kingdom",
    "FHY", "Freebird Airlines", "FREEBIRD AIR", "Turkey",
    "FIA", "Fly One", "Fly One", "Moldova",
    "FIC", "Aerosafin", "AEROSAFIN", "Mexico",
    "FIE", "FlyOne Armenia", "ARMRIDER", "Armenia",
    "FIF", "Air Finland", "AIR FINLAND", "Finland",
    "FIH", "FinnHEMS", "FINNHEMS", "Finland",
    "FIL", "Fly Line", "FLYLINE", "Spain",
    "FIN", "Finnair", "FINNAIR", "Finland",
    "FIR", "First Line Air", "FIRSTLINE AIR", "Sierra Leone",
    "FIV", "CitationAir", "FIVE STAR", "United States",
    "FIX", "Airfix Aviation", "AIRFIX", "Finland",
    "FJC", "Falcon Jet Centre", "FALCONJET", "United Kingdom",
    "FJE", "Silverjet", "ENVOY", "United Kingdom",
    "FJI", "Fiji Airways", "PACIFIC", "Fiji",
    "FJL", "Fly Jinnah", "Okaab", "Pakistan",
    "FJS", "Florida Jet Service", "FLORIDAJET", "United States",
    "FJX", "Jet Sky Cargo and Air Charter", "", "Kenya",
    "FKI", "FLM Aviation Mohrdieck", "KIEL AIR", "Germany",
    "FKL", "Kelner Airways", "KELNER", "Canada",
    "FKS", "Focus Air", "FOCUS", "United States",
    "FLA", "Midway Express", "PALM", "United States",
    "FLC", "FINFO Flight Inspection Aircraft", "FLIGHT CHECK", "United States",
    "FLD", "Air Falcon", "", "Pakistan",
    "FLE", "Flair Airlines", "FLAIR", "Canada",
    "FLF", "Friendship Airlines", "FRIEND AIR", "Uganda",
    "FLG", "Pinnacle Airlines", "FLAGSHIP", "United States",
    "FLH", "Sky Bus", "MILE HIGH", "United States",
    "FLI", "Atlantic Airways", "FAROELINE", "Faroe Islands",
    "FLK", "Flylink Express", "FLYLINK", "Spain",
    "FLL", "Federal Airlines", "FEDERAL AIRLINES", "Sweden",
    "FLM", "Fly Air", "FLY WORLD", "Turkey",
    "FLN", "Flamingo Air-Line", "ILIAS", "Kazakhstan",
    "FLR", "Fleetair", "FLEETAIR", "South Africa",
    "FLU", "Flugschule Basel", "YELLOW FLYER", "Switzerland",
    "FLW", "FLowair Aviation", "QUICKFLOW", "France",
    "FLX", "Flight Express  Inc.", "FLIGHT EXPRESS", "United States",
    "FLY", "Fly Me Sweden", "FLYBIRD", "Sweden",
    "FLZ", "Aero Leasing", "AIR FLORIDA", "United States",
    "FMC", "Claessens International Limited", "CLAESSENS", "United Kingdom",
    "FMG", "FMG Verkehrsfliegerschule Flughafen Paderborn-Lippstadt", "HUSKY", "Germany",
    "FMI", "FMI Air", "FIRST MYANMAR", "Myanmar",
    "FMR", "Flamingo Air", "FLAMINGO AIR", "United States",
    "FMS", "Hadison Aviation", "HADI", "United States",
    "FMT", "Air Fret De Mauritanie", "", "Mauritania",
    "FMY", "Aviation Legere De L'Armee De Terre", "FRENCH ARMY", "France",
    "FNA", "Norlandair", "NORLAND", "Iceland",
    "FNC", "Finalair Congo", "FINALAIR CONGO", "Republic of the Congo",
    "FNF", "Finnish Air Force", "FINNFORCE", "Finland",
    "FNG", "Frontier Guard", "FINNGUARD", "Finland",
    "FNK", "Feniks Airline", "AURIKA", "Kazakhstan",
    "FNL", "Oulun Tilauslento", "FINN FLIGHT", "Finland",
    "FNM", "Avio Nord", "", "Italy",
    "FNO", "Aeroflota Del Noroeste", "RIAZOR", "Spain",
    "FNT", "L-3 Communications Flight International Aviation", "FLIGHT INTERNATIONAL", "United States",
    "FNV", "Transaviaservice", "TRANSAVIASERVICE", "Georgia",
    "FNY", "France Marine Nationale", "FRENCH NAVY", "France",
    "FOB", "Ford Motor Company", "FORDAIR", "United Kingdom",
    "FOC", "Office Federal De'Aviation Civile", "FOCA", "Switzerland",
    "FOI", "Flight Ops International", "", "United States",
    "FOP", "Fokker", "", "Netherlands",
    "FOR", "Formula One Management", "FORMULA", "United Kingdom",
    "FOS", "Bel Limited", "", "Russia",
    "FOX", "Flyr", "GREENSTAR", "Norway",
    "FPA", "Flygprestanda", "", "Sweden",
    "FPG", "TAG Aviation", "TAG AVIATION", "Switzerland",
    "FPO", "Europe Airpost", "FRENCH POST", "France",
    "FPR", "Peruvian Air Force", "", "Peru",
    "FPS", "Flightpass Limited", "FLIGHTPASS", "United Kingdom",
    "FPY", "Play", "PLAYER", "Iceland",
    "FQA", "Quikjet Cargo Airlines", "QUIK LIFT", "India",
    "FRA", "FR Aviation", "RUSHTON", "United Kingdom",
    "FRB", "Fly Rak", "RAKWAY", "United Arab Emirates",
    "FRC", "Icare Franche Compte", "FRANCHE COMPTE", "France",
    "FRE", "Freedom Air", "FREEDOM", "United States",
    "FRF", "Fleet Air International", "FAIRFLEET", "Hungary",
    "FRG", "Freight Runners Express", "FREIGHT RUNNERS", "United States",
    "FRJ", "Afrijet Airlines", "AFRIJET", "Nigeria",
    "FRK", "Afrika Aviation Handlers", "AFRIFAST", "Kenya",
    "FRM", "Federal Armored Service", "FEDARM", "United States",
    "FRQ", "Afrique Chart'air", "CHARTER AFRIQUE", "Cameroon",
    "FRR", "Fresh Air", "FRESH AIR", "Nigeria",
    "FRT", "Aerofreight Airlines", "", "Russia",
    "FRW", "Farwest Airlines", "FARWEST", "United States",
    "FRX", "Fort Aero", "FORT AERO", "Estonia",
    "FSA", "Foster Aviation", "FOSTER-AIR", "United States",
    "FSB", "FSB Flugservice & Development", "SEABIRD", "Germany",
    "FSC", "Four Star Aviation / Four Star Cargo", "FOUR STAR", "United States",
    "FSD", "EFS-Flugservice", "FLUGSERVICE", "Germany",
    "FSH", "Flash Airlines", "FLASH", "Egypt",
    "FSL", "Flight Safety Limited", "FLIGHTSAFETY", "United Kingdom",
    "FSR", "Flightstar Corporation", "FLIGHTSTAR", "United States",
    "FSU", "Flight Support Sweden", "", "Sweden",
    "FSW", "Faso Airways", "FASO", "Burkina Faso",
    "FSX", "Flagship Express Services", "FLAG", "United States",
    "FSY", "Algonquin Airlink", "FROSTY", "Canada",
    "FTA", "Frontier Flying Service", "FRONTIER-AIR", "United States",
    "FTC", "Air Affaires Tchad", "AFFAIRES TCHAD", "Chad",
    "FTE", "Fotografia F3", "FOTOGRAFIA", "Spain",
    "FTL", "Flightline", "FLIGHT-AVIA", "Spain",
    "FTM", "Flyteam Aviation", "FLYTEAM", "United Kingdom",
    "FTP", "Keystone Aerial Surveys", "FOOTPRINT", "United States",
    "FTR", "Finist'air", "FINISTAIR", "France",
    "FTS", "First Sabre", "FIRST SABRE", "Mexico",
    "FTY", "ABC Bedarfsflug", "FLY TYROL", "Austria",
    "FTZ", "Fastjet", "GREY BIRD", "Tanzania",
    "FUF", "Servicios Aereos Fun Fly", "SERVIFUN", "Mexico",
    "FUJ", "Fujairah Aviation Centre", "FUJAIRAH", "United Arab Emirates",
    "FUM", "Fuxion Line Mexico", "FUNLINE", "Mexico",
    "FUN", "Funtshi Aviation Service", "FUNTSHI", "Democratic Republic of the Congo",
    "FUT", "Aereo Futuro", "AEREO FUTURO", "Mexico",
    "FVA", "Cardinal/Air Virginia", "AIR VIRGINIA", "United States",
    "FVS", "Falcon Aviation Services", "FALCON AVIATION", "United Arab Emirates",
    "FWD", "Fair Wind Air Charter", "FAIR WIND", "United Arab Emirates",
    "FWI", "Air Caraïbes", "FRENCH WEST", "France",
    "FWK", "Flightworks", "", "United States",
    "FWQ", "Flight West Airlines", "UNITY", "Australia",
    "FWY", "Fairways Corporation", "FAIRWAYS", "United States",
    "FWZ", "Flugwerkzeuge Aviation Software", "", "Austria",
    "FXA", "Express Air", "EFFEX", "United States",
    "FXC", "Fortunair Canada", "AIR FUTURE", "Canada",
    "FXF", "VIP Air Charter", "FOX FLIGHT", "United States",
    "FXI", "Air Iceland", "FAXI", "Iceland",
    "FXL", "Fly Excellent", "FLY EXCELLENT", "Sweden",
    "FXR", "Foxair", "WILDFOX", "Italy",
    "FXT", "Flexflight", "", "Denmark",
    "FYA", "Flyant", "FLYANT", "Spain",
    "FYE", "Easy Link Aviation Services", "FLYME", "Nigeria",
    "FYG", "Flying Service", "FLYING GROUP", "Belgium",
    "FYH", "Flyhy Cargo Airlines", "FLY HIGH", "Thailand",
    "FYN", "Comfort Air", "FLYNN", "Germany",
    "FYS", "American Flyers", "AMERICAN FLYERS", "United States",
    "GAA", "Business Express", "BIZEX", "United States",
    "GAB", "Gendall Air", "GENDALL", "Canada",
    "GAC", "GlobeAir", "DREAM TEAM", "Austria",
    "GAD", "South Coast Aviation", "SOUTHCOAST", "United Kingdom",
    "GAE", "Grand Aire Express", "GRAND EXPRESS", "United States",
    "GAF", "German Air Force", "GERMAN AIR FORCE", "Germany",
    "GAG", "Greybird Pilot Academy", "GEEBIRD", "Denmark",
    "GAH", "Ga-Ma Helicoptere", "GAMHELICO", "France",
    "GAI", "Moskovia Airlines", "GROMOV AIRLINE", "Russia",
    "GAK", "Global Aviation and Services Group", "AVIAGROUP", "Libya",
    "GAL", "Galaxy Air", "GALAXY", "Kyrgyzstan",
    "GAM", "German Army", "GERMAN ARMY", "Germany",
    "GAN", "Gander Aviation", "GANAIR", "Canada",
    "GAO", "Golden Air", "GOLDEN", "Sweden",
    "GAP", "Air Philippines", "ORIENT PACIFIC", "Philippines",
    "GAQ", "Golfe Air Quebec", "GOLFAIR", "Canada",
    "GAR", "Commodore Aviation", "", "Australia",
    "GAS", "Galena Air Service", "GALENA AIR SERVICE", "United States",
    "GAT", "Gulf Air Inc", "GULF TRANS", "United States",
    "GAU", "Aerogaucho", "AEROGAUCHO", "Uruguay",
    "GAV", "Granada Aviación", "GRANAVI", "Spain",
    "GAX", "Full Express", "GRAND AIRE", "United States",
    "GBB", "Global Aviation Operations", "GLOBE", "South Africa",
    "GBE", "Gabon Express", "GABEX", "Gabon",
    "GBH", "Global Avia Handling", "", "Russia",
    "GBJ", "Aero Business Charter", "GLOBAL JET", "Germany",
    "GBL", "GB Airways", "GEEBEE AIRWAYS", "United Kingdom",
    "GBN", "Atlantic Airlines", "ATLANTIC GABON", "Gabon",
    "GBO", "Ogooue Air Cargo", "", "Gabon",
    "GBR", "Rader Aviation", "GREENBRIER AIR", "United States",
    "GBS", "Global Air Services Nigeria", "GLOBAL SERVE", "Nigeria",
    "GBT", "A-Jet Aviation Aircraft Management", "GLOBETROTTER", "Austria",
    "GBX", "GB Airlink", "ISLAND TIGER", "United States",
    "GCB", "Lignes Nationales Aeriennes - Linacongo", "LINACONGO", "Republic of the Congo",
    "GCC", "GECAS", "GECAS", "Ireland",
    "GCF", "Aeronor", "AEROCARTO", "Spain",
    "GCH", "Gama Aviation Switzerland", "GAMA SWISS", "Switzerland",
    "GCM", "Comair Flight Services", "GLOBECOM", "South Africa",
    "GCN", "Gulf Central Airlines", "GULF CENTRAL", "United States",
    "GCO", "Gemini Air Cargo", "GEMINI", "United States",
    "GCR", "Tianjin Airlines", "BO HAI", "China",
    "GCS", "GCS Air Service", "GALION", "United States",
    "GCW", "Global Air Crew", "GLOBALCREW", "Denmark",
    "GCY", "CHC Global Operations International", "HELIBIRD", "United Kingdom",
    "GDA", "GoldAir", "AIR PARTNER", "United Kingdom",
    "GDB", "Gendarmerie Belge", "BELGIAN GENERMERIE", "Belgium",
    "GDD", "Golden Airlines", "GOLDEN AIRLINES", "United States",
    "GDE", "Servicios Aéreos Gadel", "GADEL", "Mexico",
    "GDF", "DF Aviation", "", "Ukraine",
    "GDG", "S.P. Aviation", "GOLDEN GATE", "United States",
    "GDH", "Guneydogu Havacilik Isletmesi", "RISING SUN", "Turkey",
    "GDK", "Goldeck-Flug", "GOLDECK FLUG", "Austria",
    "GDN", "Gerry's Dnata", "", "Pakistan",
    "GDQ", "Lincoln Air National Guard", "", "United States",
    "GEA", "Guinea Ecuatorial Airlines", "GEASA", "Equatorial Guinea",
    "GEC", "Lufthansa Cargo", "LUFTHANSA CARGO", "Germany",
    "GED", "Europe Air Lines", "LANGUEDOC", "France",
    "GEE", "Geesair", "GEESAIR", "Canada",
    "GEN", "GENSA", "GENSA-BRASIL", "Brazil",
    "GES", "Gestair", "GESTAIR", "Spain",
    "GET", "Get High", "AIR FLOW", "Portugal",
    "GFA", "Gulf Air", "GULF AIR", "Bahrain",
    "GFC", "Gail Force Express", "GAIL FORCE", "United States",
    "GFD", "Gesellschaft Fur Flugzieldarstellung", "KITE", "Germany",
    "GFF", "Griffin Aviation", "GRIFFIN AIR", "Cyprus",
    "GFG", "Georgian National Airlines", "NATIONAL", "Georgia",
    "GFI", "Caribbean Star Airlines", "CARIB STAR", "Antigua and Barbuda",
    "GFN", "The 955 Preservation Group", "GRIFFON", "United Kingdom",
    "GFO", "Aerovías del Golfo", "AEROVIAS GOLFO", "Mexico",
    "GFS", "Gulfstream Airlines", "GULFSTAR", "United States",
    "GFT", "Gulfstream International Airlines", "GULF FLIGHT", "United States",
    "GFW", "GFW Aviation", "", "Australia",
    "GGA", "First Flying Squadron", "JAWJA", "United States",
    "GGC", "Cargo 360", "LONG-HAUL", "United States",
    "GGE", "Gobierno De Guinea Ecuatorial", "", "Equatorial Guinea",
    "GGF", "Georgian Cargo Airlines Africa", "GEORGIAN AFRICA", "Senegal",
    "GGL", "Aeronáutica", "GIRA GLOBO", "Angola",
    "GGN", "Air Georgian", "GEORGIAN", "Canada",
    "GGS", "GATSA", "GATSA", "Mexico",
    "GGT", "Trans Island Airways", "THUNDERBALL", "Bahamas",
    "GGV", "Houston Jet Services", "GREGG AIR", "Austria",
    "GGZ", "Global Georgian Airways", "GLOBAL GEORGIAN", "Georgia",
    "GHB", "Ghana International Airlines", "GHANA AIRLINES", "Ghana",
    "GHI", "GH Stansted Limited", "", "United Kingdom",
    "GHL", "Aviance UK", "HANDLING", "United Kingdom",
    "GHM", "Aero Service Bolivia", "", "Bolivia",
    "GHN", "Air Ghana", "AIR GHANA", "Ghana",
    "GHP", "Colvin Aviation", "GRASSHOPPER EX", "United States",
    "GHS", "Gatari Hutama Air Services", "GATARI", "Indonesia",
    "GHT", "Ghadames Air Transport", "", "Libya",
    "GHV", "Ground Handling Service de Mexico", "GROUND HANDLING", "Mexico",
    "GHY", "German Sky Airlines", "GERMAN SKY", "Germany",
    "GIA", "Garuda Indonesia", "INDONESIA", "Indonesia",
    "GIB", "GR-Avia", "GRAVIA", "Guinea",
    "GIC", "Compagnie de Bauxites de Guinee", "CEBEGE", "Guinea",
    "GIG", "Gacela Air Cargo", "GACELA AIR", "Mexico",
    "GIH", "Union des Transports Africains de Guinee", "TRANSPORT AFRICAIN", "Guinea",
    "GIJ", "Guinea Airways", "GUINEA AIRWAYS", "Guinea",
    "GIK", "Seba Airlines", "SEBA", "Guinea",
    "GIL", "African International Transport", "AFRICAN TRANSPORT", "Guinea",
    "GIP", "Air Guinee Express", "FUTURE EXPRESS", "Guinea",
    "GIQ", "Guinee Paramount Airlines", "GUIPAR", "Guinea",
    "GIY", "Probiz Guinee", "PROBIZ", "Guinea",
    "GIZ", "Africa Airlines", "AFRILENS", "Guinea",
    "GJA", "Globe Jet", "", "Lebanon",
    "GJB", "Trans-Air-Link", "SKY TRUCK", "United States",
    "GJS", "GoJet Airlines", "LINDBERGH", "United States",
    "GJT", "Gestión Aérea Ejecutiva", "BANJET", "Spain",
    "GKA", "US Army Parachute Team", "GOLDEN KNIGHTS", "United States",
    "GLA", "Great Lakes Airlines", "LAKES AIR", "United States",
    "GLB", "Global Airways (GLB)", "GLO-AIR", "United States",
    "GLC", "Global Aircargo", "", "Bahrain",
    "GLD", "Golden Star Air Cargo", "GOLDEN STAR", "Sudan",
    "GLE", "Goliaf Air", "GOLIAF AIR", "São Tomé and Príncipe",
    "GLF", "Gulfstream Aerospace", "GULFSTREAM TEST", "United States",
    "GLG", "Avianca Ecuador", "GALAPAGOS", "Ecuador",
    "GLJ", "Global Jet Austria", "GLOBAL JET AUSTRIA", "Austria",
    "GLL", "Air Gemini", "TWINS", "Angola",
    "GLM", "Aero Services Mali", "GLOBAL MALI", "Mali",
    "GLO", "Gol Transportes Aéreos", "GOL TRANSPORTE", "Brazil",
    "GLP", "Globus Airlines", "GLOBUS", "Russia",
    "GLQ", "El Quilada International Aviation", "QUILADA", "Sudan",
    "GLR", "Central Mountain Air", "GLACIER", "Canada",
    "GLS", "Galaircervis", "GALS", "Ukraine",
    "GLT", "Aero Charter", "GASLIGHT", "United States",
    "GLU", "Great Lakes Airways (Uganda)", "LAKES CARGO", "Uganda",
    "GLW", "Global Wings", "", "Japan",
    "GLX", "Gelix Airlines", "RUSSIAN BIRD", "Russia",
    "GMA", "Gama Aviation", "GAMA", "United Kingdom",
    "GMC", "General Motors", "GENERAL MOTORS", "United States",
    "GME", "Aguilas Mayas Internacional", "MAYAN EAGLES", "Guatemala",
    "GMG", "GMG Airlines", "GMG", "Bangladesh",
    "GMH", "Hughes Aircraft Company", "HUGHES EXPRESS", "United States",
    "GMI", "Germania", "GERMANIA", "Germany",
    "GMJ", "Gamisa Aviación", "GAMISA", "Spain",
    "GML", "G & L Aviation", "GEEANDEL", "South Africa",
    "GMM", "Aerotaxis Guamuchil", "AEROGUAMUCHIL", "Mexico",
    "GMQ", "Germania Express", "CORGI", "Germany",
    "GMR", "Golden Myanmar Airlines", "GOLDEN MYANMAR", "Myanmar",
    "GMS", "Aeroservicios Gama", "SERVICIOS GAMA", "Mexico",
    "GMT", "Grupo Aéreo Monterrey", "GRUPOMONTERREY", "Mexico",
    "GNA", "Servicios Aéreos Gana", "SERVIGANA", "Mexico",
    "GNC", "Guinea Cargo", "GUINEA CARGO", "Equatorial Guinea",
    "GND", "Grand Airways", "GRAND VEGAS", "United States",
    "GNF", "Gandalf Airlines", "Gandalf", "Italy",
    "GNJ", "Gain Jet Aviation", "HERCULES JET", "Greece",
    "GNL", "135 Airways", "GENERAL", "United States",
    "GNR", "Gambia International Airlines", "GAMBIA INTERNATIONAL", "Gambia",
    "GNS", "Eastern Executive Air Charter", "GENESIS", "United Kingdom",
    "GNT", "Amber Air", "GINTA", "Lithuania",
    "GNX", "Genex", "", "Belarus",
    "GNY", "German Navy", "GERMAN NAVY", "Germany",
    "GNZ", "General Aviation", "GONZO", "Poland",
    "GOA", "Alberta Government", "ALBERTA", "Canada",
    "GOB", "Dash Aviation", "PILGRIM", "United Kingdom",
    "GOF", "Gof-Air", "GOF-AIR", "Mexico",
    "GOI", "Gofir", "SWISS HAWK", "Switzerland",
    "GOJ", "EuroJet Aviation", "GOJET", "United Kingdom",
    "GOL", "Cardolaar", "CARGOLAAR", "Namibia",
    "GOM", "Gomel Airlines", "GOMEL", "Belarus",
    "GOP", "Gospa Air", "GOSPA AIR", "Mexico",
    "GOR", "Gorlitsa Airlines", "GORLITSA", "Ukraine",
    "GOS", "Goldfields Air Services", "", "Australia",
    "GOT", "WaltAir", "GOTHIC", "Sweden",
    "GOW", "GoAir", "GOAIR", "India",
    "GPA", "Golden Pacific Airlines", "GOLDEN PAC", "United States",
    "GPC", "Gulf Pearl Air Lines", "AIR GULFPEARL", "Libya",
    "GPD", "Tradewind Aviation", "GOODSPEED", "United States",
    "GPE", "GP Express Airlines", "REGIONAL EXPRESS", "United States",
    "GPM", "Grup Air-Med", "GRUPOMED", "Spain",
    "GPR", "GPM Aeroservicio", "GPM AEROSERVICIO", "Mexico",
    "GRA", "Guardian Air Asset Management", "FLEX", "South Africa",
    "GRD", "National Grid plc", "GRID", "United Kingdom",
    "GRE", "Air Scotland", "GREECE AIRWAYS", "Greece",
    "GRG", "Air Georgia", "AIR GEORGIA", "Georgia",
    "GRI", "Air Cargo Center", "", "São Tomé and Príncipe",
    "GRL", "Air Greenland", "GREENLAND", "Greenland",
    "GRP", "Great Plains Airlines", "GREAT PLAINS", "United States",
    "GRR", "Agroar - Trabalhos Aéreos", "AGROAR", "Portugal",
    "GRS", "Golden Rule Airlines", "GOLDEN RULE", "Kyrgyzstan",
    "GRT", "Gabon-Air-Transport", "", "Gabon",
    "GRV", "Vernicos Aviation", "NIGHT RIDER", "Greece",
    "GRX", "Aircompany Grodno", "GRODNO", "Belarus",
    "GRY", "New York State Police", "GRAY RIDER", "United States",
    "GRZ", "Government of Zambia Communications Flight", "COM FLIGHT", "Zambia",
    "GSA", "Garden State Airlines", "GARDEN STATE", "United States",
    "GSJ", "Grossmann Jet Service", "GROSSJET", "Czech Republic",
    "GSK", "Global Sky Aircharter", "GLOBAL SKY", "United States",
    "GSL", "Geographic Air Surveys", "SURVEY-CANADA", "Canada",
    "GSP", "Airlift Alaska", "GREEN SPEED", "United States",
    "GSS", "Global Supply Systems", "JET LIFT", "United Kingdom",
    "GSV", "Agrocentr-Avia", "AGRAV", "Kazakhstan",
    "GSW", "Sky Wings Airlines", "", "Greece",
    "GSY", "Guard Systems", "GUARD AIR", "Norway",
    "GTC", "Altin Havayolu Tasimaciligi Turizm Ve Ticaret", "GOLDEN WINGS", "Turkey",
    "GTH", "General Aviation Flying Services", "GOTHAM", "United States",
    "GTI", "Atlas Air", "GIANT", "United States",
    "GTP", "Aerotaxi Grupo Tampico", "GRUPOTAMPICO", "Mexico",
    "GTR", "Gestar", "STAR GESTAR", "Chile",
    "GTV", "Empresa de Aviación Aerogaviota", "GAVIOTA", "Cuba",
    "GTX", "GTA Air", "BIG-DEE", "United States",
    "GTY", "National Aviation Company", "", "Egypt",
    "GUA", "Aerotaxis de Aguascalientes", "AGUASCALIENTES", "Mexico",
    "GUE", "Aero Servicio Guerrero", "AERO GUERRERO", "Mexico",
    "GUF", "Gulf African Airlines", "GULF AFRICAN", "The Gambia",
    "GUG", "Aviateca", "AVIATECA", "Guatemala",
    "GUJ", "Gujarat Airways", "GUJARATAIR", "India",
    "GUL", "Gull Air", "GULL-AIR", "United States",
    "GUM", "Gum Air", "GUM AIR", "Suriname",
    "GUN", "Grant Aviation", "HOOT", "United States",
    "GUS", "Guja", "GUJA", "Mexico",
    "GUY", "Air Guyane", "GREEN BIRD", "French Guiana",
    "GVG", "Flygaktiebolaget Gota Vingar", "BLUECRAFT", "Sweden",
    "GVI", "Air Victoria Georgia", "IRINA", "Georgia",
    "GVN", "Gavina", "GAVINA", "Spain",
    "GWA", "Great Western Air", "G-W AIR", "United States",
    "GWI", "Germanwings", "GERMAN WINGS", "Germany",
    "GWL", "Great Wall Airlines", "GREAT WALL", "China",
    "GWN", "Gwyn Aviation", "GWYN", "United Kingdom",
    "GWS", "General Airways", "GENAIR", "South Africa",
    "GWY", "USA3000 Airlines", "GETAWAY", "United States",
    "GXA", "Grixona", "GRIXONA", "Moldova",
    "GXL", "Star XL German Airlines", "STARDUST", "Germany",
    "GXY", "Galaxy Airlines", "GALAX", "Japan",
    "GYP", "Eagle Aviation", "GYPSY", "United Kingdom",
    "GZA", "Excellent Air", "EXCELLENT AIR", "Germany",
    "GZD", "Grizodubova Air Company", "GRIZODUBOVA AIR", "Russia",
    "GZP", "Gazpromavia", "GAZPROMAVIA", "Russia",
    "GZQ", "Zagros Air", "ZAGROS", "Iraq",
    "HAA", "Helicopteros Agroforestal", "AGROFORESTAL", "Chile",
    "HAC", "Henebury Aviation", "", "Australia",
    "HAD", "Air d'Ayiti", "HAITI AVIA", "Haiti",
    "HAF", "Hellenic Air Force", "HELLENIC AIR FORCE", "Greece",
    "HAG", "Hageland Aviation Services", "HAGELAND", "United States",
    "HAH", "Air Comores International", "AIR COMORES", "Comoros",
    "HAI", "Century Aviation International", "", "Canada",
    "HAJ", "Hajvairy Airlines", "HAJVAIRY", "Pakistan",
    "HAK", "Pegasus Helicopters", "HELIFALCON", "Norway",
    "HAL", "Hawaiian Airlines", "HAWAIIAN", "United States",
    "HAM", "Haiti Ambassador Airlines", "", "Haiti",
    "HAN", "Hansung Airlines", "HANSUNG AIR", "Republic of Korea",
    "HAP", "Helicopteros Aero Personal", "HELIPERSONAL", "Mexico",
    "HAR", "Harbor Airlines", "HARBOR", "United States",
    "HAS", "Honduras Airlines", "HONDURAS AIR", "Honduras",
    "HAT", "Air Taxi", "TAXI BIRD", "France",
    "HAU", "Skyhaul", "SKYHAUL", "Japan",
    "HAV", "Havilah Air Services", "HAVILAH", "Nigeria",
    "HAW", "Bangkok Aviation Center", "THAI HAWK", "Thailand",
    "HAX", "Benair", "SCOOP", "Norway",
    "HAY", "Hamburg Airways", "HAMBURG AIRWAYS", "Germany",
    "HBA", "Trail Lake Flying Service", "HARBOR AIR", "United States",
    "HBC", "Haitian Aviation Line", "HALISA", "Haiti",
    "HBI", "CHC Denmark", "HELIBIRD", "Denmark",
    "HBL", "Faroecopter", "HELIBLUE", "Denmark",
    "HBT", "Polizeihubschrauberstaffel Thüringen", "HABICHT", "Germany",
    "HBU", "Universal Avia", "KHARKIV UNIVERSAL", "Ukraine",
    "HCA", "Lake Havasu Air Service", "HAVASU", "United States",
    "HCB", "Helenair (Barbados)", "HELEN", "Barbados",
    "HCC", "Holidays Czech Airlines", "CZECH HOLIDAYS", "Czech Republic",
    "HCK", "Heli-Charter", "HELI-CHARTER", "United Kingdom",
    "HCL", "Helenair Corporation", "HELENCORP", "Saint Lucia",
    "HCP", "Helicopter", "HELI CZECH", "Czech Republic",
    "HCV", "Halcyonair", "CREOLE", "Cape Verde",
    "HCY", "Helios Airways", "HELIOS", "Cyprus",
    "HDC", "Helcopteros De Cataluna", "HELICATALUNA", "Spain",
    "HDI", "Hoteles Dinamicos", "DINAMICOS", "Mexico",
    "HDR", "Helikopterdrift", "HELIDRIFT", "Norway",
    "HEA", "Heliavia-Transporte Aéreo", "HELIAVIA", "Portugal",
    "HEB", "Heli Bernina", "HELIBERNINA", "Switzerland",
    "HEC", "Heliservicio Campeche", "HELICAMPECHE", "Mexico",
    "HED", "Heritage Aviation Developments", "FLAPJACK", "United Kingdom",
    "HEI", "Aerohein", "AEROHEIN", "Chile",
    "HEL", "Helicol", "HELICOL", "Colombia",
    "HEM", "CHC Helicopter", "HEMS", "Australia",
    "HEN", "Helicópteros Y Vehículos Nacionales Aéreos", "HELINAC", "Mexico",
    "HER", "Hex'Air", "HEX AIRLINE", "France",
    "HET", "TAF Helicopters", "HELITAF", "Spain",
    "HEX", "Honiara Cargo Express", "HONIARA CARGO", "Solomon Islands",
    "HEZ", "Arrow Aviation", "ARROW", "Israel",
    "HFM", "Hi Fly Malta", "MOONRAKER", "Malta",
    "HFR", "Heli France", "HELIFRANCE", "France",
    "HFY", "Hi Fly", "SKY FLYER", "Portugal",
    "HGA", "Hogan Air", "HOGAN AIR", "United States",
    "HGB", "Greater Bay Airlines", "GREATER BAY", "Hong Kong",
    "HGD", "Hangard Aviation", "HANGARD", "Mongolia",
    "HGH", "Atlantic Air Lift", "HIGHER", "France",
    "HGK", "Fika Salaama Airlines", "SALAAMA", "Uganda",
    "HGR", "Hangar 8", "HANG", "United Kingdom",
    "HGT", "GMJ Air Shuttle", "HIGHTECH", "United States",
    "HHE", "Heli-Holland", "HELI HOLLAND", "Netherlands",
    "HHH", "Helicsa", "HELICSA", "Spain",
    "HHI", "Hamburg International", "HAMBURG JET", "Germany",
    "HHN", "Hahn Air", "ROOSTER", "Germany",
    "HHO", "Houston Helicopters", "HOUSTON HELI", "United States",
    "HHP", "Helenia Helicopter Service", "HELENIA", "Denmark",
    "HHS", "Hi-Jet Helicopter Services", "HIJET", "Suriname",
    "HIA", "Canadian Eagle Aviation", "HAIDA", "Canada",
    "HIB", "Helibravo Aviacao", "HELIBRAVO", "Portugal",
    "HID", "Aviación Ejecutiva De Hildago", "EJECUTIVA HIDALGO", "Mexico",
    "HIF", "Heli-Iberica Fotogrametria", "HIFSA", "Spain",
    "HIG", "Heli-Inter Guyane", "INTER GUYANNE", "France",
    "HIM", "Himalaya Airlines", "HIMALAYA", "Nepal",
    "HIN", "Holding International Group", "HOLDING GROUP", "Mexico",
    "HIP", "Starship", "STARSA", "Mexico",
    "HIS", "Hispaniola Airways", "HISPANIOLA", "Dominican Republic",
    "HIT", "Helitalia", "HELITALIA", "Italy",
    "HJA", "Air Haiti", "AIRHAITI", "Haiti",
    "HJE", "Servicios Ejecutivos Gosa", "GOSA", "Mexico",
    "HJL", "Hamlin Jet", "BIZJET", "United Kingdom",
    "HJT", "Al Rais Cargo", "AL-RAIS CARGO", "United Arab Emirates",
    "HKA", "Superior Aviation", "SPEND AIR", "United States",
    "HKB", "Hawker Beechcraft", "CLASSIC", "United States",
    "HKC", "Hong Kong Air Cargo", "MASCOT", "Hong Kong",
    "HKE", "Hong Kong Express Airways", "HONGKONG SHUTTLE", "Hong Kong",
    "HKG", "Government Flying Service", "HONGKONG GOVERNMENT", "Hong Kong SAR of China",
    "HKH", "Air-Invest", "HAWKHUNGARY", "Hungary",
    "HKI", "Hawkaire", "HAWKEYE", "United States",
    "HKL", "Hak Air", "HAK AIRLINE", "Nigeria",
    "HKN", "Jim Hankins Air Service", "HANKINS", "United States",
    "HKR", "Hawk Air", "AIR HAW", "Argentina",
    "HKS", "CHC Helikopter Service", "HELIBUS", "Norway",
    "HLA", "HC Airlines", "HEAVYLIFT", "United Kingdom",
    "HLB", "High-Line Airways", "HIGH-LINE", "Canada",
    "HLC", "Helicap", "HELICAP", "France",
    "HLD", "Grampian Flight Centre", "GRANITE", "United Kingdom",
    "HLE", "UK HEMS", "HELIMED", "United Kingdom",
    "HLF", "Hapagfly", "HAPAG LLOYD", "Germany",
    "HLG", "Helog", "HELOG", "Switzerland",
    "HLH", "Hala Air", "HALA AIR", "Sudan",
    "HLI", "Heli Securite", "HELI SAINT-TROPEZ", "France",
    "HLK", "Heli-Link", "HELI-LINK", "Switzerland",
    "HLM", "Heli Medwest De Mexico", "HELIMIDWEST", "Mexico",
    "HLO", "Samaritan Air Service", "HALO", "Canada",
    "HLP", "Helipistas", "HELIPISTAS", "Spain",
    "HLR", "Heli Air Services", "HELI BULGARIA", "Bulgaria",
    "HLS", "Haiti Air Freight", "", "Haiti",
    "HLT", "Helitours", "HELITOURS", "Sri Lanka",
    "HLU", "Heli Union Heli Prestations", "HELI UNION", "France",
    "HLW", "Heliworks", "HELIWORKS", "Chile",
    "HLX", "Hapag-Lloyd Express", "YELLOW CAB", "Germany",
    "HMC", "Heliamerica De Mexico", "HELIAMERICA", "Mexico",
    "HMD", "Charlie Hammonds Flying Service", "HAMMOND", "United States",
    "HMF", "Norrlandsflyg", "LIFEGUARD SWEDEN", "Sweden",
    "HMM", "Hamra Air", "HAMRA", "United Arab Emirates",
    "HMP", "Papair Terminal", "PAPAIR TERMINAL", "Haiti",
    "HMR", "North American Charters", "HAMMER", "Canada",
    "HMS", "Hemus Air", "HEMUS AIR", "Bulgaria",
    "HMV", "Homac Aviation", "HOMAC", "Luxembourg",
    "HMX", "Hawk De Mexico", "HAWK MEXICO", "Mexico",
    "HMY", "Harmony Airways", "HARMONY", "Canada",
    "HNA", "Greek Navy", "HELLENIC NAVY", "Greece",
    "HNL", "CHC Helicopters Netherlands", "MAPLELEAF", "Netherlands",
    "HNR", "Haiti National Airlines (HANA)", "HANAIR", "Haiti",
    "HNT", "Helicopteros Internacionales", "HELICOP INTER", "Mexico",
    "HOA", "Hola Airlines", "HOLA", "Spain",
    "HOG", "Mahogany Air Charters", "HOGAN AIR", "Zambia",
    "HOL", "Holiday Airlines (US Airline)", "HOLIDAY", "United States",
    "HOM", "Aero Homex", "AERO HOMEX", "Mexico",
    "HOP", "Hop!", "AIR HOP", "France",
    "HOR", "Horizon Air-Taxi", "HORIZON", "Switzerland",
    "HOZ", "Horizontes Aéreos", "HORIZONTES AEREOS", "Mexico",
    "HPA", "Pearl Airways", "PEARL AIRWAYS", "Haiti",
    "HPJ", "Hop-A-Jet", "HOPA-JET", "United States",
    "HPL", "Heliportugal", "HELIPORTUGAL", "Portugal",
    "HPO", "Almiron Aviation", "ALMIRON", "Uganda",
    "HPR", "Rick Lucas Helicopters", "HELIPRO", "New Zealand",
    "HPS", "Horizon Plus", "HORIZON PLUS", "Bangladesh",
    "HQO", "Avinor", "", "Norway",
    "HRA", "Heli-Iberica", "ERICA", "Spain",
    "HRB", "Haiti International Airline", "HAITI AIRLINE", "Haiti",
    "HRH", "Royal Tongan Airlines", "TONGA ROYAL", "Tonga",
    "HRI", "Skyraidybos Mokymo Centras", "HELIRIM", "Lithuania",
    "HRN", "Heron Luftfahrt", "HERONAIR", "Germany",
    "HRS", "Pursuit Aviation", "HORSEMAN", "United States",
    "HRT", "Chartright Air", "CHARTRIGHT", "Canada",
    "HRZ", "Croatian Air Force", "CROATIAN AIRFORCE", "Croatia",
    "HSA", "East African Safari Air", "DUMA", "Kenya",
    "HSE", "Compania Helicopteros Del Sureste", "HELISURESTE", "Spain",
    "HSH", "Hispánica de Aviación", "HASA", "Spain",
    "HSI", "Heliswiss", "HELISWISS", "Switzerland",
    "HSK", "Sky Europe Airlines", "MATRA", "Slovakia",
    "HSM", "Horizon Air for Transport and Training", "ALOFUKAIR", "Libya",
    "HSN", "H.S.AVIATION CO.  LTD.", "H.S.AVIATION", "Thailand",
    "HSO", "Campania Helicopteros De Transporte", "HELIASTURIAS", "Spain",
    "HSP", "International Jet Charter", "HOSPITAL", "United States",
    "HSR", "Citylink Airlines", "HOOSIER", "United States",
    "HSS", "Compañía Transportes Aéreos Del Sur", "TAS HELICOPTEROS", "Spain",
    "HSU", "Helisul", "HELIS", "Portugal",
    "HSV", "Svenska Direktflyg", "HIGHSWEDE", "Sweden",
    "HSY", "Sky Helicopteros", "HELISKY", "Spain",
    "HTA", "Helitrans", "SCANBIRD", "Norway",
    "HTB", "Helix-Craft Aviation", "HELIX-CRAFT", "Panama",
    "HTC", "Haiti Trans Air", "HAITI TRANSAIR", "Haiti",
    "HTE", "Midwest Helicopters De Mexico", "HELICOPTERSMEXICO", "Mexico",
    "HTG", "Grossmann Air Service", "GROSSMANN", "Austria",
    "HTI", "Haiti International Air", "HAITI INTERNATIONAL", "Haiti",
    "HTL", "Jet Linx Aviation", "HEARTLAND", "United States",
    "HTN", "Haiti North Airline", "", "Haiti",
    "HTO", "Tango Bravo", "HELI TANGO", "France",
    "HTP", "Heli Trip", "HELI TRIP", "Mexico",
    "HTR", "Holstenair Lubeck", "HOLSTEN", "Germany",
    "HTS", "Helitrans Air Service", "HELITRANS", "United States",
    "HTT", "Air Tchad", "HOTEL TANGO", "Chad",
    "HTU", "Hongtu Airlines", "HONGLAND", "China",
    "HUB", "Hub Airlines", "HUB", "United States",
    "HUC", "Aerolíneas de Techuacán", "LINEAS TEHUACAN", "Mexico",
    "HUD", "Horizons Unlimited", "HUD", "United States",
    "HUF", "Hungarian Air Force", "HUNGARIAN AIRFORCE", "Hungary",
    "HUR", "Miami Air Charter", "HURRICANE CHARTER", "United States",
    "HUS", "Huessler Air Service", "HUESSLER", "United States",
    "HUT", "Aerotransportes Huitzilin", "AEROHUITZILIN", "Mexico",
    "HUV", "Hunair Hungarian Airlines", "SILVER EAGLE", "Hungary",
    "HUY", "Aero Transportes Del Humaya", "AERO HUMAYA", "Mexico",
    "HVA", "Newair", "HAVEN-AIR", "United States",
    "HVK", "Turkish Air Force", "TURKISH AIRFORCE", "Turkey",
    "HVL", "Heavylift International", "HEAVYLIFT INTERNATIONAL", "United Arab Emirates",
    "HVN", "Vietnam Airlines", "VIET NAM", "Vietnam",
    "HVY", "Heavylift Cargo Airlines", "HEAVY CARGO", "Australia",
    "HWD", "HPM Investments", "FLITEWISE", "United Kingdom",
    "HWY", "Highland Airways", "HIWAY", "United Kingdom",
    "HXA", "China Express Airlines", "CHINA EXPRESS", "China",
    "HYA", "Hyack Air", "HYACK", "Canada",
    "HYC", "Hydro Air Flight Operations", "HYDRO CARGO", "South Africa",
    "HYD", "Hydro-Québec", "HYDRO", "Canada",
    "HYH", "Heli Hungary", "HELIHUNGARY", "Hungary",
    "HYP", "Hyperion Aviation", "HYPERION", "Malta",
    "HYR", "Airlink Airways", "HIGHFLYER", "Ireland",
    "HZT", "Air Horizon", "HORIZON TOGO", "Togo",
    "HZX", "Citic General Aviation", "ZHONGXIN", "China",
    "IAA", "Indonesian Airlines", "INDO LINES", "Indonesia",
    "IAC", "Interaviation Charter", "INTERCHARTER", "Romania",
    "IAD", "Fly Wex", "FLYWEX", "Italy",
    "IAF", "Israeli Air Force", "", "Israel",
    "IAG", "EPAG", "EPAG", "France",
    "IAI", "Israel Aircraft Industries", "ISRAEL AIRCRAFT", "Israel",
    "IAJ", "Islandair Jersey", "JARLAND", "United Kingdom",
    "IAK", "International Air Cargo Corporation", "AIR CARGO EGYPT", "Egypt",
    "IAR", "Iliamna Air Taxi", "ILIAMNA AIR", "United States",
    "IAW", "Iraqi Airways", "IRAQI", "Iraq",
    "IAX", "International Air Services", "INTERAIR SERVICES", "Liberia",
    "IAY", "Deadalos Flugtbetriebs", "IASON", "Austria",
    "IBB", "Binter Canarias", "BINTER", "Spain",
    "IBC", "Ibicenca Air", "IBICENCA", "Spain",
    "IBE", "Iberia Airlines", "IBERIA", "Spain",
    "IBG", "Springfield Air", "ICE BRIDGE", "United States",
    "IBK", "Norwegian Air International", "NORTRANS", "Ireland",
    "IBL", "IBL Aviation", "CATOVAIR", "Mauritius",
    "IBR", "Ibertour Servicios Aéreos", "IBERTOUR", "Spain",
    "IBS", "Iberia Express", "IBEREXPRESS", "Spain",
    "IBT", "Ibertrans Aérea", "IBERTRANS", "Spain",
    "IBU", "Indigo Airlines", "INDIGO BLUE", "United States",
    "IBX", "Ibex Airlines", "IBEX", "Japan",
    "IBY", "International Business Aircraft", "CENTRAL STAGE", "United States",
    "IBZ", "International Business Air", "INTERBIZ", "Sweden",
    "ICA", "Icaro", "ICARFLY", "Italy",
    "ICB", "Icebird Airline", "ICEBIRD", "Iceland",
    "ICC", "Institut Cartogràfic de Catalunya", "CARTO", "Spain",
    "ICE", "Icelandair", "ICEAIR", "Iceland",
    "ICG", "Icelandic Coast Guard", "ICELAND COAST", "Iceland",
    "ICJ", "Icejet", "ICEJET", "Iceland",
    "ICL", "Challenge Airlines IL", "CAL", "Israel",
    "ICM", "Air Inter Cameroun", "INTER-CAMEROUN", "Cameroon",
    "ICN", "Inter-Canadian", "INTER-CANADIAN", "Canada",
    "ICP", "Intercopters", "CHOPER", "Spain",
    "ICR", "Eagle Aero", "ICARUS FLIGHTS", "United States",
    "ICS", "International Charter Services", "INTERSERVI", "Mexico",
    "ICT", "Intercontinental de Aviación", "CONTAVIA", "Colombia",
    "ICV", "Cargolux Italia", "CARGO MED", "Italy",
    "IDA", "Indonesia Air Transport", "INTRA", "Indonesia",
    "IDG", "IDG Technology Air", "INDIGO", "Czech Republic",
    "IDL", "Ildefonso Redriguez", "ILDEFONSO", "Mexico",
    "IDP", "Independent Air Freighters", "INDEPENDENT", "Australia",
    "IDR", "Indicator Company", "INDICATOR", "Hungary",
    "IEP", "Elipiu'", "ELIPIU", "Italy",
    "IFA", "FAI Air Service", "RED ANGEL", "Germany",
    "IFC", "Indian Air Force", "INDIAN AIRFORCE", "India",
    "IFF", "Interfreight Forwarding", "INTERFREIGHT", "Sudan",
    "IFI", "Air Lift", "HELLAS LIFT", "Greece",
    "IFL", "IFL Group", "EIFEL", "United States",
    "IFM", "Ifly", "ICOPTER", "Greece",
    "IFS", "Italy First", "RIVIERA", "Italy",
    "IFT", "Interflight", "INTERFLIGHT", "United Kingdom",
    "IFX", "International Flight Training Academy", "IFTA", "United States",
    "IGA", "Skytaxi", "IGUANA", "Poland",
    "IGN", "Interguide Air", "DIVINE AIR", "Nigeria",
    "IGO", "IndiGo", "IFLY", "India",
    "IGS", "Isle Grande Flying School", "ISLA GRANDE", "United States",
    "IHE", "Interjet Helicopters", "INTERCOPTER", "Greece",
    "IHS", "Thryluthjonustan", "", "Iceland",
    "IIC", "Inter Island Air Charter", "", "Bahamas",
    "IIG", "International Company for Transport  Trade and Public Works", "ALDAWLYH AIR", "Libya",
    "IIL", "India International Airways", "INDIA INTER", "India",
    "IIN", "Inter Island Airways", "", "Cape Verde",
    "IJA", "International Jet Aviation Services", "I-JET", "United States",
    "IJE", "Ivoire Jet Express", "IVOIRE JET", "Ivory Coast",
    "IJM", "IJM International Jet Management", "JET MANAGEMENT", "Austria",
    "IJS", "Silvair", "", "United States",
    "IJT", "Interflight (Learjet)", "", "United Kingdom",
    "IJW", "Interjet Inc.", "JET WEST", "United States",
    "IKA", "Itek Air", "ITEK-AIR", "Kyrgyzstan",
    "IKK", "IKI International Airlines", "IKIAIR", "Japan",
    "IKM", "Aero Survey", "EASY SHUTTLE", "Ghana",
    "IKN", "IKON FTO", "IKON", "Germany",
    "IKR", "Ikaros DK", "IKAROS", "Denmark",
    "IKY", "Intersky Bulgary", "GENERAL SKY", "Bulgaria",
    "ILC", "ILAS Air", "", "Japan",
    "ILF", "Island Air Charters", "ISLAND FLIGHT", "United States",
    "ILK", "Aero Airline", "ILEK", "Kazakhstan",
    "ILL", "Ilyich-Avia", "ILYICHAVIA", "Ukraine",
    "ILN", "Interair South Africa", "INLINE", "South Africa",
    "ILP", "Ilpo Aruba Cargo", "", "Aruba",
    "ILS", "Servicios Aéreos Ilsa", "SERVICIOS ILSA", "Mexico",
    "ILV", "Il-Avia", "ILAVIA", "Russia",
    "IMA", "Inter-Mountain Airways", "INTER-MOUNTAIN", "United States",
    "IMG", "Imperial Cargo Airlines", "IMPERIAL AIRLINES", "Ghana",
    "IMN", "Aerotaxis Cimarron", "TAXI CIMARRON", "Mexico",
    "IMR", "Imaer", "IMAER", "Portugal",
    "IMT", "Imtrec Aviation", "IMTREC", "Cambodia",
    "IMX", "Zimex Aviation", "ZIMEX", "Switzerland",
    "INA", "Aero Internacional", "AERO-NACIONAL", "Mexico",
    "INC", "Insel Air International", "INSELAIR", "Netherlands Antilles",
    "IND", "Iona National Airways", "IONA", "Ireland",
    "INK", "Sincom-Avia", "SINCOM AVIA", "Ukraine",
    "INL", "Intal Avia", "INTAL AVIA", "Kyrgyzstan",
    "INO", "Aeroservicios Intergrados de Norte", "INTENOR", "Mexico",
    "INP", "Peruvian Navy", "", "Peru",
    "INS", "Inflite The Jet Centre", "", "United Kingdom",
    "INT", "Intair", "INTAIRCO", "Canada",
    "INU", "Flyguppdraget Backamo", "INSTRUCTOR", "Sweden",
    "INV", "Inversija", "INVER", "Latvia",
    "INX", "Inter Express", "INTER-EURO", "Turkey",
    "IOA", "Iowa Airways", "IOWA AIR", "United States",
    "IOM", "Island Aviation and Travel", "ISLE AVIA", "United Kingdom",
    "IOS", "Isles of Scilly Skybus", "SCILLONIA", "United Kingdom",
    "IPA", "IPEC Aviation", "IPEC", "Australia",
    "IPL", "Airpull Aviation", "IPULL", "Spain",
    "IPM", "IPM Europe", "SHIPEX", "United Kingdom",
    "IPN", "Industri Pesawat Terbang Nusantara", "NUSANTARA", "Indonesia",
    "IPR", "Independent Carrier (ICAR)", "ICAR", "Ukraine",
    "IPT", "Interport Corporation", "INTERPORT", "United States",
    "IQQ", "Caribbean Airways", "CARIBJET", "Barbados",
    "IRA", "Iran Air", "IRANAIR", "Iran",
    "IRB", "Iranair Tours", "", "Iran",
    "IRC", "Iran Aseman Airlines", "ASEMAN", "Iran",
    "IRD", "Arvand Airlines", "ARVAND", "Iran",
    "IRE", "Pariz Air", "PARIZAIR", "Iran",
    "IRF", "TA-Air Airline", "TA-AIR", "Iran",
    "IRG", "Iranian Naft Airlines", "NAFT", "Iran",
    "IRH", "Atlas Aviation Group", "ATLAS AVIA", "Iran",
    "IRI", "Navid", "NAVID", "Iran",
    "IRJ", "Bonyad Airlines", "BONYAD AIR", "Iran",
    "IRK", "Kish Air", "KISHAIR", "Iran",
    "IRL", "Irish Air Corps", "IRISH", "Ireland",
    "IRM", "Mahan Air", "MAHAN AIR", "Iran",
    "IRO", "CSA Air", "IRON AIR", "United States",
    "IRP", "Payam Air", "PAYAMAIR", "Iran",
    "IRR", "Tara Air Line", "TARAIR", "Iran",
    "IRU", "Chabahar Airlines", "CHABAHAR", "Iran",
    "IRV", "Safat Airlines", "SAFAT AIR", "Iran",
    "IRW", "Aram Airline", "ARAM", "Iran",
    "IRX", "Aria Tour", "ARIA", "Iran",
    "IRY", "Eram Air", "ERAM AIR", "Iran",
    "IRZ", "Saha Airlines Services", "SAHA", "Iran",
    "ISA", "Island Airlines", "", "United States",
    "ISD", "ISD Avia", "ISDAVIA", "Ukraine",
    "ISF", "International Stabilisation Assistance Force", "", "United Kingdom",
    "ISG", "Club Air", "CLUBAIR", "Italy",
    "ISI", "Island Air", "ISLANDMEX", "Mexico",
    "ISL", "Landsflug", "ISLANDIA", "Iceland",
    "ISM", "Auo Airclub AIST-M", "STORK", "Russia",
    "ISN", "Interisland Airlines", "TRI-BIRD", "Philippines",
    "ISR", "Israir", "ISRAIR", "Israel",
    "ISS", "Meridiana", "MERIDIANA", "Italy",
    "IST", "Istanbul Airlines", "ISTANBUL", "Turkey",
    "ISV", "Islena De Inversiones", "", "Honduras",
    "ISW", "Islas Airways", "PINTADERA", "Spain",
    "ITA", "Inter-Air", "CAFEX", "United States",
    "ITC", "International Air Carrier Association", "", "Belgium",
    "ITE", "Aerotaxi S.R.O.", "AEROTAXI", "Czech Republic",
    "ITF", "Avita-Servicos Aéreos", "AIR AVITA", "Angola",
    "ITH", "International Trans-Air", "INTRANS NIGERIA", "Nigeria",
    "ITI", "AirSwift", "AIRSWIFT", "Philippines",
    "ITK", "Interlink Airlines", "INTERLINK", "South Africa",
    "ITN", "Industrias Titan", "TITANLUX", "Spain",
    "ITO", "Aero Citro", "AERO CITRO", "Mexico",
    "ITR", "Frontier Commuter", "OUT BACK", "United States",
    "ITS", "Inter-State Aviation", "INTER-STATE", "United States",
    "ITU", "Intervuelos", "INTERLOS", "Mexico",
    "ITW", "Inter Air", "INTER WINGS", "Bulgaria",
    "ITX", "Imair Airlines", "IMPROTEX", "Azerbaijan",
    "ITY", "ITA Airways", "ITARROW", "Italy",
    "IUS", "Icarus", "ICARUS", "Italy",
    "IVA", "Innotech Aviation", "INNOTECH", "Canada",
    "IVE", "Air Executive", "COMPANY EXEC", "Spain",
    "IVJ", "Flight International", "INVADER JACK", "United States",
    "IVR", "Burundaiavia", "RERUN", "Kazakhstan",
    "IVS", "Ivoire Aero Services", "IVOIRE AERO", "Ivory Coast",
    "IVT", "Interaviatrans", "INTERAVIA", "Ukraine",
    "IVW", "Ivoire Airways", "IVOIRAIRWAYS", "Ivory Coast",
    "IWD", "Iberworld", "IBERWORLD", "Spain",
    "IWL", "Island Wings", "", "Bahamas",
    "IWS", "Aviainvest", "", "Russia",
    "IWY", "InterCaribbean Airways", "ISLANDWAYS", "Turks and Caicos Islands",
    "IXR", "Ixair", "X-BIRD", "France",
    "IXX", "Dolphin Express Airlines", "ISLAND EXPRESS", "United States",
    "IYE", "Yemenia", "YEMENI", "Yemen",
    "IZA", "Izhavia", "IZHAVIA", "Russia",
    "IZG", "Zagros Airlines", "ZAGROS", "Iran",
    "IZM", "Izair", "IZMIR", "Turkey",
    "JAA", "Jet Asia Airways", "JET ASIA", "Thailand",
    "JAB", "Air Bagan", "AIR BAGAN", "Myanmar",
    "JAC", "Japan Air Commuter", "COMMUTER", "Japan",
    "JAD", "Aerojal", "AEROJAL", "Mexico",
    "JAE", "Jade Cargo International", "JADE CARGO", "China",
    "JAF", "TUI fly Belgium", "BEAUTY", "Belgium",
    "JAG", "Jetalliance", "JETALLIANCE", "Austria",
    "JAI", "Jet Airways", "JET AIRWAYS", "India",
    "JAK", "Jana-Arka", "YANZAR", "Kazakhstan",
    "JAL", "Japan Airlines", "JAPANAIR", "Japan",
    "JAM", "Sunline Express", "SUNTRACK", "Kenya",
    "JAR", "Airlink", "AIRLINK", "Austria",
    "JAS", "Jet Aviation Flight Services", "JET SETTER", "United States",
    "JAT", "JetSMART", "ROCKSMART", "Chile",
    "JAV", "Jordan Aviation", "JORDAN AVIATION", "Jordan",
    "JAW", "Jamahiriya Airways", "JAW", "Libya",
    "JAX", "Janair", "JANAIR", "United States",
    "JAZ", "JALways", "JALWAYS", "Japan",
    "JBA", "Helijet", "HELIJET", "Canada",
    "JBR", "Job Air", "JOBAIR", "Czech Republic",
    "JBU", "JetBlue Airways", "JETBLUE", "United States",
    "JCB", "J C Bamford (Excavators)", "JAYSEEBEE", "United Kingdom",
    "JCC", "Jetcraft Aviation", "JETCRAFT", "Australia",
    "JCF", "Jet Center Flight Training", "JET CENTER", "Spain",
    "JCH", "Trading Air Cargo", "TRADING CARGO", "Mauritania",
    "JCI", "Jordan International Air Cargo", "", "Jordan",
    "JCK", "Jackson Air Services", "JACKSON", "Canada",
    "JCM", "Secure Air Charter", "SECUREAIR", "United States",
    "JCR", "Rotterdam Jet Center", "ROTTERDAM JETCENTER", "Netherlands",
    "JCS", "Jetclub", "JETCLUB", "Switzerland",
    "JCT", "Jet Charter", "JET CHARTER", "United States",
    "JDA", "JDAviation", "JAY DEE", "United Kingdom",
    "JDC", "Deere and Company", "JOHN DEERE", "United States",
    "JDG", "Joanas Avialinijos", "LADYBLUE", "Lithuania",
    "JDI", "Jet Story", "JEDI", "Poland",
    "JDP", "JDP Lux", "RED PELICAN", "Luxembourg",
    "JED", "Jet East International", "JET EAST", "United States",
    "JEE", "Ambjek Air Services", "AMBJEK AIR", "Nigeria",
    "JEF", "Jetflite", "JETFLITE", "Finland",
    "JEI", "Jet Executive International Charter", "JET EXECUTIVE", "Germany",
    "JEJ", "Jets Ejecutivos", "MEXJETS", "Mexico",
    "JEK", "Jet Link", "JET OPS", "Israel",
    "JEL", "Tal Air Charters", "JETEL", "Canada",
    "JEM", "Emerald Airways", "GEMSTONE", "United Kingdom",
    "JEP", "Jets Personales", "JET PERSONALES", "Spain",
    "JES", "JS Aviation", "JAY-ESS AVIATION", "Mexico",
    "JET", "Wind Jet", "GHIBLI", "Italy",
    "JEV", "Lagun Air", "", "Spain",
    "JEX", "JAL Express", "JANEX", "Japan",
    "JFA", "Jetfly Aviation", "MOSQUITO", "Luxembourg",
    "JFC", "LTV Jet Fleet Corporation", "JET-FLEET", "United States",
    "JFK", "Keenair Charter -", "KEENAIR", "United Kingdom",
    "JFL", "Jetfly Airlines", "LINEFLYER", "Austria",
    "JFS", "Juanda Flying School", "JAEMCO", "Indonesia",
    "JFU", "Jet4You", "ARGAN", "Morocco",
    "JFY", "Foster Yeoman", "YEOMAN", "United Kingdom",
    "JGD", "Jet G&D Aviation", "JET GEE-AND-DEE", "Israel",
    "JGJ", "Jinggong Jet", "GLOBAL JINGGONG", "China",
    "JHM", "JHM Cargo Expreso", "", "Costa Rica",
    "JHN", "Johnson Air", "AIR JOHNSON", "United States",
    "JIA", "PSA Airlines", "BLUE STREAK", "United States",
    "JIB", "Jibair", "JIBAIRLINE", "Djibouti",
    "JIC", "Jetgo International", "JIC-JET", "Thailand",
    "JIM", "Sark International Airways", "SARK", "United Kingdom",
    "JJA", "Jeju Air", "JEJU AIR", "Republic of Korea",
    "JJM", "Regional Geodata Air", "GEODATA", "Spain",
    "JJP", "Jetstar Japan", "ORANGE LINER", "Japan",
    "JKA", "LeTourneau University", "JACKET", "United States",
    "JKH", "JETKONTOR AG", "JETKONTOR", "Germany",
    "JKR", "Justice Air Charter", "JOKER", "United States",
    "JKT", "Jetstar Hong Kong Airways", "KAITAK", "China",
    "JKY", "Helicopter & Aviation Services", "JOCKEY", "United Kingdom",
    "JLA", "MIA Airlines", "SALLINE", "Romania",
    "JLH", "Centro de Servicio Aeronautico", "CESA", "Mexico",
    "JLN", "Eurojet Limited", "JET LINE", "Malta",
    "JLX", "Jetlink Express", "KEN JET", "Kenya",
    "JMB", "Jambo Africa Airlines", "JAMBOAFRICA", "Democratic Republic of Congo",
    "JMC", "JMC Airlines", "JAYEMMSEE", "United Kingdom",
    "JMJ", "Johnston Airways", "JOHNSTON", "United States",
    "JMM", "Joint Military Commission", "JOICOMAR", "Sudan",
    "JMP", "Businesswings", "JUMP RUN", "Germany",
    "JMR", "Alexandair", "ALEXANDAIR", "Canada",
    "JMT", "Jomartaxi Aereo", "JOMARTAXI", "Mexico",
    "JMX", "Air Jamaica Express", "JAMAICA EXPRESS", "Jamaica",
    "JNA", "Jin Air", "JIN AIR", "South Korea",
    "JNH", "M & N Aviation", "JONAH", "United States",
    "JNJ", "Journey Jet", "JOURNEY JET", "Thailand",
    "JNL", "JetNetherlands", "JETNETHERLANDS", "Netherlands",
    "JNR", "Jet Norte", "JET NORTE", "Mexico",
    "JNV", "Jetnova de Aviación Ejecutiva", "JETNOVA", "Spain",
    "JNY", "Jenney Beechcraft", "JENAIR", "United States",
    "JOA", "Air Swift Aviation", "", "Australia",
    "JOB", "Aerojobeni", "JOBENI", "Mexico",
    "JOL", "Atyrau Air Ways", "EDIL", "Kazakhstan",
    "JON", "Johnsons Air", "JOHNSONSAIR", "Ghana",
    "JOS", "DHL de Guatemala", "", "Guatemala",
    "JPA", "OSACOM", "J-PAT", "United States",
    "JPN", "Jeppesen UK", "JETPLAN", "United Kingdom",
    "JPO", "Jetpro", "JETPRO", "Mexico",
    "JPQ", "Jett Paqueteria", "JETT PAQUETERIA", "Mexico",
    "JRF", "First Air Transport", "", "Japan",
    "JRI", "Jetrider International", "JETRIDER", "United Kingdom",
    "JRN", "Jet Rent", "JET RENT", "Mexico",
    "JSA", "Jetstar Asia Airways", "JETSTAR ASIA", "Singapore",
    "JSE", "Jets Y Servicios Ejecutivos", "SERVIJETS", "Mexico",
    "JSH", "Jet-stream", "STREAM AIR", "Hungary",
    "JSI", "Jet Air Group", "SISTEMA", "Russia",
    "JSJ", "JS Air", "JS CHARTER", "Pakistan",
    "JSM", "Jet Stream", "JET STREAM", "Moldova",
    "JSP", "Palmer Aviation", "PALMER", "United Kingdom",
    "JSS", "Jet Stream International", "", "Pakistan",
    "JST", "Jetstar", "JETSTAR", "Australia",
    "JSV", "Japan Aircraft Service", "", "Japan",
    "JSW", "Jigsaw Project", "JIGSAW", "United Kingdom",
    "JSX", "JSX (airline)", "BIGSTRIPE", "United States",
    "JSY", "Jung Sky", "", "Croatia",
    "JTA", "Japan Transocean Air", "JAI OCEAN", "Japan",
    "JTC", "Jet Trans Aviation", "JETRANS", "Ghana",
    "JTE", "National Jet Express", "JETEX", "Australia",
    "JTF", "Jet Time", "JETFIN", "Finland",
    "JTG", "Jettime", "JETTIME", "Denmark",
    "JTI", "Cirrus Middle East", "", "Lebanon",
    "JTL", "Jet Linx Aviation", "JET LINX", "United States",
    "JTM", "Exxavia Limited", "SKYMAN", "Ireland",
    "JTN", "Jet Test Intl.", "JET TEST", "United States",
    "JTR", "Executive Aviation Services", "JESTER", "United Kingdom",
    "JTS", "Arrendamiento de Aviones Jets", "AVIONESJETS", "Mexico",
    "JTT", "Jet-2000", "MOSCOW JET", "Russia",
    "JTU", "Zhetysu", "ZHETYSU", "Kazakhstan",
    "JTX", "Jet Aspen Air Lines", "JET ASPEN", "United States",
    "JTY", "Jatayu Airlines", "JATAYU", "Indonesia",
    "JUA", "Aero Juarez", "JUAREZ", "Mexico",
    "JUB", "Jubba Airways", "JUBBA", "Somalia",
    "JUC", "Juba Cargo Services & Aviation Company", "JUBA CARGO", "Sudan",
    "JUR", "Ju-Air", "JUNKERS", "Switzerland",
    "JUS", "USA Jet Airlines", "JET USA", "United States",
    "JVK", "Jorvik", "ISLANDIC", "Iceland",
    "JWD", "Jayawijaya Dirgantara", "", "Indonesia",
    "JWY", "Jetways of Iowa", "JETWAYS", "United States",
    "JXA", "Jetex Aviation", "", "Lebanon",
    "JXT", "Jetstream Executive Travel", "VANNIN", "United Kingdom",
    "JXX", "JetX Airlines", "JETBIRD", "Iceland",
    "JZA", "Air Canada Jazz", "JAZZ", "Canada",
    "JZR", "Jazeera Airways", "JAZEERA", "Kuwait",
    "KAC", "Kuwait Airways", "KUWAITI", "Kuwait",
    "KAD", "Air Kirovograd", "AIR KIROVOGRAD", "Ukraine",
    "KAE", "Kartika Airlines", "KARTIKA", "Indonesia",
    "KAH", "Kent Aviation", "DEKAIR", "Canada",
    "KAI", "KaiserAir", "KAISER", "United States",
    "KAJ", "Karthago Airlines", "KARTHAGO", "Tunisia",
    "KAL", "Korean Air", "KOREANAIR", "South Korea",
    "KAM", "Air Mach", "ICO-AIR", "Italy",
    "KAO", "Kazan Aviation Production Association", "KAZAVAIA", "Russia",
    "KAP", "Cape Air", "CAIR", "United States",
    "KAR", "Ikar", "IKAR", "Russian Federation",
    "KAS", "Kingston Air Services", "KINGSTON AIR", "Canada",
    "KAT", "Kato Airline", "KATO-AIR", "Norway",
    "KAV", "Air Kufra", "AIRKUFRA", "Libya",
    "KAW", "Kaz Air West", "KAZWEST", "Kazakhstan",
    "KAZ", "Comlux Kazakhstan", "KAZLUX", "Kazakhstan",
    "KBA", "Kenn Borek Air", "BOREK AIR", "Canada",
    "KBN", "Spiracha Aviation", "KABIN", "Thailand",
    "KBV", "Kustbevakningen", "SWECOAST", "Sweden",
    "KCA", "Trans-Kiev", "TRANS-KIEV", "Ukraine",
    "KCE", "Irving Oil", "KACEY", "Canada",
    "KCH", "KC International Airlines", "CAM AIR", "Cambodia",
    "KCR", "Kolob Canyons Air Services", "KOLOB", "United States",
    "KDC", "K D Air Corporation", "KAY DEE", "Canada",
    "KDR", "Royal Daisy Airlines", "DARLINES", "Uganda",
    "KDZ", "Flightworks", "KUDZU", "United States",
    "KEE", "Keystone Air Service", "KEYSTONE", "Canada",
    "KEM", "CemAir", "CEMAIR", "South Africa",
    "KEN", "Kenmore Air", "KENMORE", "United States",
    "KES", "Kallat El Saker Air Company", "KALLAT EL SKER", "Libya",
    "KEW", "Keewatin Air", "BLIZZARD", "Canada",
    "KEY", "Key Airlines", "KEY AIR", "United States",
    "KFA", "Kelowna Flightcraft Air Charter", "FLIGHTCRAFT", "Canada",
    "KFC", "Kremenchuk Flight College", "KREMENCHUK", "Ukraine",
    "KFE", "SkyFirst LTD", "SKYFIRST", "Malta",
    "KFK", "Aero Charter Krifka", "KRIFKA AIR", "Austria",
    "KFS", "Kalitta Charters", "KALITTA", "United States",
    "KFT", "Air Kraft Mir", "AIR KRAFT MIR", "Uzbekistan",
    "KGA", "Kyrgyzstan Airlines", "KYRGYZ", "Kyrgyzstan",
    "KGB", "Kyrgz General Aviation", "KEMIN", "Kyrgyzstan",
    "KGC", "Peach Air", "GOLDCREST", "United Kingdom",
    "KGD", "Air Concorde", "CONCORDE AIR", "Bulgaria",
    "KGL", "Kogalymavia Air Company", "KOGALYM", "Russia",
    "KGT", "Knights Airlines", "KNIGHT-LINER", "Nigeria",
    "KGZ", "Kyrgyz Airlines", "BERMET", "Kyrgyzstan",
    "KHB", "Dalavia", "DALAVIA", "Russia",
    "KHE", "Kanfey Ha'emek Aviation", "KANFEY HAEMEK", "Israel",
    "KHH", "Alexandria Airlines", "", "Egypt",
    "KHK", "Kharkiv Airlines", "SUNRAY", "Ukraine",
    "KHO", "Khors Aircompany", "AIRCOMPANY KHORS", "Ukraine",
    "KHP", "Khoezestan Photros Air Lines", "PHOTROS AIR", "Iran",
    "KHR", "Khazar", "KHAZAR", "Turkmenistan",
    "KHV", "Cambodia Angkor Air", "ANGKOR AIR", "Cambodia",
    "KHX", "Knighthawk Express", "RIZZ", "United States",
    "KHY", "Khyber Afghan Airlines", "KHYBER", "Afghanistan",
    "KIA", "Kiwi International Air Lines", "KIWI AIR", "United States",
    "KIE", "Afit", "TWEETY", "Germany",
    "KII", "Kalitta Charters II", "DRAGSTER", "United States",
    "KIL", "Kuban Airlines", "AIR KUBAN", "Russia",
    "KIN", "RAF Kinloss", "KINLOSS", "United Kingdom",
    "KIP", "Kinnarps", "KINNARPS", "Sweden",
    "KIS", "Contactair", "CONTACTAIR", "Germany",
    "KIW", "Royal New Zealand Air Force", "KIWI", "New Zealand",
    "KIZ", "Kanaf-Arkia Airlines", "", "Israel",
    "KKA", "Kazavia", "KAKAIR", "Kazakhstan",
    "KKB", "Air South", "KHAKI BLUE", "United States",
    "KKK", "Atlasjet", "ATLASJET", "Turkey",
    "KKS", "Salem", "KOKSHE", "Kazakhstan",
    "KLB", "Air Mali International", "TRANS MALI", "Mali",
    "KLC", "KLM Cityhopper", "CITY", "Netherlands",
    "KLD", "Air Klaipeda", "AIR KLAIPEDA", "Lithuania",
    "KLE", "Rusaero", "", "Russia",
    "KLH", "KLM Helicopter", "KLM HELI", "Netherlands",
    "KLM", "KLM", "KLM", "Netherlands",
    "KLO", "Flight-Ops International", "KLONDIKE", "Canada",
    "KLR", "Columbus Air Transport", "KAY-LER", "United States",
    "KLS", "Kalstar Aviation", "KALSTAR", "Indonesia",
    "KLX", "Kelix Air", "KELIX", "Nigeria",
    "KLZ", "Aerokaluz", "AEROKALUZ", "Mexico",
    "KMA", "Komiaviatrans State Air Enterprise", "KOMI AVIA", "Russia",
    "KMB", "Delta Engineering Aviation", "KEMBLEJET", "United Kingdom",
    "KMC", "Kahama Mining Corporation", "KAHAMA", "Tanzania",
    "KME", "Cambodia Airways", "GIANT IBIS", "Cambodia",
    "KMF", "Kam Air", "KAMGAR", "Afghanistan",
    "KMG", "Kosmas Air", "KOSMAS CARGO", "Serbia",
    "KMI", "K-Mile Air", "KAY-MILE AIR", "Thailand",
    "KMP", "Kampuchea Airlines", "KAMPUCHEA", "Cambodia",
    "KMR", "Western Pacific Airlines", "KOMSTAR", "United States",
    "KMV", "Komiinteravia", "KOMIINTER", "Russia",
    "KNA", "Knight Air", "KNIGHTAIR", "Canada",
    "KNE", "Flynas", "NAS EXPRESS", "Saudi Arabia",
    "KNG", "King Aviation", "KING", "United Kingdom",
    "KNI", "KD Avia", "KALININGRAD AIR", "Russia",
    "KNM", "GB Helicopters", "KINGDOM", "United Kingdom",
    "KOA", "Koanda Avacion", "KOANDA", "Spain",
    "KOB", "Koob-Corp - 96 KFT", "AUTOFLEX", "Hungary",
    "KOE", "Northland Aviation", "KOKEE", "United States",
    "KOK", "Horizon Air Service", "KOKO", "United States",
    "KOM", "Kom Activity", "COMJET", "Netherlands",
    "KOP", "Servicios Aéreos Copters", "COPTERS", "Chile",
    "KOR", "Air Koryo", "AIR KORYO", "Democratic People's Republic of Korea",
    "KOS", "Kosova Airlines", "KOSOVA", "Serbia",
    "KOV", "Orlan-2000", "ORLAN", "Kazakhstan",
    "KOY", "Araiavia", "ALEKS", "Kazakhstan",
    "KPA", "Kunpeng Airlines", "KUNPENG", "China",
    "KPH", "Kazan Helicopters", "KAMA", "Russia",
    "KPM", "Sky Prim Air", "SKY PRIMAIR", "Molodva",
    "KQA", "Kenya Airways", "KENYA", "Kenya",
    "KRA", "Kiwi Regional Airlines", "REGIONAL", "New Zealand",
    "KRB", "Karibu Airways Company", "KARIBU AIR", "Tanzania",
    "KRC", "Royal New Zealand Air Force", "KIWI RESCUE", "New Zealand",
    "KRE", "AeroSucre", "AEROSUCRE", "Colombia",
    "KRF", "United Kingdom Royal VIP Flights", "KITTYHAWK", "United Kingdom",
    "KRG", "Krimaviamontag", "AVIAMONTAG", "Ukraine",
    "KRH", "United Kingdom Royal VIP Flight", "SPARROWHAWK", "United Kingdom",
    "KRI", "Krylo Airlines", "Krylo", "Russia",
    "KRM", "Crimea Universal Avia", "TRANS UNIVERSAL", "Ukraine",
    "KRN", "Kaz Agros Avia", "ANTOL", "Kazakhstan",
    "KRO", "Kroonk Air Agency", "KROONK", "Ukraine",
    "KRP", "Carpatair", "CARPATAIR", "Romania",
    "KRS", "Rosen Aviation", "", "Japan",
    "KRV", "Khoriv-Avia", "KHORIV-AVIA", "Ukraine",
    "KSA", "K S Avia", "SKY CAMEL", "Latvia",
    "KSI", "Air Kissari", "KISSARI", "Angola",
    "KSM", "Kosmos", "KOSMOS", "Russia",
    "KSP", "Servicios Aéreos Expecializados En Transportes Petroleros", "SAEP", "Colombia",
    "KSS", "Raytheon Travel Air", "KANSAS", "United States",
    "KST", "PTL Luftfahrtunternehmen", "KING STAR", "Germany",
    "KSU", "Kansas State University", "K-STATE", "United States",
    "KTA", "Kirov Air Enterprise", "VYATKA-AVIA", "Russia",
    "KTB", "Transaviabaltika", "TRANSBALTIKA", "Lithuania",
    "KTC", "Kyrgyz Trans Avia", "DINARA", "Kyrgyzstan",
    "KTK", "Katekavia", "KATEKAVIA", "Russia",
    "KTL", "P & P Floss Pick Manufacturers", "KNOTTSBERRY", "South Africa",
    "KTN", "Aeronavigaciya", "AERONAVIGACIYA", "Ukraine",
    "KTR", "HT Helikoptertransport", "COPTER TRANS", "Sweden",
    "KTS", "Transair-Gyraintiee", "KOTAIR", "Russia",
    "KTV", "Kata Transportation", "KATAVIA", "Sudan",
    "KUS", "National Airlines", "KUSWAG", "South Africa",
    "KVK", "Olimp Air", "PONTA", "Kazakhstan",
    "KVR", "Alliance Avia", "KAVAIR", "Kazakhstan",
    "KVS", "Kevis", "KEVIS", "Kazakhstan",
    "KVZ", "Z-Aero Airlines", "", "Ukraine",
    "KWA", "Vozdushnaya Academy", "VOZAIR", "Kazakhstan",
    "KWN", "Kwena Air", "KWENA", "South Africa",
    "KWX", "Florida Aerocharter", "KAY DUB", "United States",
    "KYC", "Av Atlantic", "DOLPHIN", "United States",
    "KYD", "Sky Messaging", "SKYAD", "South Africa",
    "KYE", "Sky Lease Cargo", "SKY CUBE", "United States",
    "KYM", "Krym", "CRIMEA AIR", "Ukraine",
    "KYR", "Sky Aeronautical Services", "SKY AERONAUTICAL", "Mexico",
    "KZA", "Kurzemes Avio", "", "Russia",
    "KZE", "Euro-Asia Air International", "KAZEUR", "Kazakhstan",
    "KZH", "Zhez Air", "", "Kazakhstan",
    "KZM", "Phoebus Apolloa Zambia", "CARZAM", "Zambia",
    "KZR", "Air Astana", "ASTANALINE", "Kazakhstan",
    "KZS", "Kazaviaspas", "SPAKAZ", "Kazakhstan",
    "KZU", "Kuzu Airlines Cargo", "KUZU CARGO", "Turkey",
    "KZW", "Khalifa Airways", "KHALIFA AIR", "Algeria",
    "LAA", "Libyan Arab Airlines", "LIBAIR", "Libya",
    "LAB", "L.A.B. Flying Service", "LAB", "United States",
    "LAC", "Lockeed Aircraft Corporation", "LOCKHEED", "United States",
    "LAD", "Lebanon Airport Development Corporation", "LADCO-AIR", "United States",
    "LAF", "Latvian Air Force", "LATVIAN AIRFORCE", "Latvia",
    "LAG", "Aviation Legacy", "AVILEG", "Gambia",
    "LAH", "L A Helicopter", "STAR SHIP", "United States",
    "LAL", "Labrador Airways", "LAB AIR", "Canada",
    "LAM", "Linhas Aéreas de Moçambique", "MOZAMBIQUE", "Mozambique",
    "LAN", "LATAM Chile", "LAN CHILE", "Chile",
    "LAO", "Lao Airlines", "LAO", "Lao People's Democratic Republic",
    "LAP", "LATAM Paraguay", "PARAGUAYA", "Paraguay",
    "LAQ", "Lebanese Air Transport", "LAT", "Lebanon",
    "LAR", "Lawrence Aviation", "LAWRENCE", "United States",
    "LAT", "Lebanese Air Transport (charter)", "LEBANESE AIR", "Lebanon",
    "LAU", "Líneas Aéreas Suramericanas", "SURAMERICANO", "Colombia",
    "LAV", "AlbaStar", "ALBASTAR", "Spain",
    "LAW", "Link Airways of Australia", "", "Australia",
    "LAX", "Laminar Air", "", "Spain",
    "LAY", "Layang-Layang Aerospace", "LAYANG", "Malaysia",
    "LBC", "Albanian Airlines", "ALBANIAN", "Albania",
    "LBH", "Laker Airways (Bahamas)", "LAKER BAHAMAS", "United States",
    "LBI", "Albisa", "ALBISA", "Mexico",
    "LBQ", "Quest Diagnostics", "LABQUEST", "United States",
    "LBR", "Elbe Air Transport", "MOTION", "Germany",
    "LBT", "Nouvel Air Tunisie", "NOUVELAIR", "Tunisia",
    "LBW", "Albatros Airways", "ALBANWAYS", "Albania",
    "LBY", "Belle Air", "ALBAN-BELLE", "Albania",
    "LBZ", "Angkasa Super Service", "", "Indonesia",
    "LCA", "Leconte Airlines", "LECONTE", "United States",
    "LCB", "LC Busre", "BUSRE", "Peru",
    "LCC", "The Lancair Company", "LANCAIR", "United States",
    "LCG", "Lignes Aeriennes Congolaises", "CONGOLAISE", "Democratic Republic of the Congo",
    "LCH", "Lynch Flying Service", "LYNCH AIR", "United States",
    "LCM", "Líneas Aéreas Comerciales", "LINEAS COMERCIALES", "Mexico",
    "LCN", "Líneas Aéreas Canedo LAC", "CANEDO", "Bolivia",
    "LCO", "LATAM Cargo Chile", "LAN CARGO", "Chile",
    "LCR", "Libyan Arab Air Cargo", "LIBAC", "Libya",
    "LCS", "RAF Leuchars", "LEUCHARS", "United Kingdom",
    "LCT", "Compañía De Actividades Y Servicios De Aviación", "STELLAIR", "Spain",
    "LCY", "London City Airport Jet Centre", "LONDON CITY", "United Kingdom",
    "LDA", "Lauda Air", "LAUDA AIR", "Austria",
    "LDE", "LADE - Líneas Aéreas Del Estado", "LADE", "Argentina",
    "LDG", "Aerolíneas Aéreas Ejecutivas De Durango", "DURANGO", "Mexico",
    "LDI", "Lauda Air Italy", "LAUDA ITALY", "Italy",
    "LDL", "Aerologic", "", "Russia",
    "LDM", "LaudaMotion", "LAUDA MOTION", "Austria",
    "LDN", "Al-Donas Airlines", "ALDONAS AIR", "Nigeria",
    "LDR", "Aero Lider", "AEROLIDER", "Mexico",
    "LEA", "Unijet", "LEADAIR", "France",
    "LEB", "Lebap", "LEBAP", "Turkmenistan",
    "LEC", "Linex", "LECA", "Central African Republic",
    "LED", "Blom Geomatics", "SWEEPER", "Norway",
    "LEE", "RAF Leeming", "JAVELIN", "United Kingdom",
    "LEG", "The Army Aviation Heritage Foundation", "LEGACY", "United States",
    "LEJ", "FSH Luftfahrtunternehmen", "LEIPZIG FAIR", "Germany",
    "LEL", "Leonsa De Aviación", "LEONAVIA", "Spain",
    "LEM", "Aleem", "", "Egypt",
    "LEN", "Lentini Aviation", "LENTINI", "United States",
    "LEP", "Laughlin Express", "LAUGHLIN EXPRESS", "United States",
    "LER", "Línea Aérea de Servicio Ejecutivo Regional", "LASER", "Venezuela",
    "LET", "Aerolíneas Ejecutivas", "MEXEJECUTIV", "Mexico",
    "LEU", "Lions-Air", "LIONSAIR", "Switzerland",
    "LEX", "L'Express Airlines", "LEX", "United States",
    "LFA", "Air Alfa", "AIR ALFA", "Turkey",
    "LFE", "Luxflight Executive", "LUX EXPRESS", "Luxembourg",
    "LFI", "National Airways Corporation", "AEROMED", "South Africa",
    "LFL", "Executive Air", "LIFE FLIGHT", "Zimbabwe",
    "LFO", "Deutsches Zentrum fur Luft-und Raumfahrt EV", "LUFO", "Germany",
    "LFP", "Alfa Aerospace", "ALFA-SPACE", "Australia",
    "LFR", "Atlantic Airfreight Aviation", "LANFREIGHT", "São Tomé and Príncipe",
    "LGA", "Logistic Air", "LOGAIR", "Malaysia",
    "LGC", "Legacy Air", "LEGACY AIR", "Thailand",
    "LGD", "Legend Airlines", "LEGENDARY", "United States",
    "LGL", "Luxair", "LUXAIR", "Luxembourg",
    "LGN", "Aerolaguna", "AEROLAGUNA", "Mexico",
    "LGT", "Longtail Aviation", "LONGTAIL", "Bermuda",
    "LGU", "Servicios Aéreos Ejecutivos De La Laguna", "LAGUNA", "Mexico",
    "LGW", "German Airways", "WALTER", "Germany",
    "LHB", "Liebherr Geschaeftreiseflugzeug", "FAMILY", "Germany",
    "LHC", "London Helicopter Centres", "MUSTANG", "United Kingdom",
    "LHR", "Al Ahram Aviation", "AL AHRAM", "Egypt",
    "LHS", "Luhansk", "ENTERPRISE LUHANSK", "Ukraine",
    "LHT", "Lufthansa Technik", "LUFTHANSA TECHNIK", "Germany",
    "LHX", "City Airlines", "CITYAIR", "Germany",
    "LIA", "Leeward Islands Air Transport", "LIAT", "Antigua and Barbuda",
    "LIB", "Polizeihubschrauberstaffel Hamburg", "LIBELLE", "Germany",
    "LID", "Alidaunia", "ALIDA", "Italy",
    "LIE", "Al-Dawood Air", "AL-DAWOOD AIR", "Nigeria",
    "LIF", "Rocky Mountain Holdings", "LIFECARE", "United States",
    "LIJ", "Líneas Aéreas San Jose", "LINEAS JOSE", "Mexico",
    "LIN", "Aerolimousine", "AEROLIMOUSINE", "Russia",
    "LIQ", "Lid Air", "", "Sweden",
    "LIR", "Minsk Aircraft Overhaul Plant", "LISLINE", "Belarus",
    "LIS", "Eastern Express", "LARISA", "Kazakhstan",
    "LJY", "L J Aviation", "ELJAY", "United States",
    "LKA", "Lao Capricorn Air", "NAKLAO", "Lao People's Democratic Republic",
    "LKD", "Lignes Aeriennes Du Tchad", "LATCHAD", "Chad",
    "LKE", "Lucky Air", "LUCKY AIR", "China",
    "LKL", "Lakeland Aviation", "LAKELAND", "United States",
    "LKN", "Lankair", "Lankair", "Sri Lanka",
    "LKR", "Laker Airways", "LAKER", "United States",
    "LKS", "Airlink Solutions", "AIRLIN", "Spain",
    "LKW", "Top Sky International", "TOPINTER", "Indonesia",
    "LKY", "Air Solutions", "LUCKY", "United States",
    "LLA", "Servico Leo Lopex", "LEO LOPOZ", "Mexico",
    "LLB", "Lloyd Aéreo Boliviano", "LLOYDAEREO", "Bolivia",
    "LLD", "Lloyd Aviation", "", "Venezuela",
    "LLL", "Lao Skyway", "LAVIE", "Lao People's Democratic Republic",
    "LLM", "Yamal Airlines", "YAMAL", "Russia",
    "LLO", "Operation Enduring Freedom", "APOLLO", "Canada",
    "LLR", "Air India Regional", "ALLIED", "India",
    "LLS", "Servicios Aéreos Estrella", "SERVIESTRELLA", "Mexico",
    "LMA", "Aerolima", "AEROLIMA", "Mexico",
    "LMC", "Línea Aérea Mexicana de Carga", "LINEAS DECARGA", "Mexico",
    "LME", "Lignes Mauritaniennes Air Express", "LIMAIR EXPRESS", "Mauritania",
    "LMG", "South African Air Force", "SOUTH AFRICAN", "South Africa",
    "LMJ", "Masterjet", "MASTERJET", "Portugal",
    "LMK", "Grantex Aviation", "LANDMARK", "United Kingdom",
    "LMN", "Líneas Aéreas Monarca", "LINEAS MONARCA", "Mexico",
    "LMO", "Sky One Holdings as Privaira", "SKY HOLDINGS", "United States",
    "LMP", "Air Plus Argentina", "AIR FLIGHT", "Argentina",
    "LMR", "Lamra", "LAMAIR", "Sudan",
    "LMS", "Lomas Helicopters", "LOMAS", "United Kingdom",
    "LMT", "Almaty Aviation", "ALMATY", "Kazakhstan",
    "LMU", "AlMasria Universal Airlines", "ALMASRIA", "Egypt",
    "LMX", "Aerolíneas Mexicanas J S", "LINEAS MEXICANAS", "Mexico",
    "LMY", "Air Almaty", "AGLEB", "Kazakhstan",
    "LMZ", "Air Almaty ZK", "ALUNK", "Kazakhstan",
    "LNA", "Lnair Air Services", "ELNAIR", "Spain",
    "LNC", "LAN Dominicana", "LANCANA", "Dominican Republic",
    "LNE", "Aerolane", "AEROLANE", "Ecuador",
    "LNG", "Lockheed Martin Aeronautics Company", "LIGHTNING", "United States",
    "LNI", "Lion Air", "LION INTER", "Indonesia",
    "LNK", "Airlink", "LINK", "South Africa",
    "LNP", "Línea Aérea SAPSA", "SAPSA", "Chile",
    "LNT", "Aerolíneas Internacionales", "LINEAINT", "Mexico",
    "LNX", "London Executive Aviation", "LONEX", "United Kingdom",
    "LOD", "Malmoe Air Taxi", "LOGIC", "Sweden",
    "LOF", "Trans States Airlines", "WATERSKI", "United States",
    "LOG", "Loganair", "LOGAN", "United Kingdom",
    "LOK", "Alok Air", "ALOK AIR", "Sudan",
    "LOP", "RAF Linton-on-Ouse", "LINTON ON OUSE", "United Kingdom",
    "LOR", "Leo-Air", "LEO CHARTER", "South Africa",
    "LOS", "RAF Lossiemouth", "LOSSIE", "United Kingdom",
    "LOT", "LOT Polish Airlines", "LOT", "Poland",
    "LOU", "Air Saint Louis", "AIR SAINTLOUIS", "Senegal",
    "LOV", "London Flight Centre (Stansted)", "LOVEAIR", "United Kingdom",
    "LPA", "Pal Aerolíneas", "LINEASPAL", "Mexico",
    "LPC", "Alpine Aviation", "NETSTAR", "South Africa",
    "LPD", "UK Royal/HRH Duke of York", "LEOPARD", "United Kingdom",
    "LPE", "LATAM Peru", "LANPERU", "Peru",
    "LPL", "Lease-a-Plane International", "LEASE-A-PLANE", "United States",
    "LPN", "Laoag International Airlines", "LAOAG AIR", "Philippines",
    "LPV", "Air Alps Aviation", "ALPAV", "Austria",
    "LRA", "Little Red Air Service", "LITTLE RED", "Canada",
    "LRB", "L R Airlines", "LADY RACINE", "Czech Republic",
    "LRC", "LACSA", "LACSA", "Costa Rica",
    "LRD", "Laredo Air", "LAREDO AIR", "United States",
    "LRO", "Alrosa-Avia", "ALROSA", "Russia",
    "LRR", "Lorraine Aviation", "LORRAINE", "France",
    "LRS", "Sansa", "", "Costa Rica",
    "LRT", "Lincoln Airlines", "", "Australia",
    "LRW", "Al Rida Airways", "AL RIDA", "Mauritania",
    "LSA", "LANSA", "INTERNACIONAL", "Dominican Republic",
    "LSC", "Los Cedros Aviación", "CEDROS", "Chile",
    "LSE", "Línea De Aeroservicios", "", "Chile",
    "LSK", "Aurela", "AURELA", "Lithuania",
    "LSP", "Spectrum Aviation Incorporated", "AIR TONY", "United Kingdom",
    "LSR", "Alsair", "ALSAIR", "France",
    "LSS", "Lone Star Airlines", "LONE STAR", "United States",
    "LSU", "Laus", "LAUS AIR", "Croatia",
    "LSV", "Slovenian Ministry of Defence", "", "Slovenia",
    "LSY", "Lindsay Aviation", "LINDSAY AIR", "United States",
    "LTA", "LIFT Academy", "LIFT", "United States",
    "LTD", "Executive Express Aviation/JA Air Charter", "LIGHT SPEED", "United States",
    "LTE", "LTE International Airways", "FUN JET", "Spain",
    "LTF", "Lufttaxi Fluggesellschaft", "Garfield", "Germany",
    "LTI", "Aerotaxis Latinoamericanos", "LATINO", "Mexico",
    "LTL", "Benin Littoral Airways", "LITTORAL", "Benin",
    "LTO", "LTU Austria", "BILLA TRANSPORT", "Austria",
    "LTR", "Lufttransport", "LUFT TRANSPORT", "Norway",
    "LTS", "Flight Inspections and Systems", "SPECAIR", "Russia",
    "LTU", "LTU International", "LTU", "Germany",
    "LTW", "Luchtvaartmaatschappij Twente", "TWENTAIR", "Netherlands",
    "LTY", "Liberty Air", "SKYDECK", "Netherlands",
    "LUC", "Albinati Aeronautics", "ALBINATI", "Switzerland",
    "LUE", "Aeroclub de Alicante", "", "Spain",
    "LUK", "LUKoil-Avia", "LUKOIL", "Russia",
    "LUT", "Luft Carago", "LUGO", "South Africa",
    "LUV", "Luxembourg Air Rescue", "LUX RESCUE", "Luxembourg",
    "LUZ", "Luzair", "LISBON JET", "Portugal",
    "LVB", "IRS Airlines", "SILVERBIRD", "Nigeria",
    "LVD", "Luftfahrt-Vermietungs-Dienst", "AIR SANTE", "Austria",
    "LVL", "Level", "LEVEL", "Spain and France",
    "LVN", "Aliven", "ALIVEN", "Italy",
    "LVR", "Aviavilsa", "AVIAVILSA", "Lithuania",
    "LVT", "La Valenciana Taxi Aéreo", "TAXIVALENCIANA", "Mexico",
    "LWA", "Libyan Wings", "LIBYAN WINGS", "Libya",
    "LWD", "Leisure Air", "LEISURE WORLD", "United States",
    "LWG", "Luxwing", "LUXWING", "Malta",
    "LWL", "Lowlevel", "CUB DRIVER", "Portugal",
    "LXA", "Luxaviation", "RED LION", "Luxembourg",
    "LXF", "Lynx Air International", "LYNX FLIGHT", "United States",
    "LXG", "Air Luxor GB", "LUXOR GOLF", "Guinea-Bissau",
    "LXJ", "Bombardier Business Jet Solutions", "FLEXJET", "United States",
    "LXO", "Luxor Air", "", "Egypt",
    "LXP", "LATAM Express", "LANEX", "Chile",
    "LYB", "Lynden Air Cargo", "HIGHLANDS", "Papua New Guinea",
    "LYC", "Lynden Air Cargo", "LYNDEN", "United States",
    "LYD", "Lydd Air", "LYDDAIR", "United Kingdom",
    "LYF", "Lithuanian Air Force", "LITHUANIAN AIRFORCE", "Lithuania",
    "LYH", "Yankee Lima Helicopteres", "HELIGUYANE", "France",
    "LYM", "Key Lime Air", "KEY LIME", "United States",
    "LYN", "Air Kyrgyzstan", "ALTYN AVIA", "Kyrgyzstan",
    "LYT", "Apatas Air", "APATAS", "Lithuania",
    "LYW", "Libyan Airlines", "LIBYAN AIRWAYS", "Libya",
    "LYX", "Lynx Aviation", "LYNX AIR", "Pakistan",
    "LZA", "Lanza Air", "AEROLANZA", "Spain",
    "LZB", "Bulgaria Air", "FLYING BULGARIA", "Bulgaria",
    "LZF", "Lease Fly", "SKYLEASE", "Portugal",
    "LZP", "Air Ban", "DOC AIR", "Bulgaria",
    "LZR", "Air Lazur", "LAZUR BEE-GEE", "Bulgaria",
    "LZT", "Lanzarote Aerocargo", "BARAKA", "Spain",
    "MAA", "MasAir", "MAS CARGA", "Mexico",
    "MAB", "Millardair", "MILLARDAIR", "Canada",
    "MAC", "Air Arabia Maroc", "ARABIA MAROC", "Morocco",
    "MAD", "Maple Air Services", "MAPLE AIR", "Canada",
    "MAE", "Mali Air", "MALI AIREXPRESS", "Austria",
    "MAF", "Mission Aviation Fellowship", "MISSI", "Indonesia",
    "MAI", "Max Avia", "MAX AVIA", "Kyrgyzstan",
    "MAJ", "Majestic Airlines", "MAGIC AIR", "United States",
    "MAL", "Morningstar Air Express", "MORNINGSTAR", "Canada",
    "MAM", "Aeródromo De La Mancha", "AEROMAN", "Spain",
    "MAN", "Mannion Air Charter", "MANNION", "United States",
    "MAQ", "Mac Aviation", "MAC AVIATION", "Spain",
    "MAR", "March Helicopters", "MARCH", "United Kingdom",
    "MAS", "Malaysia Airlines", "MALAYSIAN", "Malaysia",
    "MAT", "Maine Aviation", "MAINE-AV", "United States",
    "MAU", "Air Mauritius", "AIRMAURITIUS", "Mauritius",
    "MAV", "Minoan Air", "MINOAN", "Greece",
    "MAW", "Mustique Airways", "MUSTIQUE", "Barbados",
    "MAX", "Max-Aviation", "MAX AVIATION", "Canada",
    "MAY", "Malta Air", "", "Malta",
    "MAZ", "Mines Air Services Zambia", "MINES", "Zambia",
    "MBA", "Avag Air", "AVAG AIR", "Austria",
    "MBB", "Air Manas", "AIR MANAS", "Kyrgyzstan",
    "MBC", "Airjet Exploracao Aerea de Carga", "MABECO", "Angola",
    "MBE", "Martin-Baker", "MARTIN", "United Kingdom",
    "MBG", "Zephyr Aviation", "CHALGROVE", "United Kingdom",
    "MBI", "Mountain Bird", "MOUNTAIN BIRD", "United States",
    "MBL", "First City Air", "FIRST CITY", "United Kingdom",
    "MBN", "Zambian Airways", "ZAMBIANA", "Zambia",
    "MBO", "Mobil Oil", "MOBIL", "Canada",
    "MBR", "Brazilian Navy Aviation", "BRAZILIAN NAVY", "Brazil",
    "MBS", "Mbach Air", "MBACHI AIR", "Malawi",
    "MCB", "Air Mercia", "WESTMID", "United Kingdom",
    "MCC", "MCC Aviation", "DISCOVERY", "South Africa",
    "MCD", "Air Medical", "AIR MED", "United Kingdom",
    "MCE", "Marshall Aerospace", "MARSHALL", "United Kingdom",
    "MCF", "MAC Fotografica", "MAC FOTO", "Spain",
    "MCG", "SOS Helikoptern Gotland", "MEDICOPTER", "Sweden",
    "MCH", "McAlpine Helicopters", "MACLINE", "United Kingdom",
    "MCJ", "Avianca Argentina", "JETMAC", "Argentina",
    "MCK", "Macair Airlines", "", "Australia",
    "MCL", "Medical Aviation Services", "MEDIC", "United Kingdom",
    "MCM", "Heli-Air-Monaco", "HELI AIR", "Monaco",
    "MCN", "Mac Dan Aviation Corporation", "MAC DAN", "United States",
    "MCO", "Aerolíneas Marcos", "MARCOS", "Mexico",
    "MCP", "Marcopolo Airways", "MARCOPOLO", "Afghanistan",
    "MCS", "Macedonian Airlines", "MACAIR", "Greece",
    "MCT", "Transportación Aérea Del Mar De Cortés", "TRANS CORTES", "Mexico",
    "MCV", "MTC Aviación", "MTC AVIACION", "Mexico",
    "MCX", "Cargo Express", "MAURICARGO", "Mauritania",
    "MCY", "Ambulance Air Africa", "MERCY", "South Africa",
    "MDA", "Mandarin Airlines", "MANDARIN", "Taiwan",
    "MDB", "Monde Air Charters", "MONDEAIR CARGO", "United Kingdom",
    "MDC", "Atlantic Aero and Mid-Atlantic Freight", "NIGHT SHIP", "United States",
    "MDE", "Mauritanienne De Transport Aerien", "MAURI-TRANS", "Mauritania",
    "MDF", "Mediterranean Air Freight", "MED-FREIGHT", "Greece",
    "MDG", "Air Madagascar", "AIR MADAGASCAR", "Madagascar",
    "MDH", "Madina Air", "MADINA AIR", "Libya",
    "MDJ", "Jetran Air", "JETRAN AIR", "Romania",
    "MDL", "Mandala Airlines", "MANDALA", "Indonesia",
    "MDM", "Medavia", "MEDAVIA", "Malta",
    "MDN", "Mudan Airlines", "", "Somali Republic",
    "MDR", "Compania Mexicana De Aeroplanos", "AEROPLANOS", "Mexico",
    "MDS", "McNeely Charter Services", "MID-SOUTH", "United States",
    "MDT", "Sundt Air", "MIDNIGHT", "Norway",
    "MDV", "Moldavian Airlines", "MOLDAVIAN", "Moldova",
    "MDX", "Aerosud Charter", "MEDAIR", "South Africa",
    "MDY", "Mediterranean Airways", "", "Egypt",
    "MEA", "Middle East Airlines", "CEDAR JET", "Lebanon",
    "MEC", "Mercury Aircourier Service", "MERCAIR", "United States",
    "MED", "Ontario Ministry of Health", "MEDICAL", "Canada",
    "MEE", "Elimediterranea", "ELIMEDITERRANEA", "Italy",
    "MEF", "Air Meridan", "EMPENNAGE", "Nigeria",
    "MEI", "Merlin Airways", "AVALON", "United States",
    "MEJ", "Medjet International", "MEDJET", "United States",
    "MEK", "Med-Trans of Florida", "MED-TRANS", "United States",
    "MEL", "Mega Linhas Aéreas", "MEGA AIR", "Brazil",
    "MEM", "Meridian Limited", "MERIDIAN CHERRY", "Ukraine",
    "MEP", "Midwest Airlines", "MIDEX", "United States",
    "MER", "Methow Aviation", "METHOW", "United States",
    "MES", "Mesaba Airlines", "MESABA", "United States",
    "MET", "Meteorological Research Flight", "METMAN", "United Kingdom",
    "MEX", "Metro Express", "EAGLE EXPRESS", "United States",
    "MEY", "Justair Scandinavia", "MELODY", "Sweden",
    "MFA", "Martyn Fiddler Associates", "SEAHORSE", "United Kingdom",
    "MFB", "Mountain Flyers 80", "MOUNTAINHELI", "Switzerland",
    "MFC", "Moncton Flying Club", "EAST WIND", "Canada",
    "MFL", "Aero McFly", "MCFLY", "Mexico",
    "MFR", "Midline Air Freight", "MIDLINE FREIGHT", "United States",
    "MFS", "Miller Flying Services", "MILLER TIME", "United States",
    "MFT", "Multiflight", "YORKAIR", "",
    "MFZ", "Mofaz Air", "MOFAZ AIR", "Malaysia",
    "MGA", "MG Aviación", "MAG AVACION", "Spain",
    "MGB", "Coulson Flying Service", "MOCKINGBIRD", "United Kingdom",
    "MGE", "Asia Pacific Airlines", "MAGELLAN", "United States",
    "MGG", "Elmagal Aviation Services", "ELMAGAL", "Sudan",
    "MGI", "Marghi Air", "MARGHI", "Nigeria",
    "MGK", "Mega", "MEGLA", "Kazakhstan",
    "MGL", "MIAT Mongolian Airlines", "MONGOL AIR", "Mongolia",
    "MGM", "Transporte Aero MGM", "AERO EMM-GEE-EMM", "Mexico",
    "MGO", "Punto Fa", "MANGO", "Spain",
    "MGR", "Magna Air", "MAGNA AIR", "Austria",
    "MGS", "Aeromagar", "AEROMAGAR", "Mexico",
    "MGX", "Montenegro Airlines", "MONTENEGRO", "Montenegro",
    "MHA", "Mountain High Aviation", "MOUNTAIN HIGH", "United States",
    "MHC", "Aero Jomacha", "AERO JOMACHA", "Mexico",
    "MHD", "Yas Air Kish", "YAS AIR", "Iran",
    "MHF", "Maritime Helicopters", "AIR MARITIME", "United States",
    "MHL", "Meridian Airlines", "HASSIMAIR", "Nigeria",
    "MHN", "Manhattan Air", "MANHATTAN", "United Kingdom",
    "MHQ", "Skargardshavets Helikoptertjanst", "HELICARE", "Finland",
    "MHU", "Air Memphis", "MEPHIS UGANDA", "Uganda",
    "MHV", "MHS Aviation GmbH", "SNOWCAP", "Germany",
    "MIA", "Mauria", "MAURIA", "Mauritania",
    "MIC", "Mint Airways", "MINT AIRWAYS", "Spain",
    "MID", "Midland Airport Services", "", "United Kingdom",
    "MIE", "Aero Premier De Mexico", "AEROPREMIER", "Mexico",
    "MIF", "Miras", "MIRAS", "Kazakhstan",
    "MIG", "Russian Aircraft Corporation-MiG", "MIG AVIA", "Russia",
    "MIM", "Mimino", "MIMINO", "Russia",
    "MIR", "Miramichi Air Service", "MIRAMICHI", "Canada",
    "MIS", "Midstate Airlines", "MIDSTATE", "United States",
    "MIT", "Flight Line", "MATCO", "United States",
    "MIZ", "Desarrollo Milaz", "MILAZ", "Mexico",
    "MJB", "Magic Blue Airlines", "MAGIC BLUE", "Netherlands",
    "MJC", "Mandarin Air", "AIR MANDA", "China",
    "MJF", "MJET", "EM-EXPRESS", "Austria",
    "MJL", "Jet Line International", "MOLDJET", "Moldova",
    "MJM", "Eti 2000", "ELCO ETI", "Italy",
    "MJN", "Royal Air Force of Oman", "MAJAN", "Oman",
    "MJR", "Midamerica Jet", "MAJOR", "United States",
    "MJT", "Mex-Jet", "MEJETS", "Mexico",
    "MKA", "MK Airline", "KRUGER-AIR", "Ghana",
    "MKH", "Air Marrakech Service", "AIR MARRAKECH", "Morocco",
    "MKK", "Malaya Aviatsia Dona", "AEROKEY", "Russia",
    "MKL", "McCall Aviation", "MCCALL", "United States",
    "MKO", "Markoss Aviation", "GOSHAWK", "United Kingdom",
    "MKS", "Pimichikamac Air", "MIKISEW", "Canada",
    "MKY", "Monky Aerotaxis", "MONKY", "Mexico",
    "MLA", "40-Mile Air", "MILE-AIR", "United States",
    "MLB", "Manaf International Airways", "MANAF", "Burundi",
    "MLC", "Malila Airlift", "MALILA", "Democratic Republic of the Congo",
    "MLD", "Air Moldova", "AIR MOLDOVA", "Moldova",
    "MLE", "Moldaeroservice", "MOLDAERO", "Moldova",
    "MLF", "Amal Airlines", "AMAL", "Djibouti",
    "MLG", "Malagasy Airlines", "", "Madagascar",
    "MLH", "Mahalo Air", "MAHALO", "United States",
    "MLK", "Millennium Air", "NIGERJET", "Nigeria",
    "MLL", "Aeroclub de Mallorca", "MALLORCA", "Spain",
    "MLM", "Comlux Malta", "LUXMALTA", "Malta",
    "MLN", "Air Madeleine", "AIR MADELEINE", "Canada",
    "MLO", "Servicios Aéreos Milenio", "MILENIO", "Mexico",
    "MLR", "Mihin Lanka", "MIHIN LANKA", "Sri Lanka",
    "MLS", "Mall Airways", "MALL-AIRWAYS", "United States",
    "MLT", "Maleth-Aero", "", "Malta",
    "MLU", "Zracno Pristaniste Mali Losinj", "MALI LOSINJ", "Croatia",
    "MLV", "Multiservicios Aereos Del Valle", "MULTI VALLE", "Mexico",
    "MLX", "Malawi Express", "MALAWI EXPRESS", "Malawi",
    "MMA", "Myanmar Airways International", "MYANMAR", "Myanmar",
    "MMC", "Aermarche", "AERMARCHE", "Italy",
    "MMD", "Air Alsie", "MERMAID", "Denmark",
    "MMG", "Aereo Ruta Maya", "RUTA MAYA", "Guatemala",
    "MMH", "McMahon Helicopter", "NIGHT RIDER", "United States",
    "MMJ", "Macau Jet International", "MACAUJET", "China",
    "MML", "Hunnu Air", "TRANS MONGOLIA", "Mongolia",
    "MMM", "Aviation Company Meridian", "AVIAMERIDIAN", "Russia",
    "MMP", "AMP Incorporated", "AMP-INC", "United States",
    "MMR", "Musrata Air Transport", "MUSRATA AIR", "Libya",
    "MMS", "SAAD (A320) Limited", "MUSAAD AIR", "Cayman Islands",
    "MMX", "Airmax", "PERUMAX", "Peru",
    "MMZ", "EuroAtlantic Airways", "EUROATLANTIC", "Portugal",
    "MNA", "Merpati Nusantara Airlines", "MERPATI", "Indonesia",
    "MNB", "MNG Airlines", "BLACK SEA", "Turkey",
    "MNC", "MIT Airlines", "MUNCIE", "Canada",
    "MNE", "Air Montenegro", "MOUNT EAGLE", "Montenegro",
    "MNG", "Aero Mongolia", "AERO MONGOLIA", "Mongolia",
    "MNH", "Monarch Airlines", "MONARCH AIR", "United States",
    "MNI", "Aeromilenio", "AEROMIL", "Mexico",
    "MNJ", "Menajet", "MENAJET", "Lebanon",
    "MNL", "Miniliner", "MINILINER", "Italy",
    "MNO", "Mango", "TULCA", "South Africa",
    "MNR", "Mann Air", "TEEMOL", "United Kingdom",
    "MNS", "Ministic Air", "MINISTIC", "Canada",
    "MNT", "Montserrat Airways", "MONTSERRAT", "Montserrat",
    "MNU", "Elite Airways", "MAINER", "United States",
    "MNV", "Mauritanienne Aerienne Et Navale", "NAVALE", "Mauritania",
    "MNX", "Manx Airlines", "MANX", "United Kingdom",
    "MNY", "Mooney Aircraft Corporation", "MOONEY FLIGHT", "United States",
    "MNZ", "Murmansk Aircompany", "MURMAN AIR", "Russia",
    "MOC", "Air Monarch Cargo", "MONARCH CARGO", "Mexico",
    "MOH", "Tigerfly", "MOTH", "United Kingdom",
    "MOP", "Aeropublicitaria De Angola", "PUBLICITARIA", "Angola",
    "MOR", "Aerolíneas De Morelia", "AEROMORELIA", "Mexico",
    "MOS", "Misr Overseas Airways", "", "Egypt",
    "MOV", "VIM Airlines", "MOV AIR", "Russia",
    "MOW", "Mohawk Airlines", "MOHAWK AIR", "United States",
    "MPA", "Mid-Pacific Airlines", "MID PAC", "United States",
    "MPC", "Mountain Pacific Air", "MOUNTAIN PACIFIC", "Canada",
    "MPD", "Air Plus Comet", "RED COMET", "Spain",
    "MPH", "Martinair", "MARTINAIR", "Netherlands",
    "MPI", "Mosphil Aero", "MOSPHIL", "Philippines",
    "MPJ", "MAP-Management and Planung", "MAPJET", "Austria",
    "MPL", "Master Planner", "", "United States",
    "MPO", "Transportes Aéreos Amparo", "AMPARO", "Mexico",
    "MPR", "Empire Aviation Services", "", "Nigeria",
    "MPS", "Metropolis", "METRO REGIONAL", "Netherlands",
    "MPT", "Miapet-Avia", "MIAPET", "Armenia",
    "MPX", "Aeromexpress", "AEROMEXPRESS", "Mexico",
    "MQT", "Air ITM", "MUSKETEER", "France",
    "MRA", "Martinaire", "MARTEX", "United States",
    "MRD", "Meridian Air Cargo", "MERIDIAN", "United States",
    "MRE", "Namibia Commercial Aviation", "MED RESCUE", "Namibia",
    "MRF", "Mauritanienne Air Fret", "MAUR-FRET", "Mauritania",
    "MRG", "MANAG'AIR", "MANAG'AIR", "France",
    "MRH", "RAF Marham", "MARHAM", "United Kingdom",
    "MRI", "Servicios Aéreos Moritani", "MORITANI", "Mexico",
    "MRK", "Markair", "MARKAIR", "United States",
    "MRL", "Aeromorelos", "AEROMORELOS", "Mexico",
    "MRM", "Aerocharter", "MARITIME", "Canada",
    "MRN", "Missions Gouvernemtales Francaises", "MARIANNE", "France",
    "MRO", "Morrison Flying Service", "MORRISON", "United States",
    "MRP", "Abas", "ABAS", "Czech Republic",
    "MRR", "San Juan Airlines", "MARINER", "United States",
    "MRT", "Air Mauritanie", "MIKE ROMEO", "Mauritania",
    "MRW", "Mars RK", "AVIAMARS", "Ukraine",
    "MRX", "Herman's Markair Express", "SPEEDMARK", "United States",
    "MRY", "Air Marine", "AIR MARINE", "France",
    "MRZ", "Medical Air Rescue Services", "MARS", "Zimbabwe",
    "MSA", "Poste Air Cargo", "AIRMERCI", "Italy",
    "MSC", "Air Cairo", "", "Egypt",
    "MSF", "Minsheng International Jet", "MEINSHENG", "China",
    "MSG", "Servico Aéreo Regional", "SAR-REGIONAL", "Mozambique",
    "MSH", "US Marshals Service", "MARSHALAIR", "United States",
    "MSI", "Motor Sich Airlines", "MOTOR SICH", "Ukraine",
    "MSJ", "Magnum Air", "MAGNUM AIR", "Philippines",
    "MSK", "Air Sport", "AIR SPORT", "Bulgaria",
    "MSL", "Marsland Aviation", "MARSLANDAIR", "Sudan",
    "MSM", "Aeromas", "AEROMAS EXPRESS", "Uruguay",
    "MSN", "Missionair", "MISIONAIR", "Spain",
    "MSO", "Aerolíneas Mesoamericanas", "MESO AMERICANAS", "Mexico",
    "MSP", "Servicio De Vigilancia Aérea Del Ministerio De Seguridad Pública", "SEGURIDAD", "Costa Rica",
    "MSQ", "Meta Linhas Aéreas", "META", "Brazil",
    "MSR", "Egyptair", "EGYPTAIR", "Egypt",
    "MSS", "Morris Air Service", "WASATCH", "United States",
    "MSV", "Aero-Kamov", "AERAFKAM", "Russia",
    "MSW", "Master Airways", "MASTER AIRWAYS", "Serbia",
    "MSX", "Egyptair Cargo", "EGYPTAIR CARGO", "Egypt",
    "MSY", "Massey University School of Aviation", "MASSEY", "New Zealand",
    "MTA", "GAK/Mitchell Aero", "GAK AVIATION", "United States",
    "MTB", "Aerotaxis Metropolitanos", "AEROMETROPOLIS", "Mexico",
    "MTC", "Mountain Air Company", "MOUNTAIN LEONE", "Sierra Leone",
    "MTD", "MacKnight Airlines", "", "Australia",
    "MTG", "Servicios Aéreos MTT", "", "Mexico",
    "MTH", "Massachusetts Institute of Technology", "RESEARCH", "United States",
    "MTI", "Monerrey Air Taxi", "MONTERREY AIR", "Mexico",
    "MTJ", "Metrojet", "METROJET", "Hong Kong",
    "MTK", "Air Metack", "AIRMETACK", "Angola",
    "MTL", "RAF-Avia", "MITAVIA", "Latvia",
    "MTN", "Mountain Air Cargo", "MOUNTAIN", "United States",
    "MTO", "Marathon Airlines", "MARATHON", "Greece",
    "MTP", "Island Helicopters", "METROCOPTER", "United States",
    "MTR", "Metroflight", "METRO", "United States",
    "MTS", "Mantrust Asahi Airways", "MANTRUST", "Indonesia",
    "MTU", "Middle Tennessee State University", "BLUE RAIDER", "United States",
    "MTV", "Mountain Valley Air Service", "MOUNTAIN VALLEY", "United States",
    "MTX", "Multi Taxi", "MULTITAXI", "Mexico",
    "MTZ", "Mali Airways", "MALI AIRWAYS", "Mali",
    "MUA", "Murray Air", "MURRAY AIR", "United States",
    "MUI", "Trans Air", "MAUI", "United States",
    "MUL", "Mokulele Airlines", "MUKULELE", "United States",
    "MUN", "Aeromundo Ejecutivo", "AEROMUNDO", "Mexico",
    "MUR", "Aerolínea Muri", "MURI", "Mexico",
    "MVA", "Mississippi Valley Airways", "VALAIR", "United States",
    "MVD", "Kavminvodyavia", "AIR MINVODY", "Russia",
    "MVG", "Moldova", "MOLDOVA-STATE", "Moldova",
    "MVI", "Metro Business Aviation", "", "United Kingdom",
    "MVK", "Helicopter Training & Hire", "MAVRIK", "United Kingdom",
    "MVL", "Mavial Magadan Airlines", "Mavial", "Russia",
    "MVM", "Air Cargo America", "PEGASUS", "United States",
    "MVN", "Marvin Limited", "MARVIN", "United Kingdom",
    "MVR", "Maverick Airways", "MAV-AIR", "United States",
    "MVY", "VIM-Aviaservice", "", "Russia",
    "MWA", "Midwest Airlines (Egypt)", "", "Egypt",
    "MWG", "MASwings", "MASWINGS", "Malaysia",
    "MWI", "Malawian Airlines 2014", "MALAWIAN", "Malawi",
    "MWM", "Modern Transporte Aereo De Carga", "MODERNAIR", "Brazil",
    "MWR", "Raslan Air Service", "RASLAN", "Egypt",
    "MWS", "Malta Wings", "MALTA WINGS", "Malta",
    "MWT", "Midwest Aviation Division", "MIDWEST", "United States",
    "MWY", "Mauritanienne Airways", "MAURITANIENNE", "Mauritania",
    "MXA", "Mexicana de Aviación", "MEXICANA", "Mexico",
    "MXB", "Mex Blue", "MEX BLUE", "Mexico",
    "MXD", "Malindo Airways", "MALINDO EXPRESS", "Malaysia",
    "MXE", "Mocambique Expresso", "MOZAMBIQUE EXPRESS", "Mozambique",
    "MXF", "Maximum Flight Advantages", "MAXFLIGHT", "United States",
    "MXL", "Maxair", "MAXAIR", "Sweden",
    "MXO", "Aerotaxi Mexicano", "MAXAERO", "Mexico",
    "MXP", "May Air Xpress", "BEECHNUT", "United States",
    "MXQ", "Transportes Aéreos Mexiquenses", "MEXIQUENSES", "Mexico",
    "MXS", "Millon Express", "MILLON EXPRESS", "United States",
    "MXT", "México Transportes Aéreos", "TRANSMEX", "Mexico",
    "MXU", "Maximus Air Cargo", "CARGO MAX", "United Arab Emirates",
    "MXX", "Merchant Express Aviation", "MERCHANT", "Nigeria",
    "MXY", "Breeze Airways", "MOXY", "United States",
    "MYA", "Myflug", "MYFLUG", "Iceland",
    "MYD", "Maya Island Air", "MYLAND", "Belize",
    "MYI", "Mayair", "MAYAIR", "Mexico",
    "MYM", "MYAirline", "MYAIR", "Malaysia",
    "MYO", "Dominguez Toledo (Grupo Mayoral)", "MAYORAL", "Spain",
    "MYP", "Mann Yadanarpon Airlines", "MANN ROYAL", "Myanmar",
    "MYS", "Aero Yaqui Mayo", "AERO YAQUI", "Mexico",
    "MYW", "MyWay Airlines", "MYSKY", "Georgia",
    "MYX", "Smartlynx Airlines Estonia", "TALLINN CAT", "Estonia",
    "MZA", "Irtysh Air", "IRTYSH AIRLINES", "Kazakhstan",
    "MZE", "Zenith Aviation (Malta)", "", "Malta",
    "MZK", "AVC Airlines", "", "Japan",
    "MZL", "Aerovías Montes Azules", "MONTES AZULES", "Mexico",
    "MZS", "Mahfooz Aviation", "MAHFOOZ", "Gambia",
    "N/A", "North Coast Air Services Ltd", "NORTH COAST", "Canada",
    "NAA", "Norwegian Air Argentina", "NORUEGA", "Argentina",
    "NAB", "Mina Airline Company", "", "Egypt",
    "NAC", "Northern Air Cargo", "YUKON", "United States",
    "NAD", "Seulawah Nad Air", "SEULAWAH", "Indonesia",
    "NAE", "Nations Air Express Inc", "NATIONS EXPRESS", "United States",
    "NAF", "Royal Netherlands Air Force", "NETHERLANDS AIR FORCE", "Netherlands",
    "NAH", "Nahanni Air Services Ltd", "NAHANNI", "Canada",
    "NAI", "North Adria Aviation", "NORTH-ADRIA", "Croatia",
    "NAJ", "North American Jet Charter Group", "JET GROUP", "United States",
    "NAK", "École Nationale de l'Aviation Civile", "ENAC SCHOOL", "France",
    "NAL", "Northway Aviation Ltd", "NORTHWAY", "Canada",
    "NAM", "Nortland Air Manitoba", "MANITOBA", "Canada",
    "NAN", "Norwegian Air Norway", "NORSHIP", "Norway",
    "NAO", "North American Airlines", "NORTH AMERICAN", "United States",
    "NAP", "Napier Air Service Inc", "NAPIER", "United States",
    "NAR", "Air Continental Inc", "NIGHT AIR", "United States",
    "NAS", "Nasair", "NASAIRWAYS", "Eritrea",
    "NAT", "North Atlantic Air Inc", "MASS AIR", "United States",
    "NAU", "Antanik-Air", "ANTANIK", "Ukraine",
    "NAV", "Nav Flight Planning", "NAV DISPATCH", "Czech Republic",
    "NAY", "Navegación Servicios Aéreos Canarios S.A.", "NAYSA", "Spain",
    "NAZ", "Servicios Aéreos del Nazas S.A. de C.V.", "NAZAS", "Mexico",
    "NBE", "Novosibirsk Aviaenterprise", "NAKAIR", "Russia",
    "NBK", "Albarka Air", "AL-AIR", "Nigeria",
    "NBL", "Nobil Air", "NOBIL AIR", "Moldova",
    "NBN", "North British Airlines", "TEESAIR", "United Kingdom",
    "NBR", "Haughey Air", "NORBROOK", "United Kingdom",
    "NBS", "Nimbus Aviation", "NIMBUS", "United Kingdom",
    "NBT", "Norse Atlantic Airways", "LONGSHIP", "Norway",
    "NCA", "Nippon Cargo Airlines", "NIPPON CARGO", "Japan",
    "NCB", "North Caribou Flying Service Ltd", "NORTH CARIBOU", "Canada",
    "NCC", "T3 Aviation  Inc.", "STARFLEET", "United States",
    "NCE", "Northcoast Executive Airlines", "TOP HAT", "United States",
    "NCF", "Norfolk County Flight College", "COUNTY", "United Kingdom",
    "NCG", "Nederlandse Kustwacht", "NETHERLANDS COASTGUARD", "Netherlands",
    "NCH", "Chanchangi Airlines", "CHANCHANGI", "Nigeria",
    "NCM", "Nas Air", "AIR BANE", "Angola",
    "NCN", "National Airlines", "", "Chile",
    "NCO", "Natalco Air Lines", "NATALCO", "São Tomé and Príncipe",
    "NCP", "Capital Airlines Limited", "CAPITAL SHUTTLE", "Nigeria",
    "NCR", "National Air Cargo dba National Airlines", "NATIONAL CARGO", "United States",
    "NCS", "Simpson Air Ltd", "COMMUTER-CANADA", "Canada",
    "NCT", "NokScoot", "BIG BIRD", "Thailand",
    "NDA", "Northern Airways", "NORTHERN DAKOTA", "United States",
    "NDF", "Namibian Defence Force", "NAMIBIAN AIR FORCE", "Namibia",
    "NDS", "Nordstree (Australia)", "", "Australia",
    "NDU", "University of North Dakota", "SIOUX", "United States",
    "NEA", "New England Airlines", "NEW ENGLAND", "United States",
    "NEB", "State of Nebraska", "NEBRASKA", "United States",
    "NEC", "Necon Air", "NECON AIR", "Nepal",
    "NEE", "Northeast Airlines", "NORTHEAST", "United States",
    "NEF", "Nord-Flyg", "NORDEX", "Sweden",
    "NEG", "Línea Aérea de Fumig Aguas Negras", "AGUAS NEGRAS", "Chile",
    "NEJ", "Netjets Business Aviation", "NET BUSINESS", "China",
    "NEL", "Aero Servicios de Nuevo Laredo", "AEROLAREDO", "Mexico",
    "NEN", "North-East Airlines", "NORTHEAST SWAN", "Nigeria",
    "NER", "Air Newark", "NEWAIR", "United States",
    "NES", "Nordeste Linhas Aéreas Regionais", "NORDESTE", "Brazil",
    "NET", "Network Aviation Services", "NETWORK", "Nigeria",
    "NEW", "Northeastern Aviation", "MEADOW FLIGHT", "United States",
    "NEX", "Northern Executive Aviation", "NEATAX", "United Kingdom",
    "NEZ", "New England Air Express", "ENGAIR", "United States",
    "NFA", "North Flying", "NORTH FLYING", "Denmark",
    "NFC", "North Atlantic Cargo", "NORTH ATLANTIC", "Norway",
    "NFL", "Northaire Freight Lines", "GREAT LAKES", "United States",
    "NFT", "Nefteyugansk Aviation Division", "NEFTEAVIA", "Russia",
    "NGA", "Nigeria Airways", "NIGERIA", "Nigeria",
    "NGC", "Angoservice", "ANGOSERVICE", "Angola",
    "NGF", "Angel Flight America", "ANGEL FLIGHT", "United States",
    "NGK", "Oriental Air Bridge", "ORIENTAL BRIDGE", "Japan",
    "NGO", "Air-Angol", "AIR ANGOL", "Angola",
    "NGR", "Nigerian Air Force", "NIGERIAN AIRFORCE", "Nigeria",
    "NGV", "Angoavia", "ANGOAVIA", "Angola",
    "NGX", "Nigerian Global", "AIR GLOBAL", "Nigeria",
    "NHC", "Northern Helicopter", "NORTHERN", "Germany",
    "NHG", "NHT Linhas Aéreas", "HELGA", "Brazil",
    "NHK", "Federal Aviation Administration", "NIGHTHAWK", "United States",
    "NHL", "Northumbria Helicopters", "NORTHUMBRIA", "United Kingdom",
    "NHR", "Nuevo Horizonte Internacional", "NUEVO HORIZONTE", "Mexico",
    "NHT", "New Heights 291", "NEWHEIGHTS", "South Africa",
    "NHV", "NHV Aviation", "", "Ghana",
    "NHZ", "Nada Air Service", "NADA AIR", "Chad",
    "NIC", "Northern Illinois Commuter", "ILLINOIS COMMUTER", "United States",
    "NID", "Aeroni", "AERONI", "Mexico",
    "NIE", "Aeroejecutiva Nieto", "AERONIETO", "Mexico",
    "NIG", "Aero Contractors", "AEROLINE", "Nigeria",
    "NIH", "NAM Air", "NAM", "Indonesia",
    "NIN", "Niger Airlines", "NIGER AIRLINES", "Niger",
    "NIR", "Norsk Flytjeneste", "NORSEMAN", "Norway",
    "NIS", "Nicaragüense de Aviación", "NICA", "Nicaragua",
    "NIT", "Midwest Aviation", "NIGHTTRAIN", "United States",
    "NJA", "New Japan Aviation", "SHIN NIHON", "Japan",
    "NJC", "Nashville Jet Charters", "NASHVILLE JET", "United States",
    "NJE", "NetJets Europe", "FRACTION", "Portugal",
    "NJS", "National Jet Systems", "NATIONAL JET", "Australia",
    "NKF", "Barents AirLink", "NORDFLIGHT", "Sweden",
    "NKL", "Nakheel Aviation", "NAKHEEL", "United Arab Emirates",
    "NKP", "Abakan Air", "ABAKAN AIR", "Russia",
    "NKS", "Spirit Airlines", "SPIRIT WINGS", "United States",
    "NKV", "Nikolaev-Air", "AIR NIKOLAEV", "Ukraine",
    "NKY", "Aeromonkey", "AEROMON", "Mexico",
    "NKZ", "Aerokuzbass", "NOVOKUZNETSK", "Russia",
    "NLA", "Neiltown Air", "NEILTOWN AIR", "Canada",
    "NLC", "Nelair Charters", "NELAIR", "South Africa",
    "NLG", "NEL Cargo", "NELCARGO", "Ivory Coast",
    "NLH", "Norwegian Long Haul", "NORSTAR", "Norway",
    "NLK", "Elbrus-Avia Air Enterprise", "ELAVIA", "Russia",
    "NLL", "Northafrican Air Transport", "NORTHAFRICAN AIR", "Libya",
    "NLS", "Nationale Luchtvaartschool", "PANDER", "Netherlands",
    "NLT", "Newfoundland Labrador Air Transport", "NALAIR", "Canada",
    "NLW", "Nile Wings Aviation Services", "NILE WINGS", "Sudan",
    "NLY", "Niki", "FLYNIKI", "Austria",
    "NMB", "Air Namibia", "NAMIBIA", "Namibia",
    "NMD", "Nomad Aviation", "NOMAD AIR", "Namibia",
    "NMI", "Pacific Wings", "TSUNAMI", "United States",
    "NML", "Gambia New Millennium Air", "NEWMILL", "Gambia",
    "NOA", "Norontair", "NORONTAIR", "Canada",
    "NOC", "Norcopter", "NORCOPTER", "Norway",
    "NOF", "Fonnafly", "FONNA", "Norway",
    "NOH", "No. 32 (The Royal) Squadron", "NORTHOLT", "United Kingdom",
    "NOK", "Nok Air", "NOK AIR", "Thailand",
    "NOL", "National Overseas Airlines Company", "NAT AIRLINE", "Egypt",
    "NON", "Servicios Aéreos Latinoamericanos", "SERVICIOS LATINO", "Mexico",
    "NOR", "Norsk Helikopter", "NORSKE", "Norway",
    "NOS", "Neos", "MOONFLOWER", "Italy",
    "NOT", "Línea Aérea Costa Norte", "COSTA NORTE", "Chile",
    "NOV", "Nova Airline", "NOVANILE", "Sudan",
    "NOW", "Royal Norwegian Air Force", "NORWEGIAN", "Norway",
    "NOY", "Noy Aviation", "NOY AVIATION", "Israel",
    "NOZ", "Norwegian Air Shuttle", "NORDIC", "Norway",
    "NPC", "Western Air Couriers", "NORPAC", "United States",
    "NPO", "Novosibirsk Aviation Production Association", "NOVSIB", "Russia",
    "NPT", "West Atlantic UK", "NEPTUNE", "United Kingdom",
    "NPX", "Northeast Aviation", "NORTHEAST EXPRESS", "United States",
    "NRC", "North Sea Airways", "NORTH SEA", "Netherlands",
    "NRD", "Nordic Regional", "NORTH RIDER", "Sweden",
    "NRE", "Aviones Are", "AVIONES ARE", "Mexico",
    "NRG", "Ross Aviation", "ENERGY", "United States",
    "NRK", "Naturelink Charter", "NATURELINK", "South Africa",
    "NRL", "Nolinor Aviation", "NOLINOR", "Canada",
    "NRN", "Royal Netherland Navy", "NETHERLANDS NAVY", "Netherlands",
    "NRP", "Aeronord-Grup", "AERONORD", "Moldova",
    "NRR", "Natureair", "NATUREAIR", "Costa Rica",
    "NRS", "Norwegian Air UK", "REDNOSE", "United Kingdom",
    "NRT", "Norestair", "NORESTAIR", "Spain",
    "NRV", "North Vancouver Airlines", "NORVAN", "Canada",
    "NRW", "Polizeifliegerstaffel Nordrhein-Westfalen", "HUMMEL", "Germany",
    "NRX", "Norse Air Charter", "NORSE AIR", "South Africa",
    "NRZ", "Servicios Aéreos Monarrez", "MONARREZ", "Mexico",
    "NSA", "Nile Safaris Aviation", "NILE SAFARIS", "Sudan",
    "NSC", "Societe De Transport Aerien De Mauritanie", "TRANS-SOCIETE", "Mauritania",
    "NSE", "SATENA", "SATENA", "Colombia",
    "NSF", "Northamptonshire School of Flying", "NORTON", "United Kingdom",
    "NSK", "Air Intersalonika", "INTERSALONIKA", "Greece",
    "NSL", "Neric", "NERICAIR", "United Kingdom",
    "NSM", "Global Jet Corporation", "THUNDERCLOUD", "United States",
    "NSO", "Aerolíneas Sosa", "SOSA", "Honduras",
    "NSP", "Novosibirsk Aircraft Repairing Plant", "NARPAIR", "Russia",
    "NSR", "National Air Charter", "NASAIR", "Indonesia",
    "NSS", "Northstar Aviation", "NORTHSTAR", "United States",
    "NSW", "Country Connection Airlines", "", "Australia",
    "NSZ", "Norwegian Air Sweden", "REDNOSE", "Sweden",
    "NTA", "Northern Thunderbird Air", "THUNDERBIRD", "Canada",
    "NTB", "Servicios Aéreos Del Norte", "SERVINORTE", "Mexico",
    "NTC", "Gibson Aviation", "NIGHT CHASE", "United States",
    "NTD", "Aero Norte", "", "Mexico",
    "NTE", "Interaire", "INTERMEX", "Mexico",
    "NTG", "Servicios Integrales De Aviación", "INTEGRALES", "Mexico",
    "NTH", "Hokkaido Air System", "NORTH AIR", "Japan",
    "NTJ", "NextJet", "NEXTJET", "Sweden",
    "NTK", "National Air Traffic Controllers Association", "NATCA", "United States",
    "NTR", "TNT International Aviation", "NITRO", "United Kingdom",
    "NTS", "Cirrus Air", "NITE STAR", "United States",
    "NTT", "Inter Tropic Airlines", "INTER-TROPIC", "Sierra Leone",
    "NTV", "Air Inter Ivoire", "INTER-IVOIRE", "Ivory Coast",
    "NTW", "Nationwide Airlines", "NATIONWIDE", "South Africa",
    "NTX", "Northern Jet Management", "NORTAX", "United States",
    "NUB", "Nomad Aviation", "VALLETTA", "Malta",
    "NUL", "Aeroservicios De Nuevo Leon", "SERVICIOS NUEVOLEON", "Mexico",
    "NUN", "Nunasi-Central Airlines", "NUNASI", "Canada",
    "NVA", "Aeroclub de Albacete", "", "Spain",
    "NVC", "Nav Canada", "NAV CAN", "Canada",
    "NVD", "Avion Express", "NORDVIND", "Lithuania",
    "NVG", "Novgorod Air Enterprise", "SADKO AVIA", "Russia",
    "NVI", "Avial NV Aviation Company", "NEW AVIAL", "Russia",
    "NVJ", "Fly International Airways", "NOUVINTER", "Tunisia",
    "NVK", "Nizhnevartovskavia", "VARTOSKAVIA", "Russia",
    "NVL", "Navigator Airlines", "NAVLINES", "Armenia",
    "NVM", "Naviera Mexicana", "NAVIERA", "Mexico",
    "NVP", "Navegacao Aérea De Portugal", "", "Portugal",
    "NVQ", "Novo Air", "NOVO AIR", "Bangladesh",
    "NVR", "Novair", "NAVIGATOR", "Sweden",
    "NVY", "Royal Navy", "NAVY", "United Kingdom",
    "NWD", "New World Jet Corporation", "NEW WORLD", "United States",
    "NWE", "Northwest Aero Associates", "", "United States",
    "NWG", "Airwing", "NORWING", "Norway",
    "NWL", "North-Wright Airways", "NORTHWRIGHT", "Canada",
    "NWN", "Northwinds Northern", "NORTHWINDS", "Canada",
    "NWO", "RAF Northwood", "", "United Kingdom",
    "NWR", "Northwest Regional Airlines", "", "Australia",
    "NWS", "Nordwind Airlines", "NORDLAND", "Russia",
    "NWT", "Northwest Territorial Airways", "TERRITORIAL", "Canada",
    "NWW", "North West Airlines", "HALANT", "Australia",
    "NWZ", "Nationwide Airlines (Zambia)", "ZAMNAT", "Zambia",
    "NXA", "Air Next", "BLUE-DOLPHIN", "Japan",
    "NXF", "Nextflight Aviation", "NEXTFLIGHT", "United States",
    "NXS", "Nexus Aviation", "NEXUS AVIATION", "Nigeria",
    "NXT", "National Express", "NATIONAL FREIGHT", "United States",
    "NYA", "Nanyah Aviation", "NANYAH", "Israel",
    "NYB", "Belgian Navy", "BELGIAN NAVY", "Belgium",
    "NYH", "New York Helicopter", "NEW YORK", "United States",
    "NYL", "Mid Airlines", "NILE", "Sudan",
    "NYS", "Nyasa Express", "NYASA", "Malawi",
    "NYT", "Yeti Airlines", "YETI AIRLINES", "Nepal",
    "NZA", "Nayzak Air Transport", "", "Libya",
    "NZM", "Mount Cook Airline", "MOUNTCOOK", "New Zealand",
    "OAA", "Oxley Aviation", "", "Australia",
    "OAC", "Oriental Airlines", "ORIENTAL AIR", "Nigeria",
    "OAD", "Orscom Tourist Installations Company", "ORSCOM", "Egypt",
    "OAE", "Omni Air International", "OMNI-EXPRESS", "United States",
    "OAL", "Olympic Air", "OLYMPIC", "Greece",
    "OAO", "Arkhangelsk 2 Aviation Division", "DVINA", "Russia",
    "OAP", "COAPA AIR", "COAPA", "Mexico",
    "OAR", "ONE AIR", "BOSS AIR", "Spain",
    "OAV", "Omni - Aviacao e Tecnologia", "OMNI", "Portugal",
    "OAW", "Helvetic Airways", "HELVETIC", "Switzerland",
    "OAX", "Operational Aviation Services", "", "Australia",
    "OBA", "Aerobanana", "AEROBANANA", "Mexico",
    "OBK", "Amako Airlines", "AMAKO AIR", "Nigeria",
    "OCA", "Aserca Airlines", "AROSCA", "Venezuela",
    "OCE", "Heliocean", "HELIOCEAN", "France",
    "OCN", "Eurowings Discover", "OCEAN", "Germany",
    "OCO", "Ostend Air College", "AIR COLLEGE", "Belgium",
    "OCS", "Ocean Sky UK", "OCEANSKY", "United Kingdom",
    "ODI", "Jonsson  H Air Taxi", "ODINN", "Iceland",
    "ODM", "Pan African Airways", "", "Kenya",
    "ODS", "Odessa Airlines", "ODESSA AIR", "Ukraine",
    "ODY", "Odyssey International", "ODYSSEY", "Canada",
    "OEA", "Orient Thai Airlines", "ORIENT THAI", "Thailand",
    "OEC", "Christophorus Flugrettungsverein", "CHRISTOPHORUS", "Austria",
    "OED", "Orion Air Charter", "ORION CHARTER", "South Africa",
    "OES", "ART Aviation", "ART AUSTRIA", "Austria",
    "OFA", "Helitaxi Ofavi", "OFAVI", "Mexico",
    "OFF", "Challenge International Airlines", "CHALLENGE AIR", "United States",
    "OGI", "Aerogisa", "AEROGISA", "Mexico",
    "OGJ", "Bakoji Airlines Services", "BAKO AIR", "Nigeria",
    "OGN", "Origin Pacific Airways", "ORIGIN", "New Zealand",
    "OHY", "Onur Air", "ONUR AIR", "Turkey",
    "OIC", "Iwamoto Crane Co Ltd", "", "Japan",
    "OIX", "Orion-x", "ORIONIX", "Russia",
    "OJY", "Florida Air", "OHJAY", "United States",
    "OKA", "Okay Airways", "OKAYJET", "China",
    "OKJ", "Okada Airlines", "OKADA AIR", "Nigeria",
    "OKL", "Oklahoma Department of Public Safety", "OKLAHOMA", "United States",
    "OKP", "Okapi Airways", "OKAPI", "Democratic Republic of Congo",
    "OKS", "Slok Air Gambia", "SLOK GAMBIA", "Gambia",
    "OKT", "Soko Aviation", "SOKO AIR", "Spain",
    "OLA", "Overland Airways", "OVERLAND", "Nigeria",
    "OLC", "Solar Cargo", "SOLARCARGO", "Venezuela",
    "OLE", "Operadora de Lineas Ejecutivas", "OPERADORA", "Mexico",
    "OLO", "Soloflight", "SOLO", "United Kingdom",
    "OLR", "Colaéreos", "COLAEREOS", "Ecuador",
    "OLT", "OLT Express Germany", "OLTRA", "Germany",
    "OLV", "Aerolíneas Olve", "OLVE", "Mexico",
    "OLX", "Olimex Aerotaxi", "OLIMEX", "Czech Republic",
    "OLY", "Olympic Aviation", "OLAVIA", "Greece",
    "OMA", "Oman Air", "OMAN AIR", "Oman",
    "OMD", "Nomadic Aviation Group LLC", "NOMADIC", "United States",
    "OMF", "Omniflys", "OMNIFLYS", "Mexico",
    "OMG", "Aeromega", "OMEGA", "United Kingdom",
    "OML", "Organizacoes Mambra", "MAMBRA", "Angola",
    "OMN", "Servicios Aereos Ominia", "SERVIOMNIA", "Mexico",
    "OMR", "Minair", "ORMINE", "Central African Republic",
    "OMS", "SalamAir", "MAZOON", "Oman",
    "ONE", "Avianca Brasil", "OCEAN AIR", "Brazil",
    "ONG", "Sonnig SA", "SONNIG", "Switzerland",
    "ONI", "OMNI AVIATION TRAINING CENTER", "OMNI TRAINING", "Portugal",
    "ONM", "Presidencia de La Republica de Guinea Ecuatorial", "", "Equatorial Guinea",
    "ONS", "One Airlines", "AIR DREAMS", "Chile",
    "ONT", "Air Ontario", "ONTARIO", "Canada",
    "OOT", "Out Of The Blue Air Safaris", "OOTBAS", "South Africa",
    "OPA", "Opal Air", "", "Australia",
    "OPC", "Krystel Air Charter", "OPTIC", "United Kingdom",
    "OPS", "Jet-Ops", "OPS-JET", "United Arab Emirates",
    "OPT", "Flight Options", "OPTIONS", "United States",
    "OPV", "Operadora de Veulos Ejectutivos", "OPERADORA DE VUELOS", "Mexico",
    "ORA", "Long Island Airlines", "LONG ISLAND", "United States",
    "ORB", "Orenburg Airlines", "ORENBURG", "Russia",
    "ORD", "Orange Air Services", "ORANGE SERVICES", "Sierra Leone",
    "ORE", "Orange Aviation", "ORANGE AVIATION", "Israel",
    "ORF", "Oman Royal Flight", "OMAN", "Oman",
    "ORJ", "Orange Air Sierra Leone", "ORANGE SIERRA", "Sierra Leone",
    "ORK", "Orca Air", "ORCA TAXI", "Egypt",
    "ORL", "On Air Limited", "ON AIR", "Canada",
    "ORM", "Orel State Air Enterprise", "ORPRISE", "Russia",
    "ORN", "Orange Air", "ORANGE JET", "United States",
    "ORO", "C N Air", "CAPRI", "Spain",
    "ORP", "Aerocorp", "CORPSA", "Mexico",
    "ORR", "Operadora Turistica Aurora", "TURISTICA AURORA", "Mexico",
    "ORX", "Orbit Express Airlines", "OREX", "Turkey",
    "ORZ", "Zorex", "ZOREX", "Spain",
    "OSA", "Open Sky Aviation", "", "Lebanon",
    "OSH", "Osh Avia", "OSH AVIA", "Kyrgyzstan",
    "OSL", "Sosoliso Airlines", "SOSOLISO", "Nigeria",
    "OSN", "Aerosan", "AEROSAN", "Mexico",
    "OSO", "Aviapartner Limited Company", "", "Russia",
    "OSS", "Servicios Aéreos Noticiosos", "NOTICIOSOS", "Mexico",
    "OST", "Airline Alania", "ALANIA", "Russia",
    "OSU", "Ohio State University", "SCARLET", "United States",
    "OSW", "JetAfrica Eswatini", "BEVO", "Eswatini",
    "OSY", "Open Skies Consultative Commission", "OPEN SKIES", "United States",
    "OTA", "Business Aviators", "OUTLAW", "United States",
    "OTG", "One Two Go Airlines", "THAI EXPRESS", "Thailand",
    "OTL", "South Airlines", "SOUTHLINE", "Ukraine",
    "OTM", "Onetime Airlines Zambia", "ZEDTIME", "Zambia",
    "OTN", "LASTP", "LASTP", "São Tomé and Príncipe",
    "OTP", "Operadora de Transportes Aéreos", "OPERADORA AEREO", "Mexico",
    "OTR", "Orient Airlines", "ORIENTROC", "Sudan",
    "OUF", "Beijing Eofa International Jet", "ELEMENT", "China",
    "OVA", "Aero Nova", "AERONOVA", "Spain",
    "OVC", "Aerovic", "", "Ecuador",
    "OVE", "Aeromover", "AEROMOVER", "Mexico",
    "OVI", "Aerovías Ejecutivas", "VIAS EJECUTIVAS", "Mexico",
    "OVV", "Orient Air", "ORIENTSYR", "Syrian Arab Republic",
    "OWE", "Owenair", "OWENAIR", "South Africa",
    "OWL", "Miami Valley Aviation", "NIGHT OWL", "United States",
    "OWN", "Aero Owen", "AERO OWEN", "Mexico",
    "OXE", "Oxaero", "OXOE", "United Kingdom",
    "OXO", "Million Air", "MILL AIR", "United States",
    "OYE", "Koda International", "KODA AIR", "Nigeria",
    "OZJ", "OzJet", "AUSJET", "Australia",
    "OZU", "Hozu-Avia", "HOZAVIA", "Kazakhstan",
    "OZW", "Virgin Australia Regional Airlines", "VELOCITY", "Australia",
    "PAA", "Pan American World Airways", "CLIPPER", "United States",
    "PAB", "Pacific Air Boats", "AIR BOATS", "Canada",
    "PAC", "Polar Air Cargo", "POLAR", "United States",
    "PAD", "Professional Express Courier Service", "AIR PROFESSIONAL", "United States",
    "PAE", "Paisajes Españoles", "PAISAJES", "Spain",
    "PAG", "Perimeter Aviation", "PERIMETER", "Canada",
    "PAH", "Panorama Air Tour", "LANI", "United States",
    "PAI", "Paradise Airways", "SEA RAY", "United States",
    "PAJ", "Aliparma", "ALIPARMA", "Italy",
    "PAK", "Pacific Alaska Airlines", "PACIFIC ALASKA", "United States",
    "PAL", "Philippine Airlines", "PHILIPPINE", "Philippines",
    "PAM", "Phoenix Air", "PHOENIX", "Germany",
    "PAO", "Polynesian Airlines", "POLYNESIAN", "Samoa",
    "PAP", "Langtry Flying Group", "PROFLIGHT", "United Kingdom",
    "PAQ", "Pacific Air Express", "SOLPAC", "Solomon Islands",
    "PAR", "Pacific Rim Airways", "PACRIM", "Australia",
    "PAS", "Pelita Air Service", "PELITA", "Indonesia",
    "PAT", "Priority Air Transport", "PAT", "United States",
    "PAV", "VIP Avia", "NICOL", "Kazakhstan",
    "PAW", "Pointair Burkina", "POINTAIR BURKINA", "Burkina Faso",
    "PAX", "Pan Air", "PANNEX", "United States",
    "PAZ", "Point Afrique Niger", "POINTAIR NIGER", "Niger",
    "PBA", "PB Air", "PEEBEE AIR", "Thailand",
    "PBB", "Polizeihubschrauberstaffel Brandenburg", "ADEBAR", "Germany",
    "PBN", "Pacific Blue", "BLUEBIRD", "New Zealand",
    "PBR", "Fast Air", "POLAR BEAR", "Canada",
    "PBT", "Air Parabet", "PARABET", "Bangladesh",
    "PBU", "Air Burundi", "AIR-BURUNDI", "Burundi",
    "PBW", "Polizeihubschrauberstaffel Baden-Württemberg", "BUSSARD", "Germany",
    "PBY", "Pearl Air Services", "PEARL SERVICES", "Uganda",
    "PCA", "Penya De L'Aire", "PENA DEL AIRE", "Spain",
    "PCC", "Perforadora Central", "PERFORADORA CENTRAL", "Mexico",
    "PCE", "Pace Airlines", "PACE", "United States",
    "PCG", "Aeropostal Cargo de Mexico", "POSTAL CARGO", "Mexico",
    "PCH", "Pilatus Flugzeugwerke", "PILATUS WINGS", "Switzerland",
    "PCJ", "Pacific Jet", "PACIFIC JET", "United States",
    "PCK", "Air Pack Express", "AIRPACK EXPRESS", "Spain",
    "PCL", "Pinnacle Air Group", "PINNACLE GROUP", "United States",
    "PCM", "Westair Industries", "PAC VALLEY", "United States",
    "PCN", "Princeton Aviation Corporation", "PRINCETON", "United States",
    "PCO", "Pacific Coastal Airlines", "PASCO", "Canada",
    "PCP", "Aerolínea Principal Chile", "PRINCIPAL", "Chile",
    "PCR", "PAC Air", "PACAIR", "United States",
    "PCS", "Air Palace", "AIR PALACE", "Mexico",
    "PCV", "Pacific Aviation (Australia)", "PACAV", "Australia",
    "PCW", "Trans-Pacific Orient Airways", "PACIFIC ORIENT", "Philippines",
    "PCX", "Pacific Aviation (United States)", "", "United States",
    "PDA", "Podilia-Avia", "PODILIA", "Ukraine",
    "PDC", "Potomac Air", "DISTRICT", "United States",
    "PDD", "Phillips Alaska", "PADA", "United States",
    "PDF", "Pelican Air Services", "PELICAN AIRWAYS", "South Africa",
    "PDG", "PLM Dollar Group", "OSPREY", "United Kingdom",
    "PDI", "Paradise Island Airways", "PARADISE ISLAND", "United States",
    "PDQ", "PDQ Air Charter", "DISPATCH", "United States",
    "PDR", "COMAV", "SPEEDSTER", "Namibia",
    "PDT", "Piedmont Airlines", "PIEDMONT", "United States",
    "PDV", "Elicar", "ELICAR", "Italy",
    "PDY", "Pen-Avia", "PENDLEY", "United Kingdom",
    "PEA", "Pan Europeenne Air Service", "", "France",
    "PEB", "Benders Air", "PALEMA", "Sweden",
    "PEC", "Pacific East Asia Cargo Airlines", "PAC-EAST CARGO", "Philippines",
    "PEI", "Panamedia", "PANAMEDIA", "Spain",
    "PEL", "Aeropelican Air Services", "PELICAN", "Australia",
    "PEM", "Pem-Air", "PEM-AIR", "Canada",
    "PEN", "Peninsula Airways", "PENINSULA", "United States",
    "PEO", "Petro Air", "PETRO AIR", "Libya",
    "PER", "Pioneers Limited", "", "Pakistan",
    "PET", "Aerotransporte Petrolero", "AEROPETRO", "Colombia",
    "PEV", "Peoples Vienna Line", "PEOPLES", "Austria",
    "PEX", "Pelican Express", "PELICAN EXPRESS", "United States",
    "PFA", "Pacific Flight Services", "PACIFIC SING", "Singapore",
    "PFI", "Aerolíneas Chihuahua", "PACIFICO CHIHUAHUA", "Mexico",
    "PFN", "Pan African Air Services", "PANAFRICAN", "Sierra Leone",
    "PFR", "Pacificair Airlines", "PACIFIC WEST", "United States",
    "PFS", "Prairie Flying Service", "PRAIRIE", "United States",
    "PFT", "Air Cargo Express International", "PROFREIGHT", "United States",
    "PFY", "Pel-Air Aviation", "PELFLIGHT", "Australia",
    "PFZ", "Proflight Zambia", "PROFLIGHT-ZAMBIA", "Zambia",
    "PGA", "Portugalia", "PORTUGALIA", "Portugal",
    "PGF", "Paragon Global Flight Support", "", "United Kingdom",
    "PGH", "Pulkovo Aircraft Services", "", "Russia",
    "PGI", "Panagra Airways", "PANAGRA", "United States",
    "PGL", "Premiair Aviation Services", "PREMIERE", "United Kingdom",
    "PGP", "Perm Airlines", "PERM AIR", "Russia",
    "PGS", "Tauranga Aer Club", "", "New Zealand",
    "PGT", "Pegasus Airlines", "SUNTURK", "Turkey",
    "PGX", "Paragon Air Express", "PARAGON EXPRESS", "United States",
    "PHA", "Phoenix Air Group", "GRAY BIRD", "United States",
    "PHB", "Phoebus Apollo Aviation", "PHOEBUS", "South Africa",
    "PHC", "Petroleum Helicopters de Colombia", "HELICOPTERS", "Colombia",
    "PHD", "Duncan Aviation", "PANHANDLE", "United States",
    "PHE", "Pawan Hans", "PAWAN HANS", "India",
    "PHG", "Phoenix Aviation", "PHOENIX GROUP", "Kyrgyzstan",
    "PHH", "Polizeihubschrauberstaffel Hessen", "IBIS", "Germany",
    "PHI", "Philips Aviation Services", "PHILAIR", "Netherlands",
    "PHL", "Phillips Michigan City Flying Service", "PHILLIPS", "United States",
    "PHM", "Petroleum Helicopters", "PETROLEUM", "United States",
    "PHN", "Phoenix Air Lines", "PHOENIX BRASIL", "Brazil",
    "PHO", "L&L Flygbildteknik", "PHOTOFLIGHT", "Sweden",
    "PHR", "Al Farana Airline", "PHARAOH", "Egypt",
    "PHS", "Polizeihubschrauberstaffel Sachsen", "PASSAT", "Germany",
    "PHT", "Pan Havacilik Ve Ticaret", "PANANK", "Turkey",
    "PHU", "Pannon Air Service", "PANNON", "Hungary",
    "PHV", "Phenix Aviation", "NEW BIRD", "France",
    "PHY", "Phoenix Avia", "PHOENIX ARMENIA", "Armenia",
    "PIA", "Pakistan International Airlines", "PAKISTAN", "Pakistan",
    "PIC", "Pacific Airlines", "PACIFIC AIRLINES", "Vietnam",
    "PIE", "Air South West", "PIRATE", "United Kingdom",
    "PIF", "Aeroservicios California Pacifico", "AEROCALPA", "Mexico",
    "PIK", "Polizeihubschrauberstaffel Sachsen-Anhalt", "POLICE IKARUS", "Germany",
    "PIL", "Canada Jet Charters", "PINNACLE", "Canada",
    "PIM", "Pinframat", "PINFRAMAT", "Angola",
    "PIN", "Pacific International Airlines", "ROAD RUNNERS", "United States",
    "PIO", "Pioneer Airlines", "PIONEER", "United States",
    "PIP", "Pilot Flight Academy", "PILOT", "Norway",
    "PIR", "Pamir Airways", "PAMIR", "Afghanistan",
    "PIU", "43 Air School", "PRIMA", "South Africa",
    "PIV", "Sokol", "AEROSOKOL", "Russia",
    "PIX", "Metropix UK", "METROPIX", "United Kingdom",
    "PJA", "Private Jet Management", "PRIVATE FLIGHT", "United States",
    "PJE", "Private Jet Expeditions", "PEE JAY", "United States",
    "PJP", "Princely Jets", "PRINCELY JETS", "Pakistan",
    "PJS", "Jet Aviation", "JETAVIATION", "Switzerland",
    "PKA", "AST Pakistan Airways", "PAKISTAN AIRWAY", "Pakistan",
    "PKP", "Mountain Air Express", "PIKES PEAK", "United States",
    "PKR", "Pakker Avio", "PAKKER AVIO", "Estonia",
    "PKW", "Pak West Airlines", "PLATINUM WEST", "United States",
    "PKZ", "Prime Aviation", "PRAVI", "Kazakhstan",
    "PLA", "Polynesian Air-Ways", "POLYAIR", "United States",
    "PLB", "Polynesian Blue", "POLYBLUE", "New Zealand",
    "PLC", "Police Aviation Services", "SPECIAL", "United Kingdom",
    "PLF", "Polish Air Force", "POLISH AIRFORCE", "Poland",
    "PLG", "MBK-S", "PILGRIM", "Russia",
    "PLL", "Air Pal", "AIRPAL", "Spain",
    "PLM", "Air Pullmantur", "PULLMANTUR", "Spain",
    "PLN", "Planar", "PLANAR", "Angola",
    "PLR", "Northwestern Air", "POLARIS", "Canada",
    "PLS", "Aeroflot-Plus", "AEROPLUS", "Russia",
    "PLT", "South Carolina Aeronautics Commission", "PALMETTO", "United States",
    "PLU", "Pilatus PC-12 Center De Mexico", "PILATUS MEXICO", "Mexico",
    "PLX", "Pool Aviation", "POOLEX", "United Kingdom",
    "PLY", "Puma Linhas Aéreas", "PUMA BRASIL", "Brazil",
    "PLZ", "Planet Airways", "PLANET", "United States",
    "PMA", "Pan Malaysian Air Transport", "PAN MALAYSIA", "Malaysia",
    "PMC", "Primas Courier", "PRIMAC", "United States",
    "PME", "Premiair Fliyng Club", "ADUR", "United Kingdom",
    "PMI", "Primero Transportes Aereos", "AEROEPRIM", "Mexico",
    "PMM", "Paradigm Air Operators", "PARADIGM", "United States",
    "PMO", "Polar Airlines de Mexico", "POLAR MEXICO", "Mexico",
    "PMR", "Servicios Aéreos Premier", "SERVICIOS PREMIER", "Mexico",
    "PMS", "Planemaster Services", "PLANEMASTER", "United States",
    "PMT", "PMTair", "MULTITRADE", "Cambodia",
    "PMU", "Premium Aviation", "PREMIUM", "Germany",
    "PMV", "Polizeihubschrauberstaffel Mecklenburg-Vorpommern", "POLICE MERLIN", "Germany",
    "PMW", "Paramount Airways", "PARAWAY", "India",
    "PMX", "Petroleos Mexicanos", "PEMEX", "Mexico",
    "PMY", "Phetchabun Airline", "PHETCHABUN AIR", "Thailand",
    "PNA", "Universal Airlines", "PACIFIC NORTHERN", "United States",
    "PNC", "Pan-Air", "PANAIRSA", "Mexico",
    "PND", "Pond Air Express", "POND AIR", "United States",
    "PNE", "Peninter Aérea", "PENINTER", "Mexico",
    "PNG", "Puerto Rico National Guard", "", "United States",
    "PNH", "Panh", "KUBAN LIK", "Russia",
    "PNK", "Air Pink", "AIRPINK", "Serbia",
    "PNL", "Aero Personal", "AEROPERSONAL", "Mexico",
    "PNM", "Panorama", "PANORAMA", "Spain",
    "PNP", "Pineapple Air", "PINEAPPLE AIR", "Bahamas",
    "PNR", "PAN Air", "SKYJET", "Spain",
    "PNS", "Survey Udara (Penas)", "PENAS", "Indonesia",
    "PNT", "Balmoral Central Contracts", "PORTNET", "South Africa",
    "PNU", "Aero Servicios Platinum", "AERO PLATINUM", "Mexico",
    "PNW", "Palestinian Airlines", "PALESTINIAN", "Egypt",
    "PNX", "AIS Airlines", "SPINNER", "Netherlands",
    "PNY", "Polish Navy", "POLISH NAVY", "Poland",
    "POA", "Portuguese Army", "PORTUGUESE ARMY", "Portugal",
    "POB", "Servicios Aéreos Poblanos", "POBLANOS", "Mexico",
    "POC", "Pocono Air Lines", "POCONO", "United States",
    "POE", "Porter Airlines", "PORTER", "Canada",
    "POF", "Police Aux Frontières", "AIRPOL", "France",
    "POI", "BGB Air", "BOJBAN", "Kazakhstan",
    "POL", "Rikspolisstyrelsen", "", "Sweden",
    "PON", "Portuguese Navy", "PORTUGUESE NAVY", "Portugal",
    "POR", "Porteadora De Cosola", "PORTEADORA", "Mexico",
    "POT", "Polet Airlines", "POLET", "Russia",
    "POV", "Meridian", "AIR POLTAVA", "Ukraine",
    "POW", "Hagondale Limited", "AIRNET", "United Kingdom",
    "POY", "Apoyo Aéreo", "APOYO AEREO", "Mexico",
    "PPA", "Propheter Aviation", "AIR PROP", "United States",
    "PPC", "Palau Asia Pacific Airlines", "PALAU ASIAPAC", "Palau",
    "PPG", "Phoenix Air Transport", "PAPAGO", "United States",
    "PPH", "Polizeihubschrauberstaffel Niedersachsen", "POLICE PHOENIX", "Germany",
    "PPK", "Ramp 66", "PELICAN", "United States",
    "PPM", "Pacific Pearl Airways", "PACIFIC PEARL", "Philippines",
    "PPQ", "Personas Y Pasquetes Por Air", "PERSONSPAQ", "Mexico",
    "PPS", "Butte Aviation", "PIPESTONE", "United States",
    "PPW", "Royal Phnom Penh Airways", "PHNOM-PENH AIR", "Cambodia",
    "PQA", "Pacific Coast Airlines", "SAGE BRUSH", "United States",
    "PRA", "Pars Aviation Service", "PARSAVIA", "Iran",
    "PRC", "Pacific Air Charter", "PACIFIC CHARTER", "United States",
    "PRD", "Presidential Aviation", "PRESIDENTIAL", "United States",
    "PRE", "Precision Airlines", "PRECISION", "United States",
    "PRF", "Precision Air", "PRECISION AIR", "Tanzania",
    "PRG", "Empresa Aero-Servicios Parrague", "ASPAR", "Chile",
    "PRH", "Pro Air", "PROHAWK", "United States",
    "PRI", "Primera Air Scandinavia", "PRIMERA", "Denmark",
    "PRL", "Pearl Air", "PEARL LINE", "Pakistan",
    "PRM", "Prime Airlines", "PRIME AIR", "United States",
    "PRN", "Pirinair Express", "PRINAIR EXPRESS", "Spain",
    "PRO", "Propair", "PROPAIR", "Canada",
    "PRP", "PRT Aviation", "PRONTO", "Spain",
    "PRR", "Paramount Airlines", "PARAMOUNT", "Sierra Leone",
    "PRT", "Atlantic Coast Jet", "PATRIOT", "United States",
    "PRV", "Provincial Express", "PROVINCIAL", "Canada",
    "PRW", "Primera Air Nordic", "JETBIRD", "Latvia",
    "PRX", "VIP Avia", "PAREX", "Latvia",
    "PRY", "Priority Air Charter", "PRIORITY AIR", "United States",
    "PSA", "Pacific Island Aviation", "PACIFIC ISLE", "United States",
    "PSC", "Pascan Aviation", "PASCAN", "Canada",
    "PSD", "President Airlines", "", "Cambodia",
    "PSE", "Aeroservicio Sipse", "SIPSE", "Mexico",
    "PSF", "Plymouth School of Flying", "LIZARD", "United Kingdom",
    "PSG", "Aviones Para Servirle", "SERVIAVIONES", "Mexico",
    "PSH", "Red Aviation", "PASSION", "United Kingdom",
    "PSL", "Aeroservicios Corporativos De San Luis", "CORSAN", "Mexico",
    "PSN", "Potosina Del Aire", "POTOSINA", "Mexico",
    "PSO", "Aerotaxis Pegaso", "AEROPEGASO", "Mexico",
    "PSP", "Publiservicios Aéreos", "PUBLISERVICIOS", "Mexico",
    "PSR", "Polestar Aviation", "POLESTAR", "United Kingdom",
    "PSS", "TSSKB-Progress", "PROGRESS", "Russia",
    "PST", "Parsa", "TURISMO REGIONAL", "Panama",
    "PSV", "Servicios Aéreos Profesionales", "PROSERVICIOS", "Dominican Republic",
    "PSW", "Pskovavia", "PSKOVAVIA", "Russia",
    "PSZ", "Pro Air Service", "POP-AIR", "United States",
    "PTA", "Ptarmigan Airways", "PTARMIGAN", "Canada",
    "PTB", "Passaredo Transportes Aéreos", "PASSAREDO", "Brazil",
    "PTC", "Patria Cargas Aéreas", "PATRIA", "Argentina",
    "PTD", "Aero Servicio Pity", "PITY", "Mexico",
    "PTE", "Aero Copter", "AERO-COP", "Mexico",
    "PTH", "Proteus Helicopteres", "PROTEUS", "France",
    "PTI", "Privatair", "PRIVATAIR", "Switzerland",
    "PTK", "Petropavlovsk-Kamchatsk Air Enterprise", "PETROKAM", "Russia",
    "PTL", "Providence Airline", "PLANTATION", "United States",
    "PTM", "Southeastern Airways", "POSTMAN", "United States",
    "PTN", "Pantanal Linhas Aéreas", "PANTANAL", "Brazil",
    "PTO", "North West Geomatics", "PHOTO", "Canada",
    "PTP", "Palau Trans Pacific Airlines", "TRANS PACIFIC", "Palau",
    "PTQ", "Port Townsend Airways", "TOWNSEND", "United States",
    "PTR", "Nova Scotia Department of Lands and Forests", "PATROL", "Canada",
    "PTS", "Points of Call Airlines", "POINTSCALL", "Canada",
    "PTT", "Promotora Industria Totolapa", "TOTOLAPA", "Mexico",
    "PTV", "Puntavia Air Services", "PUNTAVIA", "Djibouti",
    "PTY", "Petty Transport", "PETTY", "United States",
    "PUA", "PLUNA", "PLUNA", "Uruguay",
    "PUE", "Aeropuelche", "PUELCHE", "Chile",
    "PUR", "Spurwing Airlines", "SPURWING", "South Africa",
    "PUV", "Publivoo", "PUBLIVOO", "Portugal",
    "PVA", "Aerotransportes Privados", "TRANSPRIVADO", "Mexico",
    "PVG", "Privilege Style Líneas Aéreas", "PRIVILEGE", "Spain",
    "PVI", "Panavia", "", "Panama",
    "PVL", "Professione VOlare", "VOLARE", "Italy",
    "PVN", "Peruvian Airlines", "", "Peru",
    "PVO", "Bearing Supplies Limited", "PROVOST", "United Kingdom",
    "PVU", "Peau Vavau", "PEAU", "Tonga",
    "PVV", "Fly Pro", "Sunday", "Moldova",
    "PWA", "Priester Aviation", "PRIESTER", "United States",
    "PWC", "Pratt and Whitney Canada", "PRATT", "Canada",
    "PWD", "CARIBAIR", "CARIBAIR", "Dominican Republic",
    "PWF", "Private Wings Flugcharter", "PRIVATE WINGS", "Germany",
    "PWL", "Powell Air", "POWELL AIR", "Canada",
    "PXA", "Pecotox Air", "PECOTOX", "Moldova",
    "PXG", "Aitheras Aviation Group", "", "United States",
    "PXP", "Pacific Air Transport", "PAK EXPRESS", "United States",
    "PXR", "Pixair Survey", "PIXAIR", "France",
    "PXT", "Pacific Coast Jet", "PACK COAST", "United States",
    "PXX", "Aroostook Aviation", "PINE STATE", "United States",
    "PYC", "Aeropycsa", "AEROPYCSA", "Mexico",
    "PYN", "Haverfordwest Air Charter Services", "POYSTON", "United Kingdom",
    "PYR", "Pyramid Air Lines", "PYAIR", "Egypt",
    "PYZ", "Players Air", "PLAYERS AIR", "United States",
    "PZA", "Aéreo Taxi Paraza", "AEREO PARAZA", "Mexico",
    "PZR", "Sky Trek International Airlines", "PHAZER", "United States",
    "PZY", "Zapolyarye Airline Company", "ZAPOLYARYE", "Russia",
    "QAC", "Qatar Air Cargo", "QATAR CARGO", "Qatar",
    "QAF", "Qatar Amiri Flight", "AMIRI", "Qatar",
    "QAH", "Quick Airways Holland", "QUICK", "Netherlands",
    "QAI", "Conquest Air", "CHICKPEA", "United States",
    "QAJ", "Quick Air Jet Charter", "DAGOBERT", "Germany",
    "QAQ", "Qurinea Air Service", "QURINEA AIR", "Libya",
    "QAS", "Quisqueya Airlines", "QUISQUEYA", "Haiti",
    "QCC", "Qwest Commuter Corporation", "QWEST AIR", "United States",
    "QCL", "Air Class Líneas Aéreas", "ACLA", "Uruguay",
    "QEA", "Aviation Consultancy Office", "", "Australia",
    "QFA", "Qantas", "QANTAS", "Australia",
    "QGA", "Windrose Air", "QUADRIGA", "Germany",
    "QID", "USAF 100th Air Refueling Wing", "QUID", "United States",
    "QJE", "QantasLink", "QJET", "Australia",
    "QKC", "Aero Taxi Aviation", "QUAKER CITY", "United States",
    "QLA", "Aviation Quebec Labrador", "QUEBEC LABRADOR", "Canada",
    "QLK", "QantasLink", "QLINK", "Australia",
    "QNA", "Queen Air", "QUEEN AIR", "Dominican Republic",
    "QNK", "Kabo Air", "KABO", "Nigeria",
    "QNT", "Qanot Sharq", "QANAT SHARQ", "Uzbekistan",
    "QNZ", "Jetconnect", "QANTAS JETCONNECT", "New Zealand",
    "QQE", "Qatar Executive", "", "Qatar",
    "QSC", "African Safari Airways", "ZEBRA", "Kenya",
    "QSM", "Qeshm Air", "QESHM AIR", "Iran",
    "QSR", "SR Jet", "SPARKLE ROLL", "China",
    "QTR", "Qatar Airways", "QATARI", "Qatar",
    "QTX", "Quantex Environmental", "AIR QUANTEX", "Canada",
    "QUE", "Quebec Government Air Service", "QUEBEC", "Canada",
    "QUI", "Aero Quimmco", "QUIMMCO", "Mexico",
    "QVR", "Kvadro Aero", "PEGASO", "Kyrgyzstan",
    "QWA", "Qwestair", "", "Australia",
    "QWL", "Qwila Air", "Q-CHARTER", "South Africa",
    "QXE", "Horizon Air", "HORIZON AIR", "United States",
    "RAA", "Rynes Aviation", "RYNES AVIATION", "United States",
    "RAC", "Icar Air", "TUZLA AIR", "Bosnia and Herzegovina",
    "RAD", "Alada", "AIR ALADA", "Angola",
    "RAE", "Régional", "REGIONAL EUROPE", "France",
    "RAF", "Farnas Aviation Services", "FARNAS", "Sudan",
    "RAG", "Regio Air", "GERMAN LINK", "Germany",
    "RAH", "Regent Air", "REGENT", "Canada",
    "RAI", "Aerotur Air", "DIASA", "Kazakhstan",
    "RAJ", "Raji Airlines", "RAJI", "Pakistan",
    "RAK", "Riga Airclub", "SPORT CLUB", "Latvia",
    "RAL", "Roswell Airlines", "ROSWELL", "United States",
    "RAM", "Royal Air Maroc", "ROYALAIR MAROC", "Morocco",
    "RAN", "Renan", "RENAN", "Moldova",
    "RAP", "Air Center Helicopters", "RAPTOR", "United States",
    "RAQ", "Rath Aviation", "RATH AVIATION", "Austria",
    "RAR", "Air Rarotonga", "AIR RAROTONGA", "Cook Islands",
    "RAS", "Jim Ratliff Air Service", "SHANHIL", "United States",
    "RAU", "Uganda Royal Airways", "UGANDA ROYAL", "Uganda",
    "RAV", "Reed Aviation", "REED AVIATION", "United Kingdom",
    "RAX", "Royal Air Freight", "AIR ROYAL", "United States",
    "RAZ", "Rijnmond Air Services", "RIJNMOND", "Netherlands",
    "RBA", "Royal Brunei Airlines", "BRUNEI", "Brunei",
    "RBB", "Rabbit-Air", "RABBIT", "Switzerland",
    "RBC", "Republicair", "REPUBLICAIR", "Mexico",
    "RBD", "Trans World Express", "RED BIRD", "United States",
    "RBE", "Aur Rum Benin", "RUM BENIN", "Benin",
    "RBG", "Air Arabia Egypt", "ARABIA EGYPT", "Egypt",
    "RBH", "Regal Bahamas International Airways", "CALYPSO", "Bahamas",
    "RBJ", "Aeroserivios Del Bajio", "AEROBAJIO", "Mexico",
    "RBN", "Red Baron Aviation", "RED BARON", "United States",
    "RBR", "Siam Airnet", "SIAM AIRNET", "Thailand",
    "RBT", "Robinton Aero", "ROBIN", "Dominican Republic",
    "RBU", "Airbus France", "AIRBUS FRANCE", "France",
    "RBV", "Air Roberval", "AIR ROBERVAL", "Canada",
    "RBW", "Shandong Airlines Rainbow Jet", "CAI HONG", "China",
    "RBY", "Vision Airlines", "RUBY", "United States",
    "RCA", "Richland Aviation", "RICHLAND", "United States",
    "RCB", "Real Aero Club De Baleares", "BALEARES", "Spain",
    "RCD", "Real Aeroclub De Tenerife", "AEROCLUB", "Spain",
    "RCE", "Aerocer", "AEROCER", "Mexico",
    "RCF", "Aeroflot-Cargo", "AEROFLOT-CARGO", "Russia",
    "RCG", "Royal Air Cargo", "ROYAL CARGO", "South Africa",
    "RCH", "Air Mobility Command", "REACH", "United States",
    "RCI", "Air Cassai", "AIR CASSAI", "Angola",
    "RCJ", "Raytheon Corporate Jets", "NEWPIN", "United Kingdom",
    "RCK", "FaroeJet", "ROCKROSE", "Faroe Islands",
    "RCO", "Aero Renta De Coahuila", "AEROCOAHUILA", "Mexico",
    "RCP", "Aerocorp", "AEROCORPSA", "Mexico",
    "RCQ", "Aerolíneas Regionales", "REGIONAL CARGO", "Mexico",
    "RCT", "Ryan Air Services", "ARCTIC TRANSPORT", "United States",
    "RCU", "Atlantic S.L.", "AIR COURIER", "Spain",
    "RCX", "Air Service Center", "SERVICE CENTER", "Italy",
    "RCY", "Package Express", "RACE CITY", "United States",
    "RDE", "II Lione Alato Arl", "FLIGHT RED", "United Kingdom",
    "RDK", "Irish Air Transport", "IRISH TRANS", "Ireland",
    "RDL", "Roadair Lines", "ROADAIR", "Canada",
    "RDM", "Air Ada", "AIR ADA", "Mauritania",
    "RDP", "Eurojet Romania", "JET-ARROW", "Romania",
    "RDR", "Goodridge (UK) Limited", "RED STAR", "United Kingdom",
    "RDS", "Rhoades Aviation", "RHOADES EXPRESS", "United States",
    "RDV", "Red Sea Aviation", "RED AVIATION", "Egypt",
    "RDW", "Valair AG (Helicoptere)", "ROADWATCH", "Switzerland",
    "RDZ", "Rodze Air", "RODZE AIR", "Nigeria",
    "REA", "Aer Arann", "AER ARANN", "Ireland",
    "REB", "Rebus", "REBUS", "Bulgaria",
    "REC", "Trans Reco", "TRANS-RECO", "Mauritania",
    "RED", "International Committee of the Red Cross", "RED CROSS", "Switzerland",
    "REF", "Reef Air", "REEF AIR", "New Zealand",
    "REG", "Regional Air Services", "REGIONAL SERVICES", "Tanzania",
    "REI", "Ray Aviation", "RAY AVIATION", "Israel",
    "REJ", "SA Airlink Regional", "REGIONAL LINK", "South Africa",
    "REK", "Reem Air", "REEM AIR", "Kyrgyzstan",
    "REL", "Reliance Aviation", "RELIANCE AIR", "United States",
    "REN", "Aero-Rent", "AERORENT", "Mexico",
    "REO", "Rio Airways", "RIO", "United States",
    "RER", "Servicio Aéreo Regional Regair", "REGAIR", "Ecuador",
    "RES", "Australian Maritime Safety Authority", "RESCUE", "Australia",
    "REU", "Air Austral", "REUNION", "France",
    "REV", "RVL Group", "ENDURANCE", "United Kingdom",
    "REW", "Regional Air Express", "REGIONAL WINGS", "Germany",
    "REX", "Ram Air Freight", "RAM EXPRESS", "United States",
    "REY", "Aero-Rey", "AEROREY", "Mexico",
    "REZ", "Cal-West Aviation", "CAL AIR", "United States",
    "RFA", "Raleigh Flying Service", "RALEIGH SERVICE", "United States",
    "RFC", "Aero Africa", "AERO AFRICA", "Eswatini",
    "RFD", "Aerotransportes Rafilher", "RAFHILER", "Mexico",
    "RFF", "Russian Federation Air Force", "RUSSIAN AIRFORCE", "Russia",
    "RFI", "National Air Traffic Services", "SHERLOCK", "United Kingdom",
    "RFL", "Interfly", "INFLY", "Italy",
    "RFR", "Royal Air Force", "RAFAIR", "United Kingdom",
    "RFS", "Rossair", "", "Australia",
    "RFT", "Scoala Superioara De Aviatie Civila", "ROMANIAN ACADEMY", "Romania",
    "RFX", "J P Hunt Air Carriers", "REFLEX", "United States",
    "RGA", "Royal Ghanaian Airlines", "ROYAL GHANA", "Ghana",
    "RGC", "Servicios Aéreos Regiomontanos", "REGIOMONTANO", "Mexico",
    "RGE", "Regent Airways", "REGENT", "Bangladesh",
    "RGL", "Regional Air Lines", "MAROC REGIONAL", "Morocco",
    "RGM", "Rangemile Limited", "RANGEMILE", "United Kingdom",
    "RGN", "Cygnus Air", "CYGNUS AIR", "Spain",
    "RGO", "Argo", "ARGOS", "Dominican Republic",
    "RGP", "River State Government of Nigeria", "GARDEN CITY", "Nigeria",
    "RGR", "Avior Regional", "AVIOR REGIONAL", "Venezuela",
    "RGS", "Renown Aviation", "RENOWN", "United States",
    "RGV", "RG Aviation", "", "Venezuela",
    "RGY", "Regency Airlines", "REGENCY", "United States",
    "RHC", "Redhill Aviation", "REDAIR", "United Kingdom",
    "RHD", "Bond Air Services", "RED HEAD", "United Kingdom",
    "RHL", "Air Archipels", "ARCHIPELS", "France",
    "RIA", "Rich International Airways", "RICHAIR", "United States",
    "RIC", "Richardson's Airway", "RICHARDSON", "United States",
    "RID", "Ridder Avia", "AKRID", "Kazakhstan",
    "RIF", "Aviation Ministry of the Interior of the Russian Federation", "INTERMIN AVIA", "Russian Federation",
    "RIL", "Regional Air", "", "Mauritania",
    "RIM", "Rimrock Airlines", "RIMROCK", "United States",
    "RIO", "Rio Linhas Aéreas", "RIO", "Brazil",
    "RIS", "Aeris Gestión", "AERIS", "Spain",
    "RIT", "Asian Spirit", "ASIAN SPIRIT", "Philippines",
    "RIU", "Riau Airlines", "RIAU AIR", "Indonesia",
    "RIV", "APG Airlines", "RIVERA", "France",
    "RIX", "Rectrix Aviation", "RECTRIX", "United States",
    "RJA", "Royal Jordanian", "JORDANIAN", "Jordan",
    "RJM", "Millen Corporation", "MILLEN", "United Kingdom",
    "RJS", "Aeroservicios Jet", "ASERJET", "Mexico",
    "RJT", "RA Jet Aeroservicios", "RA JET", "Mexico",
    "RJZ", "Royal Jordanian Air Force", "JORDAN AIR FORCE", "Jordan",
    "RKA", "Air Afrique", "AIRAFRIC", "Ivory Coast",
    "RKC", "DAS Airlines", "DAS CONGO", "Democratic Republic of the Congo",
    "RKH", "Royal Khmer Airlines", "KHMER AIR", "Cambodia",
    "RKM", "RAK Airways", "RAKAIR", "United Arab Emirates",
    "RKT", "Rotormotion", "ROCKET", "United Kingdom",
    "RKW", "Rockwell Collins Avionics", "ROCKWELL", "United States",
    "RLA", "Airlinair", "AIRLINAIR", "France",
    "RLE", "Rico Linhas Aéreas", "RICO", "Brazil",
    "RLH", "Ruili Airlines", "SENDI", "China",
    "RLI", "Reliant Air", "RELIANT", "United States",
    "RLL", "Air Leone", "AEROLEONE", "Sierra Leone",
    "RLM", "Royal American Airways", "ROYAL AMERICAN", "United States",
    "RLN", "Aero Lanka", "AERO LANKA", "Sri Lanka",
    "RLR", "Business Airfreight", "RATTLER", "United States",
    "RLS", "S-Air", "S-AIRLINES", "Russia",
    "RLU", "Rusline", "RUSLINE AIR", "Russia",
    "RLV", "Real Aviation", "REAL", "Ghana",
    "RLX", "Go2Sky", "RELAX", "Slovakia",
    "RLZ", "Air Alize", "ALIZE", "France",
    "RMA", "Rocky Mountain Airways", "ROCKY MOUNTAIN", "United States",
    "RMD", "Air Amder", "AIR AMDER", "Mauritania",
    "RMF", "Royal Malaysian Air Force", "ANGKASA", "Malaysia",
    "RMG", "Rumugu Air & Space Nigeria", "RUMUGU AIR", "Nigeria",
    "RMI", "Point Airlines", "POINT AIRLINE", "Nigeria",
    "RML", "Air Mediterranean", "HELLASMED", "Greece",
    "RMO", "Arm-Aero", "ARM-AERO", "Armenia",
    "RMP", "Servicios De Rampa Y Mostrador", "SERAMSA", "Mexico",
    "RMS", "Tas Aviation", "TASS AIR", "United States",
    "RMT", "Ram Aircraft Corporation", "RAM FLIGHT", "United States",
    "RMU", "C.S.P.  Societe", "AIR-MAUR", "Mauritania",
    "RMV", "Romavia", "AEROMAVIA", "Romania",
    "RMX", "Air Max", "AEROMAX", "Bulgaria",
    "RMY", "Raya Airways", "TRANSMILE", "Malaysia",
    "RNA", "Nepal Airlines", "ROYAL NEPAL", "Nepal",
    "RNB", "Rosneft-Baltika", "ROSBALT", "Russia",
    "RND", "Rutland Aviation", "RUTLAND", "United Kingdom",
    "RNE", "Air Salone", "AIR SALONE", "Sierra Leone",
    "RNG", "Orange Aircraft Leasing", "ORANGE", "Netherlands",
    "RNM", "Aeronem Air Cargo", "AEROMNEM", "Ecuador",
    "RNR", "Air Cargo Masters", "RUNNER", "United States",
    "RNS", "Ronso", "RONSO", "Mexico",
    "ROC", "Rocky Mountain Airlines", "", "Canada",
    "ROD", "Aerodan", "AERODAN", "Mexico",
    "ROE", "Aeroeste", "ESTE-BOLIVIA", "Bolivia",
    "ROF", "Romanian Air Force", "ROMAF", "Romania",
    "ROG", "FundaciÃ³ Rego", "REGO", "Spain",
    "ROH", "Aero Gen", "AEROGEN", "Mexico",
    "ROI", "Avior Airlines", "AVIOR", "Venezuela",
    "ROJ", "Royal Jet", "ROYALJET", "United Arab Emirates",
    "RON", "Our Airline", "OUR AIRLINE", "Nauru",
    "ROO", "Aero Roa", "AERO ROA", "Mexico",
    "ROP", "Royal Oman Police", "", "Oman",
    "ROR", "Roraima Airways", "RORAIMA", "Guyana",
    "ROS", "Rossair Europe", "CATCHER", "Netherlands",
    "ROT", "Tarom", "TAROM", "Romania",
    "ROU", "Air Canada Rouge", "ROUGE", "Canada",
    "ROV", "Rover Airways International", "ROVERAIR", "United States",
    "ROW", "Nor Aviation", "ROTORWING", "Norway",
    "ROX", "Roblex Aviation", "ROBLEX", "United States",
    "ROY", "Conifair Aviation", "", "Canada",
    "RPA", "Republic Airways", "BRICKYARD", "United States",
    "RPB", "AeroRepública", "AEROREPUBLICA", "Colombia",
    "RPC", "Aerolíneas Del Pacífico", "AEROPACSA", "Ecuador",
    "RPH", "Republic Express Airlines", "PUBLIC EXPRESS", "Indonesia",
    "RPK", "Royal Airlines", "ROYAL PAKISTAN", "Pakistan",
    "RPS", "Global Air Charter", "RESPONSE", "United States",
    "RPX", "HD Air Ltd", "RAPEX", "United Kingdom",
    "RRA", "Royal Rwanda Airlines", "ROYAL RWANDA", "Rwanda",
    "RRB", "Aero Club de Castellon", "", "Spain",
    "RRC", "Aero Roca", "AEROROCA", "Mexico",
    "RRE", "Aerotransportes Internacionales De Torreon", "AERO TORREON", "Mexico",
    "RRF", "Royal Air Force", "KITTY", "United Kingdom",
    "RRL", "Rolls-Royce Limited", "MERLIN", "United Kingdom",
    "RRO", "Aerocredo", "", "Russia",
    "RRR", "Royal Air Force", "ASCOT", "United Kingdom",
    "RRS", "Boscombe Down DERA (Formation)", "BLACKBOX", "United Kingdom",
    "RRT", "Transportes Aéreos Sierra", "SIERRA ALTA", "Mexico",
    "RRV", "Mombasa Air Safari", "SKYROVER", "Kenya",
    "RRY", "Tbilisi Aviation University", "AIRFERRY", "Georgia",
    "RRZ", "Rollright Aviation", "ROLLRIGHT", "United Kingdom",
    "RSA", "Elisra Airlines", "ESRA", "Sudan",
    "RSB", "Rubystar", "RUBYSTAR", "Belarus",
    "RSC", "Aerolíneas Ejecutivas Tarascas", "TARASCAS", "Mexico",
    "RSE", "SNAS Aviation", "RED SEA", "Saudi Arabia",
    "RSF", "Royal Saudi Air Force", "ARSAF", "Saudi Arabia",
    "RSH", "Air Sahara", "SAHARA", "India",
    "RSI", "Air Sunshine", "AIR SUNSHINE", "United States",
    "RSK", "DSWA", "REDSKIN", "United States",
    "RSL", "Panama Aircraft Rental and Sales", "PANAMA RENTAL", "Panama",
    "RSM", "Air Somalia", "AIR SOMALIA", "Somali Republic",
    "RSN", "Royal Swazi National Airways", "SWAZI NATIONAL", "Eswatini",
    "RSP", "JetSuite", "REDSTRIPE", "United States",
    "RSQ", "International SOS Windhoek", "SKYMEDIC", "Namibia",
    "RSR", "Aero-Service", "CONGOSERV", "Republic of the Congo",
    "RSS", "Rossair", "ROSS CHARTER", "South Africa",
    "RST", "Resort Air", "RESORT AIR", "United States",
    "RSU", "AeroSur", "AEROSUR", "Bolivia",
    "RSV", "Red Sky Ventures", "RED SKY", "Namibia",
    "RTH", "Artis", "ARTHELICO", "France",
    "RTM", "Trans Am Compania", "AERO TRANSAM", "Ecuador",
    "RTN", "Raytheon Aircraft Company", "RAYTHEON", "United States",
    "RTO", "Rectimo Air Transports", "RACCOON", "France",
    "RTQ", "Air Turquoise", "TURQUOISE", "France",
    "RTR", "Rotatur", "ROTATUR", "Brazil",
    "RTS", "Relief Transport Services", "RELIEF", "United Kingdom",
    "RTU", "Aerotucan", "AEROTUCAN", "Mexico",
    "RTV", "Nortavia", "TIC-TAC", "Portugal",
    "RUA", "Rwanda Airlines", "", "Rwanda",
    "RUC", "Rutas Aéreas", "RUTACA", "Venezuela",
    "RUD", "Air Anastasia", "ANASTASIA", "Ukraine",
    "RUH", "Rusich-T", "", "Russia",
    "RUK", "Ryanair UK", "BLUEMAX", "United Kingdom",
    "RUM", "Air Rum", "AIR RUM", "Sierra Leone",
    "RUN", "Air ACT", "CARGO TURK", "Turkey",
    "RUR", "Rusaero", "", "Russia",
    "RUT", "Reut Airways", "YADID", "Israel",
    "RUZ", "Rusuertol", "ROSTUERTOL", "Russia",
    "RVC", "Richards Aviation", "RIVER CITY", "United States",
    "RVE", "Airventure", "AIRVENTURE", "Belgium",
    "RVF", "Ravn Alaska", "RAVEN FLIGHT", "United States",
    "RVI", "Aero Servicios", "AERO SERVICIOS", "Mexico",
    "RVL", "Airvallee", "AIR VALLEE", "Italy",
    "RVM", "River Ministries Air Charter", "RIVER", "South Africa",
    "RVN", "Raven Air", "RAVEN U-S", "United States",
    "RVP", "Air VIP", "AEROVIP", "Portugal",
    "RVQ", "Aero Jet International", "REVA AIR", "United States",
    "RVR", "Raven Air", "RAVEN", "United Kingdom",
    "RVT", "Aircompany Veteran", "AIR-VET", "Armenia",
    "RWA", "Rwanda Airways", "", "Rwanda",
    "RWB", "Alliance Express Rwanda", "", "Rwanda",
    "RWC", "Arrow Ecuador Arrowec", "ARROWEC", "Ecuador",
    "RWD", "Rwandair Express", "RWANDAIR", "Rwanda",
    "RWE", "Royal West Airlines", "ROYAL WEST", "United States",
    "RWG", "C&M Airways", "RED WING", "United States",
    "RWL", "RWL Luftfahrtgesellschaft", "RHEINTRAINER", "Germany",
    "RWS", "Air Whitsunday", "", "Australia",
    "RXA", "Regional Express", "REX", "Australia",
    "RXP", "Royal Aviation Express", "ROY EXPRESS", "Canada",
    "RXT", "Aeroxtra", "AERO-EXTRA", "Mexico",
    "RYA", "Ryan Air Services", "RYAN AIR", "United States",
    "RYB", "Royal Bahrain Airlines", "ROYAL BAHRAIN", "Bahrain",
    "RYL", "Royal Aruban Airlines", "ROYAL ARUBAN", "Aruba",
    "RYN", "Ryan International Airlines", "RYAN INTERNATIONAL", "United States",
    "RYR", "Ryanair", "RYANAIR", "Ireland",
    "RYS", "Buzz (Ryanair)", "MAGIC SUN", "Poland",
    "RYT", "Raya Jet", "", "Jordan",
    "RYZ", "Ryazan State Air Enterprise", "RYAZAN AIR", "Russia",
    "RZ", "Superna Airlines", "YANGTZE RIVER", "China",
    "RZA", "Jet Fighter Flights", "RAZOR", "Australia",
    "RZL", "Aero Zambia", "AERO ZAMBIA", "Zambia",
    "RZN", "Aero Zano", "ZANO", "Mexico",
    "RZO", "SATA International", "AIR AZORES", "Portugal",
    "RZR", "Zephyr Express", "RECOVERY", "United States",
    "RZU", "Zhersu Avia", "ZHERSU AVIA", "Kazakhstan",
    "RZZ", "Anoka Air Charter", "RED ZONE", "United States",
    "SAA", "South African Airways", "SPRINGBOK", "South Africa",
    "SAB", "Sky Way Air", "SKY WORKER", "Kyrgyzstan",
    "SAC", "SASCO Airlines", "SASCO", "Sudan",
    "SAF", "Singapore Air Force", "SINGA", "Singapore",
    "SAG", "SOS Flygambulans", "MEDICAL AIR", "Sweden",
    "SAH", "Sayakhat Airlines", "SAYAKHAT", "Kazakhstan",
    "SAI", "Shaheen Air", "SHAHEEN AIR", "Pakistan",
    "SAM", "SAM Colombia", "SAM", "Colombia",
    "SAO", "Sahel Aviation Service", "SAVSER", "Mali",
    "SAP", "Avia Jaynar", "TOBOL", "Kazakhstan",
    "SAQ", "Springbank Aviation", "SPRINGBANK", "Canada",
    "SAS", "Scandinavian Airlines", "SCANDINAVIAN", "Sweden  Denmark and Norway",
    "SAT", "SATA Air Acores", "SATA", "Portugal",
    "SAU", "United Aviation Services", "UNISERVE", "Spain",
    "SAV", "Samal Air", "", "Kazakhstan",
    "SAW", "Sham Wing Airlines", "SHAMWING", "Syrian Arab Republic",
    "SAX", "Sabah Air", "SABAH AIR", "Malaysia",
    "SAY", "ScotAirways", "SUCKLING", "United Kingdom",
    "SAZ", "Swiss Air-Ambulance", "SWISS AMBULANCE", "Switzerland",
    "SBA", "SOL Linhas Aéreas", "SOL", "Brazil",
    "SBB", "Steinman Aviation", "SABER EXPRESS", "United States",
    "SBC", "Emoyeni Air Charter", "SABIAN AIR", "South Africa",
    "SBD", "SIBIA Aircompany Ltd", "SIBIA", "Russia",
    "SBF", "Seven Bar Flying Service", "SEVENAIR", "Tunisia",
    "SBG", "Sabre Incorporated", "", "United States",
    "SBH", "Aerosaab", "AEROSAAB", "Mexico",
    "SBI", "S7 Airlines", "SIBERIAN AIRLINES", "Russia",
    "SBJ", "Trans Sahara Air", "TRANS SAHARA", "Nigeria",
    "SBL", "Sobel Airlines of Ghana", "SOBGHANA", "Ghana",
    "SBM", "SkyBahamas", "SKY BAHAMAS", "Bahamas",
    "SBO", "Stabo Air", "STABAIR", "Zambia",
    "SBQ", "SmithKline Beecham Clinical Labs", "SKIBBLE", "United States",
    "SBR", "Saber Aviation", "FREIGHTER", "United States",
    "SBS", "Seaborne Airlines", "SEABORNE", "United States",
    "SBT", "Taftan Airlines", "TAFTAN", "Iran",
    "SBU", "St Barth Commuter", "BLACK FIN", "France",
    "SBW", "Snowbird Airlines", "SNOWMAN", "Finland",
    "SBX", "North Star Air Cargo", "SKY BOX", "United States",
    "SBZ", "Scibe Airlift", "SCIBE AIRLIFT", "Democratic Republic of the Congo",
    "SCA", "South Central Air", "SOUTH CENTRAL", "United States",
    "SCB", "Saigon Capital Aircraft Management", "SAIGON", "Netherlands",
    "SCC", "Seacoast Airlines", "SEA-COASTER", "United States",
    "SCD", "Associated Aviation", "ASSOCIATED", "Nigeria",
    "SCE", "Scenic Airlines", "SCENIC", "United States",
    "SCF", "Socofer", "SOCOFER", "Angola",
    "SCH", "Seychelles Airlines", "OCEAN BIRD", "Seychelles",
    "SCI", "Servicios Aéreos San Cristóbal", "SAN CRISTOBAL", "Mexico",
    "SCJ", "Siamjet Aviation", "SIAMJET", "Thailand",
    "SCK", "Sky Cam", "SKYCAM", "France",
    "SCL", "Switfair Cargo", "SWIFTAIR", "Canada",
    "SCM", "American Jet International", "SCREAMER", "United States",
    "SCN", "South American Airlines", "SOUTH AMERICAN", "Peru",
    "SCO", "Helikopterservice Euro Air", "SWEDCOPTER", "Sweden",
    "SCP", "Scorpio Aviation", "SCORPIO", "Egypt",
    "SCQ", "OSM Aviation Academy", "SCAVAC", "Norway  Sweden and San Diego",
    "SCR", "Silver Cloud Air", "SILVER CLOUD", "Germany",
    "SCS", "South African Non Scheduled Airways", "SOUTHERN CHARTERS", "South Africa",
    "SCT", "SAAB-Aircraft", "SAAB-CRAFT", "Sweden",
    "SCU", "Air Scorpio", "SCORPIO UNIVERS", "Bulgaria",
    "SCV", "Servicios Aéreos Del Centro", "SACSA", "Mexico",
    "SCW", "Malmö Aviation", "SCANWING", "Sweden",
    "SCX", "Sun Country Airlines", "SUN COUNTRY", "United States",
    "SDA", "St. Andrews Airways", "SAINT ANDREWS", "Canada",
    "SDB", "Sukhoi Design Bureau Company", "SU-CRAFT", "Russia",
    "SDC", "Sunrise Airlines", "SUNDANCE", "United States",
    "SDD", "Skymaster Air Taxi", "SKY DANCE", "United States",
    "SDE", "Air Partners Corp.", "STAMPEDE", "Canada",
    "SDF", "Sundorph Aeronautical Corporation", "SUNDORPH", "United States",
    "SDG", "Star Air (India)", "HISTAR", "India",
    "SDH", "Servicio De Helicopteros", "ARCOS", "Spain",
    "SDJ", "Club 328", "SPACEJET", "United Kingdom",
    "SDK", "SADELCA - Sociedad Aérea Del Caquetá", "SADELCA", "Colombia",
    "SDL", "Skydrift", "SKYDRIFT", "United Kingdom",
    "SDM", "Rossiya", "RUSSIA", "Russia",
    "SDN", "Spirit of Africa Airlines", "BLUE NILE", "Sudan",
    "SDO", "Air Santo Domingo", "AERO DOMINGO", "Dominican Republic",
    "SDP", "Aero Sudpacifico", "SUDPACIFICO", "Mexico",
    "SDR", "City Airline", "SWEDESTAR", "Sweden",
    "SDS", "United Kingdom Civil Aviation Authority", "STANDARDS", "United Kingdom",
    "SDU", "Sud Airlines", "SUD LINES", "France",
    "SDV", "Servicios Aéreos Del Vaupes", "SELVA", "Colombia",
    "SDX", "Servicio Tecnico Aero De Mexico", "SERVICIO TECNICO", "Mexico",
    "SDY", "Island Express", "SANDY ISLE", "United States",
    "SDZ", "Sudan Pezetel for Aviation", "SUDANA", "Sudan",
    "SEA", "Southeast Air", "SOUTHEAST AIR", "United States",
    "SEB", "Servicios Aéreos Luce", "SERVILUCE", "Mexico",
    "SEC", "3D Aviation", "SECUREX", "United States",
    "SED", "Sedona Air Center", "SEDONA AIR", "United States",
    "SEE", "Shaheen Air Cargo", "SHAHEEN CARGO", "Pakistan",
    "SEF", "Aero Servicios Ejecutivas Del Pacifico", "SERVIPACIFICO", "Mexico",
    "SEG", "Eagle International", "SEN-EAGLE", "Senegal",
    "SEH", "Sky Express", "AIR CRETE", "Greece",
    "SEI", "Transportes Aéreos Sierra Madre", "TRANSPORTE SIERRA", "Mexico",
    "SEJ", "Spicejet", "SPICEJET", "India",
    "SEK", "Star East Airline", "EAST RIDER", "Romania",
    "SEL", "Sentel Corporation", "SENTEL", "United States",
    "SEM", "Cape Central Airways", "SEMO", "United States",
    "SEN", "Servicios de Aviacion Sierra", "SERVISIERRA", "Mexico",
    "TUX", "Tunisair Express", "TUNEXPRESS", "Tunisia",
    "SEO", "Selcon Airlines", "SELCON AIR", "Nigeria",
    "SEQ", "Sky Eyes", "SKY EYES", "Thailand",
    "SER", "Aero California", "AEROCALIFORNIA", "Mexico",
    "SES", "Servicio Aéreo Saltillo", "SERVISAL", "Mexico",
    "SET", "SAETA", "SAETA", "Ecuador",
    "SEU", "XL Airways France", "STARWAY", "France",
    "SEV", "Serair Transworld Press", "CARGOPRESS", "Spain",
    "SEY", "Air Seychelles", "SEYCHELLES", "Seychelles",
    "SFC", "Shuswap Flight Centre", "SHUSWAP", "Canada",
    "SFE", "Sefofane Air Charters", "SEFOFANE", "Botswana",
    "SFF", "Safewings Aviation Company", "SWIFTWING", "United States",
    "SFG", "Sun Freight Logistics", "AERO GULF", "Thailand",
    "SFJ", "Star Flyer", "STARFLYER", "Japan",
    "SFL", "Southflight Aviation", "SOUTHFLIGHT", "New Zealand",
    "SFM", "A-Safar Air Services", "AIR SAFAR", "Nigeria",
    "SFN", "Safiran Airlines", "SAFIRAN", "Iran",
    "SFP", "Safe Air", "SAFE AIR", "Pakistan",
    "SFR", "Safair", "CARGO", "South Africa",
    "SFS", "Southern Frontier Air Transport", "SOUTHERN FRONTIER", "Canada",
    "SFT", "Skyfreight", "SKYFREIGHT", "United States",
    "SFU", "Solent Flight", "SAINTS", "United Kingdom",
    "SFX", "S.K. Logistics", "SWAMP FOX", "United States",
    "SFY", "Gulf Flite Center", "SKY FLITE", "United States",
    "SGA", "Air Saigon", "AIR SAIGON", "Vietnam",
    "SGB", "Sky King  Inc.", "SONGBIRD", "United States",
    "SGC", "Southern Right Air Charter", "SOUTHERNRIGHT", "South Africa",
    "SGD", "Sky Gate International Aviation", "AIR BISHKEK", "Kyrgyzstan",
    "SGF", "STAC Swiss Government Flights", "STAC", "Switzerland",
    "SGH", "Servisair", "SERVISAIR", "United Kingdom",
    "SGI", "Servicios Aéreos Agrícolas", "SERAGRI", "Chile",
    "SGK", "Skyward Aviation", "SKYWARD", "Canada",
    "SGM", "Sky Aircraft Service", "SIGMA", "Netherlands",
    "SGN", "Siam GA", "SIAM", "Thailand",
    "SGP", "Sagolair Transportes Ejecutivos", "SAGOLAIR", "Spain",
    "SGS", "Saskatchewan Government Executive Air Service", "SASKATCHEWAN", "Canada",
    "SGT", "Skygate", "SKYGATE", "Netherlands",
    "SGU", "Sol del Paraguay", "SOLPARAGUAYO", "Paraguay",
    "SGV", "Aerosegovia", "SEGOVIA", "Nicaragua",
    "SGX", "Saga Airlines", "", "Turkey",
    "SGY", "Skagway Air Service", "SKAGWAY AIR", "United States",
    "SHA", "Shree Airlines", "SHREEAIR", "Nepal",
    "SHB", "Shabair", "SHABAIR", "Democratic Republic of the Congo",
    "SHC", "Sky Harbor Air Service", "SKY HARBOR CHEYENNE", "United States",
    "SHD", "Sahara Airlines", "", "Algeria",
    "SHE", "Shell Aircraft", "SHELL", "United Kingdom",
    "SHF", "Royal Air Force", "VORTEX", "United Kingdom",
    "SHG", "Shoprite Group", "SHOP AIR", "United Kingdom",
    "SHJ", "Sharjah Ruler's Flight", "SHARJAH", "United Arab Emirates",
    "SHK", "Shorouk Air", "", "Egypt",
    "SHL", "Samson Aviation", "SAMSON", "United Kingdom",
    "SHM", "Sheltam Aviation", "SHELTAM", "South Africa",
    "SHN", "Shaheen Airport Services", "SUGAR ALFA", "Pakistan",
    "SHO", "Sheremetyevo-Cargo", "", "Russia",
    "SHP", "Service Aerien Francais", "SAF", "France",
    "SHQ", "Shanghai Airlines Cargo", "SHANGHAI CARGO", "China",
    "SHR", "Shooter Air Courier", "SHOOTER", "Canada",
    "SHS", "Shura Air Transport Services", "SHURA AIR", "Ethiopia",
    "SHT", "British Airways Shuttle", "SHUTTLE", "United Kingdom",
    "SHU", "Sakhalinskie Aviatrassy (SAT)", "SATAIR", "Russia",
    "SHV", "Shavano Air", "SHAVANO", "United States",
    "SHW", "Shawnee Airline", "SHAWNEE", "United States",
    "SHX", "Slim Aviation Services", "SLIM AIR", "Nigeria",
    "SHY", "Sky Airlines", "ANTALYA BIRD", "Turkey",
    "SIA", "Singapore Airlines", "SINGAPORE", "Singapore",
    "SIB", "Sibaviatrans", "SIBAVIA", "Russia",
    "SIC", "SFS Aviation", "SICHART", "Thailand",
    "SIE", "Sierra Express", "SEREX", "United States",
    "SIH", "Skynet Airlines", "BLUEJET", "Ireland",
    "SII", "Aero Servicios Ejecutivos Internacionales", "ASEISA", "Mexico",
    "SIJ", "Seco International", "", "Japan",
    "SIL", "Silver Airways", "SILVER WINGS", "United States",
    "SIM", "Star Air", "", "Sierra Leone",
    "SIO", "Sirio (airline)", "SIRIO", "Italy",
    "SIP", "Air Spirit", "AIR SPIRIT", "United States",
    "SIQ", "National Center for Atmospheric Research", "SCIENCE QUEST", "United States",
    "SIR", "Salair", "SALAIR", "United States",
    "SIS", "Saber Airlines", "", "Egypt",
    "SIT", "SITA", "", "Belgium",
    "SIV", "Slovenian Armed Forces", "SLOVENIAN", "Slovenia",
    "SIW", "Sirio Executive", "SIRIO EXECUTIVE", "Italy",
    "SIX", "Sixt Rent A Car", "DRIVE ORANGE", "United States",
    "SIY", "Aerosiyusa", "SIYUSA", "Mexico",
    "SIZ", "Aero Silza", "AEROSILZA", "Mexico",
    "SJA", "Servicios Aéreos Especiales De Jalisco", "SERVICIOJAL", "Mexico",
    "SJB", "SKS Airways", "SOUTHER TIGER", "Malaysia",
    "SJC", "Servicios Ejecutivos Continental", "SERVIEJECUTIVO", "Mexico",
    "SJE", "Sunair 2001", "SUNBIZ", "South Africa",
    "SJJ", "Spirit Aviation", "SPIRIT JET", "United States",
    "SJL", "Servicios Especiales Del Pacifico Jalisco", "SERVICIOS JALISCO", "Mexico",
    "SJM", "Sino Jet Management", "SINO SKY", "China",
    "SJN", "Air San Juan", "SAN JUAN", "United States",
    "SJO", "Spring Airlines Japan", "JEY SPRING", "Japan",
    "SJT", "Swiss Jet", "SWISS JET", "Switzerland",
    "SJX", "Starlux Airlines", "STARWALKER", "Taiwan",
    "SJY", "Sriwijaya Air", "SRIWIJAYA", "Indonesia",
    "SKA", "Rio Air Express", "RIO EXPRESS", "Brazil",
    "SKC", "Skymaster Airlines", "SKYMASTER AIR", "Brazil",
    "SKD", "Sky Harbor Air Service", "SKY DAWG", "United States",
    "SKE", "Sky Tours", "SKYISLE", "United States",
    "SKF", "Skycraft", "SKYCRAFT", "United States",
    "SKG", "Skycraft Air Transport", "SKYCRAFT-CANADA", "Canada",
    "SKH", "British Sky Broadcasting", "SKYNEWS", "United Kingdom",
    "SKI", "SkyKing Turks and Caicos Airways", "SKYKING", "Turks and Caicos Islands",
    "SKK", "Skylink Aviation", "SKYLINK", "Canada",
    "SKL", "Skycharter (Malton)", "SKYCHARTER", "Canada",
    "SKM", "Fayetteville Flying Service and Scheduled Skyways System", "SKYTEM", "United States",
    "SKN", "Skyline Aviation Services", "SKYLINER", "United States",
    "SKO", "Scottish Airways Flyers", "SKYWORK", "United Kingdom",
    "SKQ", "Labcorp", "SKYLAB", "United States",
    "SKR", "Skyscapes Air Charters", "SKYSCAPES", "South Africa",
    "SKS", "Sky Link Aviation", "", "Pakistan",
    "SKT", "SkyStar Airways", "SKY YOU", "Thailand",
    "SKU", "Sky Airline", "AEROSKY", "Chile",
    "SKV", "Sky Regional Airlines", "MAPLE", "Canada",
    "SKW", "SkyWest Airlines", "SKYWEST", "United States",
    "SKY", "Skymark Airlines", "SKYMARK", "Japan",
    "SKZ", "Skyway Enterprises", "SKYWAY-INC", "United States",
    "SLA", "Sierra National Airlines", "SELAIR", "Sierra Leone",
    "SLB", "Slok Air", "SLOK AIR", "Nigeria",
    "SLD", "Silver Air", "SILVERLINE", "Czech Republic",
    "SLE", "Streamline", "SLIPSTREAM", "South Africa",
    "SLF", "Starfly", "ELISTARFLY", "Italy",
    "SLG", "Saskatchewan Government", "LIFEGUARD", "Canada",
    "SLH", "Silverhawk Aviation", "SILVERHAWK", "United States",
    "SLI", "Aeroméxico Connect", "COSTERA", "Mexico",
    "SLK", "SilkAir", "SILKAIR", "Singapore",
    "SLL", "Slovak Airlines", "SLOV LINE", "Slovakia",
    "SLM", "Surinam Airways", "SURINAM", "Suriname",
    "SLN", "Sloane Aviation", "SLOANE", "United Kingdom",
    "SLO", "Edgartown Air", "SLOW", "United States",
    "SLP", "Salpa Aviation", "SALPA", "Sudan",
    "SLS", "Servicios Aéreos Slainte", "SERVICIOS SLAINTE", "Mexico",
    "SLU", "Avio Sluzba", "AVIO SLUZBA", "Serbia",
    "SLV", "Stella Aviation", "AVISTELLA", "Mauritania",
    "SLW", "Salama Airlines Nigeria", "SALMA AIR", "Nigeria",
    "SLX", "Sete Linhas Aéreas", "SETE", "Brazil",
    "SLY", "Sky Line for Air Services", "SKYCO", "Sudan",
    "SLZ", "Super Luza", "LUZA", "Angola",
    "SMA", "SMA Airlines", "SESAME", "Nigeria",
    "SMC", "Sabang Merauke Raya Air Charter", "SAMER", "Indonesia",
    "SMD", "Servicios Aéreos La Marquesa", "SERVICIOS MARQUESA", "Mexico",
    "SME", "Semos", "SEMICH", "Kazakhstan",
    "SMF", "Smalandsflyg", "GORDON", "Sweden",
    "SMG", "RAF St Mawgan Search and Rescue", "", "United Kingdom",
    "SMH", "Smithair", "SMITHAIR", "United States",
    "SMI", "Aero Sami", "SAMI", "Mexico",
    "SMJ", "Avient Aviation", "AVAVIA", "Zimbabwe",
    "SMK", "Semeyavia", "ERTIS", "Kazakhstan",
    "SML", "Smith Air (1976)", "SMITH AIR", "Canada",
    "SMM", "Summit Air", "SUMMIT", "Canada",
    "SMQ", "Samar Air", "SAMAR AIR", "Tajikistan",
    "SMR", "Somon Air", "SOMON AIR", "Tajikistan",
    "SMS", "Linhas Aéreas Santomenses", "SANTOMENSES", "São Tomé and Príncipe",
    "SMT", "Skyline", "SKYLIMIT", "Nigeria",
    "SMU", "Sanborn Map Company", "SPRINGER", "United States",
    "SMW", "Carpatair Flight Service", "SMART WINGS", "Romania",
    "SMX", "Alitalia Express", "ALIEXPRESS", "Italy",
    "SMY", "Sama Airlines", "NAJIM", "Saudi Arabia",
    "SMZ", "RAF Scampton", "SCAMPTON", "United Kingdom",
    "SNA", "Senator Aviation Charter", "SENATOR", "Germany",
    "SNB", "Sterling Airlines", "STERLING", "Denmark",
    "SNC", "Air Cargo Carriers", "NIGHT CARGO", "United States",
    "SND", "Air Samarkand", "ARSAM", "Uzbekistan",
    "SNE", "Servicios Aéreos De Nicaragua (SANSA)", "SANSA", "Nicaragua",
    "SNF", "Shans Air", "SHANS AIR", "Russia",
    "SNG", "LongJiang Airlines", "SNOW EAGLE", "China",
    "SNH", "Senair Services", "SENSERVICE", "Senegal",
    "SNI", "Savanah Airlines", "SAVANAHLINE", "Nigeria",
    "SNJ", "Solaseed Air", "NEWSKY", "Japan",
    "SNK", "Southeast Airlines (Sun Jet International)", "SUN KING", "United States",
    "SNL", "Soonair Lines", "SOONAIR", "United States",
    "SNM", "Servizi Aerei", "SERVIZI AEREI", "Italy",
    "SNO", "Delta Air Charter", "SNOWBALL", "Canada",
    "SNP", "Sun Pacific International", "SUN PACIFIC", "United States",
    "SNQ", "Sun Quest Executive Air Charter", "EXECU-QUEST", "United States",
    "SNS", "Societe Centrafricaine De Transport Aerien", "", "Central African Republic",
    "SNT", "Suncoast Aviation", "SUNCOAST", "United States",
    "SNU", "Snunit Aviation", "", "Israel",
    "SNV", "Sudanese States Aviation", "SUDANESE", "Sudan",
    "SNW", "Sun West Airlines", "SUN WEST", "United States",
    "SNX", "Sun Air Aviation Services", "SUNEX", "Canada",
    "SNY", "Air Sandy", "AIR SANDY", "Canada",
    "SOB", "Stabo Freight", "STABO", "Zambia",
    "SOC", "Southern Cargo Air Lines", "", "Russia",
    "SOD", "Aerolíneas Sol", "ALSOL", "Mexico",
    "SOE", "Air Soleil", "AIR SOLEIL", "Mauritania",
    "SOG", "Solenta Aviation Ghana", "", "Ghana",
    "SOH", "Southern Ohio Aviation Sales", "SOUTHERN OHIO", "United States",
    "SOI", "Southern Aviation", "SOAVAIR", "Zambia",
    "SOL", "Solomon Airlines", "SOLOMON", "Solomon Islands",
    "SOM", "Somali Airlines", "SOMALAIR", "Somali Republic",
    "SON", "Sunshine Air Tours", "SUNSHINE TOURS", "United States",
    "SOO", "Southern Air", "SOUTHERN AIR", "United States",
    "SOP", "Solinair", "SOLINAIR", "Slovenia",
    "SOR", "Sonair Servico Aéreo", "SONAIR", "Angola",
    "SOT", "Southeast Correct Craft", "SOUTH COURIER", "United States",
    "SOU", "Southern Airways", "SOUTHERN EXPRESS", "United States",
    "SOV", "Saratov Airlines Joint Stock Company", "SARATOV AIR", "Russia",
    "SOW", "White Sparrow GmbH", "SPARROW", "Austria",
    "SOX", "Solid Air", "SOLIDAIR", "Netherlands",
    "SOY", "Island Aviation", "SORIANO", "Philippines",
    "SOZ", "Sat Airlines", "SATCO", "Kazakhstan",
    "SPA", "Sierra Pacific Airlines", "SIERRA PACIFIC", "United States",
    "SPB", "Springbok Classic Air", "SPRING CLASSIC", "South Africa",
    "SPC", "Spark Air Cargo", "Spark Cargo", "United States",
    "SPE", "Sprague Electric Company", "SPRAGUE", "United States",
    "SPF", "Space World Airline", "SPACE WORLD", "Nigeria",
    "SPG", "Springdale Air Service", "SPRING AIR", "United States",
    "SPH", "Sapphire Executive Air", "SAPPHIRE-CHARTER", "South Africa",
    "SPI", "South Pacific Island Airways", "SOUTH PACIFIC", "United States",
    "SPJ", "Air Service", "AIR SKOPJE", "Macedonia",
    "SPK", "Diamond Aviation", "SPARKLE", "United States",
    "SPL", "Servicios Corporativos Aéreos De La Laguna", "CORPORATIVOS LAGUNA", "Mexico",
    "SPM", "Air Saint Pierre", "SAINT-PIERRE", "France",
    "SPN", "Skorpion Air", "AIR SKORPIO", "Bulgaria",
    "SPO", "Aeroservicios Ejecutivos Del Pacifico", "EJECTUIV PACIFICO", "Mexico",
    "SPP", "Sapphire Aviation", "SAPPHIRE", "United States",
    "SPQ", "Servicios Aéreos Palenque", "SERVICOS PALENQUE", "Mexico",
    "SPR", "Provincial Airlines", "SPEEDAIR", "Canada",
    "SPS", "Spark Shuttle", "Spark Shuttle", "United States",
    "SPT", "Speed Aviation", "SPEED AVIATION", "Bangladesh",
    "SPU", "Southeast Airmotive", "SPUTTER", "United States",
    "SPV", "Servicios Privados De Aviación", "SERVICIOS PRIVADOS", "Mexico",
    "SPW", "Speedwings", "SPEEDWING", "Switzerland",
    "SPX", "Spark Express (Glow)", "Glow|United States", "",
    "SPY", "Asian Aerospace Service", "THAI SPACE", "Thailand",
    "SPZ", "Airworld", "SPEED SERVICE", "South Africa",
    "SQA", "Slovak National Aeroclub", "SLOVAK AEROCLUB", "Slovakia",
    "SQC", "Singapore Airlines Cargo", "SINGCARGO", "Singapore",
    "SQF", "Slovak Air Force", "SLOVAK AIRFORCE", "Slovakia",
    "SQH", "SeaPort Airlines", "SASQUATCH", "United States",
    "SQL", "Servicos De Alquiler", "ALQUILER", "Mexico",
    "SQP", "SkyUp", "SKYUP", "Ukraine",
    "SRA", "Sair Aviation", "SAIR", "Canada",
    "SRC", "Searca", "SEARCA", "Colombia",
    "SRD", "HM Coastguard", "COASTGUARD", "United Kingdom",
    "SRE", "Fly Jetstream Aviation", "STREAMJET", "South Africa",
    "SRF", "Transportes Aéreos San Rafael", "SAN RAFEAL", "Chile",
    "SRG", "HM Coastguard", "RESCUE", "United Kingdom",
    "SRH", "Siem Reap Airways", "SIEMREAP AIR", "Cambodia",
    "SRI", "Air Safaris and Services", "AIRSAFARI", "New Zealand",
    "SRJ", "C Air Jet Airlines", "SYRJET", "Syria",
    "SRK", "Sky Work Airlines", "SKYFOX", "Switzerland",
    "SRL", "Servicios Aeronáuticos Aero Personal", "SERVICIOS PERSONAL", "Mexico",
    "SRN", "Sirair", "SIRAIR", "Russia",
    "SRO", "Servicios Aéreos Ejecutivos Saereo", "SAEREO", "Ecuador",
    "SRP", "Polizeihubschauberstaffel Rheinland-Pfalz", "SPERBER", "Germany",
    "SRQ", "Cebgo", "BLUE JAY", "Philippines",
    "SRR", "Star Air", "WHITESTAR", "Denmark",
    "SRS", "Selkirk Remote Sensing", "PHOTO CHARLIE", "Canada",
    "SRT", "Trans Asian Airlines", "TRASER", "Kazakhstan",
    "SRU", "Star Up", "STAR-UP", "Peru",
    "SRV", "Aero Servicio Corporativo", "SERVICORP", "Mexico",
    "SRW", "Sarit Airlines", "SARIA", "Sudan",
    "SRX", "Sierra Expressway Airlines", "SIERRA EX", "United States",
    "SRY", "As-Aero", "", "Armenia",
    "SRZ", "Strato Air Services", "STRATO", "South Africa",
    "SSB", "Sasair", "SASIR", "Canada",
    "SSC", "Southern Seaplane", "SOUTHERN SKIES", "United States",
    "SSD", "Star Service International", "STAR SERVICE", "France",
    "SSE", "Servicios Aéreos Sunset", "SUNSET", "Mexico",
    "SSF", "Severstal Air Company", "SEVERSTAL", "Russia",
    "SSG", "Slovak Government Flying Service", "SLOVAK GOVERNMENT", "Slovakia",
    "SSH", "Heritage Flight (Valley Air Services)", "SNOWSHOE", "United States",
    "SSI", "Vision Airlines", "SUPER JET", "Nigeria",
    "SSK", "Skystar International", "SKYSTAR", "United States",
    "SSL", "Air Sultan", "SIERRA SULTAN", "Sierra Leone",
    "SSO", "Special Scope Limited", "DOPE", "United Kingdom",
    "SSP", "Starspeed", "STARSPEED", "United Kingdom",
    "SSQ", "Sunstate Airlines", "SUNSTATE", "Australia",
    "SSR", "Sardinian Sky Service", "SARDINIAN", "Italy",
    "SSS", "SAESA", "SAESA", "Spain",
    "SST", "Sunwest Airlines", "SUNFLIGHT", "Canada",
    "SSU", "SASCA", "SASCA", "Venezuela",
    "SSW", "Streamline Aviation", "STREAMLINE", "United Kingdom",
    "SSX", "Lynx Aviation", "SHASTA", "United States",
    "SSY", "Sky Aviation", "SIERRA SKY", "Sierra Leone",
    "SSZ", "Specsavers Aviation", "SPECSAVERS", "United Kingdom",
    "STA", "Star Aviation", "STAR", "United Kingdom",
    "STB", "Status-Alpha Airline", "STATUS-ALPHA", "Ukraine",
    "STC", "Stadium City Limited", "STADIUM", "United Kingdom",
    "STD", "Servicios De Aerotransportacion De Aguascalientes", "AERO AGUASCALINETES", "Mexico",
    "STE", "Semitool Europe", "SEMITRANS", "United Kingdom",
    "STF", "SFT-Sudanese Flight", "", "Sudan",
    "STG", "Sedalia  Marshall  Boonville Stage Line", "STAGE", "United States",
    "STH", "South-Airlines", "", "Armenia",
    "STI", "Sontair", "SONTAIR", "Canada",
    "STJ", "Sella Aviation", "STELLAVIA", "Netherlands",
    "STK", "Aeropac", "SAT PAK", "United States",
    "STL", "Stapleford Flight Centre", "STAPLEFORD", "United Kingdom",
    "STN", "RAF St Athan", "SAINT ATHAN", "United Kingdom",
    "STO", "Streamline Ops", "SLOPS", "Russia",
    "STQ", "Star Air", "STERA", "Indonesia",
    "STR", "Red Star", "STARLINE", "United Arab Emirates",
    "STT", "Western Aircraft  Inc", "SAWTOOTH", "United States",
    "STU", "Star African Air", "STARSOM", "Somali Republic",
    "STV", "Saturn Aviation", "SATURN", "United States",
    "STW", "South West Air Corporation", "SIERRA WHISKEY", "Philippines",
    "STX", "Stars Away Aviation", "STARSAWAY", "South Africa",
    "STY", "Styrian Airways", "STYRIAN", "Austria",
    "SUA", "Silesia Air", "AIR SILESIA", "Czech Republic",
    "SUB", "Suburban Air Freight", "SUB AIR", "United States",
    "SUD", "Sudan Airways", "SUDANAIR", "Sudan",
    "SUE", "Aerolíneas Del Sureste", "AEROSURESTE", "Mexico",
    "SUF", "Sun Air (Fiji)", "SUNFLOWER", "Fiji",
    "SUG", "Sunu Air", "SUNU AIR", "Senegal",
    "SUH", "Sun Light", "LIGHT AIR", "Kyrgyzstan",
    "SUI", "Swiss Air Force", "SWISS AIR FORCE", "Switzerland",
    "SUK", "Superior Aviation Services", "SKYCARGO", "Kenya",
    "SUM", "State Unitary Air Enterprise", "SUMES", "Russia",
    "SUN", "Antillana De Navegación Aérea", "", "Dominican Republic",
    "SUO", "Aeroservicios De San Luis", "SERVICIO SANLUIS", "Mexico",
    "SUP", "Aeronautical Charters", "SUN SPEED", "United States",
    "SUR", "Sun Air", "", "Egypt",
    "SUS", "Sun Air of Scandinavia", "SUNSCAN", "Denmark",
    "SUT", "Sistemas Aeronauuticos 2000", "SISTEMAS AERONAUTICOS", "Mexico",
    "SUU", "Star West Aviation", "SUNSTAR", "United States",
    "SUV", "Sundance Air", "DANCEAIR", "Venezuela",
    "SUW", "Interavia Airlines", "ASTAIR", "Russia",
    "SUY", "Aerial Surveys (1980) Limited", "SURVEY", "New Zealand",
    "SVA", "Saudia", "SAUDIA", "Saudi Arabia",
    "SVB", "Siavia", "SIAVIA", "Slovenia",
    "SVD", "St. Vincent Grenadines Air (1990)", "GRENADINES", "Saint Vincent and the Grenadines",
    "SVE", "Aero Servicios Expecializados", "AEROESPECIAL", "Mexico",
    "SVF", "Swedish Armed Forces", "SWEDEFORCE", "Sweden",
    "SVH", "Sterling Helicopters", "SILVER", "United Kingdom",
    "SVI", "Servicios De Transporte Aéreo", "SETRA", "Mexico",
    "SVJ", "Silver Air", "", "Djibouti",
    "SVL", "Sevastopol-Avia", "SEVAVIA", "Ukraine",
    "SVM", "Aeroservicios Monterrey", "SERVIMONTE", "Mexico",
    "SVN", "Savanair (Angola)", "SAVANAIR", "Angola",
    "SVO", "Servicios Aeronáuticos De Oriente", "SERVIORIENTE", "Mexico",
    "SVR", "Ural Airlines", "SVERDLOVSK AIR", "Russia",
    "SVS", "Servicios Aéreos Saar", "AEREOS SAAR", "Mexico",
    "SVT", "Seven Four Eight Air Services", "SIERRA SERVICES", "Luxembourg",
    "SVV", "SALTAVIATION", "SALT", "Poland",
    "SVW", "Global Jet Luxembourg", "SILVER ARROWS", "Luxembourg",
    "SVX", "Security Aviation", "SECURITY AIR", "United States",
    "SVY", "Cooper Aerial Surveys", "SURVEYOR", "United Kingdom",
    "SWA", "Southwest Airlines", "SOUTHWEST", "United States",
    "SWB", "Swissboogie Parapro", "SWISSBOOGIE", "Switzerland",
    "SWC", "South West Air", "SAINT CLAIR", "Canada",
    "SWD", "Trifly", "SAWBLADE", "United States",
    "SWE", "Swedeways", "SWEDELINE", "Sweden",
    "SWF", "Galair International", "GALAIR", "United Kingdom",
    "SWG", "Sunwing Airlines", "SUNWING", "Canada",
    "SWH", "Adler Aviation", "SHOCKWAVE", "Canada",
    "SWI", "Sunworld Airlines", "SUNWORLD", "United States",
    "SWJ", "StatesWest Airlines", "STATES", "United States",
    "SWK", "General Aerospace", "SKYWALKER", "Canada",
    "SWL", "Trans Jet Airways", "TRANSJET", "Sweden",
    "SWN", "West Air Sweden", "AIR SWEDEN", "Sweden",
    "SWP", "Star Work Sky", "STAR WORK", "Italy",
    "SWQ", "Swift Air (Interstate Equipment Leasing)", "SWIFTFLIGHT", "United States",
    "SWR", "Swiss International Air Lines", "SWISS", "Switzerland",
    "SWS", "Sunwest Aviation (Lindquist Investment)", "SUNNY WEST", "United States",
    "SWT", "Swiftair", "SWIFT", "Spain",
    "SWU", "Swiss Global Air Lines", "EUROSWISS", "Switzerland",
    "SWV", "Swe Fly", "FLYING SWEDE", "Sweden",
    "SWW", "Shovkoviy Shlyah", "WAY AERO", "Ukraine",
    "SWX", "Swazi Express Airways", "SWAZI EXPRESS", "Eswatini",
    "SWY", "Sky Jet", "SWISSLINK", "Switzerland",
    "SWZ", "Skywise Airline", "SKYWISE", "South Africa",
    "SXA", "Southern Cross Aviation", "FERRY", "United States",
    "SXC", "Sky Exec Aviation Services", "SKY EXEC", "Nigeria",
    "SXD", "Sunexpress Deutschland", "SUNRISE", "Germany",
    "SXE", "Southeast Express Airlines", "DOGWOOD EXPRESS", "United States",
    "SXM", "Servicios Aéreos Especializados Mexicanos", "SERVIMEX", "Mexico",
    "SXN", "SaxonAir", "SAXONAIR", "United Kingdom",
    "SXS", "SunExpress", "SUNEXPRESS", "Turkey",
    "SXT", "Servicios de Taxi Aereos", "SERTAXI", "Mexico",
    "SXX", "Satellite Aero", "SATELLITE EXPRESS", "United States",
    "SXY", "Safari Express Cargo", "SAFARI EXPRESS", "Kenya",
    "SYA", "Skyways", "LINEAS CARDINAL", "Argentina",
    "SYC", "Systec 2000", "SYSTEC", "United States",
    "SYE", "Sheba Aviation", "", "Yemen",
    "SYF", "Sky One Express Airlines", "SKY FIRST", "United States",
    "SYG", "Synergy Aviation", "SYNERGY", "United Kingdom",
    "SYH", "Sky Handling", "", "Ukraine",
    "SYI", "Sonalysts", "", "United States",
    "SYJ", "Slate Falls Airways", "", "Canada",
    "SYK", "Satsair", "AEROCAB", "United States",
    "SYL", "Aircompany Yakutia", "AIR YAKUTIA", "Russia",
    "SYN", "Syncrude Canada", "SYNCRUDE", "Canada",
    "SYR", "Syrian Arab Airlines", "SYRIANAIR", "Syrian Arab Republic",
    "SYS", "Shawbury Flying Training Unit", "SHAWBURY", "United Kingdom",
    "SYT", "Aerosud Aviation", "SKYTRACK", "South Africa",
    "SYV", "Special Aviation Systems", "SPECIAL SYSTEM", "United States",
    "SYX", "Skywalk Airlines", "SKYWAY-EX", "United States",
    "SYY", "South African Historic Flight", "SKY COACH", "South Africa",
    "SYZ", "Zil Air", "ZIL AIR", "Seychelles",
    "SZB", "Samoa Air", "SAMOA", "Samoa",
    "SZN", "Air Senegal", "AIR SENEGAL", "Senegal",
    "SZT", "Servicios Aeronáuticos Z", "AERO ZEE", "Mexico",
    "TAA", "Aeroservicios de La Costa", "AERO COSTA", "Mexico",
    "TAC", "Turbot Air Cargo", "TURBOT", "Senegal",
    "TAD", "Transporte Aéreo Dominicano", "TRANS DOMINICAN", "Dominican Republic",
    "TAE", "TAME", "TAME", "Ecuador",
    "TAG", "TAG Aviation USA", "TAG U-S", "United States",
    "TAJ", "Tunisavia", "TUNISAVIA", "Tunisia",
    "TAL", "Talair", "TALAIR", "Papua New Guinea",
    "TAM", "LATAM Brasil", "TAM", "Brazil",
    "TAN", "Zanair", "ZANAIR", "Tanzania",
    "TAO", "Aeromar", "TRANS-AEROMAR", "Mexico",
    "TAP", "TAP Portugal", "AIR PORTUGAL", "Portugal",
    "TAR", "Tunisair", "TUNAIR", "Tunisia",
    "TAS", "Lotus Air", "LOTUS FLOWER", "Egypt",
    "TAT", "Grupo TACA", "TACA-COSTARICA", "Costa Rica",
    "TAU", "Transportes Aéreos Tauro", "TRANSTAURO", "Mexico",
    "TAV", "Compañía de Servicios Aéreos Tavisa", "TAVISA", "Spain",
    "TAX", "Thai AirAsia X", "EXPRESS WING", "Thailand",
    "TAY", "TNT Airways", "QUALITY", "Belgium",
    "TBA", "Tibet Airlines", "TIBET", "China",
    "TBC", "Turbine Air Cargo UK", "", "United Kingdom",
    "TBD", "Thunderbird Tours", "ORCA", "Canada",
    "TBG", "Tropical Airways", "", "Haiti",
    "TBH", "Trinity Air Bahamas", "", "Bahamas",
    "TBI", "TAB Express International", "TAB INTERNATIONAL", "United States",
    "TBL", "Bell Aliant Regional Communications", "TELCO", "Canada",
    "TBM", "Taban Air Lines", "TABAN AIR", "Iran",
    "TBN", "Teebah Airlines", "TEEBAH", "Sierra Leone",
    "TBO", "Aero Taxi de Los Cabos", "AERO CABOS", "Mexico",
    "TBR", "Tubelair", "TUBELAIR", "Tunisia",
    "TBS", "Timbis Air", "TIMBIS", "Kenya",
    "TBX", "Tobago Express", "TABEX", "Trinidad and Tobago",
    "TCA", "Tropican Air Services", "TROPICANA", "Egypt",
    "TCB", "Transporte Aereo De Colombia", "AERO COLOMBIA", "Colombia",
    "TCC", "Trans Continental Airlines", "TRANSCAL", "Sudan",
    "TCD", "Tchad Airlines", "TCHADLINES", "Chad",
    "TCE", "Trans-Colorado Airlines", "TRANS-COLORADO", "United States",
    "TCF", "Shuttle America", "MERCURY", "United States",
    "TCG", "Thai Air Cargo", "THAI CARGO", "Thailand",
    "TCH", "Transcontinental Air", "TRANS GULF", "Bahrain",
    "TCL", "Coastal Air Transport", "TRANS COASTAL", "United States",
    "TCM", "Teledyne Continental Motors", "TELEDYNE", "United States",
    "TCN", "Trans Continental Airlines", "TRANSCON", "United States",
    "TCO", "Aerotranscolombina de Carga", "TRANSCOLOMBIA", "Colombia",
    "TCP", "Transcorp Airways", "TRANSCORP", "United Kingdom",
    "TCR", "Lanaes Aereas Trans Costa Rica", "TICOS", "Costa Rica",
    "TCT", "Transcontinental Sur", "TRANS-CONT", "Uruguay",
    "TCU", "Transglobal Airways Corporation", "TRANSGLOBAL", "Philippines",
    "TCV", "TACV", "CABOVERDE", "Cape Verde",
    "TCX", "Thomas Cook Airlines", "KESTREL", "United Kingdom",
    "TCY", "Twin Cities Air Service", "TWIN CITY", "United States",
    "TDA", "Trend Aviation", "TREND AIR", "United States",
    "TDB", "Welch Aviation", "THUNDER BAY", "United States",
    "TDC", "Tadair", "TADAIR", "Spain",
    "TDE", "Tellavia / Flight One", "TELLURIDE", "United States",
    "TDG", "Air Cargo Express", "TURBO DOG", "United States",
    "TDI", "Transportes Aéreos de Ixtlán", "TRANSIXTLAN", "Mexico",
    "TDM", "Tandem Aero", "TANDEM", "Moldova",
    "TDO", "TRADO", "TRADO", "Dominican Republic",
    "TDR", "Trade Air", "TRADEAIR", "Croatia",
    "TDT", "Atlas Helicopters", "TRIDENT", "United Kingdom",
    "TDV", "Taxi Aero Nacional Del Evora", "TAXI EVORA", "Mexico",
    "TDX", "Tradewinds Airlines", "TRADEWINDS EXPRESS", "United States",
    "TDY", "Air Today", "AIR TODAY", "United States",
    "TEA", "Executive Turbine Aviation", "TRAVELMAX", "South Africa",
    "TEB", "Tenir Airlines", "TENIR AIR", "Kyrgyzstan",
    "TEC", "ADI Shuttle Group", "TECHJET", "United States",
    "TED", "Aero Servicios Azteca", "AEROAZTECA", "Mexico",
    "TEE", "West Freugh DTEO", "TEEBIRD", "United Kingdom",
    "TEF", "Tecnicas Fotograficas", "TECFOTO", "Spain",
    "TEH", "Tempelhof Airways", "TEMPELHOF", "United States",
    "TEL", "Telford Aviation", "TELFORD", "United States",
    "TEM", "Tech-Mont Helicopter Company", "TECHMONT", "Slovakia",
    "TEN", "Tennessee Airways", "TENNESSEE", "United States",
    "TEP", "Transeuropean Airlines", "TRANSEURLINE", "Russia",
    "TER", "Territorial Airlines", "TERRI-AIRE", "United States",
    "TES", "Taespejo Portugal LDA", "Tesaban", "Portugal",
    "TET", "Tepavia-Trans Airlines", "TEPAVIA", "Moldova",
    "TEW", "Airteam Charter", "TEAMWORK", "South Africa",
    "TEX", "Catex", "CATEX", "France",
    "TEZ", "TezJet Airlines", "", "Kyrgyzstan",
    "TFA", "Trans-Florida Airlines", "TRANS FLORIDA", "United States",
    "TFB", "Tair Airways", "ROYAL TEE-AIR", "Philippines",
    "TFF", "Talon Air", "TALON FLIGHT", "United States",
    "TFG", "MAS Airways", "TRAFALGAR", "United Kingdom",
    "TFH", "Thai Flying Helicopter Service", "THAI HELICOPTER", "Thailand",
    "TFI", "Transport Facilitators", "", "United States",
    "TFK", "Transafrik International", "", "São Tomé and Príncipe",
    "TFL", "TUI fly Netherlands", "ORANGE", "Netherlands",
    "TFN", "Norwegian Aviation College", "SPIRIT", "Norway",
    "TFO", "Transportes Aéreos del Pacífico", "TRANSPORTES PACIFICO", "Mexico",
    "TFT", "Thai Flying Service", "THAI FLYING", "Thailand",
    "TFU", "213th Flight Unit", "THJY", "Russia",
    "TFY", "Tayside Aviation", "TAYSIDE", "United Kingdom",
    "TGC", "TG Aviation", "THANET", "United Kingdom",
    "TGE", "Trabajos Aéreos", "TASA", "Spain",
    "TGG", "Tigerair Australia", "TIGGOZ", "Australia",
    "TGI", "Transportes Aéreos Regionales", "TRANSPORTE REGIONAL", "Mexico",
    "TGM", "TAG Aviation Espana", "TAG ESPANA", "Spain",
    "TGN", "Trigana Air Service", "TRIGANA", "Indonesia",
    "TGO", "Transport Canada", "TRANSPORT", "Canada",
    "TGT", "SAAB Nyge Aero", "TARGET", "Sweden",
    "TGW", "Scoot", "SCOOTER", "Singapore",
    "TGX", "Transair Gabon", "TRANSGABON", "Gabon",
    "TGY", "Trans Guyana Airways", "TRANS GUYANA", "Guyana",
    "TGZ", "Georgian Airways", "TAMAZI", "Georgia",
    "THA", "Thai Airways International", "THAI", "Thailand",
    "THB", "Spark Air", "THAI SABAI", "Thailand",
    "THC", "Tar Heel Aviation", "TARHEEL", "United States",
    "THD", "Thai Smile Airways", "THAI SMILE", "Thailand",
    "THE", "Toumai Air Tchad", "TOUMAI AIR", "Chad",
    "THF", "Touraine Helicoptere", "TOURAINE HELICO", "France",
    "THG", "Thai Global Airline", "THAI GLOBAL", "Thailand",
    "THJ", "Thai Jet Intergroup", "THAI JET", "Thailand",
    "THK", "Turk Hava Kurumu Hava Taksi Isletmesi", "HUR KUS", "Turkey",
    "THM", "Airmark Aviation", "THAI AIRMARK", "Thailand",
    "THN", "International Security Assistance Force", "ATHENA", "Canada",
    "THO", "TACA De Honduras", "LEMPIRA", "Honduras",
    "THR", "Tehran Airline", "TEHRAN AIR", "Iran",
    "THS", "Turkish Aerospace Industries", "TUSAS", "Turkey",
    "THT", "Air Tahiti Nui", "TAHITI AIRLINES", "France",
    "THU", "Thunder Airlines", "AIR THUNDER", "Canada",
    "THY", "Turkish Airlines", "TURKISH", "Turkey",
    "THZ", "Trans Helicoptere Service", "LYON HELIJET", "France",
    "TIA", "Trans International Airlines", "TRANS INTERNATIONAL", "United States",
    "TIB", "TRIP Linhas Aéreas", "TRIP", "Brazil",
    "TIC", "Travel International Air Charters", "TRAVEL INTERNATIONAL", "Zambia",
    "TID", "Air Tindi", "TINDI", "Canada",
    "TIE", "Time Air", "TIME AIR", "Czech Republic",
    "TIH", "S C Ion Tiriac", "TIRIAC AIR", "Romania",
    "TIK", "Tic Air", "TICAIR", "Australia",
    "TIM", "TEAM Linhas Aéreas", "TEAM BRASIL", "Brazil",
    "TIN", "Taino Tours", "TAINO", "Dominican Republic",
    "TIP", "C and M Aviation", "TRANSPAC", "United States",
    "TIR", "Antair", "ANTAIR", "Mexico",
    "TIS", "Tesis", "TESIS", "Russia",
    "TIW", "Transcarga Intl Airways", "TIACA", "Venezuela",
    "TJK", "Tajikair", "TAJIKAIR", "Tajikistan",
    "TJN", "Tien-Shan", "NERON", "Kazakhstan",
    "TJS", "Tyrolean Jet Services", "TYROLJET", "Austria",
    "TJT", "Twin Jet", "TWINJET", "France",
    "TKC", "Tikal Jets Airlines", "TIKAL", "Guatemala",
    "TKE", "Take Air Line", "ISLAND BIRD", "France",
    "TKJ", "Tarkim Aviation", "TARKIM AVIATION", "Turkey",
    "TKX", "Tropical International Airways", "TROPEXPRESS", "Saint Kitts and Nevis",
    "TLA", "Translift Airways", "TRANSLIFT", "Ireland",
    "TLB", "Atlantique Air Assistance", "TRIPLE-A", "France",
    "TLC", "Caribbean Express", "CARIB-X", "United States",
    "TLD", "Aereo Taxi Autlan", "AEREO AUTLAN", "Mexico",
    "TLE", "Aero Util", "AEROUTIL", "Mexico",
    "TLF", "Transport Africa", "TRANS-LEONE", "Sierra Leone",
    "TLK", "Starlink Aviation", "STARLINK", "Canada",
    "TLL", "Trans Atlantic Airlines", "ATLANTIC LEONE", "Sierra Leone",
    "TLM", "Thai Lion Mentari", "MENTARI", "Thailand",
    "TLO", "Eagle Canyon Airlines", "TALON AIR", "United States",
    "TLP", "Tulip Air", "TULIPAIR", "Netherlands",
    "TLR", "Air Libya Tibesti", "AIR LIBYA", "Libya",
    "TLS", "TLC Air", "TEALSY", "United States",
    "TLT", "Turtle Airways", "TURTLE", "Fiji",
    "TLU", "Aero Toluca Internactional", "AEROTOLUCA", "Mexico",
    "TLV", "Travelair", "PAJAROS", "Uruguay",
    "TLW", "Teamline Air", "Teamline", "Austria",
    "TLX", "Telesis Transair", "TELESIS", "United States",
    "TLY", "Top Fly", "TOPFLY", "Spain",
    "TMA", "Trans Mediterranean Airlines", "TANGO LIMA", "Lebanon",
    "TMB", "Volato", "Tombo", "United States",
    "TMC", "Travel Management Company", "TRAIL BLAZER", "United States",
    "TMD", "Transmandu", "TRANSMANDU", "Venezuela",
    "TME", "Aero Taxi del Centro de Mexico", "TAXICENTRO", "Mexico",
    "TMG", "Tri-MG Intra Asia Airlines", "TRILINES", "Indonesia",
    "TMH", "Taxis Turisticos Marakame", "TAXIMARAKAME", "Mexico",
    "TMI", "Tamir Airways", "TAMIRWAYS", "Israel",
    "TMK", "Tomahawk Airways", "TOMAHAWK", "United States",
    "TML", "Transports et Travaux Aériens de Madagascar", "TAM AIRLINE", "Madagascar",
    "TMM", "TMC Airlines", "WILLOW RUN", "United States",
    "TMN", "Tasman Cargo Airlines", "TASMAN", "Australia",
    "TMP", "Arizona Express Airlines", "TEMPE", "United States",
    "TMQ", "TRAM", "TRAM AIR", "Mauritania",
    "TMR", "Timberline Air", "TIMBER", "Canada",
    "TMS", "Temsco Helicopters", "TEMSCO", "United States",
    "TMT", "Trans Midwest Airlines", "TRANS MIDWEST", "United States",
    "TMX", "Tramon Air", "TRAMON", "South Africa",
    "TMY", "Transportes Aéreos del Mundo Maya", "MUNDO MAYA", "Mexico",
    "TMZ", "Transporte Amazonair", "TRANS AMAZON", "Venezuela",
    "TNB", "Trans Air-Benin", "TRANS-BENIN", "Benin",
    "TNC", "National Aviation Consultants", "NATCOM", "Canada",
    "TND", "Aero Taxis Cessna", "TAXIS CESSNA", "Mexico",
    "TNE", "Taxis Aéreos del Noroeste", "TAXINOROESTE", "Mexico",
    "TNF", "Transafricaine", "TRANSFAS", "Burkina Faso",
    "TNG", "Tennessee Air National Guard 164th Airlift Group", "", "United States",
    "TNI", "Transair International Linhas Aéreas", "TRANSINTER", "United States",
    "TNL", "Tengeriyn Ulaach Shine", "SKY HORSE", "Mongolia",
    "TNM", "Tiara Air", "TIARA", "Aruba",
    "TNO", "Aerotransporte de Carga Union", "AEROUNION", "Mexico",
    "TNP", "Transped Aviation", "TRANSPED", "Austria",
    "TNR", "Tanana Air Services", "TAN AIR", "United States",
    "TNT", "Trans North Turbo Air", "TRANS NORTH", "Canada",
    "TNV", "Transnorthern", "TRANSNORTHERN", "United States",
    "TNW", "Trans Nation Airways", "TRANS-NATION", "Ethiopia",
    "TNX", "Trener Ltd", "TRAINER", "Hungary",
    "TNY", "Twin Town Leasing Company", "TWINCAL", "United States",
    "TOB", "Tobruk Air", "TOBRUK AIR", "Libya",
    "TOC", "Aerotropical", "TROPICMEX", "Mexico",
    "TOF", "RAF Topcliffe Flying Training Unit", "TOPCLIFFE", "United Kingdom",
    "TOH", "Air Tomisko", "TOMISKO CARGO", "Serbia",
    "TOJ", "TOJ Airlines", "TOJ AIRLINE", "Tajikistan",
    "TOK", "Airlines PNG", "BALUS", "Papua New Guinea",
    "TOL", "Tol-Air Services", "TOL AIR", "United States",
    "TOM", "TUI Airways", "TOM JET", "United Kingdom",
    "TON", "Aero Tonala", "AEROTONALA", "Mexico",
    "TOP", "Top Air", "AIR TOP", "Indonesia",
    "TOR", "FlyGTA Airlines", "HOMERUN", "Canada",
    "TOS", "Tropic Air", "TROPISER", "Belize",
    "TOT", "Totavia", "", "Canada",
    "TOW", "AirTanker Services", "TOWLINE", "United Kingdom",
    "TOX", "Neosiam Airways", "SKY KINGDOM", "Thailand",
    "TOY", "Toyota Canada", "TOYOTA", "Canada",
    "TPA", "TAMPA", "TAMPA", "Colombia",
    "TPB", "Aero Tropical", "AERO TROPICAL", "Angola",
    "TPC", "Air Calédonie", "AIRCAL", "France",
    "TPD", "Top Speed", "TOP SPEED", "Austria",
    "TPF", "Taxis Aéreos del Pacífico", "TAXIPACIFICO", "Mexico",
    "TPG", "Transportes Aéreos Pegaso", "TRANSPEGASO", "Mexico",
    "TPK", "Air Horizon", "TCHAD-HORIZON", "Chad",
    "TPL", "TAR Interpilot", "INTERPILOT", "Mauritania",
    "TPM", "Transpaís Aéreo", "TRANSPAIS", "Mexico",
    "TPN", "Transportación Aérea del Norte", "AEREA DELNORTE", "Mexico",
    "TPO", "Aero Taxi del Potosi", "TAXI-POTOSI", "Mexico",
    "TPP", "Transpac Express", "TRANS EXPRESS", "Australia",
    "TPR", "Taxis Aéreos De Parral", "TAXIS PARRAL", "Mexico",
    "TPS", "TAPSA Transportes Aéreos Petroleros", "TAPSA", "Argentina",
    "TPT", "Transportes Aéreo del Sureste", "TASSA", "Mexico",
    "TPU", "Trans American Airlines (Trans Am)", "TRANS PERU", "Peru",
    "TPV", "Thai Pacific Airlines Business", "THAI PACIFIC", "Thailand",
    "TPX", "Transportes Aéreos De Xalapa", "TRANSXALAPA", "Mexico",
    "TPY", "Trans-Provincial Airlines", "TRANS PROVINCIAL", "Canada",
    "TPZ", "Transportes La Paz", "TRANSPAZ", "Mexico",
    "TQE", "Taxair Mexiqienses", "TAXAIR", "Mexico",
    "TQF", "United Kingdom Royal VIP Flights", "RAINBOW", "United Kingdom",
    "TQM", "JM Family Aviation", "TACOMA", "United States",
    "TQN", "Taquan Air Services", "TAQUAN", "United States",
    "TQR", "Transportación Aérea De Querétaro", "TRANSQUERETARO", "Mexico",
    "TQS", "Aeroturquesa", "AEROTURQUESA", "Mexico",
    "TRA", "Transavia Holland", "TRANSAVIA", "Netherlands",
    "TRB", "Ukraine Transavia", "KIROVTRANS", "Ukraine",
    "TRC", "Trans Air Charter", "TRACKER", "United States",
    "TRD", "Trans Island Air", "TRANS ISLAND", "Barbados",
    "TRF", "Taxi Air Fret", "TAXI JET", "France",
    "TRG", "TRAGSA (Medios Aéreos)", "", "Spain",
    "TRH", "Airmark Aviation", "TRANSTAR", "United States",
    "TRI", "Executive Flight Operations Ontario Government", "TRILLIUM", "Canada",
    "TRJ", "Trans Euro Air", "HIGH TIDE", "United Kingdom",
    "TRK", "Turkish Airlines General Aviation", "TURKISH REPUBLIC", "Turkey",
    "TRL", "Starlite Aviation", "STARSTREAM", "South Africa",
    "TRM", "Transport Aerien de Mauritanie", "SOTRANS", "Mauritania",
    "TRN", "Servicios Aéreos Corporativos", "AEROTRON", "Mauritania",
    "TRO", "Tropic Airlines-Air Molokai", "MOLOKAI", "United States",
    "TRP", "Maryland State Police", "TROOPER", "United States",
    "TRR", "Tramson Limited", "TRAMSON", "Sudan",
    "TRT", "Trans Arabian Air Transport", "TRANS ARABIAN", "Sudan",
    "TRU", "Triangle Airline (Uganda)", "TRI AIR", "Uganda",
    "TRW", "Transwestern Airlines of Utah", "TRANS-WEST", "United States",
    "TRY", "Tristar Airlines", "TRISTAR AIR", "United States",
    "TSA", "Transair France", "AIRTRAF", "France",
    "TSC", "Air Transat", "AIR TRANSAT", "Canada",
    "TSD", "TAF-Linhas Aéreas", "TAFI", "Brazil",
    "TSG", "Trans-Air-Congo", "TRANS-CONGO", "Republic of the Congo",
    "TSH", "R1 Airlines  previously Regional 1", "TRANSCANADA", "Canada",
    "TSI", "Transport'air", "TRANSPORTAIR", "France",
    "TSJ", "Trast Aero", "TRAST AERO", "Kyrgyzstan",
    "TSK", "Trast Aero", "TOMSK-AVIA", "Kyrgyzstan",
    "TSL", "Thai Aviation Services", "THAI AVIATION", "Thailand",
    "TSM", "Trans Sayegh Airport Services", "", "Lebanon",
    "TSN", "Trans-Air Services", "AIR TRANS", "Nigeria",
    "TSO", "Transaero Airlines", "TRANSOVIET", "Russia",
    "TSP", "Transportes Aéreos Inter", "TRANSPO-INTER", "Guatemala",
    "TSQ", "airtransse", "AIRTRA", "Japan",
    "TSR", "TJS San Marino S.r.L.", "SAN MARINO", "San Marino",
    "TSS", "Tri-State Aero", "TRI-STATE", "United States",
    "TST", "TRAST", "TRAST", "Kazakhstan",
    "TSU", "Gulf & Caribbean Cargo / Contract Air Cargo", "TRANSAUTO", "United States",
    "TSV", "Tropair Airservices", "TROPIC", "United Kingdom",
    "TSW", "Transwings", "SWISSTRANS", "Switzerland",
    "TSX", "Thai Star Airlines", "THAI STAR", "Thailand",
    "TSY", "Tristar Air", "TRIPLE STAR", "Egypt",
    "TTA", "TTA - Sociedade de Transporte e Trabalho Aéreo", "KANIMANBO", "Mozambique",
    "TTB", "Aerolíneas Turísticas del Caribe", "AERO TURISTICAS", "Mexico",
    "TTC", "Transteco", "TRANSTECO", "Angola",
    "TTE", "Avcenter", "TETON", "United States",
    "TTF", "224th Flight Unit", "CARGO UNIT", "Russia",
    "TTH", "Tarhan Tower Airlines", "", "Turkey",
    "TTL", "Total Linhas Aéreas", "TOTAL", "Brazil",
    "TTM", "Societe Tout Transport Mauritanien", "TOUT-AIR", "Mauritania",
    "TTN", "Absolute Flight Services", "TITANIUM", "South Africa",
    "TTP", "Triple O Aviation", "MIGHTY WING", "Nigeria",
    "TTR", "Transportaciones Y Servicios Aéreos", "TRANSPORTACIONES", "Mexico",
    "TTS", "Transporte Aéreo Técnico Ejecutivo", "TECNICO", "Mexico",
    "TTW", "Tigerair Taiwan", "SMART CAT", "Taiwan",
    "TTX", "Alliance Air Charters", "TWISTER", "United States",
    "TUA", "Turkmenistan Airlines", "TURKMENISTAN", "Turkmenistan",
    "TUC", "Turismo Aéreo de Chile", "TURICHILE", "Chile",
    "TUD", "Flight Alaska", "TUNDRA", "United States",
    "TUI", "TUI fly Deutschland", "TUI JET", "Germany",
    "TUK", "Ocean Wings Commuter Service", "TUCKERNUCK", "United States",
    "TUL", "Tulpar Air", "URSAL", "Russia",
    "TUM", "Tyumenspecavia", "TUMTEL", "Russia",
    "TUO", "Taxi Aéreo Turístico", "TURISTICO", "Mexico",
    "TUP", "Aviastar-Tu", "TUPOLEVAIR", "Russia",
    "TUR", "ATUR", "", "Ecuador",
    "TUS", "ABSA Cargo", "Turismo", "Brazil",
    "TUY", "Línea Turística Aereotuy", "AEREOTUY", "Venezuela",
    "TUZ", "Tuna Aero", "TUNA", "Sweden",
    "TVA", "Trans America Airlines", "TRANS-AMERICA", "United States",
    "TVF", "Transavia France", "FRANCE SOLEIL", "France",
    "TVH", "Trabajos Aéreos Vascongados", "TRAVASA", "Spain",
    "TVI", "Tiramavia", "TIRAMAVIA", "Moldova",
    "TVJ", "Thai Vietjet Air", "THAIVIET JET", "Thailand",
    "TVL", "Smartwings Hungary", "TRAVEL SERVICE", "Hungary",
    "TVO", "Transavio", "TRANS-BALLERIO", "Italy",
    "TVP", "Smartwings Poland", "JETTRAVEL", "Poland",
    "TVQ", "Smartwings Slovakia", "SLOVAKTRAVEL", "Slovakia",
    "TVR", "Tavrey Airlines", "TAVREY", "Ukraine",
    "TVS", "Smartwings", "SKYTRAVEL", "Czech Republic",
    "TWA", "Trans World Airlines", "TWA", "United States",
    "TWB", "T'way Air", "TWAYAIR", "Republic of Korea",
    "TWE", "Transwede Airways", "TRANSWEDE", "Sweden",
    "TWF", "247 Jet Ltd", "CLOUD RUNNER", "United Kingdom",
    "TWG", "air-taxi Europe", "TWINGOOSE", "Germany",
    "TWI", "Tailwind Airlines", "TAILWIND", "Turkey",
    "TWJ", "Twinjet Aircraft Sales", "", "United Kingdom",
    "TWL", "Tradewinds Aviation", "TRADEWINDS CANADA", "Canada",
    "TWM", "Transairways", "", "Mozambique",
    "TWN", "Avialeasing Aviation Company", "TWINARROW", "Uzbekistan",
    "TWO", "Twente Airlines", "COLIBRI", "Netherlands",
    "TWW", "Trans Air Welwitchia", "WELWITCHIA", "Angola",
    "TWY", "Sunset Aviation  LLC", "TWILIGHT", "United States",
    "TXA", "Texair Charter", "OKAY AIR", "United States",
    "TXB", "Bell Helicopter Textron", "TEXTRON", "Canada",
    "TXC", "TransAVIAexport Airlines", "TRANSEXPORT", "Belarus",
    "TXD", "Aerotaxis del Noroeste", "TAXI OESTE", "Mexico",
    "TXE", "Transilvania Express", "TRANSAIR EXPRESS", "Romania",
    "TXF", "Aerotaxis Alfe", "ALFE", "Mexico",
    "TXI", "Aereotaxis", "AEREOTAXIS", "Mexico",
    "TXL", "Taxi Aéreo Cozatl", "TAXI COZATL", "Mexico",
    "TXM", "Taxi Aéreo de México", "TAXIMEX", "Mexico",
    "TXN", "Texas National Airlines", "TEXAS NATIONAL", "United States",
    "TXO", "Taxis Aéreos de Sinaloa", "TAXIS SINALOA", "Mexico",
    "TXR", "Taxirey", "TAXIREY", "Mexico",
    "TXS", "Texas Airlines", "TEXAIR", "United States",
    "TXT", "Texas Air Charters", "TEXAS CHARTER", "United States",
    "TXU", "ATESA Aerotaxis Ecuatorianos", "ATESA", "Ecuador",
    "TXV", "Puerto Vallarta Taxi Aéreo", "TAXIVALLARTA", "Mexico",
    "TXZ", "Tex Star Air Freight", "TEX STAR", "United States",
    "TYA", "NordStar", "TAIMYR", "Russia",
    "TYF", "Tayflite", "TAYFLITE", "United Kingdom",
    "TYG", "Trygg-Flyg", "TRYGG", "Sweden",
    "TYJ", "TJS Malta Ltd.", "TYROLMALTA", "Malta",
    "TYR", "Tyrolean Airways", "TYROLEAN", "Austria",
    "TYW", "Tyrol Air Ambulance", "TYROL AMBULANCE", "Austria",
    "TZA", "Aero Tomza", "AERO TOMZA", "Mexico",
    "TZE", "Transporte Aéreo Ernesto Saenz", "TRANSPORTE SAENZ", "Mexico",
    "TZK", "Tajikistan International Airlines", "TAJIKISTAN", "Tajikistan",
    "TZP", "Zipair Tokyo", "ZIPPY", "Japan",
    "TZT", "Air Zambezi", "ZAMBEZI", "Zimbabwe",
    "TZU", "Servicios Aéreos Tamazula", "TAMAZULA", "Mexico",
    "UAA", "University Air Squadron", "", "United Kingdom",
    "UAB", "United Arabian Airlines", "UNITED ARABIAN", "Sudan",
    "UAC", "United Air Charters", "UNITAIR", "Zimbabwe",
    "UAD", "University Air Squadron", "", "United Kingdom",
    "UAE", "Emirates Airlines", "EMIRATES", "United Arab Emirates",
    "UAF", "United Arab Emirates Air Force", "UNIFORCE", "United Arab Emirates",
    "UAG", "Afra Airlines", "AFRALINE", "Ghana",
    "UAH", "Air Experience Flight  Cranwell", "", "United Kingdom",
    "UAI", "Union Africaine des Transports", "UNAIR", "Ivory Coast",
    "UAJ", "University Air Squadron", "", "United Kingdom",
    "UAK", "Kiev Aviation Plant", "AVIATION PLANT", "Ukraine",
    "UAL", "United Airlines", "UNITED", "United States",
    "UAR", "Aerostar Airlines", "AEROSTAR", "Ukraine",
    "UAS", "University Air Squadron", "", "United Kingdom",
    "UBA", "Myanma Airways", "UNIONAIR", "Myanmar",
    "UBD", "United Airways", "UNITED BANGLADESH", "Bangladesh",
    "UBG", "US-Bangla Airlines", "BANGLA STAR", "Bangladesh",
    "UCA", "CommutAir", "COMMUTAIR", "United States",
    "UCC", "Uganda Air Cargo", "UGANDA CARGO", "Uganda",
    "UCG", "Uniworld Air Cargo", "UNIWORLD", "Panama",
    "UCH", "US Airports Air Charter", "US CHARTER", "United States",
    "UCK", "Air Division of the Eastern Kazakhstan Region", "GALETA", "Kazakhstan",
    "UCO", "Ucoaviacion", "UCOAVIACION", "Spain",
    "UCR", "Aero-Charter Ukraine", "CHARTER UKRAINE", "Ukraine",
    "UCS", "United Carriers Systems", "UNITED CARRIERS", "United States",
    "UDA", "Psudiklat Perhubungan Udara/PLP", "UDARA", "Indonesia",
    "UDC", "DonbassAero", "DONBASS AERO", "Ukraine",
    "UDN", "Dniproavia", "DNIEPRO", "Ukraine",
    "UEA", "United Eagle Airlines", "UNITED EAGLE", "China",
    "UED", "Air LA", "AIR L-A", "United States",
    "UEJ", "Jetcorp", "JETCORP", "United States",
    "UES", "Ues-Avia Aircompany", "AVIASYSTEM", "Ukraine",
    "UEU", "United European Airlines", "UNITED EUROPEAN", "Romania",
    "UFA", "State Flight Academy of Ukraine", "FLIGHT ACADEMY", "Ukraine",
    "UFS", "United Feeder Service", "FEEDER EXPRESS", "United States",
    "UGA", "Air Uganda", "UGANDA", "Uganda",
    "UGC", "Urgemer Canarias", "URGEMER", "Spain",
    "UGD", "Uganda Airlines", "CRESTED", "Uganda",
    "UGL", "Inter-Island Air", "UGLY VAN", "United States",
    "UGN", "Yuzhnaya Aircompany", "PLUTON", "Kazakhstan",
    "UGP", "Shar Ink", "SHARINK", "Russia",
    "UHL", "Ukrainian Helicopters", "UKRAINE COPTERS", "Ukraine",
    "UHS", "Ulyanovsk Higher Civil Aviation School", "PILOT AIR", "Russia",
    "UIA", "UNI Air", "GLORY", "Taiwan",
    "UIT", "University of Tromsø School of Aviation", "ARCTIC", "Norway",
    "UJR", "Universal Jet Rental de Mexico", "UNIVERSAL JET", "Mexico",
    "UJT", "Universal Jet Aviation", "UNI-JET", "United States",
    "UJX", "Atlas Ukraine Airlines", "ATLAS UKRAINE", "Ukraine",
    "UKA", "Buzzaway Limited", "UKAY", "United Kingdom",
    "UKI", "UK International Airlines", "KHALIQ", "United Kingdom",
    "UKL", "Ukraine Air Alliance", "UKRAINE ALLIANCE", "Ukraine",
    "UKM", "UM Airlines", "UKRAINE MEDITERRANEE", "Ukraine",
    "UKN", "Ukraine Air Enterprise", "ENTERPRISE UKRAINE", "Ukraine",
    "UKP", "National Police Air Service", "POLICE", "United Kingdom",
    "UKR", "Air Ukraine", "AIR UKRAINE", "Ukraine",
    "UKS", "Ukrainian Cargo Airways", "CARGOTRANS", "Ukraine",
    "UKU", "Second Sverdlovsk Air Enterprise", "PYSHMA", "Russia",
    "UKW", "Lviv Airlines", "UKRAINE WEST", "Ukraine",
    "ULH", "Ultimate HELI", "ULTIMATEHELI", "South Africa",
    "ULR", "Ultimate Air", "VIPER", "South Africa",
    "ULS", "Carroll Air Service", "ULSTER", "United States",
    "ULT", "Ultrair", "ULTRAIR", "United States",
    "UMA", "Líneas Aéreas del Humaya", "HUMAYA", "Mexico",
    "UMB", "Air Umbria", "AIR UMBRIA", "Italy",
    "UMK", "Yuzhmashavia", "YUZMASH", "Ukraine",
    "UNC", "Uni-Fly", "UNICOPTER", "Denmark",
    "UND", "Atuneros Unidos de California", "ATUNEROS UNIDOS", "Mexico",
    "UNF", "Union Flights", "UNION FLIGHTS", "United States",
    "UNJ", "Universal Jet", "PROJET", "Spain",
    "UNO", "United Nations", "UNITED NATIONS", "n/a",
    "UNR", "Rivne Universal Avia", "RIVNE UNIVERSAL", "Ukraine",
    "UNS", "Unsped Paket Servisi", "UNSPED", "Turkey",
    "UNT", "Servicios Aéreos Universitarios", "UNIVERSITARIO", "Mexico",
    "UNU", "Unifly Servizi Aerei", "UNIEURO", "Italy",
    "UNY", "Lund University School of Aviation", "UNIVERSITY", "Sweden",
    "UPL", "Ukrainian Pilot School", "PILOT SCHOOL", "Ukraine",
    "UPS", "United Parcel Service", "UPS", "United States",
    "URA", "Aircompany Rosavia", "ROSAVIA", "Ukraine",
    "URF", "Surf Air", "SURF AIR", "United States",
    "URG", "Air Urga", "URGA", "Ukraine",
    "URJ", "Star Air", "STARAV", "Pakistan",
    "URN", "Turan Air", "TURAN", "Azerbaijan",
    "URP", "ARP 410 Airlines", "AIR-ARP", "Ukraine",
    "URV", "Uraiavia", "URAI", "Russia",
    "URY", "Century Aviation", "CENTURY AVIA", "Mexico",
    "USB", "Tusheti", "TUSHETI", "Georgia",
    "USC", "AirNet Express", "STAR CHECK", "United States",
    "USF", "USAfrica Airways", "AFRICA EXPRESS", "United States",
    "USH", "US Helicopter", "US-HELI", "United States",
    "USJ", "US Jet", "USJET", "United States",
    "USK", "Skif-Air", "SKIF-AIR", "Ukraine",
    "USN", "Smarkand Aero Servise", "SAMAS", "Uzbekistan",
    "UST", "Austro Aéreo", "AUSTRO AEREO", "Ecuador",
    "USW", "Special Aviation Works", "AKSAR", "Uzbekistan",
    "USX", "US Express", "AIR EXPRESS", "United States",
    "UTA", "UTair Aviation", "UTAIR", "Russia",
    "UTM", "TAPC Aviatrans Aircompany", "AVIATAPS", "Uzbekistan",
    "UTN", "UTair-Ukraine", "UT Ukraine", "Ukraine",
    "UTR", "Utair South Africa", "AIRUT", "South Africa",
    "UTS", "Ukrainian State Air Traffic Service Enterprise", "AIRRUH", "Ukraine",
    "UTT", "Transarabian Transportation Services", "ARABIAN TRANSPORT", "Uganda",
    "UTU", "Urartu-Air", "", "Armenia",
    "UTX", "Avfinity", "", "United States",
    "UTY", "Alliance Airlines", "UNITY", "Australia",
    "UVA", "Universal Airways", "UNIVERSAL", "United States",
    "UVG", "Universal Airlines", "GUYANA JET", "Guyana",
    "UVM", "Uvavemex", "UVAVEMEX", "Mexico",
    "UVN", "United Aviation", "UNITED AVIATION", "Kuwait",
    "UVT", "Auvia Air", "AUVIA", "Indonesia",
    "UYA", "Yute Air Alaska", "", "United States",
    "UZA", "Constanta Airline", "CONSTANTA", "Ukraine",
    "UZB", "Uzbekistan Airways", "UZBEK", "Uzbekistan",
    "UZS", "Samarkand Airways", "SOGDIANA", "Uzbekistan",
    "VAA", "Van Air Europe", "EUROVAN", "Czech Republic",
    "VAB", "Airtrans Ltd", "", "Russia",
    "VAC", "Vacationair", "VACATIONAIR", "Canada",
    "VAD", "Aero Taxi Los Valles", "VALLES", "Spain",
    "VAE", "Air Evans", "AIR-EVANS", "Spain",
    "VAG", "Vietravel Airlines", "VIETRAVEL AIR", "Vietnam",
    "VAI", "Avalair", "AIR AVALAIR", "Serbia",
    "VAL", "Voyageur Airways", "VOYAGEUR", "Canada",
    "VAM", "Ameravia", "AMERAVIA", "Uruguay",
    "VAN", "Caravan Air", "CAMEL", "Mauritania",
    "VAP", "Phuket Air", "PHUKET AIR", "Thailand",
    "VAR", "Veca Airlines", "VECA", "El Salvador",
    "VAS", "ATRAN Cargo Airlines", "ATRAN", "Russian Federation",
    "VAT", "Visionair", "VISIONAIR", "Ireland",
    "VAW", "Fly2Sky", "SOFIA JET", "Bulgaria",
    "VAZ", "Airlines 400", "REMONT AIR", "Russia",
    "VBA", "V Bird Airlines Netherlands", "VEEBEE", "Netherlands",
    "VBC", "AVB-2004 Ltd", "AIR VICTOR", "Bulgaria",
    "VBD", "V-Berd-Avia", "VEEBIRD-AVIA", "Armenia",
    "VBG", "North-West Air Transport Company - Vyborg", "VYBORG AIR", "Russia",
    "VBW", "Air Burkina", "BURKINA", "Burkina Faso",
    "VCA", "VICA - Viacao Charter Aéreos", "VICA", "Brazil",
    "VCB", "Real Aero Club de Vizcaya", "", "Spain",
    "VCH", "Consorcio Helitec", "CONSORCIO HELITEC", "Venezuela",
    "VCI", "CI-Tours", "CI-TOURS", "Ivory Coast",
    "VCM", "Volare Air Charter Company", "CARMEN", "United States",
    "VCN", "Execujet Charter", "AVCON", "Switzerland",
    "VCR", "Cruiser Linhas Aéreas", "VOE CRUISER", "Brazil",
    "VCT", "Viscount Air Service", "VISCOUNT AIR", "United States",
    "VCV", "Conviasa", "CONVIASA", "Venezuela",
    "VCX", "Ocean Airlines", "OCEANCARGO", "Italy",
    "VDA", "Volga-Dnepr Airlines", "VOLGA", "Russia",
    "VDO", "Servicios Aéreos Avandaro", "AVANDARO", "Mexico",
    "VDR", "Voldirect", "VOLDIR", "France",
    "VEA", "Vega Airlines", "VEGA AIRLINES", "Bulgaria",
    "VEC", "Venescar Internacional", "VECAR", "Venezuela",
    "VEE", "Victor Echo", "VICTOR ECHO", "Spain",
    "VEG", "Aerovega", "AEROVEGA", "Mexico",
    "VEJ", "Aero Ejecutivos", "VENEJECUTIV", "Venezuela",
    "VEN", "Transaven", "TRANSAVEN AIRLINE", "Venezuela",
    "VER", "Almaver", "ALMAVER", "Mexico",
    "VES", "Vieques Air Link", "VIEQUES", "United States",
    "VFC", "Vietnam Air Services Company (VASCO)", "VASCO AIR", "Vietnam",
    "VFT", "VZ Flights", "ZETA FLIGHTS", "Mexico",
    "VGC", "Vanguardia en Aviación en Colima", "VANGUARDIA COLIMA", "Mexico",
    "VGD", "Vanguard Airlines", "VANGUARD AIR", "United States",
    "VGF", "Aerovista Gulf Express", "VISTA GULF", "United Arab Emirates",
    "VGN", "Virgin Nigeria Airways", "VIRGIN NIGERIA", "Nigeria",
    "VGO", "Sabaidee Airways", "VIRGO", "Thailand",
    "VGS", "Stichting Vliegschool 16Hoven", "SMART", "Netherlands",
    "VGV", "Vologda State Air Enterprise", "VOLOGDA AIR", "Russia",
    "VHA", "VH-Air Industrie", "AIR V-H", "Angola",
    "VHM", "VHM Schul-und-Charterflug", "EARLY BIRD", "Germany",
    "VHT", "Corporate Flight International", "VEGAS HEAT", "United States",
    "VIB", "Vibroair Flugservice", "VITUS", "Germany",
    "VIC", "VIP Servicios Aéreos Ejecutivos", "VIP-EJECUTIVO", "Mexico",
    "VIE", "VIP Empresarial", "VIP EMPRESARIAL", "Mexico",
    "VIF", "VIF Luftahrt", "VIENNA FLIGHT", "Austria",
    "VIG", "Vega Aviation", "VEGA AVIATION", "Sudan",
    "VIH", "Vichi", "VICHI", "Moldova",
    "VIK", "Viking Airlines", "SWEDJET", "Sweden",
    "VIL", "V I Airlink", "TURTLE DOVE", "British Virgin Islands",
    "VIM", "Air VIA", "CRYSTAL", "Bulgaria",
    "VIN", "Vinair Aeroserviços", "VINAIR", "Portugal",
    "VIP", "Tag Aviation UK", "SOVEREIGN", "United Kingdom",
    "VIR", "Virgin Atlantic", "VIRGIN", "United Kingdom",
    "VIV", "Aeroenlaces Nacionales", "AEROENLACES", "Mexico",
    "VIZ", "Aerovis Airlines", "AEROVIZ", "Ukraine",
    "VJA", "ValuJet Airlines", "CRITTER", "United States",
    "VJC", "Vietjet Air", "VIETJET", "Vietnam",
    "VJE", "AvJet Routing", "", "United Arab Emirates",
    "VJM", "Viajes Ejecutivos Mexicanos", "VIAJES MEXICANOS", "Mexico",
    "VJT", "Vistajet", "VISTA", "Canada",
    "VLA", "Valan International Cargo Charter", "NALAU", "South Africa",
    "VLB", "Air Volta", "VOLTA", "Bulgaria",
    "VLE", "C.A.I. Second", "VOLA", "Italy",
    "VLF", "DFS UK Limited", "VOLANTE", "United Kingdom",
    "VLG", "Vueling Airlines", "VUELING", "Spain",
    "VLK", "Vladivostok Air", "VLADAIR", "Russia",
    "VLL", "RAF Valley SAR Training Unit", "", "United Kingdom",
    "VLN", "Valan Limited", "VALAN", "Moldova",
    "VLR", "Aerolíneas Villaverde", "VILLAVERDE", "Mexico",
    "VLS", "Aero Virel", "VIREL", "Mexico",
    "VLT", "Vertical-T Air Company", "VERTICAL", "Russia",
    "VLU", "Valuair", "VALUAIR", "Singapore",
    "VLV", "Avialift Vladivostok", "VLADLIFT", "Russia",
    "VLX", "Biz Jet Charter", "AVOLAR", "United States",
    "VMA", "Vero Monmouth Airlines", "VERO MONMOUTH", "United States",
    "VME", "Aviación Comercial de América", "AVIAMERICA", "Mexico",
    "VMM", "Grupo Vuelos Mediterraneo", "VUELOS MED", "Spain",
    "VMP", "Execujet Scandinavia", "VAMPIRE", "Denmark",
    "VMS", "His Majesty King Maha Vajiralongkorn", "VICTOR MIKE[32]", "Thailand",
    "VMX", "Aeroventas de Mexico", "VENTA", "Mexico",
    "VNA", "Empresa Aviación Interamericana", "EBBA", "Uruguay",
    "VNE", "Empresa Venezolana", "VENEZOLANA", "Venezuela",
    "VNG", "Aero Servicios Vanguardia", "VANGUARDIA", "Mexico",
    "VNK", "Vipport Joint Stock Company", "", "Russia",
    "VNL", "Vanilla Air", "VANILLA", "Japan",
    "VNT", "Avient Air Zambia", "AVIENT", "Zambia",
    "VNX", "Fly Advance", "VANCE", "United States",
    "VNZ", "Tbilaviamsheni", "TBILAVIA", "Georgia",
    "VOA", "Viaggio Air", "VIAGGIO", "Bulgaria",
    "VOE", "Volotea", "VOLOTEA", "Spain",
    "VOG", "Voyager Airlines", "VOYAGER AIR", "Bangladesh",
    "VOI", "Volaris", "VOLARIS", "Mexico",
    "VOL", "Blue Chip Jet", "BLUE SPEED", "Sweden",
    "VOR", "Flight Calibration Services Ltd.", "FLIGHT CAL", "United Kingdom",
    "VOS", "Rovos Air", "ROVOS", "South Africa",
    "VOZ", "Virgin Australia", "VELOCITY", "Australia",
    "VPA", "DanubeWings", "VIP TAXI", "Slovakia",
    "VPB", "Veteran Air", "VETERAN", "Ukraine",
    "VPV", "VIP-Avia", "VIP AVIA", "Georgia",
    "VRA", "Vertair", "VERITAIR", "United Kingdom",
    "VRB", "Silverback Cargo Freighters", "SILVERBACK", "Rwanda",
    "VRC", "Taxi de Veracruz", "VERACRUZ", "Mexico",
    "VRD", "Virgin America", "REDWOOD", "United States",
    "VRE", "Volare Airlines", "UKRAINE VOLARE", "Ukraine",
    "VRI", "Aerotaxi Villa Rica", "VILLARICA", "Mexico",
    "VRL", "Voar Lda", "VOAR LINHAS", "Angola",
    "VRN", "Varig", "VARIG", "Brazil",
    "VRO", "Aerovitro", "AEROVITRO", "Mexico",
    "VRS", "Sirvair", "VAIRSA", "Mexico",
    "VRT", "Averitt Air Charter", "AVERITT", "United States",
    "VSA", "Avstar Aviation", "STARBIRD", "South Africa",
    "VSB", "Vickers Limited", "VICKERS", "United Kingdom",
    "VSC", "Aeronautic de Los Pirineos", "", "Spain",
    "VSG", "AirClass Airways", "VISIG", "Spain",
    "VSN", "Vision Airways Corporation", "VISION", "Canada",
    "VSO", "Voronezh Aircraft Manufacturing Society", "VASO", "Russia",
    "VSR", "Aviostart AS", "AVIOSTART", "Bulgaria",
    "VSS", "Virign Islands Seaplane Shuttle", "WATERBIRD", "United States",
    "VSV", "Scat Air", "VLASTA", "Kazakhstan",
    "VTA", "Air Tahiti", "AIR TAHITI", "French Polynesia",
    "VTB", "Jet Stream Charter KFT.", "SUXAIR", "Hungary",
    "VTC", "Vuelos Especializados Tollocan", "VUELOS TOLLOCAN", "Mexico",
    "VTE", "Contour Airlines", "VOLUNTEER", "United States",
    "VTG", "Aviação Transportes Aéreos e Cargas", "ATACARGO", "Angola",
    "VTH", "Vuelos Corporativos de Tehuacan", "VUELOS TEHUACAN", "Mexico",
    "VTI", "Vistara", "Vistara", "India",
    "VTK", "Vostok Airlines", "VOSTOK", "Russia",
    "VTL", "Victor Tagle Larrain", "VITALA", "Chile",
    "VTM", "Aeronaves TSM", "AERONAVES TSM", "Mexico",
    "VTS", "Everts Air Alaska/Everts Air Cargo", "EVERTS", "United States",
    "VTT", "Avia Trans Air Transport", "VIATRANSPORT", "Sudan",
    "VTV", "Vointeh", "VOINTEH", "Bulgaria",
    "VTX", "Verataxis", "VERATAXIS", "Mexico",
    "VTY", "Air Midwest (Nigeria)", "VICTORY", "Nigeria",
    "VUE", "AD Aviation", "FLIGHTVUE", "United Kingdom",
    "VUL", "Elios", "ELIOS", "Italy",
    "VUO", "Aerovuelox", "AEROVUELOX", "Mexico",
    "VUS", "Vuela Bus", "VUELA BUS", "Mexico",
    "VVC", "Viva Air Colombia", "Viva Air Colombia", "Colombia",
    "VVF", "Dunyaya Bakis Hava Tasimaciligi", "WORLDFOCUS", "Turkey",
    "VVG", "Aerovilla", "AEROVILLA", "Colombia",
    "VVV", "Valair Aviação Lda", "VALAIRJET", "Portugal",
    "VXG", "Avirex", "AVIREX-GABON", "Gabon",
    "VXN", "Sunset Aviation", "VIXEN", "United States",
    "VXP", "Avelo Airlines", "AVELO", "United States",
    "VXX", "Aviaexpress Aircompany", "EXPRESSAVIA", "Ukraine",
    "VYT", "RAF Valley Flying Training Unit", "ANGLESEY", "United Kingdom",
    "VZL", "Vzlyet", "VZLYET", "Russia",
    "VZR", "Aviazur", "IAZUR", "France",
    "WAA", "Westair Aviation", "WESTAIR WINGS", "Namibia",
    "WAB", "Aero Industries Inc", "WABASH", "United States",
    "WAC", "West African Cargo Airlines", "WESTAF CARGO", "Mauritania",
    "WAD", "RAF Waddington", "VULCAN", "United Kingdom",
    "WAE", "Western Air Express", "WESTERN EXPRESS", "United States",
    "WAF", "Flamenco Airways", "FLAMENCO", "United States",
    "WAG", "Wisconsin Air National Guard", "", "United States",
    "WAL", "Western Arctic Air", "WESTERN ARCTIC", "Canada",
    "WAM", "Air Taxi & Cargo", "TAXI CARGO", "Sudan",
    "WAN", "Wataniya Airways", "WATANIYA", "Kuwait",
    "WAP", "Arrow Panama", "ARROW PANAMA", "Panama",
    "WAR", "NZ Warbirds Association", "WARBIRDS", "New Zealand",
    "WAS", "Walsten Air Services", "WALSTEN", "Canada",
    "WAT", "Wings Air Transport", "", "Sudan",
    "WAV", "Warbelow's Air Ventures", "WARBELOW", "United States",
    "WAW", "Wings Airways", "WING SHUTTLE", "United States",
    "WAY", "Airways", "GARONNE", "France",
    "WAZ", "Wizz Air Abu Dhabi", "WIZZ SKY", "United Arab Emirates",
    "WBA", "Finncomm Airlines", "WESTBIRD", "Finland",
    "WBR", "Multi-Aero", "WEBER", "United States",
    "WCA", "West Coast Airways", "WEST-LEONE", "Sierra Leone",
    "WCB", "West Africa Airlines", "KILO YANKEE", "Ghana",
    "WCC", "West Coast Charters", "WEST COAST", "United States",
    "WCG", "West Coast Airlines", "WHISKY INDIA", "Ghana",
    "WCO", "Columbia Helicopters", "COLUMBIA HELI", "United States",
    "WCP", "Primaris Airlines", "WHITECAP", "United States",
    "WCR", "West Caribbean Costa Rica", "WEST CARIBBEAN", "Costa Rica",
    "WCW", "West Caribbean Airways", "WEST", "Colombia",
    "WCY", "Viking Express", "TITAN AIR", "United States",
    "WDA", "Wimbi Dira Airways", "WIMBI DIRA", "Democratic Republic of Congo",
    "WDG", "Ministry of Agriculture  Fisheries and Food", "WATCHDOG", "United Kingdom",
    "WDK", "Oxford Air Services", "WOODSTOCK", "United Kingdom",
    "WDL", "WDL Aviation", "WDL", "Germany",
    "WDR", "Air Net Private Charter", "WIND RIDER", "United States",
    "WDS", "Four Winds Aviation", "WINDS", "United States",
    "WDY", "Phoenix Airline Services", "WINDYCITY", "United States",
    "WEA", "White Eagle Aviation", "WHITE EAGLE", "Poland",
    "WEB", "WebJet Linhas Aéreas", "WEB-BRASIL", "Brazil",
    "WEC", "Universal Airlines", "AIRGO", "United States",
    "WEL", "Veles  Ukrainian Aviation Company", "VELES", "Ukraine",
    "WEN", "WestJet Encore", "ENCORE", "Canada",
    "WES", "Western Express Air Lines", "WEST EX", "Canada",
    "WEV", "Victoria International Airways", "VICTORIA UGANDA", "Uganda",
    "WEW", "West Wind Aviation", "WESTWIND", "Canada",
    "WEX", "Wings Express", "WINGS EXPRESS", "United States",
    "WFC", "Swift Copters", "SWIFTCOPTERS", "Switzerland",
    "WFD", "BAE Systems", "AVRO", "United Kingdom",
    "WFO", "Wilbur's Flight Operations", "WILBURS", "United States",
    "WFT", "Aircharters Worldwide", "WORLD FLIGHT", "United States",
    "WGA", "Vega Air Company", "WEGA FRANKO", "Ukraine",
    "WGN", "Western Global Airlines", "WESTERN GLOBAL", "United States",
    "WGP", "Williams Grand Prix Engineering", "GRAND PRIX", "United Kingdom",
    "WGS", "Airwings oy", "AIRWINGS", "Finland",
    "WGT", "Volkswagen AirService GmbH", "WORLDGATE", "United Kingdom",
    "WHE", "Westland Helicopters", "WESTLAND", "United Kingdom",
    "WHH", "Richy Skylark", "", "Sri Lanka",
    "WHR", "Hummingbird Helicopter Service", "WHIRLEYBIRD", "United States",
    "WHS", "Wiking Helikopter Service", "WEEKING", "Germany",
    "WHT", "White", "WHITEJET", "Portugal",
    "WHY", "Air Sorel", "AIR SOREL", "Canada",
    "WIA", "Windward Islands Airways International", "WINDWARD", "Netherlands",
    "WIF", "Widerøe", "WIDEROE", "Norway",
    "WIG", "Wiggins Airways", "WIGGINS AIRWAYS", "United States",
    "WIL", "Aero Air", "WILLIAMETTE", "United States",
    "WIN", "Winlink", "WINLINK", "Saint Lucia",
    "WIS", "Paccair", "WISCAIR", "United States",
    "WIT", "RAF Wittering", "STRIKER", "United Kingdom",
    "WIW", "V-avia Airline", "VEE-AVIA", "Ukraine",
    "WIZ", "Micromatter Technology Solutions", "WIZARD", "United Kingdom",
    "WJA", "WestJet", "WESTJET", "Canada",
    "WKH", "Kharkov Aircraft Manufacturing Company", "WEST-KHARKOV", "Ukraine",
    "WLA", "Airwaves Airlink", "AIRLIMITED", "Zambia",
    "WLB", "Wings of Lebanon Aviation", "WING LEBANON", "Lebanon",
    "WLC", "Welcome Air", "WELCOMEAIR", "Austria",
    "WLG", "Air Volga", "GOUMRAK", "Russia",
    "WLK", "Skyrover CC", "SKYWATCH", "South Africa",
    "WLR", "Air Walser", "AIRWALSER", "Italy",
    "WLS", "Air Wales Virtual", "WALES", "United Kingdom",
    "WLT", "Aviation Partners", "WINGLET", "United States",
    "WLV", "Aviation North", "WOLVERINE", "United States",
    "WLX", "West Air Luxembourg", "WEST LUX", "Luxembourg",
    "WML", "Chantilly Air", "MARLIN", "United States",
    "WMT", "Wizz Air Malta", "WIZZ AIR MALTA", "Malta",
    "WNA", "Winair", "WINAIR", "United States",
    "WNR", "Wondair on Demand Aviation", "WONDAIR", "Spain",
    "WOA", "World Airways", "WORLD", "United States",
    "WOK", "Kovar Air", "WOKAIR", "Czech Republic",
    "WOL", "Wings Aviation", "WINGJET", "Guyana",
    "WON", "Wings Air", "WINGS ABADI", "Indonesia",
    "WOW", "WOW air", "WOW air", "Iceland",
    "WPA", "Western Pacific Airservice", "WESTPAC", "Solomon Islands",
    "WPK", "Air-Lift Associates", "WOLFPACK", "United States",
    "WPR", "Auckland Regional Rescue Helicopter Trust", "WESTPAC RESCUE", "New Zealand",
    "WPT", "Wapiti Aviation", "WAPITI", "Canada",
    "WRA", "White River Air Services", "", "Canada",
    "WRF", "Wright Air Service", "WRIGHT FLYER", "United States",
    "WRR", "WRA Inc", "WRAP AIR", "United States",
    "WSA", "Westgates Airlines", "WESTATES", "United States",
    "WSC", "Westair Cargo Airlines", "WESTCAR", "Côte d'Ivoire",
    "WSF", "West African Airlines", "", "Benin",
    "WSG", "Wasaya Airways", "WASAYA", "Canada",
    "WSI", "Wind Spirit Air", "WIND SPIRIT", "United States",
    "WSL", "Westflight Aviation", "WEST LINE", "United Kingdom",
    "WSM", "Wisman Aviation", "WISMAN", "United States",
    "WSN", "Advanced Air", "WINGSPAN", "United States",
    "WST", "Western Air", "WESTERN BAHAMAS", "Bahamas",
    "WSW", "Swoop", "SWOOP", "Canada",
    "WTA", "Africa West", "WEST TOGO", "Togo",
    "WTC", "Weasua Air Transport Company", "WATCO", "Liberia",
    "WTF", "West African Air Transport", "WESTAF AIRTRANS", "Senegal",
    "WTN", "BAE Systems", "TARNISH", "United Kingdom",
    "WTP", "Westpoint Air", "WESTPOINT", "Canada",
    "WTV", "Western Aviators", "WESTAVIA", "United States",
    "WUK", "Wizz Air UK", "WIZZ GO", "United Kingdom",
    "WVA", "Hand D Aviation", "WABASH VALLEY", "United States",
    "WWD", "Westward Airways", "WESTWARD", "United States",
    "WWG", "Aereo WWG", "AERO-W", "Mexico",
    "WWI", "Worldwide Jet Charter", "WORLDWIDE", "United States",
    "WWL", "Whyalla Airlines", "", "Australia",
    "WWM", "World Wing Aviation", "MANAS WING", "Kyrgyzstan",
    "WWS", "Worldwide Aviation Services", "", "Pakistan",
    "WWW", "Janet", "JANET", "United States",
    "WYC", "Wycombe Air Centre", "WYCOMBE", "United Kingdom",
    "WYG", "Wyoming Airlines", "WYOMING", "United States",
    "WYT", "2 Sqn No 1 Elementary Flying Training School", "WYTON", "United Kingdom",
    "WZZ", "Wizz Air", "WIZZAIR", "Hungary",
    "XAA", "Aeronautical Radio Inc", "", "United States",
    "XAB", "Xabre Aerolineas", "AERO XABRE", "Mexico",
    "XAC", "Air Charter World", "", "United States",
    "XAD", "Certified Air Dispatch", "", "United States",
    "XAE", "Xair", "AURA", "Czech Republic",
    "XAF", "Executive Air Fleet", "", "United States",
    "XAH", "Executive Aircraft Services", "", "United Kingdom",
    "XAK", "Airkenya", "SUNEXPRESS", "Kenya",
    "XAM", "AMR Services Corporation", "ALLIANCE", "United States",
    "XAO", "Airline Operations Services", "", "United States",
    "XAP", "Direct Air trading as Midway Connection", "MID-TOWN", "United States",
    "XAR", "XpressAir", "XPRESS", "Indonesia",
    "XAS", "PHH Aviation System", "", "United States",
    "XAT", "AT and T Aviation Division", "", "United States",
    "XAU", "Aerolink Uganda", "PEARL", "Uganda",
    "XAV", "Aviaprom Enterprises", "AVIAPROM", "Russia",
    "XAX", "AirAsia X", "XANADU", "Malaysia",
    "XBG", "City of Bangor", "", "United States",
    "XBO", "Baseops International", "", "United States",
    "XCA", "Colt Transportes Aereos", "COLT", "Brazil",
    "XCC", "Ecoturistica de Xcalak", "XCALAK", "Mexico",
    "XCL", "Contel ASC", "", "United States",
    "XCO", "Compuflight Operations Service", "", "United States",
    "XCS", "Compuserve Incorporated", "", "United States",
    "XCT", "Aero Costa Taxi Aéreo", "AEROCOSTAXI", "Mexico",
    "XCX", "Citibank", "", "United States",
    "XDA", "Bureau Veritas", "", "France",
    "XDD", "Lockheed DUATS", "", "United States",
    "XDS", "Dispatch Services", "", "United States",
    "XDT", "Date Transformation Corp", "", "United States",
    "XDY", "Dynair Services", "", "United States",
    "XEC", "Air Executive Charter", "", "Germany",
    "XEL", "Excel Charter", "HELI EXCEL", "United Kingdom",
    "XER", "Xerox Corporation", "XEROX", "United States",
    "XFA", "FlyAsianXpress", "FAX AIR", "Malaysia",
    "XFS", "American Flight Service Systems", "", "United States",
    "XFX", "Airways Corporation of New Zealand", "AIRCORP", "New Zealand",
    "XGA", "General Aviation Terminal", "", "Canada",
    "XGG", "IMP Group Aviation Services", "", "Canada",
    "XGS", "Global System", "", "United States",
    "XGW", "Global Weather Dynamics", "", "United States",
    "XJA", "Assistance Aeroportuaire de L'Aeroport de Paris", "", "France",
    "XJC", "XJC Limited", "EXCLUSIVE JET", "United Kingdom",
    "XJE", "X-Jet", "", "Austria",
    "XJT", "Xjet Limited", "XRAY", "United Kingdom",
    "XKA", "Kavouras Inc", "", "United States",
    "XKX", "ASECNA", "", "France",
    "XLA", "Excel Airways", "EXPO", "United Kingdom",
    "XLB", "Aircraft Performance Group", "", "United States",
    "XLD", "Jeppesen Data Plan", "", "United States",
    "XLG", "Lockheed Air Terminal", "", "United States",
    "XLK", "Safarilink Aviation", "SAFARILINK", "Kenya",
    "XLL", "Air Excel", "TINGA-TINGA", "Tanzania",
    "XLT", "Empressa Brasileira de Infra-Estrutura Aeroportuaria-Infraero", "INFRAERO", "Brazil",
    "XMA", "Martin Aviation Services", "", "United States",
    "XME", "Australian airExpress", "AUS-CARGO", "Australia",
    "XMG", "AMS Group", "", "Russia",
    "XMR", "Irish Aviation Authority", "AUTHORITY", "Ireland",
    "XMS", "British Airways Santa", "SANTA", "United Kingdom",
    "XMX", "SENEAM", "SENEAM", "Mexico",
    "XNA", "Express Net Airlines", "EXPRESSNET", "United States",
    "XNR", "Taxi Aero Del Norte", "TAXI NORTE", "Mexico",
    "XNS", "Navtech System Support", "", "Canada",
    "XNT", "Notams International", "", "United States",
    "XNV", "Navinc Airlines Services", "", "United States",
    "XOJ", "XOJet", "EXOJET", "United States",
    "XPA", "Pan Am Weather Systems", "", "United States",
    "XPE", "Amira Air", "EXPERT", "Austria",
    "XPG", "Southport Air Service", "", "United States",
    "XPL", "Express Line Aircompany", "EXPRESSLINE", "United States",
    "XPN", "Aero Express", "", "Niger",
    "XPR", "Air-Rep", "", "United States",
    "XPS", "XP International", "XP PARCEL", "Netherlands",
    "XPX", "Phoenix Flight Operations", "", "United States",
    "XRA", "Intensive Air", "INTENSIVE", "South Africa",
    "XRC", "Express Air Cargo", "TUNISIA CARGO", "Tunisia",
    "XRO", "ExxAero", "CRAMER", "Netherlands",
    "XSA", "Spectrum Air Service", "", "United States",
    "XSL", "Excel-Aire Service", "EXCELAIRE", "United States",
    "XSN", "Stephenville Aviation Services", "", "Canada",
    "XSR", "Executive Flight Services", "AIRSHARE", "United States",
    "XSS", "Aero Express Intercontinental", "INTER EXPRESS", "Mexico",
    "XTA", "Servicios Aéreos Textra", "TEXTRA", "Mexico",
    "XTJ", "Advance Aviation Services", "", "United States",
    "XTO", "Express Tours", "EXPRESS TOURS", "Canada",
    "XTR", "Sector Airlines", "EXTER", "Canada",
    "XWS", "WSI Corporation", "", "United States",
    "XWW", "World Weatherwatch", "", "Canada",
    "XXS", "Skyplan Services", "", "Canada",
    "XXV", "AASANA", "", "Bolivia",
    "XXX", "ASL (Air Service Liege)", "", "Belgium",
    "XYZ", "Island Air Express", "RAINBIRD", "United States",
    "YAK", "Yakolev", "YAK AVIA", "Russia",
    "YBE", "Stewart Aviation Services", "YELLOW BIRD", "United States",
    "YFS", "Young Flying Service", "YOUNG AIR", "United States",
    "YOG", "Central Aviation", "YOGAN AIR", "United States",
    "YRG", "Yak Air", "YAKAIR GEORGIA", "Georgia",
    "YWZ", "West Coast Air", "COAST AIR", "Canada",
    "YZR", "Suparna Airlines", "YANGTZE RIVER", "China",
    "ZAI", "Zaire Aero Service", "ZASAIR", "Democratic Republic of Congo",
    "ZAK", "Zambia Skyways", "ZAMBIA SKIES", "Zambia",
    "ZAR", "Zairean Airlines", "ZAIREAN", "Domocratic Republic of Congo",
    "ZAV", "Zetavia", "ZETAVIA", "Ukraine",
    "ZAW", "Zoom Airways", "ZED AIR", "Bangladesh",
    "ZBA", "Boskovic Air Charters Limited", "BOSKY", "Kenya",
    "ZMA", "Zambezi Airlines", "ZAMBEZI WINGS", "Zambia",
    "ZZM", "Agence Nationale des Aerodromes et de la Meteorologie", "", "Ivory Coast",
    NULL
};

QHash<QString, const Airline*> Airline::m_icaoHash;
QHash<QString, const Airline*> Airline::m_callsignHash;

const Airline *Airline::getByICAO(const QString& icao)
{
    if (m_icaoHash.contains(icao)) {
        return m_icaoHash.value(icao);
    } else {
        return nullptr;
    }
}

const Airline *Airline::getByCallsign(const QString& callsign)
{
    if (m_callsignHash.contains(callsign)) {
        return m_callsignHash.value(callsign);
    } else {
        return nullptr;
    }
}

Airline::Init Airline::m_init;

Airline::Init::Init()
{
    const char **s = Airline::Init::m_airlines;
    while (s[0])
    {
        const Airline *airline = new Airline(s[0], s[1], s[2], s[3]);
        Airline::m_icaoHash.insert(airline->m_icao, airline);
        Airline::m_callsignHash.insert(airline->m_callsign, airline);
        s += 4;
    }
}

Airline::Init::~Init()
{
    qDeleteAll(m_icaoHash);
}
