/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.CommonsArchiver;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.CompressionType;

final class CommonsStreamFactory {
    private static CompressorStreamFactory compressorStreamFactory;
    private static ArchiveStreamFactory archiveStreamFactory;

    private CommonsStreamFactory() {
    }

    static ArchiveInputStream createArchiveInputStream(String archiverName, InputStream in) throws ArchiveException {
        return archiveStreamFactory.createArchiveInputStream(archiverName, in);
    }

    static ArchiveInputStream createArchiveInputStream(ArchiveFormat archiveFormat, InputStream in) throws ArchiveException {
        return CommonsStreamFactory.createArchiveInputStream(archiveFormat.getName(), in);
    }

    static ArchiveInputStream createArchiveInputStream(CommonsArchiver archiver, InputStream in) throws ArchiveException {
        return CommonsStreamFactory.createArchiveInputStream(archiver.getArchiveFormat(), in);
    }

    static ArchiveInputStream createArchiveInputStream(InputStream in) throws ArchiveException {
        return archiveStreamFactory.createArchiveInputStream(new BufferedInputStream(in));
    }

    static ArchiveInputStream createArchiveInputStream(File archive) throws IOException, ArchiveException {
        return CommonsStreamFactory.createArchiveInputStream(new BufferedInputStream(new FileInputStream(archive)));
    }

    static ArchiveOutputStream createArchiveOutputStream(String archiverName, OutputStream out) throws ArchiveException {
        return archiveStreamFactory.createArchiveOutputStream(archiverName, out);
    }

    static ArchiveOutputStream createArchiveOutputStream(ArchiveFormat format, File archive) throws IOException, ArchiveException {
        return CommonsStreamFactory.createArchiveOutputStream(format.getName(), new FileOutputStream(archive));
    }

    static ArchiveOutputStream createArchiveOutputStream(CommonsArchiver archiver, File archive) throws IOException, ArchiveException {
        return CommonsStreamFactory.createArchiveOutputStream(archiver.getArchiveFormat(), archive);
    }

    static CompressorInputStream createCompressorInputStream(File source) throws IOException, CompressorException {
        return CommonsStreamFactory.createCompressorInputStream(new BufferedInputStream(new FileInputStream(source)));
    }

    static CompressorInputStream createCompressorInputStream(CompressionType type, File source) throws IOException, CompressorException {
        return CommonsStreamFactory.createCompressorInputStream(type, new BufferedInputStream(new FileInputStream(source)));
    }

    static CompressorInputStream createCompressorInputStream(CompressionType compressionType, InputStream in) throws CompressorException {
        return compressorStreamFactory.createCompressorInputStream(compressionType.getName(), in);
    }

    static CompressorInputStream createCompressorInputStream(InputStream in) throws CompressorException {
        return compressorStreamFactory.createCompressorInputStream(in);
    }

    static CompressorOutputStream createCompressorOutputStream(CompressionType compressionType, File destination) throws IOException, CompressorException {
        return CommonsStreamFactory.createCompressorOutputStream(compressionType.getName(), new FileOutputStream(destination));
    }

    static CompressorOutputStream createCompressorOutputStream(CommonsCompressor compressor, File destination) throws IOException, CompressorException {
        return CommonsStreamFactory.createCompressorOutputStream(compressor.getCompressionType(), destination);
    }

    static CompressorOutputStream createCompressorOutputStream(String compressorName, OutputStream out) throws CompressorException {
        return compressorStreamFactory.createCompressorOutputStream(compressorName, out);
    }

    static {
        archiveStreamFactory = new ArchiveStreamFactory();
        compressorStreamFactory = new CompressorStreamFactory();
    }
}

