/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.linsol.lu;

import org.ejml.UtilEjml;
import org.ejml.data.FGrowArray;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.csc.CommonOps_FSCC;
import org.ejml.sparse.csc.decomposition.lu.LuUpLooking_FSCC;
import org.ejml.sparse.csc.misc.TriangularSolver_FSCC;

public class LinearSolverLu_FSCC
implements LinearSolverSparse<FMatrixSparseCSC, FMatrixRMaj> {
    LuUpLooking_FSCC decomposition;
    private final FGrowArray gx = new FGrowArray();
    private final FGrowArray gb = new FGrowArray();
    FMatrixSparseCSC Bp = new FMatrixSparseCSC(1, 1, 1);
    FMatrixSparseCSC tmp = new FMatrixSparseCSC(1, 1, 1);
    int AnumRows;
    int AnumCols;

    public LinearSolverLu_FSCC(LuUpLooking_FSCC decomposition) {
        this.decomposition = decomposition;
    }

    @Override
    public boolean setA(FMatrixSparseCSC A) {
        this.AnumRows = A.numRows;
        this.AnumCols = A.numCols;
        return this.decomposition.decompose(A);
    }

    @Override
    public double quality() {
        return TriangularSolver_FSCC.qualityTriangular(this.decomposition.getU());
    }

    @Override
    public void solveSparse(FMatrixSparseCSC B, FMatrixSparseCSC X2) {
        X2.reshape(this.AnumCols, B.numCols, X2.numRows);
        FMatrixSparseCSC L = this.decomposition.getL();
        FMatrixSparseCSC U = this.decomposition.getU();
        this.Bp.reshape(B.numRows, B.numCols, B.nz_length);
        int[] Pinv = this.decomposition.getPinv();
        CommonOps_FSCC.permute(Pinv, B, null, this.Bp);
        IGrowArray gw = this.decomposition.getGw();
        IGrowArray gw1 = this.decomposition.getGxi();
        this.tmp.reshape(L.numRows, B.numCols, 1);
        TriangularSolver_FSCC.solve(L, true, this.Bp, this.tmp, null, this.gx, gw, gw1);
        TriangularSolver_FSCC.solve(U, false, this.tmp, X2, null, this.gx, gw, gw1);
    }

    @Override
    public void setStructureLocked(boolean locked) {
        this.decomposition.setStructureLocked(locked);
    }

    @Override
    public boolean isStructureLocked() {
        return this.decomposition.isStructureLocked();
    }

    @Override
    public void solve(FMatrixRMaj B, FMatrixRMaj X2) {
        UtilEjml.checkReshapeSolve(this.AnumRows, this.AnumCols, B, X2);
        int[] pinv = this.decomposition.getPinv();
        float[] x = UtilEjml.adjust(this.gx, X2.numRows);
        float[] b = UtilEjml.adjust(this.gb, B.numRows);
        FMatrixSparseCSC L = this.decomposition.getL();
        FMatrixSparseCSC U = this.decomposition.getU();
        boolean reduceFill = this.decomposition.isReduceFill();
        int[] q = reduceFill ? this.decomposition.getReducePermutation() : null;
        for (int colX = 0; colX < X2.numCols; ++colX) {
            float[] d;
            int index = colX;
            int i = 0;
            while (i < B.numRows) {
                b[i] = B.data[index];
                ++i;
                index += X2.numCols;
            }
            CommonOps_FSCC.permuteInv(pinv, b, x, X2.numRows);
            TriangularSolver_FSCC.solveL(L, x);
            TriangularSolver_FSCC.solveU(U, x);
            if (reduceFill) {
                CommonOps_FSCC.permute(q, x, b, X2.numRows);
                d = b;
            } else {
                d = x;
            }
            index = colX;
            int i2 = 0;
            while (i2 < X2.numRows) {
                X2.data[index] = d[i2];
                ++i2;
                index += X2.numCols;
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposition.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public <D extends DecompositionInterface> D getDecomposition() {
        return (D)this.decomposition;
    }
}

