/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.misc;

import org.ejml.UtilEjml;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ElementLocation;
import org.ejml.data.Matrix;
import org.jetbrains.annotations.Nullable;

public class ImplCommonOps_DDRM {
    public static void extract(DMatrixRMaj src, int srcY0, int srcX0, DMatrixRMaj dst, int dstY0, int dstX0, int numRows, int numCols) {
        for (int y = 0; y < numRows; ++y) {
            int indexSrc = src.getIndex(y + srcY0, srcX0);
            int indexDst = dst.getIndex(y + dstY0, dstX0);
            System.arraycopy(src.data, indexSrc, dst.data, indexDst, numCols);
        }
    }

    public static double elementMax(DMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        double max = a.get(0);
        for (int i = 1; i < size; ++i) {
            double val2 = a.get(i);
            if (!(val2 >= max)) continue;
            bestIndex = i;
            max = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        double max = 0.0;
        for (int i = 0; i < size; ++i) {
            double val2 = Math.abs(a.get(i));
            if (!(val2 > max)) continue;
            bestIndex = i;
            max = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return max;
    }

    public static double elementMin(DMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        double min = a.get(0);
        for (int i = 1; i < size; ++i) {
            double val2 = a.get(i);
            if (!(val2 < min)) continue;
            bestIndex = i;
            min = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return min;
    }

    public static double elementMinAbs(DMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            double val2 = Math.abs(a.get(i));
            if (!(val2 < min)) continue;
            bestIndex = i;
            min = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return min;
    }

    public static void elementMult(DMatrixD1 A, DMatrixD1 B) {
        UtilEjml.checkSameShape((Matrix)A, (Matrix)B, true);
        int length = A.getNumElements();
        for (int i = 0; i < length; ++i) {
            A.times(i, B.get(i));
        }
    }

    public static <T extends DMatrixD1> T elementMult(T A, T B, @Nullable T output) {
        UtilEjml.checkSameShape(A, B, true);
        output = UtilEjml.reshapeOrDeclare(output, A);
        int length = A.getNumElements();
        for (int i = 0; i < length; ++i) {
            output.set(i, A.get(i) * B.get(i));
        }
        return output;
    }

    public static void elementDiv(DMatrixD1 A, DMatrixD1 B) {
        UtilEjml.checkSameShape((Matrix)A, (Matrix)B, true);
        int length = A.getNumElements();
        for (int i = 0; i < length; ++i) {
            A.div(i, B.get(i));
        }
    }

    public static <T extends DMatrixD1> T elementDiv(T A, T B, @Nullable T output) {
        UtilEjml.checkSameShape(A, B, true);
        output = UtilEjml.reshapeOrDeclare(output, A);
        int length = A.getNumElements();
        for (int i = 0; i < length; ++i) {
            output.set(i, A.get(i) / B.get(i));
        }
        return output;
    }

    public static double elementSum(DMatrixD1 mat) {
        double total = 0.0;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += mat.get(i);
        }
        return total;
    }

    public static double elementSumAbs(DMatrixD1 mat) {
        double total = 0.0;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += Math.abs(mat.get(i));
        }
        return total;
    }

    public static <T extends DMatrixD1> T elementPower(T A, T B, @Nullable T output) {
        UtilEjml.checkSameShape(A, B, true);
        output = UtilEjml.reshapeOrDeclare(output, A);
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = Math.pow(A.data[i], B.data[i]);
        }
        return output;
    }

    public static <T extends DMatrixD1> T elementPower(double a, T B, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, B);
        int size = B.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = Math.pow(a, B.data[i]);
        }
        return output;
    }

    public static <T extends DMatrixD1> T elementPower(T A, double b, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, A);
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = Math.pow(A.data[i], b);
        }
        return output;
    }

    public static <T extends DMatrixD1> T elementLog(T A, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, A);
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = Math.log(A.data[i]);
        }
        return output;
    }

    public static <T extends DMatrixD1> T elementExp(T A, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, A);
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = Math.exp(A.data[i]);
        }
        return output;
    }
}

