/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.util;

import java.util.Random;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.DogArray_I8;
import org.jetbrains.annotations.Nullable;

public class PrimitiveArrays {
    public static void intersection(int[] setA, int sizeA, int[] setB, int sizeB, DogArray_I32 results, @Nullable DogArray_I8 work) {
        int v;
        int i;
        int min;
        if (sizeA == 0 || sizeB == 0) {
            results.reset();
            return;
        }
        int max = min = setA[0];
        for (i = 1; i < sizeA; ++i) {
            v = setA[i];
            if (v < min) {
                min = v;
                continue;
            }
            if (v <= max) continue;
            max = v;
        }
        for (i = 0; i < sizeB; ++i) {
            v = setB[i];
            if (v < min) {
                min = v;
                continue;
            }
            if (v <= max) continue;
            max = v;
        }
        PrimitiveArrays.intersection(setA, sizeA, setB, sizeB, min, max, results, work);
    }

    public static void intersection(int[] setA, int sizeA, int[] setB, int sizeB, int valueMin, int valueMax, DogArray_I32 results, @Nullable DogArray_I8 work) {
        work = PrimitiveArrays.countOccurrences(setA, sizeA, setB, sizeB, valueMin, valueMax, results, work);
        for (int i = 0; i < work.size; ++i) {
            if (work.data[i] != 2) continue;
            results.add(i + valueMin);
        }
    }

    public static void union(int[] setA, int sizeA, int[] setB, int sizeB, int valueMin, int valueMax, DogArray_I32 results, @Nullable DogArray_I8 work) {
        work = PrimitiveArrays.countOccurrences(setA, sizeA, setB, sizeB, valueMin, valueMax, results, work);
        for (int i = 0; i < work.size; ++i) {
            if (work.data[i] == 0) continue;
            results.add(i + valueMin);
        }
    }

    private static DogArray_I8 countOccurrences(int[] setA, int sizeA, int[] setB, int sizeB, int valueMin, int valueMax, DogArray_I32 results, @Nullable DogArray_I8 work) {
        int i;
        results.reset();
        results.reserve(Math.min(sizeA, sizeB));
        if (work == null) {
            work = new DogArray_I8(valueMax - valueMin + 1);
        }
        work.reset();
        work.resize(valueMax - valueMin + 1, (byte)0);
        for (i = 0; i < sizeA; ++i) {
            int n = setA[i] - valueMin;
            work.data[n] = (byte)(work.data[n] + 1);
        }
        for (i = 0; i < sizeB; ++i) {
            int n = setB[i] - valueMin;
            work.data[n] = (byte)(work.data[n] + 1);
        }
        return work;
    }

    public static void fillCounting(int[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            array[i + offset] = i;
        }
    }

    public static int[] fillCounting(int length) {
        int[] array = new int[length];
        PrimitiveArrays.fillCounting(array, 0, length);
        return array;
    }

    public static void shuffle(byte[] array, int offset, int length, Random rand) {
        PrimitiveArrays.sanityCheckShuffle(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            byte tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(short[] array, int offset, int length, Random rand) {
        PrimitiveArrays.sanityCheckShuffle(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            short tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(int[] array, int offset, int length, Random rand) {
        PrimitiveArrays.sanityCheckShuffle(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            int tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(long[] array, int offset, int length, Random rand) {
        PrimitiveArrays.sanityCheckShuffle(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            long tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(float[] array, int offset, int length, Random rand) {
        PrimitiveArrays.sanityCheckShuffle(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            float tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(double[] array, int offset, int length, Random rand) {
        PrimitiveArrays.sanityCheckShuffle(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            double tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static int min(byte[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        byte min = array[offset];
        for (int i = 1; i < length; ++i) {
            byte tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static int min(short[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        short min = array[offset];
        for (int i = 1; i < length; ++i) {
            short tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static int min(int[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int min = array[offset];
        for (int i = 1; i < length; ++i) {
            int tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static long min(long[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        long min = array[offset];
        for (int i = 1; i < length; ++i) {
            long tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static float min(float[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        float min = array[offset];
        for (int i = 1; i < length; ++i) {
            float tmp = array[offset + i];
            if (!(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public static double min(double[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double min = array[offset];
        for (int i = 1; i < length; ++i) {
            double tmp = array[offset + i];
            if (!(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public static int minIdx(byte[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        byte min = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            byte tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int minIdx(int[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int min = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            int tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int minIdx(float[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        float min = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            float tmp = array[offset + i];
            if (!(tmp < min)) continue;
            min = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int minIdx(double[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double min = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            double tmp = array[offset + i];
            if (!(tmp < min)) continue;
            min = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int max(byte[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        byte max = array[offset];
        for (int i = 1; i < length; ++i) {
            byte tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public static int max(short[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        short max = array[offset];
        for (int i = 1; i < length; ++i) {
            short tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public static int max(int[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int max = array[offset];
        for (int i = 1; i < length; ++i) {
            int tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public static long max(long[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        long max = array[offset];
        for (int i = 1; i < length; ++i) {
            long tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public static float max(float[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        float max = array[offset];
        for (int i = 1; i < length; ++i) {
            float tmp = array[offset + i];
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public static double max(double[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double max = array[offset];
        for (int i = 1; i < length; ++i) {
            double tmp = array[offset + i];
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public static int maxIdx(byte[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        byte max = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            byte tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int maxIdx(int[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int max = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            int tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int maxIdx(float[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        float max = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            float tmp = array[offset + i];
            if (!(tmp > max)) continue;
            max = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int maxIdx(double[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double max = array[offset];
        int index = 0;
        for (int i = 1; i < length; ++i) {
            double tmp = array[offset + i];
            if (!(tmp > max)) continue;
            max = tmp;
            index = i;
        }
        return offset + index;
    }

    public static int lowerBound(byte[] array, int offset, int length, int val2) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val2) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBoundU(byte[] array, int offset, int length, int val2) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if ((array[idx] & 0xFF) < val2) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(short[] array, int offset, int length, int val2) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val2) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(int[] array, int offset, int length, int val2) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val2) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(float[] array, int offset, int length, float val2) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val2) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(double[] array, int offset, int length, double val2) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val2) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static double sumD(byte[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)array[offset + i];
        }
        return sum;
    }

    public static double sumD(short[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)array[offset + i];
        }
        return sum;
    }

    public static double sumD(int[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)array[offset + i];
        }
        return sum;
    }

    public static double sumD(long[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)array[offset + i];
        }
        return sum;
    }

    public static double sumD(float[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)array[offset + i];
        }
        return sum;
    }

    public static double sumD(double[] array, int offset, int length) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += array[offset + i];
        }
        return sum;
    }

    public static double feedbackIdxDOp(byte[] array, int offset, int length, FeedbackIdxD op) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result = op.process(i, array[i + offset], result);
        }
        return result;
    }

    public static double feedbackIdxDOp(short[] array, int offset, int length, FeedbackIdxD op) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result = op.process(i, array[i + offset], result);
        }
        return result;
    }

    public static double feedbackIdxDOp(int[] array, int offset, int length, FeedbackIdxD op) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result = op.process(i, array[i + offset], result);
        }
        return result;
    }

    public static double feedbackIdxDOp(long[] array, int offset, int length, FeedbackIdxD op) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result = op.process(i, array[i + offset], result);
        }
        return result;
    }

    public static double feedbackIdxDOp(float[] array, int offset, int length, FeedbackIdxD op) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result = op.process(i, array[i + offset], result);
        }
        return result;
    }

    public static double feedbackIdxDOp(double[] array, int offset, int length, FeedbackIdxD op) {
        PrimitiveArrays.sanityCheckRange(array.length, offset, length);
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result = op.process(i, array[i + offset], result);
        }
        return result;
    }

    private static void sanityCheckRange(int arrayLength, int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be positive. length=" + length);
        }
        if (offset < 0 || offset >= arrayLength) {
            throw new IllegalArgumentException("offset is invalid. offset=" + offset);
        }
    }

    private static void sanityCheckShuffle(int arrayLength, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must not be negative. length=" + length);
        }
        if (offset < 0 || offset > arrayLength) {
            throw new IllegalArgumentException("offset is invalid. offset=" + offset);
        }
    }

    @FunctionalInterface
    public static interface FeedbackIdxD {
        public double process(int var1, double var2, double var4);
    }
}

