/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.ArrayDeque;

public class RecycleManager<T> {
    protected Class<T> targetClass;
    protected ArrayDeque<T> unused = new ArrayDeque();

    public RecycleManager(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    public T requestInstance() {
        T a = this.unused.size() > 0 ? this.unused.removeLast() : this.createInstance();
        return a;
    }

    public void recycleInstance(T object) {
        this.unused.add(object);
    }

    protected T createInstance() {
        try {
            return this.targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayDeque<T> getUnused() {
        return this.unused;
    }
}

