/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

public class CircularArray_F64 {
    public double[] data;
    public int start;
    public int size;

    public CircularArray_F64() {
        this(10);
    }

    public CircularArray_F64(int dataSize) {
        this.data = new double[dataSize];
    }

    public void reset() {
        this.size = 0;
        this.start = 0;
    }

    public double popHead() {
        double r = this.data[this.start];
        this.removeHead();
        return r;
    }

    public double popTail() {
        double r = this.tail();
        this.removeTail();
        return r;
    }

    public double head() {
        return this.data[this.start];
    }

    public double tail() {
        return this.data[(this.start + this.size - 1) % this.data.length];
    }

    public void removeHead() {
        this.start = (this.start + 1) % this.data.length;
        --this.size;
    }

    public void removeTail() {
        --this.size;
    }

    public double get(int index) {
        return this.data[(this.start + index) % this.data.length];
    }

    public void add(double value) {
        if (this.size >= this.data.length) {
            this.data[this.start] = value;
            this.start = (this.start + 1) % this.data.length;
        } else {
            this.data[(this.start + this.size) % this.data.length] = value;
            ++this.size;
        }
    }

    public void set(CircularArray_F64 original) {
        if (this.data.length != original.data.length) {
            this.data = new double[original.data.length];
        }
        System.arraycopy(original.data, 0, this.data, 0, this.data.length);
        this.size = original.size;
        this.start = original.start;
    }

    public CircularArray_F64 copy() {
        CircularArray_F64 r = new CircularArray_F64();
        r.set(this);
        return r;
    }

    public void resizeQueue(int maxSize) {
        if (this.data.length != maxSize) {
            this.data = new double[maxSize];
        }
    }

    public int queueSize() {
        return this.data.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.data.length;
    }
}

