/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.BigDogArrayBase;
import org.ddogleg.struct.BigDogGrowth;
import org.ddogleg.struct.DogArray_F32;

public class BigDogArray_F32
extends BigDogArrayBase<float[]> {
    public BigDogArray_F32() {
        this(8, 32768, BigDogGrowth.GROW_FIRST);
    }

    public BigDogArray_F32(int initialAllocation) {
        this(initialAllocation, 32768, BigDogGrowth.GROW_FIRST);
    }

    public BigDogArray_F32(int initialAllocation, int blockSize, BigDogGrowth growth) {
        super(initialAllocation, blockSize, growth);
    }

    @Override
    protected float[] newArrayInstance(int size) {
        return new float[size];
    }

    @Override
    protected int arrayLength(float[] array) {
        return array.length;
    }

    public void append(float value) {
        this.allocate(this.size + 1, true, true);
        ((float[][])this.blocks.data)[this.size / this.blockSize][this.size % this.blockSize] = value;
        ++this.size;
    }

    public void add(float value) {
        this.append(value);
    }

    public void resize(int desiredSize, float initialValue) {
        this.allocate(desiredSize, true, false);
        int originalSize = this.size;
        this.size = desiredSize;
        this.fill(originalSize, desiredSize, initialValue);
    }

    public void fill(int idx0, int idx1, float value) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> Arrays.fill(block, block0, block1, value));
    }

    public void set(int index, float value) {
        ((float[][])this.blocks.data)[index / this.blockSize][index % this.blockSize] = value;
    }

    public void setTail(int index, float value) {
        this.set(this.size - index - 1, value);
    }

    public void getArray(int index, float[] array, int offset, int length) {
        this.processByBlock(index, index + length, (block, block0, block1, arrayLoc) -> System.arraycopy(block, block0, array, offset + arrayLoc, block1 - block0));
    }

    public float get(int index) {
        return ((float[][])this.blocks.data)[index / this.blockSize][index % this.blockSize];
    }

    public float getTail(int index) {
        return this.get(this.size - index - 1);
    }

    public void forEach(int idx0, int idx1, DogArray_F32.FunctionEach op) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> {
            for (int i = block0; i < block1; ++i) {
                op.process(block[i]);
            }
        });
    }

    public void forIdx(int idx0, int idx1, DogArray_F32.FunctionEachIdx op) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> {
            int index = idx0 + offset;
            for (int i = block0; i < block1; ++i) {
                op.process(index++, block[i]);
            }
        });
    }

    public void applyIdx(int idx0, int idx1, DogArray_F32.FunctionApplyIdx op) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> {
            int index = idx0 + offset;
            for (int i = block0; i < block1; ++i) {
                block[i] = op.process(index++, block[i]);
            }
        });
    }
}

