/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.functions.CoupledJacobian;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrix;

public class Individual_to_CoupledJacobian<S extends DMatrix>
implements CoupledJacobian<S> {
    FunctionNtoM func;
    FunctionNtoMxN<S> jacobian;
    double[] x;

    public Individual_to_CoupledJacobian(FunctionNtoM func, FunctionNtoMxN<S> jacobian) {
        if (func.getNumOfOutputsM() != jacobian.getNumOfOutputsM()) {
            throw new IllegalArgumentException("M not equal");
        }
        if (func.getNumOfInputsN() != jacobian.getNumOfInputsN()) {
            throw new IllegalArgumentException("N not equal");
        }
        this.func = func;
        this.jacobian = jacobian;
    }

    @Override
    public int getNumOfInputsN() {
        return this.func.getNumOfInputsN();
    }

    @Override
    public int getNumOfOutputsM() {
        return this.func.getNumOfOutputsM();
    }

    @Override
    public void setInput(double[] x) {
        this.x = x;
    }

    @Override
    public void computeFunctions(double[] output) {
        this.func.process(this.x, output);
    }

    @Override
    public void computeJacobian(S jacobian) {
        this.jacobian.process(this.x, jacobian);
    }
}

