/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.derivative;

import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;

public class NumericalJacobianForward_DDRM
implements FunctionNtoMxN<DMatrixRMaj> {
    private final int N;
    private final int M;
    private final FunctionNtoM function;
    private final double differenceScale;
    private final double[] output0;
    private final double[] output1;

    public NumericalJacobianForward_DDRM(FunctionNtoM function, double differenceScale) {
        this.function = function;
        this.differenceScale = differenceScale;
        this.N = function.getNumOfInputsN();
        this.M = function.getNumOfOutputsM();
        this.output0 = new double[this.M];
        this.output1 = new double[this.M];
    }

    public NumericalJacobianForward_DDRM(FunctionNtoM function) {
        this(function, Math.sqrt(UtilEjml.EPS));
    }

    @Override
    public int getNumOfInputsN() {
        return this.N;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.M;
    }

    @Override
    public void process(double[] input, DMatrixRMaj jacobian) {
        jacobian.reshape(this.M, this.N);
        this.function.process(input, this.output0);
        for (int i = 0; i < this.N; ++i) {
            double x = input[i];
            double h = x != 0.0 ? this.differenceScale * Math.abs(x) : this.differenceScale;
            double temp = x + h;
            h = temp - x;
            input[i] = temp;
            this.function.process(input, this.output1);
            for (int j = 0; j < this.M; ++j) {
                jacobian.unsafe_set(j, i, (this.output1[j] - this.output0[j]) / h);
            }
            input[i] = x;
        }
    }

    @Override
    public DMatrixRMaj declareMatrixMxN() {
        return new DMatrixRMaj(this.M, this.N);
    }
}

