/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.searches.KdTreeSearch1Bbf;
import org.ddogleg.nn.alg.searches.KdTreeSearchNBbf;
import org.ddogleg.nn.wrap.KdTreeInternalSearch;

public class KdForestBbfNearestNeighbor<P>
implements NearestNeighbor<P> {
    KdTree[] forest;
    KdTreeConstructor<P> constructor;
    AxisSplitter<P> splitter;
    KdTreeMemory<P> memory = new KdTreeMemory();
    int maxNodesSearched;
    KdTreeDistance<P> distance;

    public KdForestBbfNearestNeighbor(int numberOfTrees, int maxNodesSearched, KdTreeDistance<P> distance, AxisSplitter<P> splitter) {
        this.forest = new KdTree[numberOfTrees];
        this.splitter = splitter;
        this.maxNodesSearched = maxNodesSearched;
        this.distance = distance;
        this.constructor = new KdTreeConstructor<P>(this.memory, splitter);
    }

    @Override
    public void setPoints(List<P> points, boolean trackIndicies) {
        int i;
        if (this.forest[0] != null) {
            for (i = 0; i < this.forest.length; ++i) {
                this.memory.recycleGraph(this.forest[i]);
            }
        }
        for (i = 0; i < this.forest.length; ++i) {
            this.forest[i] = this.constructor.construct(points, trackIndicies);
        }
    }

    @Override
    public NearestNeighbor.Search<P> createSearch() {
        return new InternalSearch();
    }

    private class InternalSearch
    extends KdTreeInternalSearch<P> {
        InternalSearch() {
            super(new KdTreeSearch1Bbf(KdForestBbfNearestNeighbor.this.distance, KdForestBbfNearestNeighbor.this.maxNodesSearched), new KdTreeSearchNBbf(KdForestBbfNearestNeighbor.this.distance, KdForestBbfNearestNeighbor.this.maxNodesSearched));
        }

        @Override
        void setTree() {
            this.search1.setTree(KdForestBbfNearestNeighbor.this.forest);
            this.searchN.setTree(KdForestBbfNearestNeighbor.this.forest);
        }
    }
}

