/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn;

public class ConfigNearestNeighborSearch {
    public Type type = Type.EXHAUSTIVE;
    public final RandomForest randomForest = new RandomForest();
    public final KDTree kdtree = new KDTree();
    public long randomSeed = 66L;

    public void checkValidity() {
        this.randomForest.checkValidity();
        this.kdtree.checkValidity();
    }

    public void setTo(ConfigNearestNeighborSearch src) {
        this.type = src.type;
        this.randomForest.setTo(src.randomForest);
        this.kdtree.setTo(src.kdtree);
        this.randomSeed = src.randomSeed;
    }

    public static enum Type {
        EXHAUSTIVE,
        RANDOM_FOREST,
        KD_TREE,
        VP_TREE;

    }

    public static class RandomForest {
        public int maxNodesSearched = 2000;
        public int numTrees = 10;
        public int numConsiderSplit = 5;

        public void checkValidity() {
            if (this.maxNodesSearched < 0) {
                throw new IllegalArgumentException("maxNodesSearched can't be negative");
            }
            if (this.numTrees <= 0) {
                throw new IllegalArgumentException("numTrees must be positive");
            }
            if (this.numConsiderSplit <= 0) {
                throw new IllegalArgumentException("numConsiderSplit must be positive");
            }
        }

        public void setTo(RandomForest src) {
            this.maxNodesSearched = src.maxNodesSearched;
            this.numTrees = src.numTrees;
            this.numConsiderSplit = src.numConsiderSplit;
        }
    }

    public static class KDTree {
        public int maxNodesSearched = Integer.MAX_VALUE;

        public void checkValidity() {
            if (this.maxNodesSearched < 0) {
                throw new IllegalArgumentException("maxNodesSearched can't be negative");
            }
        }

        public void setTo(KDTree src) {
            this.maxNodesSearched = src.maxNodesSearched;
        }
    }
}

