/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.ransac;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.InlierThreshold;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcherPost;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class Ransac<Model, Point>
implements ModelMatcherPost<Model, Point>,
InlierThreshold {
    protected int sampleSize;
    protected double thresholdFit;
    @Nullable
    Factory<ModelGenerator<Model, Point>> factoryGenerator;
    @Nullable
    Factory<DistanceFromModel<Model, Point>> factoryDistance;
    protected ModelManager<Model> masterModelManager;
    protected long randSeed;
    protected final FastArray<Random> trialRNG = new FastArray<Random>(Random.class);
    protected int maxIterations;
    @Nullable
    protected TrialHelper helper;
    Class<Model> modelType;
    Class<Point> pointType;

    public Ransac(long randSeed, int maxIterations, double thresholdFit, ModelManager<Model> modelManager, Class<Point> pointType) {
        this.masterModelManager = modelManager;
        this.randSeed = randSeed;
        this.maxIterations = maxIterations;
        this.pointType = pointType;
        this.thresholdFit = thresholdFit;
        this.modelType = modelManager.createModelInstance().getClass();
    }

    @Override
    public boolean process(List<Point> dataSet) {
        if (dataSet.size() < this.sampleSize) {
            return false;
        }
        this.checkTrialGenerators();
        TrialHelper helper = Objects.requireNonNull(this.helper, "Need to call setModel()");
        helper.reset();
        for (int trial = 0; trial < this.maxIterations && helper.bestFitPoints.size() != dataSet.size(); ++trial) {
            Ransac.randomDraw(helper.selectedIdx, dataSet.size(), this.sampleSize, (Random)this.trialRNG.get(trial));
            Ransac.addSelect(helper.selectedIdx, this.sampleSize, dataSet, helper.initialSample);
            if (!helper.modelGenerator.generate(helper.initialSample, helper.candidateParam) || !helper.selectMatchSet(dataSet, helper.bestFitPoints.size(), this.thresholdFit, helper.candidateParam) || helper.bestFitPoints.size() >= helper.candidatePoints.size()) continue;
            helper.swapCandidateWithBest();
        }
        return helper.bestFitPoints.size() > 0;
    }

    @Override
    public void setModel(Factory<ModelGenerator<Model, Point>> factoryGenerator, Factory<DistanceFromModel<Model, Point>> factoryDistance) {
        this.factoryGenerator = factoryGenerator;
        this.factoryDistance = factoryDistance;
        this.helper = new TrialHelper();
        this.sampleSize = this.helper.modelGenerator.getMinimumPoints();
    }

    protected void checkTrialGenerators() {
        if (this.trialRNG.size == this.maxIterations) {
            return;
        }
        Random rand = new Random(this.randSeed);
        this.trialRNG.resize(this.maxIterations);
        for (int i = 0; i < this.maxIterations; ++i) {
            this.trialRNG.set(i, new Random(rand.nextLong()));
        }
    }

    public static <T> void randomDraw(List<T> dataSet, int numSample, List<T> initialSample, Random rand) {
        initialSample.clear();
        for (int i = 0; i < numSample; ++i) {
            int indexLast = dataSet.size() - i - 1;
            int indexSelected = rand.nextInt(indexLast + 1);
            T a = dataSet.get(indexSelected);
            initialSample.add(a);
            dataSet.set(indexSelected, dataSet.set(indexLast, a));
        }
    }

    public static void randomDraw(DogArray_I32 indexes, int size, int numSample, Random rand) {
        int i;
        if (indexes.size != size) {
            indexes.resize(size);
            for (i = 0; i < size; ++i) {
                indexes.data[i] = i;
            }
        }
        for (i = 0; i < numSample; ++i) {
            int last = size - i - 1;
            int selected = rand.nextInt(last + 1);
            int tmp = indexes.get(last);
            indexes.set(last, indexes.get(selected));
            indexes.set(selected, tmp);
        }
    }

    public static <T> void addSelect(DogArray_I32 indexes, int numSample, List<T> dataSet, List<T> initialSample) {
        int start;
        int i;
        initialSample.clear();
        for (i = start = indexes.size - numSample; i < indexes.size; ++i) {
            int selectedIdx = indexes.get(i);
            initialSample.add(dataSet.get(selectedIdx));
            if (selectedIdx >= start) continue;
            indexes.set(selectedIdx, selectedIdx);
        }
        for (i = start; i < indexes.size; ++i) {
            indexes.set(i, i);
        }
    }

    @Override
    public List<Point> getMatchSet() {
        return Objects.requireNonNull(this.helper).bestFitPoints;
    }

    @Override
    public int getInputIndex(int matchIndex) {
        return Objects.requireNonNull(this.helper).bestMatchToInput[matchIndex];
    }

    @Override
    public Model getModelParameters() {
        return Objects.requireNonNull(this.helper).bestFitParam;
    }

    @Override
    public double getFitQuality() {
        return Objects.requireNonNull(this.helper).bestFitPoints.size();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public int getMinimumSize() {
        return this.sampleSize;
    }

    @Override
    public void reset() {
        this.trialRNG.resize(0);
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public double getThresholdFit() {
        return this.thresholdFit;
    }

    @Override
    public void setThresholdFit(double thresholdFit) {
        this.thresholdFit = thresholdFit;
    }

    @Override
    public Class<Point> getPointType() {
        return this.pointType;
    }

    @Override
    public Class<Model> getModelType() {
        return this.modelType;
    }

    protected class TrialHelper {
        ModelGenerator<Model, Point> modelGenerator;
        DistanceFromModel<Model, Point> modelDistance;
        List<Point> initialSample;
        List<Point> candidatePoints;
        List<Point> bestFitPoints;
        Model bestFitParam;
        Model candidateParam;
        protected int[] matchToInput;
        protected int[] bestMatchToInput;
        DogArray_I32 selectedIdx;

        protected TrialHelper() {
            this.modelGenerator = Objects.requireNonNull(Ransac.this.factoryGenerator).newInstance();
            this.modelDistance = Objects.requireNonNull(Ransac.this.factoryDistance).newInstance();
            this.initialSample = new ArrayList();
            this.candidatePoints = new ArrayList();
            this.bestFitPoints = new ArrayList();
            this.bestFitParam = Ransac.this.masterModelManager.createModelInstance();
            this.candidateParam = Ransac.this.masterModelManager.createModelInstance();
            this.matchToInput = new int[1];
            this.bestMatchToInput = new int[1];
            this.selectedIdx = new DogArray_I32();
        }

        protected boolean selectMatchSet(List<Point> dataSet, int bestModelSize, double threshold, Model param) {
            if (dataSet.size() > this.matchToInput.length) {
                this.matchToInput = new int[dataSet.size()];
                this.bestMatchToInput = new int[dataSet.size()];
            }
            this.candidatePoints.clear();
            this.modelDistance.setModel(param);
            int maxFailures = dataSet.size() - bestModelSize;
            for (int i = 0; i < dataSet.size() && maxFailures >= 0; ++i) {
                Object point = dataSet.get(i);
                double distance = this.modelDistance.distance(point);
                if (distance < threshold) {
                    this.matchToInput[this.candidatePoints.size()] = i;
                    this.candidatePoints.add(point);
                    continue;
                }
                --maxFailures;
            }
            return maxFailures >= 0;
        }

        protected void swapCandidateWithBest() {
            List tempPts = this.candidatePoints;
            this.candidatePoints = this.bestFitPoints;
            this.bestFitPoints = tempPts;
            int[] tempIndex = this.matchToInput;
            this.matchToInput = this.bestMatchToInput;
            this.bestMatchToInput = tempIndex;
            Object m = this.candidateParam;
            this.candidateParam = this.bestFitParam;
            this.bestFitParam = m;
        }

        public void reset() {
            this.candidatePoints.clear();
            this.bestFitPoints.clear();
            this.selectedIdx.reset();
        }
    }
}

