/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.lmeds;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.InlierFraction;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcherPost;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class LeastMedianOfSquares<Model, Point>
implements ModelMatcherPost<Model, Point>,
InlierFraction {
    private final long randSeed;
    protected final FastArray<Random> trialRNG = new FastArray<Random>(Random.class);
    protected final int totalCycles;
    protected int sampleSize;
    protected final double maxMedianError;
    protected final ModelManager<Model> ModelManager;
    @Nullable
    Factory<ModelGenerator<Model, Point>> factoryGenerator;
    @Nullable
    Factory<DistanceFromModel<Model, Point>> factoryDistance;
    protected int[] matchToInput = new int[1];
    protected volatile double bestMedian;
    protected double errorFraction = 0.5;
    protected List<Point> inlierSet;
    protected final double inlierFrac;
    @Nullable
    protected TrialHelper helper;
    Class<Model> modelType;
    Class<Point> pointType;

    public LeastMedianOfSquares(long randSeed, int totalCycles, double maxMedianError, double inlierFraction, ModelManager<Model> modelManager, Class<Point> pointType) {
        this.randSeed = randSeed;
        this.totalCycles = totalCycles;
        this.maxMedianError = maxMedianError;
        this.inlierFrac = inlierFraction;
        this.pointType = pointType;
        this.ModelManager = modelManager;
        this.modelType = modelManager.createModelInstance().getClass();
        if (this.inlierFrac > 0.0) {
            this.inlierSet = new ArrayList<Point>();
        } else if (this.inlierFrac > 1.0) {
            throw new IllegalArgumentException("Inlier fraction must be <= 1");
        }
    }

    public LeastMedianOfSquares(long randSeed, int totalCycles, ModelManager<Model> modelManager, Class<Point> pointType) {
        this(randSeed, totalCycles, Double.MAX_VALUE, 0.0, modelManager, pointType);
    }

    @Override
    public void setModel(Factory<ModelGenerator<Model, Point>> factoryGenerator, Factory<DistanceFromModel<Model, Point>> factoryDistance) {
        this.factoryGenerator = factoryGenerator;
        this.factoryDistance = factoryDistance;
        this.helper = new TrialHelper();
        this.sampleSize = this.helper.modelGenerator.getMinimumPoints();
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public boolean process(List<Point> dataSet) {
        if (dataSet.size() < this.sampleSize) {
            return false;
        }
        this.checkTrialGenerators();
        int N = dataSet.size();
        if (this.matchToInput.length < N) {
            this.matchToInput = new int[N];
        }
        TrialHelper helper = Objects.requireNonNull(this.helper, "Need to call setModel()");
        helper.initialize(N);
        this.bestMedian = Double.MAX_VALUE;
        for (int trial = 0; trial < this.totalCycles; ++trial) {
            Ransac.randomDraw(helper.selectedIdx, N, this.sampleSize, (Random)this.trialRNG.get(trial));
            Ransac.addSelect(helper.selectedIdx, this.sampleSize, dataSet, helper.initialSample);
            if (!helper.modelGenerator.generate(helper.initialSample, helper.candidate)) continue;
            helper.modelDistance.setModel(helper.candidate);
            helper.modelDistance.distances(dataSet, helper.errors.data);
            double median = QuickSelect.select(helper.errors.data, (int)((double)N * this.errorFraction + 0.5), N);
            if (!(median < this.bestMedian)) continue;
            helper.swapModels();
            this.bestMedian = median;
        }
        this.computeInlierSet(dataSet, N, helper);
        return this.bestMedian <= this.maxMedianError;
    }

    protected void computeInlierSet(List<Point> dataSet, int n, TrialHelper helper) {
        int numPts = (int)((double)n * this.inlierFrac);
        if (this.inlierFrac > 0.0 && numPts > this.sampleSize) {
            this.inlierSet.clear();
            helper.modelDistance.setModel(helper.bestParam);
            helper.modelDistance.distances(dataSet, helper.errors.data);
            int[] indexes = new int[n];
            QuickSelect.selectIndex(helper.errors.data, numPts, n, indexes);
            for (int i = 0; i < numPts; ++i) {
                int origIndex = indexes[i];
                this.inlierSet.add(dataSet.get(origIndex));
                this.matchToInput[i] = origIndex;
            }
        } else {
            this.inlierSet = dataSet;
        }
    }

    protected void checkTrialGenerators() {
        if (this.trialRNG.size == this.totalCycles) {
            return;
        }
        Random rand = new Random(this.randSeed);
        this.trialRNG.resize(this.totalCycles);
        for (int i = 0; i < this.totalCycles; ++i) {
            this.trialRNG.set(i, new Random(rand.nextLong()));
        }
    }

    @Override
    public double getErrorFraction() {
        return this.errorFraction;
    }

    @Override
    public void setErrorFraction(double errorFraction) {
        this.errorFraction = errorFraction;
    }

    @Override
    public Model getModelParameters() {
        return Objects.requireNonNull(this.helper).bestParam;
    }

    @Override
    public List<Point> getMatchSet() {
        return this.inlierSet;
    }

    @Override
    public int getInputIndex(int matchIndex) {
        return this.matchToInput[matchIndex];
    }

    @Override
    public double getFitQuality() {
        return this.bestMedian;
    }

    @Override
    public int getMinimumSize() {
        return this.sampleSize;
    }

    @Override
    public void reset() {
        this.trialRNG.resize(0);
    }

    @Override
    public Class<Point> getPointType() {
        return this.pointType;
    }

    @Override
    public Class<Model> getModelType() {
        return this.modelType;
    }

    protected class TrialHelper {
        ModelGenerator<Model, Point> modelGenerator;
        DistanceFromModel<Model, Point> modelDistance;
        final List<Point> initialSample;
        Model bestParam;
        Model candidate;
        protected final DogArray_I32 selectedIdx;
        protected final DogArray_F64 errors;

        protected TrialHelper() {
            this.modelGenerator = Objects.requireNonNull(LeastMedianOfSquares.this.factoryGenerator).newInstance();
            this.modelDistance = Objects.requireNonNull(LeastMedianOfSquares.this.factoryDistance).newInstance();
            this.initialSample = new ArrayList();
            this.bestParam = LeastMedianOfSquares.this.ModelManager.createModelInstance();
            this.candidate = LeastMedianOfSquares.this.ModelManager.createModelInstance();
            this.selectedIdx = new DogArray_I32();
            this.errors = new DogArray_F64();
        }

        public void initialize(int datasetSize) {
            this.selectedIdx.reset();
            this.errors.resize(datasetSize);
            if (LeastMedianOfSquares.this.matchToInput.length != datasetSize) {
                LeastMedianOfSquares.this.matchToInput = new int[datasetSize];
            }
        }

        public void swapModels() {
            Object t = this.bestParam;
            this.bestParam = this.candidate;
            this.candidate = t;
        }
    }
}

