/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.List;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.clustering.gmm.InitializeGmm_F64;
import org.ddogleg.clustering.kmeans.StandardKMeans;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.LArrayAccessor;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class SeedFromKMeans_F64
implements InitializeGmm_F64 {
    StandardKMeans<double[]> kmeans;
    DogArray_I32 totals = new DogArray_I32();
    double[] dx = new double[1];
    int dof;

    public SeedFromKMeans_F64(StandardKMeans<double[]> kmeans) {
        this.kmeans = kmeans;
    }

    @Override
    public void init(int pointDimension, long randomSeed) {
        this.dof = pointDimension;
        this.kmeans.initialize(randomSeed);
        if (this.dx.length < this.dof) {
            this.dx = new double[this.dof];
        }
    }

    @Override
    public void selectSeeds(LArrayAccessor<double[]> points, List<GaussianGmm_F64> seeds) {
        DMatrixRMaj cov;
        int i;
        this.totals.resetResize(seeds.size(), 0);
        this.kmeans.process(points, seeds.size());
        DogArray_I32 labels = this.kmeans.getAssignments();
        DogArray<double[]> means = this.kmeans.getBestClusters();
        for (i = 0; i < seeds.size(); ++i) {
            GaussianGmm_F64 g = seeds.get(i);
            g.setMean((double[])means.get(i));
            CommonOps_DDRM.fill(g.covariance, 0.0);
        }
        for (i = 0; i < points.size(); ++i) {
            int label;
            double[] point = points.getTemp(i);
            int n = label = labels.get(i);
            this.totals.data[n] = this.totals.data[n] + 1;
            double[] m = (double[])means.get(label);
            for (int j = 0; j < this.dof; ++j) {
                this.dx[j] = m[j] - point[j];
            }
            DMatrixRMaj cov2 = seeds.get((int)label).covariance;
            for (int j = 0; j < this.dof; ++j) {
                for (int k = j; k < this.dof; ++k) {
                    int n2 = k * this.dof + j;
                    cov2.data[n2] = cov2.data[n2] + this.dx[j] * this.dx[k];
                }
            }
        }
        for (i = 0; i < seeds.size(); ++i) {
            cov = seeds.get((int)i).covariance;
            for (int j = 0; j < this.dof; ++j) {
                for (int k = 0; k < j; ++k) {
                    cov.data[k * this.dof + j] = cov.data[j * this.dof + k];
                }
            }
        }
        for (i = 0; i < seeds.size(); ++i) {
            cov = seeds.get((int)i).covariance;
            int M = this.totals.get(i) - 1;
            if (M <= 0) continue;
            CommonOps_DDRM.divide(cov, M);
            seeds.get((int)i).weight = (double)this.totals.get(i) / (double)points.size();
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.kmeans.setVerbose(verbose);
    }
}

