/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.EulerType;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se2_F32;
import georegression.struct.se.Se3_F32;
import georegression.struct.so.Rodrigues_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F32;
import org.jetbrains.annotations.Nullable;

public class SpecialEuclideanOps_F32 {
    public static void setToNoMotion(Se3_F32 se) {
        CommonOps_FDRM.setIdentity(se.getR());
        se.getT().setTo(0.0f, 0.0f, 0.0f);
    }

    public static Affine2D_F32 toAffine(Se2_F32 se, @Nullable Affine2D_F32 affine) {
        if (affine == null) {
            affine = new Affine2D_F32();
        }
        affine.a11 = se.c;
        affine.a12 = -se.s;
        affine.a21 = se.s;
        affine.a22 = se.c;
        affine.tx = se.T.x;
        affine.ty = se.T.y;
        return affine;
    }

    public static FMatrixRMaj toHomogeneous(Se3_F32 se, @Nullable FMatrixRMaj ret) {
        if (ret == null) {
            ret = new FMatrixRMaj(4, 4);
        } else {
            ret.set(3, 0, 0.0f);
            ret.set(3, 1, 0.0f);
            ret.set(3, 2, 0.0f);
        }
        CommonOps_FDRM.insert(se.getR(), ret, 0, 0);
        Vector3D_F32 T = se.getT();
        ret.set(0, 3, T.x);
        ret.set(1, 3, T.y);
        ret.set(2, 3, T.z);
        ret.set(3, 3, 1.0f);
        return ret;
    }

    public static Se3_F32 toSe3(FMatrixRMaj H, @Nullable Se3_F32 ret) {
        if (H.numCols != 4 || H.numRows != 4) {
            throw new IllegalArgumentException("The homogeneous matrix must be 4 by 4 by definition.");
        }
        if (ret == null) {
            ret = new Se3_F32();
        }
        ret.setTranslation(H.get(0, 3), H.get(1, 3), H.get(2, 3));
        CommonOps_FDRM.extract(H, 0, 3, 0, 3, ret.getR(), 0, 0);
        return ret;
    }

    public static FMatrixRMaj toHomogeneous(Se2_F32 se, @Nullable FMatrixRMaj ret) {
        if (ret == null) {
            ret = new FMatrixRMaj(3, 3);
        } else {
            ret.set(2, 0, 0.0f);
            ret.set(2, 1, 0.0f);
        }
        float c = se.getCosineYaw();
        float s = se.getSineYaw();
        ret.set(0, 0, c);
        ret.set(0, 1, -s);
        ret.set(1, 0, s);
        ret.set(1, 1, c);
        ret.set(0, 2, se.getX());
        ret.set(1, 2, se.getY());
        ret.set(2, 2, 1.0f);
        return ret;
    }

    public static Se2_F32 toSe2(FMatrixRMaj H, @Nullable Se2_F32 ret) {
        if (H.numCols != 3 || H.numRows != 3) {
            throw new IllegalArgumentException("The homogeneous matrix must be 3 by 3 by definition.");
        }
        if (ret == null) {
            ret = new Se2_F32();
        }
        ret.setTranslation(H.get(0, 2), H.get(1, 2));
        float c = H.get(0, 0);
        float s = H.get(1, 0);
        ret.setYaw((float)Math.atan2(s, c));
        return ret;
    }

    public static Se3_F32 eulerXyz(float dx, float dy, float dz, float rotX, float rotY, float rotZ, @Nullable Se3_F32 se) {
        return SpecialEuclideanOps_F32.eulerXyz(dx, dy, dz, EulerType.XYZ, rotX, rotY, rotZ, se);
    }

    public static Se3_F32 eulerXyz(float dx, float dy, float dz, EulerType type, float rotX, float rotY, float rotZ, @Nullable Se3_F32 se) {
        if (se == null) {
            se = new Se3_F32();
        }
        ConvertRotation3D_F32.eulerToMatrix(type, rotX, rotY, rotZ, se.getR());
        Vector3D_F32 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }

    public static Se3_F32 axisXyz(float dx, float dy, float dz, float rotX, float rotY, float rotZ, @Nullable Se3_F32 se) {
        float theta;
        if (se == null) {
            se = new Se3_F32();
        }
        if ((theta = (float)Math.sqrt(rotX * rotX + rotY + rotY + rotZ * rotZ)) == 0.0f) {
            CommonOps_FDRM.setIdentity(se.R);
        } else {
            ConvertRotation3D_F32.rodriguesToMatrix(rotX / theta, rotY / theta, rotZ / theta, theta, se.getR());
        }
        Vector3D_F32 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }

    public static Se3_F32 quatXyz(float dx, float dy, float dz, float qw, float qx, float qy, float qz, @Nullable Se3_F32 se) {
        if (se == null) {
            se = new Se3_F32();
        }
        ConvertRotation3D_F32.quaternionToMatrix(qw, qx, qy, qz, se.getR());
        Vector3D_F32 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }

    public static boolean isIdentical(Se3_F32 a, Se3_F32 b, float tolT, float tolR) {
        if (Math.abs(a.T.x - b.T.x) > tolT) {
            return false;
        }
        if (Math.abs(a.T.y - b.T.y) > tolT) {
            return false;
        }
        if (Math.abs(a.T.z - b.T.z) > tolT) {
            return false;
        }
        FMatrixRMaj D2 = new FMatrixRMaj(3, 3);
        CommonOps_FDRM.multTransA(a.R, b.R, D2);
        Rodrigues_F32 rod = new Rodrigues_F32();
        ConvertRotation3D_F32.matrixToRodrigues(D2, rod);
        return rod.theta <= tolR;
    }

    public static boolean bestFit(Se3_F32 a) {
        SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd(true, true, true);
        if (!svd.decompose(a.R)) {
            throw new RuntimeException("SVD Failed");
        }
        CommonOps_FDRM.multTransB(svd.getU(null, false), svd.getV(null, false), a.R);
        float det = CommonOps_FDRM.det(a.R);
        if (det < 0.0f) {
            CommonOps_FDRM.scale(-1.0f, a.R);
        }
        float b = 1.0f;
        float[] s = svd.getSingularValues();
        for (int i = 0; i < svd.numberOfSingularValues(); ++i) {
            b *= s[i];
        }
        b = Math.signum(det) / (float)Math.pow(b, 0.3333333432674408);
        GeometryMath_F32.scale(a.T, b);
        return true;
    }
}

