/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.EulerType;
import georegression.struct.RotationType;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.SpecialEuclidean;
import georegression.struct.so.Quaternion_F32;
import georegression.struct.so.Rodrigues_F32;
import georegression.transform.se.SePointOps_F32;
import java.text.DecimalFormat;
import org.ejml.UtilEjml;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.jetbrains.annotations.Nullable;

public class Se3_F32
implements SpecialEuclidean<Se3_F32> {
    public static final long serialVersionUID = 1L;
    public FMatrixRMaj R;
    public Vector3D_F32 T;

    public Se3_F32() {
        this.R = CommonOps_FDRM.identity(3);
        this.T = new Vector3D_F32();
    }

    public Se3_F32(FMatrixRMaj R, Vector3D_F32 T) {
        this(R, T, false);
    }

    public Se3_F32(FMatrixRMaj R, Vector3D_F32 T, boolean assign) {
        if (assign) {
            this.R = R;
            this.T = T;
        } else {
            this.R = R.copy();
            this.T = T.copy();
        }
    }

    @Override
    public void setTo(Se3_F32 se) {
        this.R.setTo(se.getR());
        this.T.setTo(se.getT());
    }

    public void setRotation(FMatrixRMaj R) {
        this.R.setTo(R);
    }

    public void setTranslation(Vector3D_F32 T) {
        this.T.setTo(T);
    }

    public void setTranslation(float x, float y, float z) {
        this.T.setTo(x, y, z);
    }

    public FMatrixRMaj getRotation() {
        return this.R;
    }

    public Vector3D_F32 getTranslation() {
        return this.T;
    }

    public FMatrixRMaj getR() {
        return this.R;
    }

    public Vector3D_F32 getT() {
        return this.T;
    }

    public float getX() {
        return this.T.getX();
    }

    public float getY() {
        return this.T.getY();
    }

    public float getZ() {
        return this.T.getZ();
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Se3_F32 createInstance() {
        return new Se3_F32();
    }

    @Override
    public Se3_F32 concat(Se3_F32 second, @Nullable Se3_F32 result) {
        if (result == null) {
            result = new Se3_F32();
        }
        CommonOps_FDRM.mult(second.getR(), this.getR(), result.getR());
        GeometryMath_F32.mult(second.getR(), this.getT(), result.getT());
        GeometryMath_F32.add(second.getT(), result.getT(), result.getT());
        return result;
    }

    @Override
    public Se3_F32 invert(@Nullable Se3_F32 inverse) {
        if (inverse == null) {
            inverse = new Se3_F32();
        }
        GeometryMath_F32.multTran(this.R, this.T, inverse.T);
        GeometryMath_F32.changeSign(inverse.T);
        CommonOps_FDRM.transpose(this.R, inverse.R);
        return inverse;
    }

    @Override
    public void reset() {
        CommonOps_FDRM.setIdentity(this.R);
        this.T.setTo(0.0f, 0.0f, 0.0f);
    }

    public void setTo(float x, float y, float z, EulerType type, float rotA, float rotB, float rotC) {
        this.T.setTo(x, y, z);
        ConvertRotation3D_F32.eulerToMatrix(type, rotA, rotB, rotC, this.R);
    }

    public void setTo(float x, float y, float z, RotationType type, float A, float B, float C, float D2) {
        this.T.setTo(x, y, z);
        switch (type) {
            case RODRIGUES: {
                ConvertRotation3D_F32.rodriguesToMatrix(A, B, C, D2, this.R);
                break;
            }
            case QUATERNION: {
                ConvertRotation3D_F32.quaternionToMatrix(A, B, C, D2, this.R);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type is not supported. " + (Object)((Object)type));
            }
        }
    }

    public Point3D_F32 transform(Point3D_F32 src, @Nullable Point3D_F32 dst) {
        return SePointOps_F32.transform(this, src, dst);
    }

    public Point3D_F32 transformReverse(Point3D_F32 src, @Nullable Point3D_F32 dst) {
        return SePointOps_F32.transformReverse(this, src, dst);
    }

    public Vector3D_F32 transform(Vector3D_F32 src, @Nullable Vector3D_F32 dst) {
        return GeometryMath_F32.mult(this.R, src, dst);
    }

    public Vector3D_F32 transformReverse(Vector3D_F32 src, @Nullable Vector3D_F32 dst) {
        return GeometryMath_F32.multTran(this.R, src, dst);
    }

    public Se3_F32 copy() {
        Se3_F32 ret = new Se3_F32();
        ret.setTo(this);
        return ret;
    }

    public String toString() {
        String ret = "Se3_F32: T = " + this.T.toString() + "\n";
        ret = ret + this.R;
        return ret;
    }

    public String toString(RotationType type) {
        DecimalFormat format = new DecimalFormat("#");
        int sig = 4;
        String tx = UtilEjml.fancyString(this.T.x, format, false, 11, 4);
        String ty = UtilEjml.fancyString(this.T.y, format, false, 11, 4);
        String tz = UtilEjml.fancyString(this.T.z, format, false, 11, 4);
        String ret = "Se3_F32: T=(" + tx + ", " + ty + ", " + tz + "), ";
        switch (type) {
            case EULER: {
                float[] euler = new float[3];
                ConvertRotation3D_F32.matrixToEuler(this.R, EulerType.XYZ, euler);
                ret = ret + "EulerXYZ=(" + UtilEjml.fancyString(euler[0], format, false, 11, 4) + ", " + UtilEjml.fancyString(euler[1], format, false, 11, 4) + ", " + UtilEjml.fancyString(euler[2], format, false, 11, 4) + ")";
                break;
            }
            case RODRIGUES: {
                Rodrigues_F32 rod = ConvertRotation3D_F32.matrixToRodrigues(this.R, null);
                ret = ret + "Rodrigues={n=(" + UtilEjml.fancyString(rod.unitAxisRotation.x, format, false, 11, 4) + ", " + UtilEjml.fancyString(rod.unitAxisRotation.y, format, false, 11, 4) + ", " + UtilEjml.fancyString(rod.unitAxisRotation.z, format, false, 11, 4) + "), theta=" + UtilEjml.fancyString(rod.theta, format, false, 11, 4) + "}";
                break;
            }
            case QUATERNION: {
                Quaternion_F32 quat = ConvertRotation3D_F32.matrixToQuaternion(this.R, null);
                ret = ret + "Quaternion=(" + UtilEjml.fancyString(quat.x, format, false, 11, 4) + ", " + UtilEjml.fancyString(quat.y, format, false, 11, 4) + ", " + UtilEjml.fancyString(quat.z, format, false, 11, 4) + ", " + UtilEjml.fancyString(quat.w, format, false, 11, 4) + ")";
            }
        }
        return ret;
    }

    public void print() {
        System.out.println(this);
    }

    public void print(RotationType type) {
        System.out.println(this.toString(type));
    }
}

