/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.struct.GeoTuple_I32;

public class Point3D_I32
extends GeoTuple_I32<Point3D_I32> {
    public int x;
    public int y;
    public int z;

    public Point3D_I32(Point3D_I32 pt) {
        this(pt.x, pt.y, pt.z);
    }

    public Point3D_I32(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3D_I32() {
    }

    @Override
    public Point3D_I32 copy() {
        return new Point3D_I32(this.x, this.y, this.z);
    }

    @Override
    public int getIdx(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        if (index == 2) {
            return this.z;
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public void setIdx(int index, int value) {
        if (index == 0) {
            this.x = value;
        } else if (index == 1) {
            this.y = value;
        } else if (index == 2) {
            this.z = value;
        } else {
            throw new RuntimeException("Invalid index " + index);
        }
    }

    public void setTo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void setTo(Point3D_I32 p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public boolean isIdentical(Point3D_I32 p) {
        return this.x == p.x && this.y == p.y && this.z == p.z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String toString() {
        return "P( " + this.x + " " + this.y + " " + this.z + " )";
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Point3D_I32 createNewInstance() {
        return new Point3D_I32();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point3D_I32)) {
            return false;
        }
        Point3D_I32 p = (Point3D_I32)obj;
        return this.x == p.x && this.y == p.y && this.z == p.z;
    }

    public int hashCode() {
        return Integer.hashCode(this.x + this.y + this.z);
    }
}

