/*
 * Decompiled with CFR 0.152.
 */
package georegression.misc;

public class StoppingCondition {
    int maxIterations;
    double errorThreshold;
    double errorRelativeChange = 1.0E-8;
    int iteration;
    double previousError;

    public StoppingCondition(int maxIterations, double errorThreshold) {
        this.maxIterations = maxIterations;
        this.errorThreshold = errorThreshold;
    }

    public StoppingCondition(int maxIterations, double errorThreshold, double errorRelativeChange) {
        this.maxIterations = maxIterations;
        this.errorThreshold = errorThreshold;
        this.errorRelativeChange = errorRelativeChange;
    }

    public void reset() {
        this.iteration = 0;
        this.previousError = 0.0;
    }

    public boolean isFinished(double foundError) {
        if (foundError < this.errorThreshold) {
            return true;
        }
        if (this.iteration++ > 0 && Math.abs(this.previousError - foundError) / this.previousError <= this.errorRelativeChange) {
            return true;
        }
        this.previousError = foundError;
        return this.iteration >= this.maxIterations;
    }

    public StoppingCondition copy() {
        return new StoppingCondition(this.maxIterations, this.errorThreshold, this.errorRelativeChange);
    }

    public int getIteration() {
        return this.iteration;
    }
}

