/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint2D_F64;
import georegression.geometry.UtilPoint2D_I32;
import georegression.struct.line.LineParametric2D_I32;
import georegression.struct.line.LineSegment2D_I32;
import georegression.struct.point.Point2D_I32;

public class Distance2D_I32 {
    public static double distance(LineSegment2D_I32 line, Point2D_I32 p) {
        int a = line.b.x - line.a.x;
        int b = line.b.y - line.a.y;
        double t = a * (p.x - line.a.x) + b * (p.y - line.a.y);
        if ((t /= (double)(a * a + b * b)) < 0.0) {
            return UtilPoint2D_I32.distance(line.a.x, line.a.y, p.x, p.y);
        }
        if (t > 1.0) {
            return UtilPoint2D_I32.distance(line.b.x, line.b.y, p.x, p.y);
        }
        return UtilPoint2D_F64.distance((double)line.a.x + t * (double)a, (double)line.a.y + t * (double)b, p.x, p.y);
    }

    public static double distance(LineParametric2D_I32 line, Point2D_I32 p) {
        int a = line.slopeX;
        int b = line.slopeY;
        double t = a * (p.x - line.p.x) + b * (p.y - line.p.y);
        return UtilPoint2D_F64.distance((double)line.p.x + (t /= (double)(a * a + b * b)) * (double)a, (double)line.p.y + t * (double)b, p.x, p.y);
    }

    public static double distanceSq(LineParametric2D_I32 line, Point2D_I32 p) {
        int a = line.slopeX;
        int b = line.slopeY;
        double t = a * (p.x - line.p.x) + b * (p.y - line.p.y);
        return UtilPoint2D_F64.distanceSq((double)line.p.x + (t /= (double)(a * a + b * b)) * (double)a, (double)line.p.y + t * (double)b, p.x, p.y);
    }
}

