/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.metric.MiscOps;
import georegression.metric.alg.DistancePointTriangle3D_F64;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.line.LineSegment3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.plane.PlaneNormal3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import org.jetbrains.annotations.Nullable;

public class ClosestPoint3D_F64 {
    @Nullable
    public static Point3D_F64 closestPoint(LineParametric3D_F64 l0, LineParametric3D_F64 l1, @Nullable Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        ret.x = l0.p.x - l1.p.x;
        ret.y = l0.p.y - l1.p.y;
        ret.z = l0.p.z - l1.p.z;
        double dv01v1 = MiscOps.dot(ret, l1.slope);
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double t0 = dv01v1 * dv1v0 - MiscOps.dot(ret, l0.slope) * dv1v1;
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0) {
            return null;
        }
        double t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        ret.x = 0.5 * (l0.p.x + t0 * l0.slope.x + (l1.p.x + t1 * l1.slope.x));
        ret.y = 0.5 * (l0.p.y + t0 * l0.slope.y + (l1.p.y + t1 * l1.slope.y));
        ret.z = 0.5 * (l0.p.z + t0 * l0.slope.z + (l1.p.z + t1 * l1.slope.z));
        return ret;
    }

    public static Point4D_F64 closestPoint(LineParametric3D_F64 l0, LineParametric3D_F64 l1, @Nullable Point4D_F64 ret) {
        if (ret == null) {
            ret = new Point4D_F64();
        }
        ret.x = l0.p.x - l1.p.x;
        ret.y = l0.p.y - l1.p.y;
        ret.z = l0.p.z - l1.p.z;
        double dv01v0 = ret.x * l0.slope.x + ret.y * l0.slope.y + ret.z * l0.slope.z;
        double dv01v1 = ret.x * l1.slope.x + ret.y * l1.slope.y + ret.z * l1.slope.z;
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double t0 = dv01v1 * dv1v0 - dv01v0 * dv1v1;
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        ret.x = bottom * l0.p.x + t0 * l0.slope.x;
        ret.y = bottom * l0.p.y + t0 * l0.slope.y;
        ret.z = bottom * l0.p.z + t0 * l0.slope.z;
        ret.w = bottom;
        return ret;
    }

    public static boolean closestPoints(LineParametric3D_F64 l0, LineParametric3D_F64 l1, double[] param) {
        double dX = l0.p.x - l1.p.x;
        double dY = l0.p.y - l1.p.y;
        double dZ = l0.p.z - l1.p.z;
        double dv01v1 = MiscOps.dot(dX, dY, dZ, l1.slope);
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double t0 = dv01v1 * dv1v0 - MiscOps.dot(dX, dY, dZ, l0.slope) * dv1v1;
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0) {
            return false;
        }
        double t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        param[0] = t0;
        param[1] = t1;
        return true;
    }

    public static Point3D_F64 closestPoint(LineParametric3D_F64 line, Point3D_F64 pt, @Nullable Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        double dx = pt.x - line.p.x;
        double dy = pt.y - line.p.y;
        double dz = pt.z - line.p.z;
        double n2 = line.slope.normSq();
        double d = line.slope.x * dx + line.slope.y * dy + line.slope.z * dz;
        ret.x = line.p.x + d * line.slope.x / n2;
        ret.y = line.p.y + d * line.slope.y / n2;
        ret.z = line.p.z + d * line.slope.z / n2;
        return ret;
    }

    public static double closestPoint(LineParametric3D_F64 line, Point3D_F64 pt) {
        double dx = pt.x - line.p.x;
        double dy = pt.y - line.p.y;
        double dz = pt.z - line.p.z;
        return (line.slope.x * dx + line.slope.y * dy + line.slope.z * dz) / line.slope.normSq();
    }

    public static Point3D_F64 closestPoint(PlaneNormal3D_F64 plane, Point3D_F64 point, @Nullable Point3D_F64 found) {
        if (found == null) {
            found = new Point3D_F64();
        }
        double A = plane.n.x;
        double B = plane.n.y;
        double C = plane.n.z;
        double D2 = plane.n.x * plane.p.x + plane.n.y * plane.p.y + plane.n.z * plane.p.z;
        double top = A * point.x + B * point.y + C * point.z - D2;
        double n2 = A * A + B * B + C * C;
        found.x = point.x - A * top / n2;
        found.y = point.y - B * top / n2;
        found.z = point.z - C * top / n2;
        return found;
    }

    public static Point3D_F64 closestPoint(PlaneGeneral3D_F64 plane, Point3D_F64 point, @Nullable Point3D_F64 found) {
        if (found == null) {
            found = new Point3D_F64();
        }
        double top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        double n2 = plane.A * plane.A + plane.B * plane.B + plane.C * plane.C;
        found.x = point.x - plane.A * top / n2;
        found.y = point.y - plane.B * top / n2;
        found.z = point.z - plane.C * top / n2;
        return found;
    }

    public static Point3D_F64 closestPointOrigin(PlaneGeneral3D_F64 plane, @Nullable Point3D_F64 found) {
        if (found == null) {
            found = new Point3D_F64();
        }
        double n2 = plane.A * plane.A + plane.B * plane.B + plane.C * plane.C;
        found.x = plane.A * plane.D / n2;
        found.y = plane.B * plane.D / n2;
        found.z = plane.C * plane.D / n2;
        return found;
    }

    public static Point3D_F64 closestPoint(LineSegment3D_F64 line, Point3D_F64 pt, @Nullable Point3D_F64 ret) {
        double n;
        double dz;
        double slope_z;
        double dy;
        double slope_y;
        double dx;
        double slope_x;
        double d;
        if (ret == null) {
            ret = new Point3D_F64();
        }
        if ((d = ((slope_x = line.b.x - line.a.x) * (dx = pt.x - line.a.x) + (slope_y = line.b.y - line.a.y) * (dy = pt.y - line.a.y) + (slope_z = line.b.z - line.a.z) * (dz = pt.z - line.a.z)) / (n = Math.sqrt(slope_x * slope_x + slope_y * slope_y + slope_z * slope_z))) <= 0.0) {
            ret.setTo(line.a);
        } else if (d >= n) {
            ret.setTo(line.b);
        } else {
            ret.x = line.a.x + d * slope_x / n;
            ret.y = line.a.y + d * slope_y / n;
            ret.z = line.a.z + d * slope_z / n;
        }
        return ret;
    }

    @Nullable
    public static Point3D_F64 closestPoint(LineSegment3D_F64 l0, LineSegment3D_F64 l1, @Nullable Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        ret.x = l0.a.x - l1.a.x;
        ret.y = l0.a.y - l1.a.y;
        ret.z = l0.a.z - l1.a.z;
        double slope0_x = l0.b.x - l0.a.x;
        double slope0_y = l0.b.y - l0.a.y;
        double slope0_z = l0.b.z - l0.a.z;
        double slope1_x = l1.b.x - l1.a.x;
        double slope1_y = l1.b.y - l1.a.y;
        double slope1_z = l1.b.z - l1.a.z;
        double n0 = Math.sqrt(slope0_x * slope0_x + slope0_y * slope0_y + slope0_z * slope0_z);
        double n1 = Math.sqrt(slope1_x * slope1_x + slope1_y * slope1_y + slope1_z * slope1_z);
        double dv01v1 = ret.x * (slope1_x /= n1) + ret.y * (slope1_y /= n1) + ret.z * (slope1_z /= n1);
        double dv01v0 = ret.x * (slope0_x /= n0) + ret.y * (slope0_y /= n0) + ret.z * (slope0_z /= n0);
        double dv1v0 = slope1_x * slope0_x + slope1_y * slope0_y + slope1_z * slope0_z;
        double t0 = dv01v1 * dv1v0 - dv01v0;
        double bottom = 1.0 - dv1v0 * dv1v0;
        if (bottom == 0.0) {
            return null;
        }
        if ((t0 /= bottom) < 0.0) {
            return ClosestPoint3D_F64.closestPoint(l1, l0.a, ret);
        }
        if (t0 > 1.0) {
            return ClosestPoint3D_F64.closestPoint(l1, l0.b, ret);
        }
        double t1 = dv01v1 + t0 * dv1v0;
        if (t1 < 0.0) {
            return ClosestPoint3D_F64.closestPoint(l0, l1.a, ret);
        }
        if (t1 > 1.0) {
            return ClosestPoint3D_F64.closestPoint(l0, l1.b, ret);
        }
        ret.x = 0.5 * (l0.a.x + t0 * slope0_x + (l1.a.x + t1 * slope1_x));
        ret.y = 0.5 * (l0.a.y + t0 * slope0_y + (l1.a.y + t1 * slope1_y));
        ret.z = 0.5 * (l0.a.z + t0 * slope0_z + (l1.a.z + t1 * slope1_z));
        return ret;
    }

    public static Point3D_F64 closestPoint(Point3D_F64 vertexA, Point3D_F64 vertexB, Point3D_F64 vertexC, Point3D_F64 point, @Nullable Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        DistancePointTriangle3D_F64 alg = new DistancePointTriangle3D_F64();
        alg.setTriangle(vertexA, vertexB, vertexC);
        alg.closestPoint(point, ret);
        return ret;
    }

    public static double closestPointT(LineParametric3D_F64 line, PlaneNormal3D_F64 plane) {
        double dx = plane.p.x - line.p.x;
        double dy = plane.p.y - line.p.y;
        double dz = plane.p.z - line.p.z;
        double top = dx * plane.n.x + dy * plane.n.y + dz * plane.n.z;
        double bottom = line.slope.dot(plane.n);
        if (bottom == 0.0) {
            return Double.NaN;
        }
        return top / bottom;
    }
}

