/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point4D_F32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UtilPoint4D_F32 {
    public static boolean isInfiniteH(Point4D_F32 p, float tol) {
        float n = (float)Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        return Math.abs(p.w) <= n * tol;
    }

    public static List<Point4D_F32> randomN(Point4D_F32 center, float stdev, int num, Random rand) {
        ArrayList<Point4D_F32> ret = new ArrayList<Point4D_F32>();
        for (int i = 0; i < num; ++i) {
            Point4D_F32 p = new Point4D_F32();
            p.x = center.x + (float)rand.nextGaussian() * stdev;
            p.y = center.y + (float)rand.nextGaussian() * stdev;
            p.z = center.z + (float)rand.nextGaussian() * stdev;
            p.w = center.w + (float)rand.nextGaussian() * stdev;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point4D_F32> randomN(Point3D_F32 center, float w, float stdev, int num, Random rand) {
        ArrayList<Point4D_F32> ret = new ArrayList<Point4D_F32>();
        for (int i = 0; i < num; ++i) {
            Point4D_F32 p = new Point4D_F32();
            p.x = center.x + (float)rand.nextGaussian() * stdev;
            p.y = center.y + (float)rand.nextGaussian() * stdev;
            p.z = center.z + (float)rand.nextGaussian() * stdev;
            p.w = w;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point4D_F32> random(float min, float max, int num, Random rand) {
        ArrayList<Point4D_F32> ret = new ArrayList<Point4D_F32>();
        float d = max - min;
        for (int i = 0; i < num; ++i) {
            Point4D_F32 p = new Point4D_F32();
            p.x = rand.nextFloat() * d + min;
            p.y = rand.nextFloat() * d + min;
            p.z = rand.nextFloat() * d + min;
            p.w = rand.nextFloat() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static Point3D_F32 h_to_e(Point4D_F32 p) {
        Point3D_F32 out = new Point3D_F32();
        UtilPoint4D_F32.h_to_e(p, out);
        return out;
    }

    public static void h_to_e(Point4D_F32 p, Point3D_F32 out) {
        out.x = p.x / p.w;
        out.y = p.y / p.w;
        out.z = p.z / p.w;
    }
}

