/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.metric.UtilAngle;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import org.jetbrains.annotations.Nullable;

public class UtilLine2D_F64 {
    public static double acuteAngle(LineGeneral2D_F64 a, LineGeneral2D_F64 b) {
        double lb;
        double la = Math.sqrt(a.A * a.A + a.B * a.B);
        double value = (a.A * b.A + a.B * b.B) / (la * (lb = Math.sqrt(b.A * b.A + b.B * b.B)));
        if (value < -1.0) {
            value = -1.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return Math.acos(value);
    }

    public static double acuteAngleN(LineGeneral2D_F64 a, LineGeneral2D_F64 b) {
        double value = a.A * b.A + a.B * b.B;
        if (value < -1.0) {
            value = -1.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return Math.acos(value);
    }

    public static LineParametric2D_F64 convert(LinePolar2D_F64 src, @Nullable LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        double c = Math.cos(src.angle);
        double s = Math.sin(src.angle);
        ret.p.setTo(c * src.distance, s * src.distance);
        ret.slope.setTo(-s, c);
        return ret;
    }

    public static LineGeneral2D_F64 convert(LinePolar2D_F64 src, @Nullable LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        double c = Math.cos(src.angle);
        double s = Math.sin(src.angle);
        ret.A = c;
        ret.B = s;
        ret.C = -src.distance;
        return ret;
    }

    public static LinePolar2D_F64 convert(LineGeneral2D_F64 src, @Nullable LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        double r = Math.sqrt(src.A * src.A + src.B * src.B);
        double sign = src.C < 0.0 ? -1.0 : 1.0;
        ret.angle = Math.atan2(-sign * src.B / r, -sign * src.A / r);
        ret.distance = sign * src.C / r;
        return ret;
    }

    public static LineParametric2D_F64 convert(LineSegment2D_F64 src, @Nullable LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.p.setTo(src.a);
        ret.slope.setTo(src.slopeX(), src.slopeY());
        return ret;
    }

    public static LineGeneral2D_F64 convert(LineSegment2D_F64 src, @Nullable LineGeneral2D_F64 ret) {
        return UtilLine2D_F64.convert(src.a, src.b, ret);
    }

    public static LineGeneral2D_F64 convert(Point2D_F64 a, Point2D_F64 b, @Nullable LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        ret.A = a.y - b.y;
        ret.B = b.x - a.x;
        ret.C = -(ret.A * a.x + ret.B * a.y);
        return ret;
    }

    public static LineParametric2D_F64 convert(Point2D_F64 a, Point2D_F64 b, @Nullable LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.p.setTo(a);
        ret.slope.x = b.x - a.x;
        ret.slope.y = b.y - a.y;
        return ret;
    }

    public static LineParametric2D_F64 convert(Point2D_F64 a, double angle, @Nullable LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.p.setTo(a);
        ret.slope.x = Math.cos(angle);
        ret.slope.y = Math.sin(angle);
        return ret;
    }

    public static LinePolar2D_F64 convert(LineParametric2D_F64 src, @Nullable LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        double top = src.slope.y * src.p.x - src.slope.x * src.p.y;
        ret.distance = top / src.slope.norm();
        ret.angle = Math.atan2(-src.slope.x, src.slope.y);
        if (ret.distance < 0.0) {
            ret.distance = -ret.distance;
            ret.angle = UtilAngle.bound(ret.angle + Math.PI);
        }
        return ret;
    }

    public static LineGeneral2D_F64 convert(LineParametric2D_F64 src, @Nullable LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        ret.A = -src.slope.y;
        ret.B = src.slope.x;
        ret.C = -ret.A * src.p.x - ret.B * src.p.y;
        return ret;
    }

    public static LineParametric2D_F64 convert(LineGeneral2D_F64 src, @Nullable LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.slope.x = src.B;
        ret.slope.y = -src.A;
        if (Math.abs(src.B) > Math.abs(src.A)) {
            ret.p.y = -src.C / src.B;
            ret.p.x = 0.0;
        } else {
            ret.p.x = -src.C / src.A;
            ret.p.y = 0.0;
        }
        return ret;
    }

    public static double area2(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        return (b.x - a.x) * (c.y - a.y) - (c.x - a.x) * (b.y - a.y);
    }

    public static boolean isColinear(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, double tol) {
        return Math.abs(UtilLine2D_F64.area2(a, b, c)) <= tol;
    }

    public static boolean isBetweenColinear(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        if (Math.abs(a.x - b.x) >= Math.abs(a.y - b.y)) {
            return a.x <= c.x && c.x <= b.x || a.x >= c.x && c.x >= b.x;
        }
        return a.y <= c.y && c.y <= b.y || a.y >= c.y && c.y >= b.y;
    }

    public static boolean isBetweenColinearExclusive(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        if (Math.abs(a.x - b.x) >= Math.abs(a.y - b.y)) {
            return a.x < c.x && c.x < b.x || a.x > c.x && c.x > b.x;
        }
        return a.y < c.y && c.y < b.y || a.y > c.y && c.y > b.y;
    }
}

