/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.curve.ConicGeneral_F32;
import georegression.struct.curve.ParabolaGeneral_F32;
import georegression.struct.curve.ParabolaParametric_F32;
import org.ejml.data.FMatrix3x3;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class UtilCurves_F32 {
    public static FMatrixRMaj convert(ConicGeneral_F32 src, @Nullable FMatrixRMaj dst) {
        if (dst == null) {
            dst = new FMatrixRMaj(3, 3);
        } else {
            dst.reshape(3, 3);
        }
        float B = src.B / 2.0f;
        float D2 = src.D / 2.0f;
        float E = src.E / 2.0f;
        dst.data[0] = src.A;
        dst.data[1] = B;
        dst.data[2] = D2;
        dst.data[3] = B;
        dst.data[4] = src.C;
        dst.data[5] = E;
        dst.data[6] = D2;
        dst.data[7] = E;
        dst.data[8] = src.F;
        return dst;
    }

    public static ConicGeneral_F32 convert(FMatrix3x3 src, @Nullable ConicGeneral_F32 dst) {
        if (dst == null) {
            dst = new ConicGeneral_F32();
        }
        dst.A = src.a11;
        dst.B = 2.0f * src.a12;
        dst.D = 2.0f * src.a13;
        dst.C = src.a22;
        dst.E = 2.0f * src.a23;
        dst.F = src.a33;
        return dst;
    }

    public static FMatrix3x3 convert(ConicGeneral_F32 src, @Nullable FMatrix3x3 dst) {
        if (dst == null) {
            dst = new FMatrix3x3();
        }
        float B = src.B / 2.0f;
        float D2 = src.D / 2.0f;
        float E = src.E / 2.0f;
        dst.a11 = src.A;
        dst.a12 = B;
        dst.a13 = D2;
        dst.a21 = B;
        dst.a22 = src.C;
        dst.a23 = E;
        dst.a31 = D2;
        dst.a32 = E;
        dst.a33 = src.F;
        return dst;
    }

    public static ConicGeneral_F32 convert(FMatrixRMaj src, @Nullable ConicGeneral_F32 dst) {
        if (dst == null) {
            dst = new ConicGeneral_F32();
        }
        dst.A = src.data[0];
        dst.B = 2.0f * src.data[1];
        dst.D = 2.0f * src.data[2];
        dst.C = src.data[4];
        dst.E = 2.0f * src.data[5];
        dst.F = src.data[8];
        return dst;
    }

    public static ParabolaGeneral_F32 convert(ConicGeneral_F32 src, @Nullable ParabolaGeneral_F32 dst) {
        if (dst == null) {
            dst = new ParabolaGeneral_F32();
        }
        dst.A = Math.signum(src.A) * (float)Math.sqrt(Math.abs(src.A));
        dst.C = Math.signum(src.C) * (float)Math.sqrt(Math.abs(src.C));
        dst.D = src.D;
        dst.E = src.E;
        dst.F = src.F;
        return dst;
    }

    public static ConicGeneral_F32 convert(ParabolaGeneral_F32 src, @Nullable ConicGeneral_F32 dst) {
        if (dst == null) {
            dst = new ConicGeneral_F32();
        }
        dst.A = src.A * src.A;
        dst.B = src.A * src.C * 2.0f;
        dst.C = src.C * src.C;
        dst.D = src.D;
        dst.E = src.E;
        dst.F = src.F;
        return dst;
    }

    public static ParabolaParametric_F32 convert(ParabolaGeneral_F32 src, @Nullable ParabolaParametric_F32 dst) {
        if (dst == null) {
            dst = new ParabolaParametric_F32();
        }
        float A = src.A;
        float C = src.C;
        float D2 = src.D;
        float E = src.E;
        float F = src.F;
        float bottom = C * D2 - A * E;
        if (bottom == 0.0f) {
            throw new RuntimeException("Not a parabola");
        }
        dst.A = -C / bottom;
        dst.B = E / bottom;
        dst.C = -C * F / bottom;
        dst.D = A / bottom;
        dst.E = -D2 / bottom;
        dst.F = A * F / bottom;
        return dst;
    }

    public static ParabolaGeneral_F32 convert(ParabolaParametric_F32 src, @Nullable ParabolaGeneral_F32 dst) {
        if (dst == null) {
            dst = new ParabolaGeneral_F32();
        }
        float Z2 = src.A * src.E - src.B * src.D;
        dst.A = src.D / Z2;
        dst.C = -src.A / Z2;
        dst.D = -src.E / Z2;
        dst.E = src.B / Z2;
        dst.F = Math.abs(dst.A) > Math.abs(dst.C) ? src.F / Z2 / dst.A : (dst.C != 0.0f ? -src.C / Z2 / dst.C : 0.0f);
        return dst;
    }
}

