/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.so;

import georegression.fitting.MotionTransformPoint;
import georegression.struct.point.Point3D_F64;
import georegression.struct.so.So3_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class MotionSo3PointSVD_F64
implements MotionTransformPoint<So3_F64, Point3D_F64> {
    private So3_F64 rotation = new So3_F64();
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(3, 3, true, true, false);

    @Override
    public So3_F64 getTransformSrcToDst() {
        return this.rotation;
    }

    @Override
    public boolean process(List<Point3D_F64> srcPts, List<Point3D_F64> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        int N = srcPts.size();
        double s11 = 0.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s21 = 0.0;
        double s22 = 0.0;
        double s23 = 0.0;
        double s31 = 0.0;
        double s32 = 0.0;
        double s33 = 0.0;
        for (int i = 0; i < N; ++i) {
            Point3D_F64 f = srcPts.get(i);
            Point3D_F64 t = dstPts.get(i);
            s11 += t.x * f.x;
            s12 += t.x * f.y;
            s13 += t.x * f.z;
            s21 += t.y * f.x;
            s22 += t.y * f.y;
            s23 += t.y * f.z;
            s31 += t.z * f.x;
            s32 += t.z * f.y;
            s33 += t.z * f.z;
        }
        DMatrixRMaj Sigma = new DMatrixRMaj(3, 3, true, s11, s12, s13, s21, s22, s23, s31, s32, s33);
        if (!this.svd.decompose(Sigma)) {
            return false;
        }
        DMatrixRMaj U = this.svd.getU(null, false);
        DMatrixRMaj V = this.svd.getV(null, false);
        SingularOps_DDRM.descendingOrder(U, false, this.svd.getSingularValues(), 3, V, false);
        if (CommonOps_DDRM.det(U) < 0.0 ^ CommonOps_DDRM.det(V) < 0.0) {
            V.data[2] = -V.data[2];
            V.data[5] = -V.data[5];
            V.data[8] = -V.data[8];
        }
        CommonOps_DDRM.multTransB(U, V, this.rotation.R);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

