/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.so;

import georegression.fitting.MotionTransformPoint;
import georegression.struct.point.Point3D_F32;
import georegression.struct.so.So3_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.SingularOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F32;

public class MotionSo3PointSVD_F32
implements MotionTransformPoint<So3_F32, Point3D_F32> {
    private So3_F32 rotation = new So3_F32();
    SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd(3, 3, true, true, false);

    @Override
    public So3_F32 getTransformSrcToDst() {
        return this.rotation;
    }

    @Override
    public boolean process(List<Point3D_F32> srcPts, List<Point3D_F32> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        int N = srcPts.size();
        float s11 = 0.0f;
        float s12 = 0.0f;
        float s13 = 0.0f;
        float s21 = 0.0f;
        float s22 = 0.0f;
        float s23 = 0.0f;
        float s31 = 0.0f;
        float s32 = 0.0f;
        float s33 = 0.0f;
        for (int i = 0; i < N; ++i) {
            Point3D_F32 f = srcPts.get(i);
            Point3D_F32 t = dstPts.get(i);
            s11 += t.x * f.x;
            s12 += t.x * f.y;
            s13 += t.x * f.z;
            s21 += t.y * f.x;
            s22 += t.y * f.y;
            s23 += t.y * f.z;
            s31 += t.z * f.x;
            s32 += t.z * f.y;
            s33 += t.z * f.z;
        }
        FMatrixRMaj Sigma = new FMatrixRMaj(3, 3, true, s11, s12, s13, s21, s22, s23, s31, s32, s33);
        if (!this.svd.decompose(Sigma)) {
            return false;
        }
        FMatrixRMaj U = this.svd.getU(null, false);
        FMatrixRMaj V = this.svd.getV(null, false);
        SingularOps_FDRM.descendingOrder(U, false, this.svd.getSingularValues(), 3, V, false);
        if (CommonOps_FDRM.det(U) < 0.0f ^ CommonOps_FDRM.det(V) < 0.0f) {
            V.data[2] = -V.data[2];
            V.data[5] = -V.data[5];
            V.data[8] = -V.data[8];
        }
        CommonOps_FDRM.multTransB(U, V, this.rotation.R);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

