/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.polygon;

import georegression.struct.point.Point3D_F32;
import georegression.struct.shapes.Box3D_F32;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FitPolygon3D_F32 {
    public static Box3D_F32 boxAabb(List<Point3D_F32> points, @Nullable Box3D_F32 rectangle) {
        if (rectangle == null) {
            rectangle = new Box3D_F32();
        }
        if (points.isEmpty()) {
            rectangle.setTo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return rectangle;
        }
        Point3D_F32 p0 = points.get(0);
        float x0 = p0.x;
        float x1 = p0.x;
        float y0 = p0.y;
        float y1 = p0.y;
        float z0 = p0.z;
        float z1 = p0.z;
        for (int i = 1; i < points.size(); ++i) {
            Point3D_F32 p = points.get(i);
            if (p.x < x0) {
                x0 = p.x;
            } else if (p.x > x1) {
                x1 = p.x;
            }
            if (p.y < y0) {
                y0 = p.y;
            } else if (p.y > y1) {
                y1 = p.y;
            }
            if (p.z < z0) {
                z0 = p.z;
                continue;
            }
            if (!(p.z > z1)) continue;
            z1 = p.z;
        }
        rectangle.setTo(x0, y0, z0, x1, y1, x1);
        return rectangle;
    }
}

