/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.polygon;

import georegression.fitting.polygon.FitConvexHull_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import java.util.Comparator;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class ConvexHullGrahamScan_F32
implements FitConvexHull_F32 {
    Point2D_F32 pivot = new Point2D_F32();
    final FastArray<Point2D_F32> stack = new FastArray<Point2D_F32>(Point2D_F32.class);
    final CompareAngle compareAngle = new CompareAngle();
    final QuickSortComparator<Point2D_F32> sorter = new QuickSortComparator<Point2D_F32>(this.compareAngle);

    @Override
    public void process(FastAccess<Point2D_F32> points, Polygon2D_F32 output) {
        int i;
        output.vertexes.reset();
        if (points.isEmpty()) {
            return;
        }
        this.stack.clear();
        int indexLowestX = this.findLowestX(points);
        this.pivot = points.get(indexLowestX);
        this.sorter.sort((Point2D_F32[])((Point2D_F32[])points.data), points.size);
        if (points.get(0) != this.pivot) {
            throw new RuntimeException("BUG!");
        }
        for (i = 0; i < points.size; ++i) {
            while (this.stack.size >= 2 && ConvexHullGrahamScan_F32.isCW((Point2D_F32)this.stack.getTail(1), (Point2D_F32)this.stack.getTail(), points.get(i)) >= 0) {
                this.stack.removeTail();
            }
            this.stack.add(points.get(i));
        }
        output.vertexes.resize(this.stack.size());
        for (i = 0; i < this.stack.size; ++i) {
            ((Point2D_F32)output.vertexes.get(i)).setTo((Point2D_F32)this.stack.get(i));
        }
    }

    private int findLowestX(FastAccess<Point2D_F32> points) {
        int selectedIndex = 0;
        Point2D_F32 pivot = points.get(selectedIndex);
        for (int i = 1; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            if (!(p.x <= pivot.x)) continue;
            if (p.x == pivot.x) {
                if (!(p.y < pivot.y)) continue;
                pivot = p;
                selectedIndex = i;
                continue;
            }
            pivot = p;
            selectedIndex = i;
        }
        return selectedIndex;
    }

    static int isCW(Point2D_F32 pivot, Point2D_F32 a, Point2D_F32 b) {
        float dxa = a.x - pivot.x;
        float dya = a.y - pivot.y;
        float dxb = b.x - pivot.x;
        float dyb = b.y - pivot.y;
        float cross = dxa * dyb - dya * dxb;
        return Float.compare(0.0f, cross);
    }

    class CompareAngle
    implements Comparator<Point2D_F32> {
        CompareAngle() {
        }

        @Override
        public int compare(Point2D_F32 a, Point2D_F32 b) {
            float dxa = a.x - ConvexHullGrahamScan_F32.this.pivot.x;
            float dyb = b.y - ConvexHullGrahamScan_F32.this.pivot.y;
            float dya = a.y - ConvexHullGrahamScan_F32.this.pivot.y;
            float dxb = b.x - ConvexHullGrahamScan_F32.this.pivot.x;
            float cross = dxa * dyb - dya * dxb;
            if (cross < 0.0f) {
                return 1;
            }
            if (cross > 0.0f) {
                return -1;
            }
            float ra = dxa * dxa + dya * dya;
            float rb = dxb * dxb + dyb * dyb;
            return Float.compare(ra, rb);
        }
    }
}

