/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.polygon;

import georegression.fitting.polygon.FitConvexHull_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class ConvexHullAndrewMonotone_F64
implements FitConvexHull_F64 {
    QuickSortComparator<Point2D_F64> sorter;
    FastArray<Point2D_F64> stack = new FastArray<Point2D_F64>(Point2D_F64.class);

    public ConvexHullAndrewMonotone_F64() {
        this.sorter = new QuickSortComparator((a, b) -> {
            if (a.x < b.x) {
                return -1;
            }
            if (a.x > b.x) {
                return 1;
            }
            if (a.y < b.y) {
                return -1;
            }
            if (a.y > b.y) {
                return 1;
            }
            return 0;
        });
    }

    @Override
    public void process(FastAccess<Point2D_F64> points, Polygon2D_F64 output) {
        int i;
        output.vertexes.reset();
        if (points.size <= 2) {
            output.vertexes.resize(points.size);
            for (int i2 = 0; i2 < points.size; ++i2) {
                output.get(i2).setTo(((Point2D_F64[])points.data)[i2]);
            }
            return;
        }
        int length = points.size;
        this.sorter.sort((Point2D_F64[])((Point2D_F64[])points.data), length);
        this.stack.reset();
        for (int i3 = 0; i3 < length; ++i3) {
            Point2D_F64 p = ((Point2D_F64[])points.data)[i3];
            while (this.stack.size() >= 2 && ConvexHullAndrewMonotone_F64.subtractThenCross(p, (Point2D_F64)this.stack.getTail(), (Point2D_F64)this.stack.getTail(1)) >= 0.0) {
                this.stack.removeTail();
            }
            this.stack.add(p);
        }
        this.stack.removeTail();
        int minSize = this.stack.size + 2;
        for (i = length - 1; i >= 0; --i) {
            Point2D_F64 p = ((Point2D_F64[])points.data)[i];
            while (this.stack.size() >= minSize && ConvexHullAndrewMonotone_F64.subtractThenCross(p, (Point2D_F64)this.stack.getTail(), (Point2D_F64)this.stack.getTail(1)) >= 0.0) {
                this.stack.removeTail();
            }
            this.stack.add(p);
        }
        this.stack.removeTail();
        output.vertexes.resize(this.stack.size());
        for (i = 0; i < this.stack.size; ++i) {
            ((Point2D_F64)output.vertexes.get(i)).setTo((Point2D_F64)this.stack.get(i));
        }
    }

    private static double subtractThenCross(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        double x0 = b.x - a.x;
        double y0 = b.y - a.y;
        double x1 = c.x - a.x;
        double y1 = c.y - a.y;
        return x0 * y1 - y0 * x1;
    }
}

