/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.points;

import georegression.fitting.points.ClosestPointToModel;
import georegression.struct.GeoTuple_F64;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PointModel<T extends GeoTuple_F64>
implements ClosestPointToModel<T> {
    private List<T> points;
    private double maxDistanceSq;

    public PointModel(List<T> points) {
        this.points = points;
        this.maxDistanceSq = Double.MAX_VALUE;
    }

    public PointModel(List<T> points, double maxDistance) {
        this.points = points;
        this.maxDistanceSq = maxDistance * maxDistance;
    }

    public void setPoints(List<T> points) {
        this.points = points;
    }

    @Override
    @Nullable
    public T findClosestPoint(T target) {
        if (this.points.size() <= 0) {
            return null;
        }
        GeoTuple_F64 closestPoint = (GeoTuple_F64)this.points.get(0);
        double closestDist = closestPoint.distance2(target);
        for (int i = 1; i < this.points.size(); ++i) {
            GeoTuple_F64 p = (GeoTuple_F64)this.points.get(i);
            double d = p.distance2(target);
            if (!(d < closestDist)) continue;
            closestDist = d;
            closestPoint = p;
        }
        if (closestDist >= this.maxDistanceSq) {
            return null;
        }
        return (T)closestPoint;
    }
}

