/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.struct.curve.EllipseQuadratic_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_FDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.jetbrains.annotations.Nullable;

public class FitEllipseWeightedAlgebraic_F32 {
    private FMatrixRMaj D1 = new FMatrixRMaj(3, 1);
    private FMatrixRMaj D2 = new FMatrixRMaj(3, 1);
    private FMatrixRMaj S1 = new FMatrixRMaj(3, 3);
    private FMatrixRMaj S2 = new FMatrixRMaj(3, 3);
    private FMatrixRMaj S3 = new FMatrixRMaj(3, 3);
    private FMatrixRMaj M = new FMatrixRMaj(3, 3);
    private FMatrixRMaj T = new FMatrixRMaj(3, 3);
    private FMatrixRMaj Ta1 = new FMatrixRMaj(3, 1);
    private FMatrixRMaj S2_tran = new FMatrixRMaj(3, 3);
    private LinearSolverDense<FMatrixRMaj> solver = LinearSolverFactory_FDRM.linear(3);
    private EigenDecomposition<FMatrixRMaj> eigen = DecompositionFactory_FDRM.eig(3, true, false);
    private EllipseQuadratic_F32 ellipse = new EllipseQuadratic_F32();

    public boolean process(List<Point2D_F32> points, float[] weights) {
        if (points.size() > weights.length) {
            throw new IllegalArgumentException("Weights must be as long as the number of points. " + points.size() + " vs " + weights.length);
        }
        int N = points.size();
        this.D1.reshape(N, 3);
        this.D2.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float w = weights[i];
            this.D1.data[index] = w * p.x * p.x;
            this.D2.data[index++] = w * p.x;
            this.D1.data[index] = w * p.x * p.y;
            this.D2.data[index++] = w * p.y;
            this.D1.data[index] = w * p.y * p.y;
            this.D2.data[index++] = w;
        }
        CommonOps_FDRM.multTransA(this.D1, this.D1, this.S1);
        CommonOps_FDRM.multTransA(this.D1, this.D2, this.S2);
        CommonOps_FDRM.multTransA(this.D2, this.D2, this.S3);
        if (!this.solver.setA(this.S3)) {
            return false;
        }
        CommonOps_FDRM.transpose(this.S2, this.S2_tran);
        CommonOps_FDRM.changeSign(this.S2_tran);
        this.solver.solve(this.S2_tran, this.T);
        CommonOps_FDRM.mult(this.S2, this.T, this.M);
        CommonOps_FDRM.add(this.M, this.S1, this.M);
        for (int col = 0; col < 3; ++col) {
            float m0 = this.M.unsafe_get(0, col);
            float m1 = this.M.unsafe_get(1, col);
            float m2 = this.M.unsafe_get(2, col);
            this.M.unsafe_set(0, col, m2 / 2.0f);
            this.M.unsafe_set(1, col, -m1);
            this.M.unsafe_set(2, col, m0 / 2.0f);
        }
        if (!this.eigen.decompose(this.M)) {
            return false;
        }
        FMatrixRMaj a1 = this.selectBestEigenVector();
        if (a1 == null) {
            return false;
        }
        CommonOps_FDRM.mult(this.T, a1, this.Ta1);
        this.ellipse.A = a1.data[0];
        this.ellipse.B = a1.data[1] / 2.0f;
        this.ellipse.C = a1.data[2];
        this.ellipse.D = this.Ta1.data[0] / 2.0f;
        this.ellipse.E = this.Ta1.data[1] / 2.0f;
        this.ellipse.F = this.Ta1.data[2];
        return true;
    }

    @Nullable
    private FMatrixRMaj selectBestEigenVector() {
        int bestIndex = -1;
        float bestCond = Float.MAX_VALUE;
        for (int i = 0; i < this.eigen.getNumberOfEigenvalues(); ++i) {
            FMatrixRMaj v = this.eigen.getEigenVector(i);
            if (v == null) continue;
            float cond = 4.0f * v.get(0) * v.get(2) - v.get(1) * v.get(1);
            float condError = (cond - 1.0f) * (cond - 1.0f);
            if (!(cond > 0.0f) || !(condError < bestCond)) continue;
            bestCond = condError;
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return this.eigen.getEigenVector(bestIndex);
    }

    public EllipseQuadratic_F32 getEllipse() {
        return this.ellipse;
    }
}

