/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.forward.standard;

import deepboof.BaseTensor;
import deepboof.Tensor;
import deepboof.forward.ConfigPadding;
import deepboof.forward.SpatialPadding2D;

public abstract class BaseSpatialPadding2D<T extends Tensor<T>>
extends BaseTensor
implements SpatialPadding2D<T> {
    protected ConfigPadding config;
    protected T input;
    protected int ROW0;
    protected int ROW1;
    protected int COL0;
    protected int COL1;

    public BaseSpatialPadding2D(ConfigPadding config) {
        this.config = config;
    }

    @Override
    public void setInput(T input) {
        if (((BaseTensor)input).getDimension() != 4) {
            throw new IllegalArgumentException("Expected 4-DOF spatial tensor");
        }
        this.input = input;
        int rows = ((Tensor)input).length(2);
        int cols = ((Tensor)input).length(3);
        this.COL0 = this.config.x0;
        this.ROW0 = this.config.y0;
        this.COL1 = cols + this.config.x0;
        this.ROW1 = rows + this.config.y0;
        this.shape = this.shapeGivenInput(((Tensor)input).shape);
    }

    @Override
    public int getPaddingRow0() {
        return this.config.y0;
    }

    @Override
    public int getPaddingCol0() {
        return this.config.x0;
    }

    @Override
    public int getPaddingRow1() {
        return this.config.y1;
    }

    @Override
    public int getPaddingCol1() {
        return this.config.x1;
    }

    @Override
    public int[] shapeGivenInput(int ... inputShape) {
        if (inputShape.length == 3) {
            return new int[]{inputShape[0], inputShape[1] + this.config.y0 + this.config.y1, inputShape[2] + this.config.x0 + this.config.x1};
        }
        if (inputShape.length == 4) {
            return new int[]{inputShape[0], inputShape[1], inputShape[2] + this.config.y0 + this.config.y1, inputShape[3] + this.config.x0 + this.config.x1};
        }
        throw new IllegalArgumentException("Spatial tensor with 3 or 4 dof expected");
    }

    public <T extends Tensor<T>> void checkBackwardsShapeChannel(Tensor<T> padded, Tensor<T> original) {
        if (padded.getDimension() != 2) {
            throw new IllegalArgumentException("Padded image expected to be a 2D spatial image, i.e. 2 channels");
        }
        if (original.getDimension() != 4) {
            throw new IllegalArgumentException("Original image expected to be a 4D spatial image, i.e. 4 channels");
        }
        if (padded.length(0) != original.length(2) + this.config.y0 + this.config.y1) {
            throw new IllegalArgumentException("Image heights do not match.  " + padded.length(0) + " != " + original.length(2) + this.config.y0 + this.config.y1);
        }
        if (padded.length(1) != original.length(3) + this.config.x0 + this.config.x1) {
            throw new IllegalArgumentException("Image widths do not match.  " + padded.length(1) + " != " + original.length(3) + this.config.x0 + this.config.x1);
        }
    }

    public <T extends Tensor<T>> void checkBackwardsShapeImage(Tensor<T> padded, Tensor<T> original) {
        if (padded.getDimension() != 3) {
            throw new IllegalArgumentException("Padded image expected to be a 3D spatial image, i.e. 3 channels");
        }
        if (original.getDimension() != 4) {
            throw new IllegalArgumentException("Original image expected to be a 4D spatial image, i.e. 4 channels");
        }
        if (padded.length(0) != original.length(1)) {
            throw new IllegalArgumentException("Image channels do not match.  " + padded.length(0) + " != " + original.length(1));
        }
        if (padded.length(1) != original.length(2) + this.config.y0 + this.config.y1) {
            throw new IllegalArgumentException("Image heights do not match.  " + padded.length(1) + " != " + original.length(2) + this.config.y0 + this.config.y1);
        }
        if (padded.length(2) != original.length(3) + this.config.x0 + this.config.x1) {
            throw new IllegalArgumentException("Image widths do not match.  " + padded.length(2) + " != " + original.length(3) + this.config.x0 + this.config.x1);
        }
    }
}

