/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.packed;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import georegression.struct.point.Point4D_F32;
import org.ddogleg.struct.BigDogArray_F32;
import org.ddogleg.struct.BigDogGrowth;

public class PackedBigArrayPoint4D_F32
implements PackedArray<Point4D_F32> {
    private static final int DOF = 4;
    private final BigDogArray_F32 dog;
    public final Point4D_F32 temp = new Point4D_F32();
    protected int numPoints;

    public PackedBigArrayPoint4D_F32() {
        this(10);
    }

    public PackedBigArrayPoint4D_F32(int reservedPoints) {
        this(reservedPoints, 50000, BigDogGrowth.GROW_FIRST);
    }

    public PackedBigArrayPoint4D_F32(int reservedPoints, int blockSize, BigDogGrowth growth) {
        this.dog = new BigDogArray_F32(reservedPoints * 4, blockSize * 4, growth);
    }

    @Override
    public void reset() {
        this.dog.reset();
        this.numPoints = 0;
    }

    @Override
    public void reserve(int numPoints) {
        this.dog.reserve(numPoints * 4);
    }

    public void append(float x, float y, float z, float w) {
        this.dog.add(x);
        this.dog.add(y);
        this.dog.add(z);
        this.dog.add(w);
        ++this.numPoints;
    }

    @Override
    public void append(Point4D_F32 element) {
        this.dog.add(element.x);
        this.dog.add(element.y);
        this.dog.add(element.z);
        this.dog.add(element.w);
        ++this.numPoints;
    }

    @Override
    public Point4D_F32 getTemp(int index) {
        float[] block = (float[])this.dog.getBlocks().get((index *= 4) / this.dog.getBlockSize());
        int element = index % this.dog.getBlockSize();
        this.temp.x = block[element];
        this.temp.y = block[element + 1];
        this.temp.z = block[element + 2];
        this.temp.w = block[element + 3];
        return this.temp;
    }

    @Override
    public void getCopy(int index, Point4D_F32 dst) {
        float[] block = (float[])this.dog.getBlocks().get((index *= 4) / this.dog.getBlockSize());
        int element = index % this.dog.getBlockSize();
        dst.x = block[element];
        dst.y = block[element + 1];
        dst.z = block[element + 2];
        dst.w = block[element + 3];
    }

    @Override
    public void copy(Point4D_F32 src, Point4D_F32 dst) {
        dst.setTo(src);
    }

    @Override
    public int size() {
        return this.numPoints;
    }

    @Override
    public Class<Point4D_F32> getElementType() {
        return Point4D_F32.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<Point4D_F32> op) {
        this.dog.processByBlock(idx0 * 4, idx1 * 4, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / 4;
            for (int i = arrayIdx0; i < arrayIdx1; i += 4) {
                this.temp.x = array[i];
                this.temp.y = array[i + 1];
                this.temp.z = array[i + 2];
                this.temp.w = array[i + 3];
                op.process(pointIndex++, this.temp);
            }
        });
    }
}

