/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.struct.feature.TupleDesc_U8;
import java.util.Arrays;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;

public class ComputeMeanTuple_U8
implements ComputeMeanClusters<TupleDesc_U8> {
    final DogArray_I32 counts = new DogArray_I32();
    final DogArray<int[]> means = new DogArray<int[]>(() -> new int[DOF]);
    final int DOF;

    public ComputeMeanTuple_U8(int DOF) {
        this.DOF = DOF;
    }

    @Override
    public void process(LArrayAccessor<TupleDesc_U8> points, DogArray_I32 assignments, FastAccess<TupleDesc_U8> clusters) {
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        this.counts.resetResize(clusters.size, 0);
        this.means.resize(clusters.size);
        for (int i = 0; i < this.means.size; ++i) {
            Arrays.fill((int[])this.means.get(i), 0);
        }
        for (int pointIdx = 0; pointIdx < points.size(); ++pointIdx) {
            int clusterIdx;
            byte[] point = points.getTemp((int)pointIdx).data;
            int n = clusterIdx = assignments.get(pointIdx);
            this.counts.data[n] = this.counts.data[n] + 1;
            int[] cluster = (int[])this.means.get(clusterIdx);
            for (int i = 0; i < point.length; ++i) {
                int n2 = i;
                cluster[n2] = cluster[n2] + (point[i] & 0xFF);
            }
        }
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            int[] mean = (int[])this.means.get(clusterIdx);
            byte[] cluster = clusters.get((int)clusterIdx).data;
            double divisor = this.counts.get(clusterIdx);
            for (int i = 0; i < mean.length; ++i) {
                cluster[i] = (byte)((double)mean[i] / divisor);
            }
        }
    }

    @Override
    public ComputeMeanClusters<TupleDesc_U8> newInstanceThread() {
        return new ComputeMeanTuple_U8(this.DOF);
    }
}

