/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.geo;

import georegression.struct.point.Point2D_F64;

public class AssociatedTriple {
    public Point2D_F64 p1;
    public Point2D_F64 p2;
    public Point2D_F64 p3;

    public AssociatedTriple(Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3) {
        this(p1, p2, p3, true);
    }

    public AssociatedTriple(Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3, boolean newInstance) {
        if (newInstance) {
            this.p1 = p1.copy();
            this.p2 = p2.copy();
            this.p3 = p3.copy();
        } else {
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }
    }

    public AssociatedTriple() {
        this.p1 = new Point2D_F64();
        this.p2 = new Point2D_F64();
        this.p3 = new Point2D_F64();
    }

    public void setTo(AssociatedTriple a) {
        this.p1.setTo(a.p1);
        this.p2.setTo(a.p2);
        this.p3.setTo(a.p3);
    }

    public void setTo(Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3) {
        this.p1.setTo(p1);
        this.p2.setTo(p2);
        this.p3.setTo(p3);
    }

    public void setTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.p1.setTo(x1, y1);
        this.p2.setTo(x2, y2);
        this.p3.setTo(x3, y3);
    }

    public AssociatedTriple copy() {
        AssociatedTriple r = new AssociatedTriple();
        r.setTo(this);
        return r;
    }

    public Point2D_F64 get(int i) {
        Point2D_F64 point2D_F64;
        switch (i) {
            case 0: {
                point2D_F64 = this.p1;
                break;
            }
            case 1: {
                point2D_F64 = this.p2;
                break;
            }
            case 2: {
                point2D_F64 = this.p3;
                break;
            }
            default: {
                throw new IllegalArgumentException("index must be 0,1,2");
            }
        }
        return point2D_F64;
    }

    public void set(int i, double x, double y) {
        switch (i) {
            case 0: {
                this.p1.setTo(x, y);
                break;
            }
            case 1: {
                this.p2.setTo(x, y);
                break;
            }
            case 2: {
                this.p3.setTo(x, y);
                break;
            }
            default: {
                throw new IllegalArgumentException("index must be 0,1,2");
            }
        }
    }

    public boolean isIdentical(AssociatedTriple o, double tol) {
        if (tol < o.p1.distance(this.p1)) {
            return false;
        }
        if (tol < o.p2.distance(this.p2)) {
            return false;
        }
        return tol >= o.p3.distance(this.p3);
    }

    public void print() {
        System.out.println("AssociatedTriple( " + this.p1 + " , " + this.p2 + " , " + this.p3 + " )");
    }
}

