/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel1D;

public class Kernel1D_F64
extends Kernel1D {
    public double[] data;

    public Kernel1D_F64(double[] data, int width) {
        this(data, width, width / 2);
    }

    public Kernel1D_F64(double[] data, int width, int offset) {
        super(width, offset);
        this.data = new double[width];
        System.arraycopy(data, 0, this.data, 0, width);
    }

    public Kernel1D_F64(int width) {
        this(width, width / 2);
    }

    public Kernel1D_F64(int width, int offset) {
        super(width, offset);
        this.data = new double[width];
    }

    protected Kernel1D_F64() {
    }

    @Override
    public double getDouble(int index) {
        return this.data[index];
    }

    @Override
    public void setD(int index, double value) {
        this.data[index] = value;
    }

    public static Kernel1D_F64 wrap(double[] data, int width, int offset) {
        Kernel1D_F64 ret = new Kernel1D_F64();
        ret.data = data;
        ret.width = width;
        ret.offset = offset;
        return ret;
    }

    public Kernel1D_F64 copy() {
        Kernel1D_F64 ret = new Kernel1D_F64(this.width, this.offset);
        System.arraycopy(this.data, 0, ret.data, 0, ret.width);
        return ret;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public double get(int i) {
        return this.data[i];
    }

    public double computeSum() {
        double sum = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            sum += this.data[i];
        }
        return sum;
    }

    public double[] getData() {
        return this.data;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            System.out.printf("%6.3f ", this.data[i]);
        }
        System.out.println();
    }
}

