/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import java.util.List;

public class LookUpImageFilesByIndex
implements LookUpImages {
    final List<String> paths;
    final ImageDimension dimension = new ImageDimension(-1, -1);
    LoadImage loader;

    public LookUpImageFilesByIndex(List<String> paths) {
        this(paths, (path, output) -> UtilImageIO.loadImage(path, true, output));
    }

    public LookUpImageFilesByIndex(List<String> paths, LoadImage loader) {
        this.paths = paths;
        this.loader = loader;
    }

    @Override
    public boolean loadShape(String name, ImageDimension shape) {
        int index = Integer.parseInt(name);
        if (index < 0 || index >= this.paths.size()) {
            return false;
        }
        if (this.dimension.height == -1) {
            GrayU8 gray = new GrayU8(1, 1);
            this.loader.load(this.paths.get(0), gray);
            this.dimension.width = gray.getWidth();
            this.dimension.height = gray.getHeight();
        }
        shape.setTo(this.dimension);
        return true;
    }

    @Override
    public <LT extends ImageBase<LT>> boolean loadImage(String name, LT output) {
        int index = Integer.parseInt(name);
        if (index < 0 || index >= this.paths.size()) {
            return false;
        }
        this.loader.load(this.paths.get(index), output);
        if (this.dimension.width == -1) {
            this.dimension.setTo(output.width, output.height);
        } else {
            BoofMiscOps.checkEq(this.dimension.width, output.width);
            BoofMiscOps.checkEq(this.dimension.height, output.height);
        }
        return true;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public LoadImage getLoader() {
        return this.loader;
    }

    public void setLoader(LoadImage loader) {
        this.loader = loader;
    }

    @FunctionalInterface
    public static interface LoadImage {
        public void load(String var1, ImageBase var2);
    }
}

