/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.structure;

import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.alg.structure.ConfigProjectiveReconstruction;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.feature.detect.selector.ConfigSelectLimit;
import boofcv.factory.sfm.ConfigBundleUtils;
import boofcv.factory.structure.ConfigGeneratePairwiseImageGraph;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public class ConfigSequenceToSparseScene
implements Configuration {
    public int maxImagePixels = 480000;
    public final ConfigBundleUtils bundleAdjustment = new ConfigBundleUtils();
    public final ConfigProjectiveReconstruction projective = new ConfigProjectiveReconstruction();
    public final ConfigPointTracker tracker = new ConfigPointTracker();
    public final ConfigGeneratePairwiseImageGraph pairwise = new ConfigGeneratePairwiseImageGraph();

    public ConfigSequenceToSparseScene() {
        int radius = 5;
        this.tracker.typeTracker = ConfigPointTracker.TrackerType.KLT;
        this.tracker.klt.pruneClose = true;
        this.tracker.klt.toleranceFB = 2.0;
        this.tracker.klt.templateRadius = radius;
        this.tracker.klt.maximumTracks.setFixed(800.0);
        this.tracker.klt.config.maxIterations = 30;
        this.tracker.detDesc.typeDetector = ConfigDetectInterestPoint.Type.POINT;
        this.tracker.detDesc.detectPoint.type = PointDetectorTypes.SHI_TOMASI;
        this.tracker.detDesc.detectPoint.shiTomasi.radius = 6;
        this.tracker.detDesc.detectPoint.general.radius = 4;
        this.tracker.detDesc.detectPoint.general.selector = ConfigSelectLimit.selectUniform(2.0);
        this.bundleAdjustment.keepFraction = 0.95;
    }

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.maxImagePixels > 0);
        this.bundleAdjustment.checkValidity();
        this.projective.checkValidity();
        this.tracker.checkValidity();
        this.pairwise.checkValidity();
    }

    public void setTo(ConfigSequenceToSparseScene src) {
        this.maxImagePixels = src.maxImagePixels;
        this.bundleAdjustment.setTo(src.bundleAdjustment);
        this.projective.setTo(src.projective);
        this.tracker.setTo(src.tracker);
        this.pairwise.setTo(src.pairwise);
    }
}

