/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public class ConfigSelfCalibEssentialGuess
implements Configuration {
    public double sampleMin = 0.3;
    public double sampleMax = 3.0;
    public int numberOfSamples = 50;
    public boolean fixedFocus = true;

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.sampleMin > 0.0, "Minimum focal length must be more than 0");
        BoofMiscOps.checkTrue(this.sampleMin < this.sampleMax, "Minimum focal length must less than the maximum");
        BoofMiscOps.checkTrue(this.numberOfSamples >= 1);
    }

    public void setTo(ConfigSelfCalibEssentialGuess src) {
        this.sampleMin = src.sampleMin;
        this.sampleMax = src.sampleMax;
        this.numberOfSamples = src.numberOfSamples;
        this.fixedFocus = src.fixedFocus;
    }
}

