/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.disparity;

import boofcv.abst.transform.census.FilterCensusTransform;
import boofcv.alg.disparity.DisparityBlockMatchRowFormat;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.alg.disparity.block.BlockRowScoreMutualInformation;
import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.alg.disparity.block.DisparitySparseSelect;
import boofcv.alg.disparity.block.select.SelectCorrelationSubpixel;
import boofcv.alg.disparity.block.select.SelectCorrelationWithChecks_F32;
import boofcv.alg.disparity.block.select.SelectCorrelationWta_F32_U8;
import boofcv.alg.disparity.block.select.SelectErrorBasicWta_F32_U8;
import boofcv.alg.disparity.block.select.SelectErrorBasicWta_S32_U8;
import boofcv.alg.disparity.block.select.SelectErrorSubpixel;
import boofcv.alg.disparity.block.select.SelectErrorWithChecks_F32;
import boofcv.alg.disparity.block.select.SelectErrorWithChecks_S32;
import boofcv.alg.disparity.block.select.SelectSparseErrorBasicWta_F32;
import boofcv.alg.disparity.block.select.SelectSparseErrorBasicWta_S32;
import boofcv.alg.disparity.block.select.SelectSparseErrorSubpixel;
import boofcv.alg.disparity.block.select.SelectSparseErrorWithChecksWta_F32;
import boofcv.alg.disparity.block.select.SelectSparseErrorWithChecksWta_S32;
import boofcv.alg.disparity.sgm.SgmDisparitySelector;
import boofcv.alg.disparity.sgm.SgmDisparitySelector_MT;
import boofcv.alg.disparity.sgm.SgmStereoDisparity;
import boofcv.alg.disparity.sgm.SgmStereoDisparityCensus;
import boofcv.alg.disparity.sgm.SgmStereoDisparityError;
import boofcv.alg.disparity.sgm.SgmStereoDisparityHmi;
import boofcv.alg.disparity.sgm.cost.SgmCostAbsoluteDifference;
import boofcv.alg.disparity.sgm.cost.SgmCostFromBlocks;
import boofcv.alg.disparity.sgm.cost.SgmCostHamming;
import boofcv.alg.disparity.sgm.cost.StereoMutualInformation;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.disparity.ConfigDisparityBM;
import boofcv.factory.disparity.ConfigDisparitySGM;
import boofcv.factory.disparity.FactoryStereoDisparity;
import boofcv.factory.transform.census.FactoryCensusTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class FactoryStereoDisparityAlgs {
    public static SgmStereoDisparity createSgm(@Nullable ConfigDisparitySGM config) {
        if (config == null) {
            config = new ConfigDisparitySGM();
        }
        int maxError = config.maxError < 0 ? Integer.MAX_VALUE : config.maxError;
        SgmDisparitySelector selector = BoofConcurrency.USE_CONCURRENT ? new SgmDisparitySelector_MT() : new SgmDisparitySelector();
        selector.setRightToLeftTolerance(config.validateRtoL);
        selector.setMaxError(maxError);
        selector.setTextureThreshold(config.texture);
        SgmStereoDisparity sgm = !config.useBlocks ? FactoryStereoDisparityAlgs.createSgmNativeCost(config, selector) : FactoryStereoDisparityAlgs.createSgmBlockCost(config, selector, GrayU8.class);
        sgm.setDisparityMin(config.disparityMin);
        sgm.setDisparityRange(config.disparityRange);
        sgm.getAggregation().setPathsConsidered(config.paths.getCount());
        sgm.getAggregation().setPenalty1(config.penaltySmallChange);
        sgm.getAggregation().setPenalty2(config.penaltyLargeChange);
        return sgm;
    }

    private static SgmStereoDisparity createSgmNativeCost(ConfigDisparitySGM config, SgmDisparitySelector selector) {
        SgmStereoDisparity sgm;
        switch (config.errorType) {
            case MUTUAL_INFORMATION: {
                StereoMutualInformation stereoMI = FactoryStereoDisparityAlgs.createStereoMutualInformation(config);
                sgm = new SgmStereoDisparityHmi(config.configHMI.pyramidLayers, stereoMI, selector);
                sgm.setExtraIterations(config.configHMI.extraIterations);
                break;
            }
            case ABSOLUTE_DIFFERENCE: {
                sgm = new SgmStereoDisparityError(new SgmCostAbsoluteDifference.U8(), selector);
                break;
            }
            case CENSUS: {
                SgmCostHamming cost;
                FilterCensusTransform censusTran = FactoryCensusTransform.variant(config.configCensus.variant, true, GrayU8.class);
                Class censusType = censusTran.getOutputType().getImageClass();
                if (censusType == GrayU8.class) {
                    cost = new SgmCostHamming.U8();
                } else if (censusType == GrayS32.class) {
                    cost = new SgmCostHamming.S32();
                } else if (censusType == GrayS64.class) {
                    cost = new SgmCostHamming.S64();
                } else {
                    throw new IllegalArgumentException("Unsupported image type");
                }
                sgm = new SgmStereoDisparityCensus<GrayU8, GrayU8>(censusTran, cost, selector);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown error type " + (Object)((Object)config.errorType));
            }
        }
        return sgm;
    }

    private static <T extends ImageGray<T>> SgmStereoDisparity createSgmBlockCost(ConfigDisparitySGM config, SgmDisparitySelector selector, Class<T> imageType) {
        SgmStereoDisparityHmi sgm;
        DisparityBlockMatchRowFormat<T, GrayU8> blockScore;
        ConfigDisparityBM configBM = new ConfigDisparityBM();
        configBM.regionRadiusX = config.configBlockMatch.radiusX;
        configBM.regionRadiusY = config.configBlockMatch.radiusY;
        configBM.disparityMin = config.disparityMin;
        configBM.disparityRange = config.disparityRange;
        configBM.border = config.border;
        SgmCostFromBlocks<GrayU8> blockCost = new SgmCostFromBlocks<GrayU8>();
        switch (config.errorType) {
            case MUTUAL_INFORMATION: {
                if (imageType != GrayU8.class) {
                    throw new IllegalArgumentException("Only GrayU8 supported at this time for Mutual Information");
                }
                StereoMutualInformation stereoMI = FactoryStereoDisparityAlgs.createStereoMutualInformation(config);
                BlockRowScoreMutualInformation.U8 rowScore = new BlockRowScoreMutualInformation.U8(stereoMI);
                rowScore.setBorder(FactoryImageBorder.generic(config.border, rowScore.getImageType()));
                blockScore = FactoryStereoDisparityAlgs.createSgmBlockMatch(config, imageType, configBM, blockCost, rowScore);
                blockScore.setBorder(FactoryImageBorder.generic(config.border, rowScore.getImageType()));
                sgm = new SgmStereoDisparityHmi(config.configHMI.pyramidLayers, stereoMI, selector, blockCost);
                sgm.setExtraIterations(config.configHMI.extraIterations);
                break;
            }
            case ABSOLUTE_DIFFERENCE: {
                BlockRowScore rowScore = FactoryStereoDisparity.createScoreRowSad(configBM, imageType);
                blockScore = FactoryStereoDisparityAlgs.createSgmBlockMatch(config, imageType, configBM, blockCost, rowScore);
                blockScore.setBorder(FactoryImageBorder.generic(config.border, rowScore.getImageType()));
                sgm = new SgmStereoDisparityError(blockCost, selector);
                break;
            }
            case CENSUS: {
                FilterCensusTransform censusTran = FactoryCensusTransform.variant(config.configCensus.variant, true, imageType);
                BlockRowScore rowScore = FactoryStereoDisparity.createCensusRowScore(configBM, censusTran);
                blockScore = FactoryStereoDisparityAlgs.createSgmBlockMatch(config, censusTran.getOutputType().getImageClass(), configBM, blockCost, rowScore);
                blockScore.setBorder(FactoryImageBorder.generic(config.border, censusTran.getOutputType()));
                sgm = new SgmStereoDisparityCensus(censusTran, blockCost, selector);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown error type " + (Object)((Object)config.errorType));
            }
        }
        blockCost.setBlockScore(blockScore);
        return sgm;
    }

    private static StereoMutualInformation createStereoMutualInformation(ConfigDisparitySGM config) {
        StereoMutualInformation stereoMI = new StereoMutualInformation();
        stereoMI.configureSmoothing(config.configHMI.smoothingRadius);
        stereoMI.configureHistogram(config.configHMI.totalGrayLevels);
        return stereoMI;
    }

    private static <T extends ImageGray<T>> DisparityBlockMatchRowFormat<T, GrayU8> createSgmBlockMatch(ConfigDisparitySGM config, Class<T> imageType, ConfigDisparityBM configBM, SgmCostFromBlocks<T> blockCost, BlockRowScore rowScore) {
        DisparityBlockMatchRowFormat disparityBlockMatchRowFormat;
        switch (config.configBlockMatch.approach) {
            case BASIC: {
                disparityBlockMatchRowFormat = FactoryStereoDisparity.createBlockMatching(configBM, imageType, blockCost, rowScore);
                break;
            }
            case BEST5: {
                disparityBlockMatchRowFormat = FactoryStereoDisparity.createBestFive(configBM, imageType, blockCost, rowScore);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)config.configBlockMatch.approach));
            }
        }
        DisparityBlockMatchRowFormat blockScore = disparityBlockMatchRowFormat;
        return blockScore;
    }

    public static DisparitySelect<int[], GrayU8> selectDisparity_S32(int maxError, int tolR2L, double texture) {
        if (maxError < 0 && tolR2L < 0 && texture <= 0.0) {
            return new SelectErrorBasicWta_S32_U8();
        }
        return new SelectErrorWithChecks_S32.DispU8(maxError, tolR2L, texture);
    }

    public static DisparitySelect<float[], GrayU8> selectDisparity_F32(int maxError, int tolR2L, double texture) {
        if (maxError < 0 && tolR2L < 0 && texture <= 0.0) {
            return new SelectErrorBasicWta_F32_U8();
        }
        return new SelectErrorWithChecks_F32.DispU8(maxError, tolR2L, texture);
    }

    public static <D extends ImageGray<D>> DisparitySelect<float[], D> selectCorrelation_F32(int tolR2L, double texture, boolean subpixel) {
        if (!subpixel && tolR2L < 0 && texture <= 0.0) {
            return new SelectCorrelationWta_F32_U8();
        }
        if (!subpixel) {
            return new SelectCorrelationWithChecks_F32.DispU8(tolR2L, texture);
        }
        return new SelectCorrelationSubpixel.F32_F32(tolR2L, texture);
    }

    public static DisparitySelect<int[], GrayF32> selectDisparitySubpixel_S32(int maxError, int tolR2L, double texture) {
        return new SelectErrorSubpixel.S32_F32(maxError, tolR2L, texture);
    }

    public static DisparitySelect<float[], GrayF32> selectDisparitySubpixel_F32(int maxError, int tolR2L, double texture) {
        return new SelectErrorSubpixel.F32_F32(maxError, tolR2L, texture);
    }

    public static DisparitySparseSelect<int[]> selectDisparitySparse_S32(int maxError, double texture, int tolRightToLeft) {
        if (maxError < 0 && texture <= 0.0) {
            return new SelectSparseErrorBasicWta_S32();
        }
        return new SelectSparseErrorWithChecksWta_S32(maxError, texture, tolRightToLeft);
    }

    public static DisparitySparseSelect<float[]> selectDisparitySparse_F32(int maxError, double texture, int tolRightToLeft) {
        if (maxError < 0 && texture <= 0.0) {
            return new SelectSparseErrorBasicWta_F32();
        }
        return new SelectSparseErrorWithChecksWta_F32(maxError, texture, tolRightToLeft);
    }

    public static DisparitySparseSelect<int[]> selectDisparitySparseSubpixel_S32(int maxError, double texture, int tolRightToLeft) {
        return new SelectSparseErrorSubpixel.S32(maxError, texture, tolRightToLeft);
    }

    public static DisparitySparseSelect<float[]> selectDisparitySparseSubpixel_F32(int maxError, double texture, int tolRightToLeft) {
        return new SelectSparseErrorSubpixel.F32(maxError, texture, tolRightToLeft);
    }
}

