/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ImplConvertImage_MT {
    public static void convert(GrayU8 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)(input.data[indexSrc++] & 0xFF);
                }
            });
        } else {
            int N = input.width * input.height;
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(InterleavedU8 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)(input.data[indexSrc++] & 0xFF);
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(GrayU8 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (short)(input.data[indexSrc++] & 0xFF);
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)(input.data[i] & 0xFF);
                }
            });
        }
    }

    public static void convert(InterleavedU8 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (short)(input.data[indexSrc++] & 0xFF);
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)(input.data[i] & 0xFF);
                }
            });
        }
    }

    public static void convert(GrayU8 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(InterleavedU8 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(GrayU8 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(InterleavedU8 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(GrayU8 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(InterleavedU8 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(GrayU8 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(InterleavedU8 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFF;
                }
            });
        }
    }

    public static void convert(InterleavedU8 input, Planar<GrayU8> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayU8 band = ((GrayU8[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayU8> input, InterleavedU8 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayU8 band = ((GrayU8[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayS8 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(InterleavedS8 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(GrayS8 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS8 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS8 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS8 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS8 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS8 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS8 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS8 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS8 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS8 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS8 input, Planar<GrayS8> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayS8 band = ((GrayS8[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayS8> input, InterleavedS8 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayS8 band = ((GrayS8[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayU16 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)(input.data[indexSrc++] & 0xFFFF);
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)(input.data[i] & 0xFFFF);
                }
            });
        }
    }

    public static void convert(InterleavedU16 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)(input.data[indexSrc++] & 0xFFFF);
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)(input.data[i] & 0xFFFF);
                }
            });
        }
    }

    public static void convert(GrayU16 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (short)(input.data[indexSrc++] & 0xFFFF);
                }
            });
        } else {
            int N = input.width * input.height;
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(InterleavedU16 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (short)(input.data[indexSrc++] & 0xFFFF);
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(GrayU16 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(InterleavedU16 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(GrayU16 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(InterleavedU16 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(GrayU16 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(InterleavedU16 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(GrayU16 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(InterleavedU16 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++] & 0xFFFF;
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i] & 0xFFFF;
                }
            });
        }
    }

    public static void convert(InterleavedU16 input, Planar<GrayU16> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayU16 band = ((GrayU16[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayU16> input, InterleavedU16 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayU16 band = ((GrayU16[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayS16 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS16 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS16 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(InterleavedS16 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            System.arraycopy(input.data, 0, output.data, 0, N);
        }
    }

    public static void convert(GrayS16 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS16 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS16 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS16 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS16 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS16 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS16 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS16 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS16 input, Planar<GrayS16> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayS16 band = ((GrayS16[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayS16> input, InterleavedS16 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayS16 band = ((GrayS16[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayS32 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS32 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS32 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS32 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS32 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS32 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS32 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS32 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS32 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS32 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS32 input, Planar<GrayS32> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayS32 band = ((GrayS32[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayS32> input, InterleavedS32 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayS32 band = ((GrayS32[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayS64 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS64 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS64 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS64 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS64 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (int)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (int)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS64 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (int)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (int)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS64 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS64 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(GrayS64 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS64 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedS64 input, Planar<GrayS64> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayS64 band = ((GrayS64[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayS64> input, InterleavedS64 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayS64 band = ((GrayS64[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayF32 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF32 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF32 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF32 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF32 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (int)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (int)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF32 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (int)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (int)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF32 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (long)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (long)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF32 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (long)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (long)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF32 input, GrayF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF32 input, InterleavedF64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF32 input, Planar<GrayF32> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayF32 band = ((GrayF32[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayF32> input, InterleavedF32 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayF32 band = ((GrayF32[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convert(GrayF64 input, GrayI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF64 input, InterleavedI8 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (byte)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (byte)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF64 input, GrayI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF64 input, InterleavedI16 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (short)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (short)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF64 input, GrayS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (int)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (int)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF64 input, InterleavedS32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (int)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (int)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF64 input, GrayS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (long)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (long)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF64 input, InterleavedS64 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (long)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (long)input.data[i];
                }
            });
        }
    }

    public static void convert(GrayF64 input, GrayF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < input.width; ++x) {
                    output.data[indexDst++] = (float)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height;
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (float)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF64 input, InterleavedF32 output) {
        if (input.isSubimage() || output.isSubimage()) {
            int N = input.width * input.getNumBands();
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = input.getIndex(0, y);
                int indexDst = output.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    output.data[indexDst++] = (float)input.data[indexSrc++];
                }
            });
        } else {
            int N = input.width * input.height * input.getNumBands();
            BoofConcurrency.loopBlocks(0, N, (i0, i1) -> {
                for (int i = i0; i < i1; ++i) {
                    output.data[i] = (float)input.data[i];
                }
            });
        }
    }

    public static void convert(InterleavedF64 input, Planar<GrayF64> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayF64 band = ((GrayF64[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convert(Planar<GrayF64> input, InterleavedF64 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayF64 band = ((GrayF64[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convertU8F32(InterleavedU8 input, Planar<GrayF32> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayF32 band = ((GrayF32[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc] & 0xFF;
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convertF32U8(InterleavedF32 input, Planar<GrayU8> output) {
        int numBands = input.numBands;
        int i = 0;
        while (i < numBands) {
            GrayU8 band = ((GrayU8[])output.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex + offset;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = (byte)input.data[indexSrc];
                    indexSrc += numBands;
                }
            });
        }
    }

    public static void convertU8F32(Planar<GrayU8> input, InterleavedF32 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayU8 band = ((GrayU8[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++] & 0xFF;
                    indexDst += numBands;
                }
            });
        }
    }

    public static void convertF32U8(Planar<GrayF32> input, InterleavedU8 output) {
        int numBands = input.getNumBands();
        int i = 0;
        while (i < numBands) {
            GrayF32 band = ((GrayF32[])input.bands)[i];
            int offset = i++;
            BoofConcurrency.loopFor(0, input.height, y -> {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + offset;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = (byte)band.data[indexSrc++];
                    indexDst += numBands;
                }
            });
        }
    }
}

