/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.DogArray_I64;
import pabeles.concurrency.GrowArray;

public class GeneralizedImageOps {
    public static boolean isFloatingPoint(Class<?> imgType) {
        return GrayF.class.isAssignableFrom(imgType);
    }

    public static double get(ImageBorder img, int x, int y) {
        if (img instanceof ImageBorder_S32) {
            return ((ImageBorder_S32)img).get(x, y);
        }
        if (img instanceof ImageBorder_F32) {
            return ((ImageBorder_F32)img).get(x, y);
        }
        if (img instanceof ImageBorder_F64) {
            return ((ImageBorder_F64)img).get(x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageGray img, int x, int y) {
        if (img instanceof GrayI8) {
            return ((GrayI8)img).get(x, y);
        }
        if (img instanceof GrayI16) {
            return ((GrayI16)img).get(x, y);
        }
        if (img instanceof GrayS32) {
            return ((GrayS32)img).get(x, y);
        }
        if (img instanceof GrayF32) {
            return ((GrayF32)img).get(x, y);
        }
        if (img instanceof GrayF64) {
            return ((GrayF64)img).get(x, y);
        }
        if (img instanceof GrayS64) {
            return ((GrayS64)img).get(x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageBase img, int x, int y, int band) {
        if (img instanceof ImageGray) {
            return GeneralizedImageOps.get((ImageGray)img, x, y);
        }
        if (img instanceof ImageInterleaved) {
            return GeneralizedImageOps.get((ImageInterleaved)img, x, y, band);
        }
        if (img instanceof Planar) {
            return GeneralizedImageOps.get(((Planar)img).getBand(band), x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageInterleaved img, int x, int y, int band) {
        if (img instanceof InterleavedU8) {
            return ((InterleavedU8)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS8) {
            return ((InterleavedS8)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS16) {
            return ((InterleavedS16)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedU16) {
            return ((InterleavedU16)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS32) {
            return ((InterleavedS32)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS64) {
            return ((InterleavedS64)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedF32) {
            return ((InterleavedF32)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedF64) {
            return ((InterleavedF64)img).getBand(x, y, band);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static <T extends ImageGray> T createSingleBand(ImageDataType type, int width, int height) {
        Class typeClass = ImageType.getImageClass(ImageType.Family.GRAY, type);
        return GeneralizedImageOps.createSingleBand(typeClass, width, height);
    }

    public static <T extends ImageBase> T createImage(Class<T> type, int width, int height, int numBands) {
        if (type == Planar.class) {
            throw new IllegalArgumentException("Can't use this function with planar because the data type needs to be specified too");
        }
        if (ImageGray.class.isAssignableFrom(type)) {
            return GeneralizedImageOps.createSingleBand(type, width, height);
        }
        if (ImageInterleaved.class.isAssignableFrom(type)) {
            return GeneralizedImageOps.createInterleaved(type, width, height, numBands);
        }
        throw new RuntimeException("Unknown. " + type.getSimpleName());
    }

    public static <T extends ImageGray<T>> T createSingleBand(Class<T> type, int width, int height) {
        type = (Class)GeneralizedImageOps.convertGenericToSpecificType(type);
        return (T)ImageGray.create(type, width, height);
    }

    public static <T extends ImageInterleaved> T createInterleaved(ImageDataType type, int width, int height, int numBands) {
        Class typeClass = ImageType.getImageClass(ImageType.Family.INTERLEAVED, type);
        return GeneralizedImageOps.createInterleaved(typeClass, width, height, numBands);
    }

    public static <T extends ImageInterleaved<T>> T createInterleaved(Class<T> type, int width, int height, int numBands) {
        type = (Class)GeneralizedImageOps.convertGenericToSpecificType(type);
        return (T)ImageInterleaved.create(type, width, height, numBands);
    }

    public static void set(ImageGray img, int x, int y, double value) {
        if (GrayI.class.isAssignableFrom(img.getClass())) {
            ((GrayI)img).set(x, y, (int)value);
        } else if (img instanceof GrayF32) {
            ((GrayF32)img).set(x, y, (float)value);
        } else if (img instanceof GrayF64) {
            ((GrayF64)img).set(x, y, value);
        } else if (img instanceof GrayS64) {
            ((GrayS64)img).set(x, y, (long)value);
        } else {
            throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
        }
    }

    public static void setM(ImageBase img, int x, int y, double ... value) {
        if (img instanceof Planar) {
            Planar ms = (Planar)img;
            for (int i = 0; i < value.length; ++i) {
                GeneralizedImageOps.set(ms.getBand(i), x, y, value[i]);
            }
        } else if (img instanceof ImageInterleaved) {
            for (int band = 0; band < value.length; ++band) {
                if (img instanceof InterleavedU8) {
                    ((InterleavedU8)img).setBand(x, y, band, (byte)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS8) {
                    ((InterleavedS8)img).setBand(x, y, band, (byte)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS16) {
                    ((InterleavedS16)img).setBand(x, y, band, (short)value[band]);
                    continue;
                }
                if (img instanceof InterleavedU16) {
                    ((InterleavedU16)img).setBand(x, y, band, (short)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS32) {
                    ((InterleavedS32)img).setBand(x, y, band, (int)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS64) {
                    ((InterleavedS64)img).setBand(x, y, band, (long)value[band]);
                    continue;
                }
                if (img instanceof InterleavedF32) {
                    ((InterleavedF32)img).setBand(x, y, band, (float)value[band]);
                    continue;
                }
                if (img instanceof InterleavedF64) {
                    ((InterleavedF64)img).setBand(x, y, band, value[band]);
                    continue;
                }
                throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
            }
        } else if (img instanceof ImageGray) {
            if (value.length != 1) {
                throw new IllegalArgumentException("For a single band image the input pixel must have 1 band");
            }
            GeneralizedImageOps.set((ImageGray)img, x, y, value[0]);
        } else {
            throw new IllegalArgumentException("Add support for this image type!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setB(ImageBase img, int x, int y, int band, double value) {
        if (img instanceof Planar) {
            Planar ms = (Planar)img;
            GeneralizedImageOps.set(ms.getBand(band), x, y, value);
            return;
        } else if (img instanceof ImageInterleaved) {
            if (img instanceof InterleavedU8) {
                ((InterleavedU8)img).setBand(x, y, band, (byte)value);
                return;
            } else if (img instanceof InterleavedS8) {
                ((InterleavedS8)img).setBand(x, y, band, (byte)value);
                return;
            } else if (img instanceof InterleavedS16) {
                ((InterleavedS16)img).setBand(x, y, band, (short)value);
                return;
            } else if (img instanceof InterleavedU16) {
                ((InterleavedU16)img).setBand(x, y, band, (short)value);
                return;
            } else if (img instanceof InterleavedS32) {
                ((InterleavedS32)img).setBand(x, y, band, (int)value);
                return;
            } else if (img instanceof InterleavedS64) {
                ((InterleavedS64)img).setBand(x, y, band, (long)value);
                return;
            } else if (img instanceof InterleavedF32) {
                ((InterleavedF32)img).setBand(x, y, band, (float)value);
                return;
            } else {
                if (!(img instanceof InterleavedF64)) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ((InterleavedF64)img).setBand(x, y, band, value);
            }
            return;
        } else {
            if (!(img instanceof ImageGray)) throw new IllegalArgumentException("Add support for this image type!");
            if (band != 0) {
                throw new IllegalArgumentException("For a single band image the input pixel must have 1 band");
            }
            GeneralizedImageOps.set((ImageGray)img, x, y, value);
        }
    }

    public static <T extends ImageGray<T>> int getNumBits(Class<T> type) {
        if (type == GrayU8.class) {
            return 8;
        }
        if (type == GrayS8.class) {
            return 8;
        }
        if (type == GrayS16.class) {
            return 16;
        }
        if (type == GrayU16.class) {
            return 16;
        }
        if (type == GrayS32.class) {
            return 32;
        }
        if (type == GrayS64.class) {
            return 64;
        }
        if (type == GrayF32.class) {
            return 32;
        }
        if (type == GrayF64.class) {
            return 64;
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }

    public static GrowArray createGrowArray(ImageType<?> type) {
        if (type.getDataType().isInteger()) {
            if (type.getDataType().getNumBits() < 64) {
                return new GrowArray<DogArray_I32>(DogArray_I32::new);
            }
            return new GrowArray<DogArray_I64>(DogArray_I64::new);
        }
        if (type.getDataType().getNumBits() < 64) {
            return new GrowArray<DogArray_F32>(DogArray_F32::new);
        }
        return new GrowArray<DogArray_F64>(DogArray_F64::new);
    }

    public static <T> T convertGenericToSpecificType(Class<?> type) {
        if (type == GrayI8.class) {
            return (T)GrayU8.class;
        }
        if (type == GrayI16.class) {
            return (T)GrayS16.class;
        }
        if (type == InterleavedI8.class) {
            return (T)InterleavedU8.class;
        }
        if (type == InterleavedI16.class) {
            return (T)InterleavedS16.class;
        }
        return (T)type;
    }

    public static Object getArray(ImageGray input) {
        if (input instanceof GrayI8) {
            return ((GrayI8)input).data;
        }
        if (input instanceof GrayI16) {
            return ((GrayI16)input).data;
        }
        if (input instanceof GrayS32) {
            return ((GrayS32)input).data;
        }
        if (input instanceof GrayS64) {
            return ((GrayS64)input).data;
        }
        if (input instanceof GrayF32) {
            return ((GrayF32)input).data;
        }
        if (input instanceof GrayF64) {
            return ((GrayF64)input).data;
        }
        throw new RuntimeException("Unknown");
    }

    public static double arrayElement(Object array, int i, boolean signed) {
        if (array instanceof byte[]) {
            byte v = ((byte[])array)[i];
            if (signed) {
                return v;
            }
            return v & 0xFF;
        }
        if (array instanceof short[]) {
            short v = ((short[])array)[i];
            if (signed) {
                return v;
            }
            return v & 0xFFFF;
        }
        if (array instanceof int[]) {
            return ((int[])array)[i];
        }
        if (array instanceof long[]) {
            return ((long[])array)[i];
        }
        if (array instanceof float[]) {
            return ((float[])array)[i];
        }
        if (array instanceof double[]) {
            return ((double[])array)[i];
        }
        throw new IllegalArgumentException("Unknown array type.");
    }
}

