/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.hybrid;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.AssociateDescriptionSets2D;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.tracker.PruneCloseTracks;
import boofcv.alg.tracker.hybrid.HybridTrack;
import boofcv.alg.tracker.hybrid.PyramidKltForHybrid;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class HybridTrackerScalePoint<I extends ImageGray<I>, D extends ImageGray<D>, TD extends TupleDesc<TD>> {
    public int maxInactiveTracks = 200;
    public Random rand = new Random(345L);
    protected int imageWidth;
    protected int imageHeight;
    protected PyramidKltForHybrid<I, D> trackerKlt;
    protected double toleranceFB = -1.0;
    protected DetectDescribePoint<I, TD> detector;
    protected AssociateDescriptionSets2D<TD> associate;
    protected DogArray<HybridTrack<TD>> tracksAll;
    protected FastArray<HybridTrack<TD>> tracksActive = new FastArray<HybridTrack>(HybridTrack.class);
    protected FastArray<HybridTrack<TD>> tracksInactive = new FastArray<HybridTrack>(HybridTrack.class);
    protected List<HybridTrack<TD>> tracksSpawned = new ArrayList<HybridTrack<TD>>();
    protected List<HybridTrack<TD>> tracksDropped = new ArrayList<HybridTrack<TD>>();
    protected FastArray<TD> detectedDesc;
    protected FastArray<TD> knownDesc;
    protected DogArray_I32 detectedSet = new DogArray_I32();
    protected DogArray_I32 knownSet = new DogArray_I32();
    protected FastArray<Point2D_F64> detectedPixels = new FastArray<Point2D_F64>(Point2D_F64.class);
    protected FastArray<Point2D_F64> knownPixels = new FastArray<Point2D_F64>(Point2D_F64.class);
    protected long totalTracks = 0L;
    long frameID = -1L;
    PruneCloseTracks<HybridTrack<TD>> pruneClose;
    List<HybridTrack<TD>> closeDropped = new ArrayList<HybridTrack<TD>>();

    public HybridTrackerScalePoint(PyramidKltForHybrid<I, D> trackerKlt, DetectDescribePoint<I, TD> detector, AssociateDescription2D<TD> associate, int tooCloseRadius) {
        if (!associate.uniqueDestination() || !associate.uniqueSource()) {
            throw new IllegalArgumentException("Associations must be unique");
        }
        this.trackerKlt = trackerKlt;
        this.detector = detector;
        this.detectedDesc = new FastArray(detector.getDescriptionType());
        this.knownDesc = new FastArray(detector.getDescriptionType());
        this.associate = new AssociateDescriptionSets2D<TD>(associate);
        this.associate.initializeSets(detector.getNumberOfSets());
        this.tracksAll = new DogArray<HybridTrack>(this::createNewTrack);
        if (tooCloseRadius > 0) {
            this.pruneClose = new PruneCloseTracks(tooCloseRadius, new PruneCloseTracks.TrackInfo<HybridTrack<TD>>(){

                @Override
                public void getLocation(HybridTrack<TD> track, Point2D_F64 l) {
                    l.setTo(track.pixel);
                }

                @Override
                public long getID(HybridTrack<TD> track) {
                    return track.featureId;
                }
            });
        }
    }

    protected HybridTrack<TD> createNewTrack() {
        HybridTrack track = new HybridTrack();
        track.descriptor = this.detector.createDescription();
        return track;
    }

    public void reset() {
        this.dropAllTracks();
        this.totalTracks = 0L;
        this.frameID = -1L;
    }

    public void updateTracks(PyramidDiscrete<I> pyramid, D[] derivX, D[] derivY) {
        this.imageWidth = pyramid.getInputWidth();
        this.imageHeight = pyramid.getInputWidth();
        this.tracksDropped.clear();
        this.tracksSpawned.clear();
        if (this.frameID == -1L) {
            this.associate.initializeAssociator(this.imageWidth, this.imageHeight);
        }
        ++this.frameID;
        this.trackerKlt.setInputs(pyramid, (ImageGray[])derivX, (ImageGray[])derivY);
        for (int i = this.tracksActive.size() - 1; i >= 0; --i) {
            HybridTrack track = (HybridTrack)this.tracksActive.get(i);
            if (!this.trackerKlt.performTracking(track.trackKlt)) {
                this.tracksActive.removeSwap(i);
                this.tracksInactive.add(track);
                continue;
            }
            track.lastSeenFrameID = this.frameID;
            track.pixel.setTo(track.trackKlt.x, track.trackKlt.y);
        }
    }

    public void pruneActiveTracksWhichAreTooClose() {
        if (this.pruneClose == null) {
            return;
        }
        this.pruneClose.init(this.imageWidth, this.imageHeight);
        this.pruneClose.process(this.tracksActive.toList(), this.closeDropped);
        for (int dropIdx = 0; dropIdx < this.closeDropped.size(); ++dropIdx) {
            HybridTrack<TD> track = this.closeDropped.get(dropIdx);
            this.dropTrackByAllIndex(this.tracksAll.indexOf(track));
            this.tracksDropped.add(track);
        }
    }

    public void associateInactiveTracks(I input) {
        int i;
        int i2;
        this.detector.detect(input);
        int N = this.detector.getNumberOfFeatures();
        this.detectedDesc.resize(N);
        this.detectedSet.resize(N);
        this.detectedPixels.resize(N);
        for (i2 = 0; i2 < N; ++i2) {
            ((TupleDesc[])this.detectedDesc.data)[i2] = this.detector.getDescription(i2);
            this.detectedSet.data[i2] = this.detector.getSet(i2);
            ((Point2D_F64[])this.detectedPixels.data)[i2] = this.detector.getLocation(i2);
        }
        this.knownDesc.resize(this.tracksAll.size());
        this.knownSet.resize(this.tracksAll.size());
        this.knownPixels.resize(this.tracksAll.size());
        for (i2 = 0; i2 < this.tracksAll.size(); ++i2) {
            HybridTrack t = (HybridTrack)this.tracksAll.get(i2);
            ((TupleDesc[])this.knownDesc.data)[i2] = t.descriptor;
            this.knownSet.data[i2] = t.detectorSetId;
            ((Point2D_F64[])this.knownPixels.data)[i2] = t.pixel;
        }
        UtilFeature.setSource(this.knownDesc, this.knownSet, this.knownPixels, this.associate);
        UtilFeature.setDestination(this.detectedDesc, this.detectedSet, this.detectedPixels, this.associate);
        this.associate.associate();
        FastAccess<AssociatedIndex> matches = this.associate.getMatches();
        for (i = 0; i < matches.size; ++i) {
            boolean active;
            HybridTrack track = (HybridTrack)this.tracksAll.get(matches.get((int)i).src);
            Point2D_F64 detectedPixel = ((Point2D_F64[])this.detectedPixels.data)[matches.get((int)i).dst];
            boolean bl = active = track.lastSeenFrameID == this.frameID;
            if (!track.respawned && active) continue;
            track.respawned = true;
            track.lastSeenFrameID = this.frameID;
            track.pixel.setTo(detectedPixel);
            this.trackerKlt.setDescription((float)detectedPixel.x, (float)detectedPixel.y, track.trackKlt);
            if (active) continue;
            this.tracksActive.add(track);
        }
        for (i = this.tracksInactive.size() - 1; i >= 0; --i) {
            if (((HybridTrack)this.tracksInactive.get((int)i)).lastSeenFrameID != this.frameID) continue;
            this.tracksInactive.removeSwap(i);
        }
    }

    public void spawnNewTracks() {
        DogArray_I32 unassociatedDetected = this.associate.getUnassociatedDestination();
        for (int unassociatedIdx = 0; unassociatedIdx < unassociatedDetected.size; ++unassociatedIdx) {
            int detectedIdx = unassociatedDetected.get(unassociatedIdx);
            Point2D_F64 p = ((Point2D_F64[])this.detectedPixels.data)[detectedIdx];
            HybridTrack<TD> track = this.tracksAll.grow();
            if (track.trackKlt == null) {
                track.trackKlt = this.trackerKlt.createNewTrack();
            }
            this.trackerKlt.setDescription((float)p.x, (float)p.y, track.trackKlt);
            track.respawned = false;
            track.spawnFrameID = track.lastSeenFrameID = this.frameID;
            ++this.totalTracks;
            track.featureId = track.featureId;
            track.descriptor.setTo((TupleDesc)((TupleDesc)this.detectedDesc.get(detectedIdx)));
            track.detectorSetId = this.detectedSet.get(detectedIdx);
            track.pixel.setTo(p);
            this.tracksActive.add(track);
            this.tracksSpawned.add(track);
        }
    }

    public void dropExcessiveInactiveTracks() {
        if (this.tracksInactive.size() > this.maxInactiveTracks) {
            int numDrop = this.tracksInactive.size() - this.maxInactiveTracks;
            for (int i = 0; i < numDrop; ++i) {
                int selectedIdx = this.rand.nextInt(this.tracksInactive.size());
                HybridTrack<TD> track = this.tracksInactive.removeSwap(selectedIdx);
                int indexAll = this.tracksAll.indexOf(track);
                this.tracksAll.removeSwap(indexAll);
            }
        }
    }

    public boolean dropTrack(HybridTrack<TD> track) {
        int index = this.tracksAll.indexOf(track);
        if (index < 0) {
            return false;
        }
        HybridTrack<TD> dropped = this.dropTrackByAllIndex(index);
        assert (dropped == track);
        return true;
    }

    public HybridTrack<TD> dropTrackByAllIndex(int index) {
        int indexInactive;
        HybridTrack<TD> track = this.tracksAll.removeSwap(index);
        boolean found = false;
        int indexActive = this.tracksActive.indexOf(track);
        if (indexActive >= 0) {
            found = true;
            this.tracksActive.remove(indexActive);
        }
        if (!found && (indexInactive = this.tracksInactive.indexOf(track)) >= 0) {
            found = true;
            this.tracksInactive.remove(indexInactive);
        }
        assert (found);
        return track;
    }

    public void dropAllTracks() {
        this.tracksAll.reset();
        this.tracksActive.reset();
        this.tracksInactive.reset();
        this.tracksSpawned.clear();
        this.tracksDropped.clear();
    }

    public PyramidKltForHybrid<I, D> getTrackerKlt() {
        return this.trackerKlt;
    }

    public DetectDescribePoint<I, TD> getDetector() {
        return this.detector;
    }

    public AssociateDescriptionSets2D<TD> getAssociate() {
        return this.associate;
    }

    public DogArray<HybridTrack<TD>> getTracksAll() {
        return this.tracksAll;
    }

    public FastArray<HybridTrack<TD>> getTracksActive() {
        return this.tracksActive;
    }

    public FastArray<HybridTrack<TD>> getTracksInactive() {
        return this.tracksInactive;
    }

    public List<HybridTrack<TD>> getTracksSpawned() {
        return this.tracksSpawned;
    }

    public List<HybridTrack<TD>> getTracksDropped() {
        return this.tracksDropped;
    }

    public long getFrameID() {
        return this.frameID;
    }
}

