/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.struct.feature.AssociatedIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class PairwiseImageGraph {
    public final DogArray<View> nodes = new DogArray<View>(View::new);
    public final DogArray<Motion> edges = new DogArray<Motion>(Motion::new, Motion::reset);
    public final Map<String, View> mapNodes = new HashMap<String, View>();

    public void reset() {
        this.mapNodes.clear();
        this.nodes.reset();
        this.edges.reset();
    }

    public View createNode(String id) {
        View v = this.nodes.grow();
        v.init(this.nodes.size - 1, id);
        this.mapNodes.put(id, v);
        return v;
    }

    public View lookupNode(String id) {
        return this.mapNodes.get(id);
    }

    public Motion connect(View a, View b) {
        Motion m = this.edges.grow();
        m.src = a;
        m.dst = b;
        m.index = this.edges.size - 1;
        a.connections.add(m);
        b.connections.add(m);
        return m;
    }

    public static class View {
        public String id;
        public int index;
        public int totalObservations;
        public FastArray<Motion> connections = new FastArray<Motion>(Motion.class);

        public View() {
        }

        public View(String id) {
            this.id = id;
        }

        void init(int index, String id) {
            this.id = id;
            this.index = index;
            this.totalObservations = 0;
            this.connections.reset();
        }

        public View connection(int index) {
            return ((Motion)this.connections.get(index)).other(this);
        }

        @Nullable
        public Motion findMotion(View target) {
            int idx = this.findMotionIdx(target);
            if (idx == -1) {
                return null;
            }
            return (Motion)this.connections.get(idx);
        }

        public int findMotionIdx(View target) {
            for (int i = 0; i < this.connections.size; ++i) {
                Motion m = (Motion)this.connections.get(i);
                if (m.src != target && m.dst != target) continue;
                return i;
            }
            return -1;
        }

        public void getConnections(int[] indexes, int length, List<View> views) {
            views.clear();
            for (int i = 0; i < length; ++i) {
                views.add(((Motion)this.connections.get(indexes[i])).other(this));
            }
        }

        public String toString() {
            return "PView{id=" + this.id + ", conn=" + this.connections.size + ", obs=" + this.totalObservations + "}";
        }
    }

    public static class Motion {
        public boolean is3D;
        public double score3D;
        public final DogArray<AssociatedIndex> inliers = new DogArray<AssociatedIndex>(AssociatedIndex::new);
        public View src;
        public View dst;
        public int index;

        public void reset() {
            this.is3D = false;
            this.score3D = 0.0;
            this.inliers.reset();
            this.src = null;
            this.dst = null;
            this.index = -1;
        }

        public boolean isConnected(View v) {
            return v == this.src || v == this.dst;
        }

        public View other(View src) {
            if (src == this.src) {
                return this.dst;
            }
            if (src == this.dst) {
                return this.src;
            }
            throw new RuntimeException("BUG!");
        }

        public String toString() {
            return "Motion( " + (this.is3D ? "3D " : "") + " '" + this.src.id + "' <-> '" + this.dst.id + "')";
        }
    }
}

