/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.overhead;

import boofcv.alg.sfm.overhead.CameraPlaneProjection;
import boofcv.alg.sfm.overhead.OverheadView;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;

public class SelectOverheadParameters {
    CameraPlaneProjection proj = new CameraPlaneProjection();
    int overheadWidth;
    int overheadHeight;
    double centerX;
    double centerY;
    double cellSize;
    double maxCellsPerPixel;
    double viewHeightFraction;
    Point2D_F64 plane0 = new Point2D_F64();
    Point2D_F64 plane1 = new Point2D_F64();

    public SelectOverheadParameters(double cellSize, double maxCellsPerPixel, double viewHeightFraction) {
        this.cellSize = cellSize;
        this.maxCellsPerPixel = maxCellsPerPixel;
        this.viewHeightFraction = viewHeightFraction;
    }

    public boolean process(CameraPinholeBrown intrinsic, Se3_F64 planeToCamera) {
        this.proj.setPlaneToCamera(planeToCamera, true);
        this.proj.setIntrinsic(intrinsic);
        double x0 = Double.MAX_VALUE;
        double y0 = Double.MAX_VALUE;
        double x1 = -1.7976931348623157E308;
        double y1 = -1.7976931348623157E308;
        for (int y = 0; y < intrinsic.height; ++y) {
            for (int x = 0; x < intrinsic.width; ++x) {
                if (!this.checkValidPixel(x, y)) continue;
                if (this.plane0.x < x0) {
                    x0 = this.plane0.x;
                }
                if (this.plane0.x > x1) {
                    x1 = this.plane0.x;
                }
                if (this.plane0.y < y0) {
                    y0 = this.plane0.y;
                }
                if (!(this.plane0.y > y1)) continue;
                y1 = this.plane0.y;
            }
        }
        if (x0 == Double.MAX_VALUE) {
            return false;
        }
        double mapWidth = x1 - x0;
        double mapHeight = y1 - y0;
        this.overheadWidth = (int)Math.floor(mapWidth / this.cellSize);
        this.overheadHeight = (int)Math.floor(mapHeight * this.viewHeightFraction / this.cellSize);
        this.centerX = -x0;
        this.centerY = -(y0 + mapHeight * (1.0 - this.viewHeightFraction) / 2.0);
        return true;
    }

    public <T extends ImageBase<T>> OverheadView createOverhead(ImageType<T> imageType) {
        OverheadView ret = new OverheadView();
        ret.image = imageType.createImage(this.overheadWidth, this.overheadHeight);
        ret.cellSize = this.cellSize;
        ret.centerX = this.centerX;
        ret.centerY = this.centerY;
        return ret;
    }

    private boolean checkValidPixel(int x, int y) {
        if (!this.proj.pixelToPlane(x, y, this.plane0)) {
            return false;
        }
        if (!this.proj.pixelToPlane(x + 1, y + 1, this.plane1)) {
            return false;
        }
        double width = Math.abs(this.plane0.x - this.plane1.x);
        double height = Math.abs(this.plane0.y - this.plane1.y);
        if (width > this.maxCellsPerPixel * this.cellSize) {
            return false;
        }
        return !(height > this.maxCellsPerPixel * this.cellSize);
    }

    public int getOverheadWidth() {
        return this.overheadWidth;
    }

    public int getOverheadHeight() {
        return this.overheadHeight;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }
}

