/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.geo.RefinePnP;
import boofcv.abst.sfm.ImagePixelTo3D;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.sfm.d3.VisOdomBundlePnPBase;
import boofcv.alg.sfm.d3.structure.VisOdomBundleAdjustment;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;

public class VisOdomMonoDepthPnP<T extends ImageBase<T>>
extends VisOdomBundlePnPBase<Track> {
    private final PointTracker<T> tracker;
    private final ImagePixelTo3D pixelTo3D;
    private final RefinePnP refine;
    private VisOdomBundleAdjustment.BFrame frameCurrent;
    private VisOdomBundleAdjustment.BFrame framePrevious;
    private final ModelMatcher<Se3_F64, Point2D3D> motionEstimator;
    private final DogArray<Point2D3D> observationsPnP = new DogArray<Point2D3D>(Point2D3D::new);
    private double timeTracking;
    private double timeEstimate;
    private double timeBundle;
    private double timeDropUnused;
    private double timeSceneMaintenance;
    private double timeSpawn;
    List<PointTrack> tmpVisualTracks = new ArrayList<PointTrack>();
    Point4D_F64 prevLoc4 = new Point4D_F64();
    Se3_F64 world_to_prev = new Se3_F64();

    public VisOdomMonoDepthPnP(ModelMatcher<Se3_F64, Point2D3D> motionEstimator, ImagePixelTo3D pixelTo3D, RefinePnP refine, PointTracker<T> tracker) {
        this.motionEstimator = motionEstimator;
        this.pixelTo3D = pixelTo3D;
        this.refine = refine;
        this.tracker = tracker;
        this.bundleViso = new VisOdomBundleAdjustment<Track>(Track::new);
        ConfigTriangulation config = new ConfigTriangulation();
        config.type = ConfigTriangulation.Type.GEOMETRIC;
        config.converge.maxIterations = 10;
        this.triangulateN = FactoryMultiView.triangulateNViewMetric(config);
    }

    @Override
    public void reset() {
        super.reset();
        this.tracker.reset();
        this.current_to_previous.reset();
    }

    public boolean process(T image) {
        this.timeSpawn = 0.0;
        this.timeEstimate = 0.0;
        this.timeDropUnused = 0.0;
        this.timeSceneMaintenance = 0.0;
        this.timeBundle = 0.0;
        this.timeTracking = 0.0;
        long time0 = System.nanoTime();
        this.tracker.process(image);
        long time1 = System.nanoTime();
        this.verbosePrintTrackerSummary();
        this.initializeForProcess();
        if (this.first) {
            this.first = false;
            this.spawnNewTracksForNewKeyFrame(this.visibleTracks);
            this.frameManager.initialize(this.bundleViso.cameras);
            this.frameManager.handleSpawnedTracks(this.tracker, (VisOdomBundleAdjustment.BCamera)this.bundleViso.cameras.getTail());
            if (this.verbose != null) {
                this.verbose.println("First Frame. Spawned=" + this.visibleTracks.size());
            }
            return true;
        }
        this.handleDroppedVisualTracks();
        List<PointTrack> activeVisualTracks = this.tracker.getActiveTracks(null);
        if (!this.estimateMotion(activeVisualTracks)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: estimate motion");
            }
            this.bundleViso.removeFrame(this.frameCurrent, this.removedBundleTracks);
            this.dropRemovedBundleTracks();
            this.updateListOfVisibleTracksForOutput();
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("_ Inliers          " + this.motionEstimator.getMatchSet().size());
        }
        this.addObservationsOfInliersToScene(activeVisualTracks);
        this.removeOldUnusedVisibleTracks();
        double time2 = System.nanoTime();
        this.optimizeTheScene();
        double time3 = System.nanoTime();
        long time4 = System.nanoTime();
        boolean droppedCurrentFrame = this.performKeyFrameMaintenance(this.tracker, 1);
        long time5 = System.nanoTime();
        if (!droppedCurrentFrame) {
            this.spawnNewTracksForNewKeyFrame(this.visibleTracks);
            this.frameManager.handleSpawnedTracks(this.tracker, (VisOdomBundleAdjustment.BCamera)this.bundleViso.cameras.getTail());
        }
        long time6 = System.nanoTime();
        if (this.verbose != null) {
            this.verbose.println("_ Visible All      " + (this.tracker.getTotalInactive() + this.tracker.getTotalActive()));
        }
        this.timeTracking = (double)(time1 - time0) * 1.0E-6;
        this.timeEstimate = (time2 - (double)time1) * 1.0E-6;
        this.timeBundle = (time3 - time2) * 1.0E-6;
        this.timeDropUnused = ((double)time4 - time3) * 1.0E-6;
        this.timeSceneMaintenance = (double)(time5 - time4) * 1.0E-6;
        this.timeSpawn = (double)(time6 - time5) * 1.0E-6;
        if (this.profileOut != null) {
            double timeTotal = (double)(time6 - time0) * 1.0E-6;
            this.profileOut.printf("TIME: TRK %5.1f Est %5.1f Bun %5.1f DU %5.1f Scene %5.1f Spn  %5.1f TOTAL %5.1f\n", this.timeTracking, this.timeEstimate, this.timeBundle, this.timeDropUnused, this.timeSceneMaintenance, this.timeSpawn, timeTotal);
        }
        return true;
    }

    private void initializeForProcess() {
        this.inlierTracks.clear();
        this.visibleTracks.clear();
        this.initialVisible.clear();
        this.framePrevious = this.first ? null : this.bundleViso.getLastFrame();
        this.frameCurrent = this.bundleViso.addFrame(this.tracker.getFrameID());
    }

    private void verbosePrintTrackerSummary() {
        if (this.verbose != null) {
            this.verbose.println("-----------------------------------------------------------------------------------------");
            this.verbose.println("Input Frame Count   " + this.tracker.getFrameID());
            this.verbose.println("   Bundle Frames    " + this.bundleViso.frames.size);
            this.verbose.println("   Bundle tracks    " + this.bundleViso.tracks.size);
            this.verbose.println("   Tracker active   " + this.tracker.getTotalActive());
            this.verbose.println("   Tracker inactive " + this.tracker.getTotalInactive());
        }
    }

    private void optimizeTheScene() {
        if (this.bundleViso.isOptimizeActive()) {
            this.bundleViso.optimize(this.verbose);
            this.triangulateNotSelectedBundleTracks();
        }
        this.current_to_world.setTo(this.frameCurrent.frame_to_world);
    }

    private void handleDroppedVisualTracks() {
        this.tmpVisualTracks.clear();
        this.tracker.getDroppedTracks(this.tmpVisualTracks);
        for (int i = 0; i < this.tmpVisualTracks.size(); ++i) {
            VisOdomBundleAdjustment.BTrack bt = (VisOdomBundleAdjustment.BTrack)this.tmpVisualTracks.get(i).getCookie();
            bt.visualTrack = null;
        }
    }

    private void dropRemovedBundleTracks() {
        for (int i = 0; i < this.removedBundleTracks.size(); ++i) {
            this.dropVisualTrack((PointTrack)this.removedBundleTracks.get(i));
        }
    }

    @Override
    protected void dropVisualTrack(PointTrack track) {
        this.tracker.dropTrack(track);
    }

    public void setCamera(CameraPinholeBrown camera) {
        this.bundleViso.cameras.reset();
        this.bundleViso.addCamera(camera);
        LensDistortionNarrowFOV factory = LensDistortionFactory.narrow(camera);
        VisOdomBundlePnPBase.CameraModel cm = new VisOdomBundlePnPBase.CameraModel();
        cm.pixelToNorm = factory.undistort_F64(true, false);
        cm.normToPixel = factory.distort_F64(false, true);
        this.cameraModels.clear();
        this.cameraModels.add(cm);
    }

    private void addObservationsOfInliersToScene(List<PointTrack> active) {
        int N = this.motionEstimator.getMatchSet().size();
        long frameID = this.getFrameID();
        for (int i = 0; i < N; ++i) {
            int index = this.motionEstimator.getInputIndex(i);
            PointTrack pt = active.get(index);
            Track bt = (Track)pt.getCookie();
            bt.lastUsed = frameID;
            bt.hasBeenInlier = true;
            this.bundleViso.addObservation(this.frameCurrent, bt, pt.pixel.x, pt.pixel.y);
            this.inlierTracks.add(bt);
        }
    }

    private void removeOldUnusedVisibleTracks() {
        long trackerFrame = this.getFrameID();
        int beforeCount = this.tracker.getTotalActive() + this.tracker.getTotalInactive();
        this.tracker.dropTracks(track -> {
            Track bt = (Track)track.getCookie();
            if (bt == null) {
                throw new RuntimeException("BUG!");
            }
            if (trackerFrame - bt.lastUsed >= (long)this.thresholdRetireTracks) {
                bt.visualTrack = null;
                return true;
            }
            return false;
        });
        int afterCount = this.tracker.getTotalActive() + this.tracker.getTotalInactive();
        if (this.verbose != null) {
            this.verbose.println("   Dropped Unused   " + (beforeCount - afterCount));
        }
    }

    private void spawnNewTracksForNewKeyFrame(List<Track> visibleTracks) {
        long frameID = this.tracker.getFrameID();
        int totalRejected = 0;
        this.tracker.spawnTracks();
        List<PointTrack> spawned = this.tracker.getNewTracks(null);
        for (PointTrack pt : spawned) {
            if (!this.pixelTo3D.process(pt.pixel.x, pt.pixel.y)) {
                ++totalRejected;
                this.tracker.dropTrack(pt);
                continue;
            }
            if (this.bundleViso.findByTrackerTrack(pt) != null) {
                throw new RuntimeException("BUG! Recycled tracker track too early tt=" + pt.featureId);
            }
            Track btrack = (Track)this.bundleViso.addTrack(this.pixelTo3D.getX(), this.pixelTo3D.getY(), this.pixelTo3D.getZ(), this.pixelTo3D.getW());
            btrack.lastUsed = frameID;
            btrack.visualTrack = pt;
            btrack.id = pt.featureId;
            pt.cookie = btrack;
            SePointOps_F64.transform(this.frameCurrent.frame_to_world, btrack.worldLoc, btrack.worldLoc);
            btrack.worldLoc.normalize();
            this.bundleViso.addObservation(this.frameCurrent, btrack, pt.pixel.x, pt.pixel.y);
            visibleTracks.add(btrack);
        }
        if (this.verbose != null) {
            this.verbose.printf("spawn: new=%d rejected=%d\n", spawned.size() - totalRejected, totalRejected);
        }
    }

    private boolean estimateMotion(List<PointTrack> active) {
        Se3_F64 previous_to_current;
        Point2Transform2_F64 pixelToNorm = ((VisOdomBundlePnPBase.CameraModel)this.cameraModels.get((int)0)).pixelToNorm;
        this.framePrevious.frame_to_world.invert(this.world_to_prev);
        this.observationsPnP.reset();
        for (int activeIdx = 0; activeIdx < active.size(); ++activeIdx) {
            PointTrack pt = active.get(activeIdx);
            this.initialVisible.add((Track)pt.cookie);
            Point2D3D p = this.observationsPnP.grow();
            pixelToNorm.compute(pt.pixel.x, pt.pixel.y, p.observation);
            Track bt = (Track)pt.getCookie();
            SePointOps_F64.transform(this.world_to_prev, bt.worldLoc, this.prevLoc4);
            PerspectiveOps.homogenousTo3dPositiveZ(this.prevLoc4, 1.0E8, 1.0E-7, p.location);
        }
        if (!this.motionEstimator.process(this.observationsPnP.toList())) {
            return false;
        }
        if (this.refine != null) {
            previous_to_current = new Se3_F64();
            this.refine.fitModel(this.motionEstimator.getMatchSet(), this.motionEstimator.getModelParameters(), previous_to_current);
        } else {
            previous_to_current = this.motionEstimator.getModelParameters();
        }
        previous_to_current.invert(this.current_to_previous);
        this.current_to_previous.concat(this.framePrevious.frame_to_world, this.frameCurrent.frame_to_world);
        return true;
    }

    @Override
    public long getFrameID() {
        return this.tracker.getFrameID();
    }

    public PointTracker<T> getTracker() {
        return this.tracker;
    }

    public ImagePixelTo3D getPixelTo3D() {
        return this.pixelTo3D;
    }

    public double getTimeTracking() {
        return this.timeTracking;
    }

    public double getTimeEstimate() {
        return this.timeEstimate;
    }

    public double getTimeBundle() {
        return this.timeBundle;
    }

    public double getTimeDropUnused() {
        return this.timeDropUnused;
    }

    public double getTimeSceneMaintenance() {
        return this.timeSceneMaintenance;
    }

    public double getTimeSpawn() {
        return this.timeSpawn;
    }

    public static class Track
    extends VisOdomBundleAdjustment.BTrack {
        public long lastUsed;
    }
}

