/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d2;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.sfm.d2.AssociatedPairTrack;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import georegression.struct.InvertibleTransform;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;

public class ImageMotionPointTrackerKey<I extends ImageBase<I>, IT extends InvertibleTransform> {
    protected PointTracker<I> tracker;
    protected ModelMatcher<IT, AssociatedPair> modelMatcher;
    protected ModelFitter<IT, AssociatedPair> modelRefiner;
    protected IT worldToKey;
    protected IT keyToCurr;
    protected IT worldToCurr;
    protected int thresholdOutlierPrune;
    protected boolean keyFrame;

    public ImageMotionPointTrackerKey(PointTracker<I> tracker, ModelMatcher<IT, AssociatedPair> modelMatcher, ModelFitter<IT, AssociatedPair> modelRefiner, IT model, int thresholdOutlierPrune) {
        this.tracker = tracker;
        this.modelMatcher = modelMatcher;
        this.modelRefiner = modelRefiner;
        this.thresholdOutlierPrune = thresholdOutlierPrune;
        this.worldToKey = model.createInstance();
        this.keyToCurr = model.createInstance();
        this.worldToCurr = model.createInstance();
        this.reset();
    }

    protected ImageMotionPointTrackerKey() {
    }

    public void reset() {
        this.keyFrame = false;
        this.tracker.reset();
        this.resetTransforms();
    }

    public boolean process(I frame) {
        this.keyFrame = false;
        this.tracker.process(frame);
        List<PointTrack> tracks = this.tracker.getActiveTracks(null);
        if (tracks.size() == 0) {
            return false;
        }
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int trackIdx = 0; trackIdx < tracks.size(); ++trackIdx) {
            pairs.add((AssociatedPair)tracks.get(trackIdx).getCookie());
        }
        if (!this.modelMatcher.process(pairs)) {
            return false;
        }
        if (this.modelRefiner != null) {
            if (!this.modelRefiner.fitModel(this.modelMatcher.getMatchSet(), (InvertibleTransform)this.modelMatcher.getModelParameters(), this.keyToCurr)) {
                return false;
            }
        } else {
            this.keyToCurr.setTo((InvertibleTransform)((InvertibleTransform)this.modelMatcher.getModelParameters()));
        }
        long frameID = this.tracker.getFrameID();
        List<AssociatedPair> matchSet = this.modelMatcher.getMatchSet();
        for (int matchIdx = 0; matchIdx < matchSet.size(); ++matchIdx) {
            ((AssociatedPairTrack)matchSet.get((int)matchIdx)).lastUsed = frameID;
        }
        this.pruneUnusedTracks();
        this.worldToKey.concat(this.keyToCurr, this.worldToCurr);
        return true;
    }

    private void pruneUnusedTracks() {
        long frameID = this.tracker.getFrameID();
        this.tracker.dropTracks(track -> {
            AssociatedPairTrack p = (AssociatedPairTrack)track.getCookie();
            return frameID - p.lastUsed >= (long)this.thresholdOutlierPrune;
        });
    }

    public void changeKeyFrame() {
        long frameID = this.tracker.getFrameID();
        List<PointTrack> inactive = this.tracker.getInactiveTracks(null);
        for (PointTrack pointTrack : inactive) {
            this.tracker.dropTrack(pointTrack);
        }
        List<PointTrack> active = this.tracker.getActiveTracks(null);
        for (PointTrack l : active) {
            AssociatedPairTrack p = (AssociatedPairTrack)l.getCookie();
            p.p1.setTo(l.pixel);
            p.lastUsed = frameID;
        }
        this.tracker.spawnTracks();
        List<PointTrack> list = this.tracker.getNewTracks(null);
        for (PointTrack l : list) {
            AssociatedPairTrack p = (AssociatedPairTrack)l.getCookie();
            if (p == null) {
                p = new AssociatedPairTrack();
                l.cookie = p;
                p.p2 = l.pixel;
            }
            p.p1.setTo(l.pixel);
            p.lastUsed = frameID;
        }
        this.worldToKey.setTo(this.worldToCurr);
        this.keyToCurr.reset();
        this.keyFrame = true;
    }

    public void resetTransforms() {
        this.worldToCurr.reset();
        this.worldToKey.reset();
        this.keyToCurr.reset();
    }

    public IT getWorldToCurr() {
        return this.worldToCurr;
    }

    public IT getWorldToKey() {
        return this.worldToKey;
    }

    public IT getKeyToCurr() {
        return this.keyToCurr;
    }

    public PointTracker<I> getTracker() {
        return this.tracker;
    }

    public ModelMatcher<IT, AssociatedPair> getModelMatcher() {
        return this.modelMatcher;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public Class<IT> getModelType() {
        return this.keyToCurr.getClass();
    }

    public long getFrameID() {
        return this.tracker.getFrameID();
    }
}

