/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.cc;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.segmentation.cc.ConnectedSpeckleFiller;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray;

public class ConnectedNaiveSpeckleFiller_Int<T extends GrayI<T>>
implements ConnectedSpeckleFiller<T> {
    GrayS32 labels = new GrayS32(1, 1);
    DogArray<Pixel> open = new DogArray<Pixel>(Pixel::new);
    int totalFilled;
    int totalRegions;
    int similarTolerance;
    int fillValue;
    ImageType<T> imageType;

    public ConnectedNaiveSpeckleFiller_Int(ImageType<T> imageType) {
        this.imageType = imageType;
    }

    @Override
    public void process(T image, int maximumArea, double similarTol, double fillValue) {
        this.similarTolerance = (int)similarTol;
        this.fillValue = (int)fillValue;
        this.totalFilled = 0;
        this.labels.reshape((ImageBase)image);
        ImageMiscOps.fill(this.labels, -1);
        this.totalRegions = 0;
        for (int y = 0; y < ((GrayI)image).height; ++y) {
            for (int x = 0; x < ((GrayI)image).width; ++x) {
                int value;
                int label = this.labels.unsafe_get(x, y);
                if (label != -1 || (double)(value = ((GrayI)image).unsafe_get(x, y)) == fillValue || this.applyLabel(image, x, y, value) > maximumArea) continue;
                for (int i = 0; i < this.open.size; ++i) {
                    Pixel p = (Pixel)this.open.get(i);
                    ((GrayI)image).unsafe_set(p.x, p.y, this.fillValue);
                }
                ++this.totalFilled;
            }
        }
    }

    @Override
    public int getTotalFilled() {
        return this.totalFilled;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    int applyLabel(T image, int seedX, int seedY, int seedValue) {
        int location;
        int label = this.totalRegions++;
        this.open.reset();
        this.open.grow().setTo(seedX, seedY, seedValue);
        this.labels.unsafe_set(seedX, seedY, label);
        for (location = 0; location < this.open.size(); ++location) {
            Pixel p = (Pixel)this.open.get(location);
            int x = p.x;
            int y = p.y;
            int value = p.value;
            this.checkAdd(image, x + 1, y, label, value);
            this.checkAdd(image, x, y + 1, label, value);
            this.checkAdd(image, x - 1, y, label, value);
            this.checkAdd(image, x, y - 1, label, value);
        }
        return location;
    }

    private void checkAdd(T image, int x, int y, int label, int targetValue) {
        if (!this.labels.isInBounds(x, y)) {
            return;
        }
        if (this.labels.unsafe_get(x, y) != -1) {
            return;
        }
        int value = ((GrayI)image).unsafe_get(x, y);
        if (value == this.fillValue || Math.abs(targetValue - value) > this.similarTolerance) {
            return;
        }
        this.labels.unsafe_set(x, y, label);
        this.open.grow().setTo(x, y, value);
    }

    public static class Pixel {
        int x;
        int y;
        int value;

        public void setTo(int x, int y, int value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

