/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene.vocabtree;

import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.PackedArray;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;

public class HierarchicalVocabularyTree<Point> {
    public int branchFactor = -1;
    public int maximumLevel = -1;
    public PointDistance<Point> distanceFunction;
    public final PackedArray<Point> descriptions;
    public final DogArray<Node> nodes = new DogArray<Node>(Node::new, Node::reset);

    public HierarchicalVocabularyTree(PointDistance<Point> distanceFunction, PackedArray<Point> descriptions) {
        this.distanceFunction = distanceFunction;
        this.descriptions = descriptions;
        this.reset();
    }

    public int addNode(int parentIndex, int branch, Point desc) {
        int index = this.nodes.size;
        Node n = this.nodes.grow();
        n.index = index;
        n.branch = branch;
        n.descIdx = this.descriptions.size();
        this.descriptions.append(desc);
        Node parent = (Node)this.nodes.get(parentIndex);
        BoofMiscOps.checkTrue(branch == parent.childrenIndexes.size, "Branch index must map to child index");
        n.parent = parentIndex;
        parent.childrenIndexes.add(index);
        return index;
    }

    public int searchPathToLeaf(Point point, BoofLambdas.ProcessIndex<Node> op) {
        Node parent = (Node)this.nodes.get(0);
        if (parent.isLeaf()) {
            return 0;
        }
        for (int level = 0; level <= this.maximumLevel; ++level) {
            int bestNodeIdx = -1;
            double bestDistance = Double.MAX_VALUE;
            for (int childIdx = 0; childIdx < parent.childrenIndexes.size; ++childIdx) {
                int nodeIdx = parent.childrenIndexes.get(childIdx);
                Object desc = this.descriptions.getTemp(((Node)this.nodes.get((int)nodeIdx)).descIdx);
                double distance = this.distanceFunction.distance(point, desc);
                if (distance >= bestDistance) continue;
                bestNodeIdx = nodeIdx;
                bestDistance = distance;
            }
            parent = (Node)this.nodes.get(bestNodeIdx);
            op.process(level + 1, parent);
            if (!parent.isLeaf()) continue;
            return bestNodeIdx;
        }
        throw new RuntimeException("Invalid tree. Max depth exceeded searching for leaf");
    }

    public void traverseGraphDepthFirst(BoofLambdas.ProcessObject<Node> op) {
        FastArray<Node> queue = new FastArray<Node>(Node.class, this.maximumLevel);
        queue.add((Node)this.nodes.get(0));
        DogArray_I32 branches = new DogArray_I32(this.maximumLevel);
        branches.add(0);
        if (((Node)this.nodes.get(0)).isLeaf()) {
            return;
        }
        while (!queue.isEmpty()) {
            Node n = (Node)queue.getTail();
            int branch = branches.getTail();
            if (branch >= n.childrenIndexes.size) {
                queue.removeTail();
                branches.removeTail();
                continue;
            }
            branches.setTail(0, branch + 1);
            n = (Node)this.nodes.get(n.childrenIndexes.get(branch));
            op.process(n);
            if (n.isLeaf()) continue;
            queue.add(n);
            branches.add(0);
        }
    }

    public int depthOfNode(Node n) {
        int depth = 0;
        while (n.parent > 0) {
            ++depth;
            n = (Node)this.nodes.get(n.parent);
        }
        return depth;
    }

    public void checkConfig() {
        BoofMiscOps.checkTrue(this.branchFactor > 0, "branchFactor needs to be set");
        BoofMiscOps.checkTrue(this.maximumLevel > 0, "maximumLevels needs to be set");
    }

    public void reset() {
        this.descriptions.reset();
        this.nodes.reset();
        this.nodes.grow().index = 0;
    }

    public static class Node {
        public double weight;
        public int index;
        public int branch;
        public int parent;
        public int userIdx;
        public int descIdx;
        public final DogArray_I32 childrenIndexes = new DogArray_I32();

        public boolean isLeaf() {
            return this.childrenIndexes.isEmpty();
        }

        public void reset() {
            this.weight = -1.0;
            this.index = -1;
            this.branch = -1;
            this.parent = -1;
            this.userIdx = -1;
            this.descIdx = -1;
            this.childrenIndexes.reset();
        }

        public void setTo(Node src) {
            this.index = src.index;
            this.branch = src.branch;
            this.parent = src.parent;
            this.userIdx = src.userIdx;
            this.descIdx = src.descIdx;
            this.childrenIndexes.setTo(src.childrenIndexes);
        }
    }
}

